<?php $pageTitle = 'Profilim'; ?>
<?php echo $__env->make("layouts.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style media="screen">
  .icon {width: 20px;fill:white;}
</style>
<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Profilim
                    </h1>
                </div>
            </header>
            <?php if ($profile['email_verified'] == null): ?>
              <form id="verify-mail-form" action="<?php echo e(route('send.verify.mail')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div style="margin-bottom:-3%;" class="flex items-center p-4  text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400" role="alert">
                  <svg style="margin-right:5px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                  </svg>
                  <span class="sr-only">Info</span>
                  <div>
                    <span class="font-medium">Bilgilendirme!</span> <button type="submit" id="submit-btn">E Posta Adresinizi henüz doğrulamadınız, doğrulama maili almak için hemen tıklayın!</button>
                  </div>
                </div>
              </form>
              <div id="alert"></div>
            <?php endif; ?>
            <div class="">
                <div class="grid flex-1 auto-cols-fr gap-y-8">
                  <div style="--col-span-default: 1 / -1;" class="col-[--col-span-default]">
                            <section class="fi-section rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10" id="data.kisisel-bilgiler">
                                <header class="fi-section-header flex flex-col gap-3 px-6 py-4">
                                    <div class="flex items-center gap-3">
                                        <svg class="fi-section-header-icon self-start text-gray-400 dark:text-gray-500 fi-color-{$iconColor} h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
                                            <path fill-rule="evenodd" d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-5.5-2.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0ZM10 12a5.99 5.99 0 0 0-4.793 2.39A6.483 6.483 0 0 0 10 16.5a6.483 6.483 0 0 0 4.793-2.11A5.99 5.99 0 0 0 10 12Z" clip-rule="evenodd"></path>
                                        </svg>

                                        <div class="grid flex-1 gap-y-1">
                                            <h3 class="fi-section-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                                Kişisel Bilgiler
                                            </h3>
                                        </div>
                                    </div>
                                </header>
                                <form id="update-client-form" action="<?php echo e(route('update-client')); ?>"  method="post">
                                  <?php echo csrf_field(); ?>
                                <div class="fi-section-content-ctn border-t border-gray-200 dark:border-white/10">
                                    <div class="fi-section-content p-6">
                                        <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(4, minmax(0, 1fr)); --cols-xl: repeat(4, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6">
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                    Adınız
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="firstname" value="<?php echo e($profile['firstname']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                    Soyadınız
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="lastname" value="<?php echo e($profile['lastname']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  T.C. Kimlik No
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                  <input name="customfields2" value="<?php echo e($profile['customfields2']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" pattern="\d{11}" maxlength="11" required>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  Doğum Yılınız (Örnek: 1900)
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                  <input name="customfields3" value="<?php echo e($profile['customfields3']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" pattern="\d{4}" maxlength="4" required>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] companyDiv">
                                            <div data-field-wrapper="" class="fi-fo-field-wrp">
                                              <div class="grid gap-y-2">
                                                <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                      Firma Adı
                                                    </span>
                                                  </label>
                                                </div>
                                                <div class="grid auto-cols-fr gap-y-2">
                                                  <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                    <div class="min-w-0 flex-1">
                                                      <input name="companyname" value="<?php echo e($profile['companyname']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text">
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>

                                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] taxOfficeDiv">
                                            <div data-field-wrapper="" class="fi-fo-field-wrp">
                                              <div class="grid gap-y-2">
                                                <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                      Vergi Dairesi
                                                    </span>
                                                  </label>
                                                </div>
                                                <div class="grid auto-cols-fr gap-y-2">
                                                  <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                    <div class="min-w-0 flex-1">
                                                      <input name="customfields4" value="<?php echo e($profile['customfields4']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text">
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>

                                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] taxNumberDiv">
                                            <div data-field-wrapper="" class="fi-fo-field-wrp">
                                              <div class="grid gap-y-2">
                                                <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                      Vergi Numarası
                                                    </span>
                                                  </label>
                                                </div>
                                                <div class="grid auto-cols-fr gap-y-2">
                                                  <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                    <div class="min-w-0 flex-1">
                                                      <input name="customfields5" value="<?php echo e($profile['customfields5']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text">
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  Telefon Numarası
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="phonenumber" value="<?php echo e($profile['phonenumber']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  E-Posta Adresi
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="email" value="<?php echo e($profile['email']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  Ülke
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                  <select name="country" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"  name="">
                                                                    <option value="AF" <?= $profile['country'] == 'AF' ? 'selected' : '' ?>>افغانستان</option>
                                                                    <option value="AX" <?= $profile['country'] == 'AX' ? 'selected' : '' ?>>Åland</option>
                                                                    <option value="AL" <?= $profile['country'] == 'AL' ? 'selected' : '' ?>>Shqipëria</option>
                                                                    <option value="DZ" <?= $profile['country'] == 'DZ' ? 'selected' : '' ?>>الجزائر</option>
                                                                    <option value="AS" <?= $profile['country'] == 'AS' ? 'selected' : '' ?>>American Samoa</option>
                                                                    <option value="AD" <?= $profile['country'] == 'AD' ? 'selected' : '' ?>>Andorra</option>
                                                                    <option value="AO" <?= $profile['country'] == 'AO' ? 'selected' : '' ?>>Angola</option>
                                                                    <option value="AI" <?= $profile['country'] == 'AI' ? 'selected' : '' ?>>Anguilla</option>
                                                                    <option value="AQ" <?= $profile['country'] == 'AQ' ? 'selected' : '' ?>>Antarctica</option>
                                                                    <option value="AG" <?= $profile['country'] == 'AG' ? 'selected' : '' ?>>Antigua And Barbuda</option>
                                                                    <option value="AR" <?= $profile['country'] == 'AR' ? 'selected' : '' ?>>Argentina</option>
                                                                    <option value="AM" <?= $profile['country'] == 'AM' ? 'selected' : '' ?>>Հայաստան</option>
                                                                    <option value="AW" <?= $profile['country'] == 'AW' ? 'selected' : '' ?>>Aruba</option>
                                                                    <option value="AU" <?= $profile['country'] == 'AU' ? 'selected' : '' ?>>Australia</option>
                                                                    <option value="AT" <?= $profile['country'] == 'AT' ? 'selected' : '' ?>>Österreich</option>
                                                                    <option value="AZ" <?= $profile['country'] == 'AZ' ? 'selected' : '' ?>>Azərbaycan</option>
                                                                    <option value="BS" <?= $profile['country'] == 'BS' ? 'selected' : '' ?>>Bahamas</option>
                                                                    <option value="BH" <?= $profile['country'] == 'BH' ? 'selected' : '' ?>>البحرين</option>
                                                                    <option value="BD" <?= $profile['country'] == 'BD' ? 'selected' : '' ?>>বাংলাদেশ</option>
                                                                    <option value="BB" <?= $profile['country'] == 'BB' ? 'selected' : '' ?>>Barbados</option>
                                                                    <option value="BY" <?= $profile['country'] == 'BY' ? 'selected' : '' ?>>Беларусь</option>
                                                                    <option value="BE" <?= $profile['country'] == 'BE' ? 'selected' : '' ?>>België</option>
                                                                    <option value="BZ" <?= $profile['country'] == 'BZ' ? 'selected' : '' ?>>Belize</option>
                                                                    <option value="BJ" <?= $profile['country'] == 'BJ' ? 'selected' : '' ?>>Bénin</option>
                                                                    <option value="BM" <?= $profile['country'] == 'BM' ? 'selected' : '' ?>>Bermuda</option>
                                                                    <option value="BT" <?= $profile['country'] == 'BT' ? 'selected' : '' ?>>འབྲུག</option>
                                                                    <option value="BO" <?= $profile['country'] == 'BO' ? 'selected' : '' ?>>Bolivia</option>
                                                                    <option value="BA" <?= $profile['country'] == 'BA' ? 'selected' : '' ?>>Bosna i Hercegovina</option>
                                                                    <option value="BW" <?= $profile['country'] == 'BW' ? 'selected' : '' ?>>Botswana</option>
                                                                    <option value="BR" <?= $profile['country'] == 'BR' ? 'selected' : '' ?>>Brasil</option>
                                                                    <option value="IO" <?= $profile['country'] == 'IO' ? 'selected' : '' ?>>British Indian Ocean Territory</option>
                                                                    <option value="BN" <?= $profile['country'] == 'BN' ? 'selected' : '' ?>>Brunei</option>
                                                                    <option value="BG" <?= $profile['country'] == 'BG' ? 'selected' : '' ?>>България</option>
                                                                    <option value="BF" <?= $profile['country'] == 'BF' ? 'selected' : '' ?>>Burkina Faso</option>
                                                                    <option value="BI" <?= $profile['country'] == 'BI' ? 'selected' : '' ?>>Burundi</option>
                                                                    <option value="KH" <?= $profile['country'] == 'KH' ? 'selected' : '' ?>>កម្ពុជា</option>
                                                                    <option value="CM" <?= $profile['country'] == 'CM' ? 'selected' : '' ?>>Cameroon</option>
                                                                    <option value="CA" <?= $profile['country'] == 'CA' ? 'selected' : '' ?>>Canada</option>
                                                                    <option value="IC" <?= $profile['country'] == 'IC' ? 'selected' : '' ?>>Islas Canarias</option>
                                                                    <option value="CV" <?= $profile['country'] == 'CV' ? 'selected' : '' ?>>Cabo Verde</option>
                                                                    <option value="KY" <?= $profile['country'] == 'KY' ? 'selected' : '' ?>>Cayman Islands</option>
                                                                    <option value="CF" <?= $profile['country'] == 'CF' ? 'selected' : '' ?>>République centrafricaine</option>
                                                                    <option value="TD" <?= $profile['country'] == 'TD' ? 'selected' : '' ?>>تشاد</option>
                                                                    <option value="CL" <?= $profile['country'] == 'CL' ? 'selected' : '' ?>>Chile</option>
                                                                    <option value="CN" <?= $profile['country'] == 'CN' ? 'selected' : '' ?>>中国</option>
                                                                    <option value="CX" <?= $profile['country'] == 'CX' ? 'selected' : '' ?>>Christmas Island</option>
                                                                    <option value="CC" <?= $profile['country'] == 'CC' ? 'selected' : '' ?>>Cocos (Keeling) Islands</option>
                                                                    <option value="CO" <?= $profile['country'] == 'CO' ? 'selected' : '' ?>>Colombia</option>
                                                                    <option value="KM" <?= $profile['country'] == 'KM' ? 'selected' : '' ?>>جزر القمر</option>
                                                                    <option value="CG" <?= $profile['country'] == 'CG' ? 'selected' : '' ?>>République du Congo</option>
                                                                    <option value="CD" <?= $profile['country'] == 'CD' ? 'selected' : '' ?>>République Démocratique du Congo</option>
                                                                    <option value="CK" <?= $profile['country'] == 'CK' ? 'selected' : '' ?>>Cook Islands</option>
                                                                    <option value="CR" <?= $profile['country'] == 'CR' ? 'selected' : '' ?>>Costa Rica</option>
                                                                    <option value="CI" <?= $profile['country'] == 'CI' ? 'selected' : '' ?>>Côte d'Ivoire</option>
                                                                    <option value="HR" <?= $profile['country'] == 'HR' ? 'selected' : '' ?>>Hrvatska</option>
                                                                    <option value="CU" <?= $profile['country'] == 'CU' ? 'selected' : '' ?>>Cuba</option>
                                                                    <option value="CW" <?= $profile['country'] == 'CW' ? 'selected' : '' ?>>Curaçao</option>
                                                                    <option value="CY" <?= $profile['country'] == 'CY' ? 'selected' : '' ?>>Κύπρος</option>
                                                                    <option value="CZ" <?= $profile['country'] == 'CZ' ? 'selected' : '' ?>>Česká republika</option>
                                                                    <option value="DK" <?= $profile['country'] == 'DK' ? 'selected' : '' ?>>Danmark</option>
                                                                    <option value="DJ" <?= $profile['country'] == 'DJ' ? 'selected' : '' ?>>جيبوتي</option>
                                                                    <option value="DM" <?= $profile['country'] == 'DM' ? 'selected' : '' ?>>Dominica</option>
                                                                    <option value="DO" <?= $profile['country'] == 'DO' ? 'selected' : '' ?>>República Dominicana</option>
                                                                    <option value="EC" <?= $profile['country'] == 'EC' ? 'selected' : '' ?>>Ecuador</option>
                                                                    <option value="EG" <?= $profile['country'] == 'EG' ? 'selected' : '' ?>>مصر</option>
                                                                    <option value="SV" <?= $profile['country'] == 'SV' ? 'selected' : '' ?>>El Salvador</option>
                                                                    <option value="GQ" <?= $profile['country'] == 'GQ' ? 'selected' : '' ?>>Guinea Ecuatorial</option>
                                                                    <option value="ER" <?= $profile['country'] == 'ER' ? 'selected' : '' ?>>Eritrea</option>
                                                                    <option value="EE" <?= $profile['country'] == 'EE' ? 'selected' : '' ?>>Eesti</option>
                                                                    <option value="ET" <?= $profile['country'] == 'ET' ? 'selected' : '' ?>>Ethiopia</option>
                                                                    <option value="FK" <?= $profile['country'] == 'FK' ? 'selected' : '' ?>>Islas Malvinas</option>
                                                                    <option value="FO" <?= $profile['country'] == 'FO' ? 'selected' : '' ?>>Føroyar</option>
                                                                    <option value="FJ" <?= $profile['country'] == 'FJ' ? 'selected' : '' ?>>Fiji</option>
                                                                    <option value="FI" <?= $profile['country'] == 'FI' ? 'selected' : '' ?>>Suomi</option>
                                                                    <option value="FR" <?= $profile['country'] == 'FR' ? 'selected' : '' ?>>France</option>
                                                                    <option value="GF" <?= $profile['country'] == 'GF' ? 'selected' : '' ?>>Guyane française</option>
                                                                    <option value="PF" <?= $profile['country'] == 'PF' ? 'selected' : '' ?>>Polynésie française</option>
                                                                    <option value="TF" <?= $profile['country'] == 'TF' ? 'selected' : '' ?>>Terres australes françaises</option>
                                                                    <option value="GA" <?= $profile['country'] == 'GA' ? 'selected' : '' ?>>Gabon</option>
                                                                    <option value="GM" <?= $profile['country'] == 'GM' ? 'selected' : '' ?>>Gambia</option>
                                                                    <option value="GE" <?= $profile['country'] == 'GE' ? 'selected' : '' ?>>საქართველო</option>
                                                                    <option value="DE" <?= $profile['country'] == 'DE' ? 'selected' : '' ?>>Deutschland</option>
                                                                    <option value="GH" <?= $profile['country'] == 'GH' ? 'selected' : '' ?>>Ghana</option>
                                                                    <option value="GI" <?= $profile['country'] == 'GI' ? 'selected' : '' ?>>Gibraltar</option>
                                                                    <option value="GR" <?= $profile['country'] == 'GR' ? 'selected' : '' ?>>Ελλάδα</option>
                                                                    <option value="GL" <?= $profile['country'] == 'GL' ? 'selected' : '' ?>>Kalaallit Nunaat</option>
                                                                    <option value="GD" <?= $profile['country'] == 'GD' ? 'selected' : '' ?>>Grenada</option>
                                                                    <option value="GP" <?= $profile['country'] == 'GP' ? 'selected' : '' ?>>Guadeloupe</option>
                                                                    <option value="GU" <?= $profile['country'] == 'GU' ? 'selected' : '' ?>>Guam</option>
                                                                    <option value="GT" <?= $profile['country'] == 'GT' ? 'selected' : '' ?>>Guatemala</option>
                                                                    <option value="GG" <?= $profile['country'] == 'GG' ? 'selected' : '' ?>>Guernsey</option>
                                                                    <option value="GN" <?= $profile['country'] == 'GN' ? 'selected' : '' ?>>Guinée</option>
                                                                    <option value="GW" <?= $profile['country'] == 'GW' ? 'selected' : '' ?>>Guiné-Bissau</option>
                                                                    <option value="GY" <?= $profile['country'] == 'GY' ? 'selected' : '' ?>>Guyana</option>
                                                                    <option value="HT" <?= $profile['country'] == 'HT' ? 'selected' : '' ?>>Haïti</option>
                                                                    <option value="HM" <?= $profile['country'] == 'HM' ? 'selected' : '' ?>>Heard Island &amp; Mcdonald Islands</option>
                                                                    <option value="VA" <?= $profile['country'] == 'VA' ? 'selected' : '' ?>>Sancta Sedes (Status Civitatis Vaticanae)</option>
                                                                    <option value="HN" <?= $profile['country'] == 'HN' ? 'selected' : '' ?>>Honduras</option>
                                                                    <option value="HK" <?= $profile['country'] == 'HK' ? 'selected' : '' ?>>香港</option>
                                                                    <option value="HU" <?= $profile['country'] == 'HU' ? 'selected' : '' ?>>Magyarország</option>
                                                                    <option value="IS" <?= $profile['country'] == 'IS' ? 'selected' : '' ?>>Ísland</option>
                                                                    <option value="IN" <?= $profile['country'] == 'IN' ? 'selected' : '' ?>>भारत</option>
                                                                    <option value="ID" <?= $profile['country'] == 'ID' ? 'selected' : '' ?>>Indonesia</option>
                                                                    <option value="IR" <?= $profile['country'] == 'IR' ? 'selected' : '' ?>>ایران</option>
                                                                    <option value="IQ" <?= $profile['country'] == 'IQ' ? 'selected' : '' ?>>العراق</option>
                                                                    <option value="IE" <?= $profile['country'] == 'IE' ? 'selected' : '' ?>>Éire</option>
                                                                    <option value="IM" <?= $profile['country'] == 'IM' ? 'selected' : '' ?>>Isle Of Man</option>
                                                                    <option value="IL" <?= $profile['country'] == 'IL' ? 'selected' : '' ?>>ישראל</option>
                                                                    <option value="IT" <?= $profile['country'] == 'IT' ? 'selected' : '' ?>>Italia</option>
                                                                    <option value="JM" <?= $profile['country'] == 'JM' ? 'selected' : '' ?>>Jamaica</option>
                                                                    <option value="JP" <?= $profile['country'] == 'JP' ? 'selected' : '' ?>>日本</option>
                                                                    <option value="JE" <?= $profile['country'] == 'JE' ? 'selected' : '' ?>>Jersey</option>
                                                                    <option value="JO" <?= $profile['country'] == 'JO' ? 'selected' : '' ?>>الأردن</option>
                                                                    <option value="KZ" <?= $profile['country'] == 'KZ' ? 'selected' : '' ?>>Қазақстан</option>
                                                                    <option value="KE" <?= $profile['country'] == 'KE' ? 'selected' : '' ?>>Kenya</option>
                                                                    <option value="KI" <?= $profile['country'] == 'KI' ? 'selected' : '' ?>>Kiribati</option>
                                                                    <option value="KR" <?= $profile['country'] == 'KR' ? 'selected' : '' ?>>한국</option>
                                                                    <option value="XK" <?= $profile['country'] == 'XK' ? 'selected' : '' ?>>Kosova</option>
                                                                    <option value="KW" <?= $profile['country'] == 'KW' ? 'selected' : '' ?>>الكويت</option>
                                                                    <option value="KG" <?= $profile['country'] == 'KG' ? 'selected' : '' ?>>Кыргызстан</option>
                                                                    <option value="LA" <?= $profile['country'] == 'LA' ? 'selected' : '' ?>>ປະເທດລາວ</option>
                                                                    <option value="LV" <?= $profile['country'] == 'LV' ? 'selected' : '' ?>>Latvija</option>
                                                                    <option value="LB" <?= $profile['country'] == 'LB' ? 'selected' : '' ?>>لبنان</option>
                                                                    <option value="LS" <?= $profile['country'] == 'LS' ? 'selected' : '' ?>>Lesotho</option>
                                                                    <option value="LR" <?= $profile['country'] == 'LR' ? 'selected' : '' ?>>Liberia</option>
                                                                    <option value="LY" <?= $profile['country'] == 'LY' ? 'selected' : '' ?>>ليبيا</option>
                                                                    <option value="LI" <?= $profile['country'] == 'LI' ? 'selected' : '' ?>>Liechtenstein</option>
                                                                    <option value="LT" <?= $profile['country'] == 'LT' ? 'selected' : '' ?>>Lietuva</option>
                                                                    <option value="LU" <?= $profile['country'] == 'LU' ? 'selected' : '' ?>>Luxembourg</option>
                                                                    <option value="MO" <?= $profile['country'] == 'MO' ? 'selected' : '' ?>>澳門</option>
                                                                    <option value="MK" <?= $profile['country'] == 'MK' ? 'selected' : '' ?>>Северна Македонија</option>
                                                                    <option value="MG" <?= $profile['country'] == 'MG' ? 'selected' : '' ?>>Madagasikara</option>
                                                                    <option value="MW" <?= $profile['country'] == 'MW' ? 'selected' : '' ?>>Malawi</option>
                                                                    <option value="MY" <?= $profile['country'] == 'MY' ? 'selected' : '' ?>>Malaysia</option>
                                                                    <option value="MV" <?= $profile['country'] == 'MV' ? 'selected' : '' ?>>Maldives</option>
                                                                    <option value="ML" <?= $profile['country'] == 'ML' ? 'selected' : '' ?>>Mali</option>
                                                                    <option value="MT" <?= $profile['country'] == 'MT' ? 'selected' : '' ?>>Malta</option>
                                                                    <option value="MH" <?= $profile['country'] == 'MH' ? 'selected' : '' ?>>Marshall Islands</option>
                                                                    <option value="MQ" <?= $profile['country'] == 'MQ' ? 'selected' : '' ?>>Martinique</option>
                                                                    <option value="MR" <?= $profile['country'] == 'MR' ? 'selected' : '' ?>>موريتانيا</option>
                                                                    <option value="MU" <?= $profile['country'] == 'MU' ? 'selected' : '' ?>>Maurice</option>
                                                                    <option value="YT" <?= $profile['country'] == 'YT' ? 'selected' : '' ?>>Mayotte</option>
                                                                    <option value="MX" <?= $profile['country'] == 'MX' ? 'selected' : '' ?>>México</option>
                                                                    <option value="FM" <?= $profile['country'] == 'FM' ? 'selected' : '' ?>>Micronesia</option>
                                                                    <option value="MD" <?= $profile['country'] == 'MD' ? 'selected' : '' ?>>Moldova</option>
                                                                    <option value="MC" <?= $profile['country'] == 'MC' ? 'selected' : '' ?>>Monaco</option>
                                                                    <option value="MN" <?= $profile['country'] == 'MN' ? 'selected' : '' ?>>Монгол</option>
                                                                    <option value="ME" <?= $profile['country'] == 'ME' ? 'selected' : '' ?>>Crna Gora</option>
                                                                    <option value="MS" <?= $profile['country'] == 'MS' ? 'selected' : '' ?>>Montserrat</option>
                                                                    <option value="MA" <?= $profile['country'] == 'MA' ? 'selected' : '' ?>>المغرب</option>
                                                                    <option value="MZ" <?= $profile['country'] == 'MZ' ? 'selected' : '' ?>>Moçambique</option>
                                                                    <option value="MM" <?= $profile['country'] == 'MM' ? 'selected' : '' ?>>မြန်မာ</option>
                                                                    <option value="NA" <?= $profile['country'] == 'NA' ? 'selected' : '' ?>>Namibia</option>
                                                                    <option value="NR" <?= $profile['country'] == 'NR' ? 'selected' : '' ?>>Nauru</option>
                                                                    <option value="NP" <?= $profile['country'] == 'NP' ? 'selected' : '' ?>>नेपाल</option>
                                                                    <option value="NL" <?= $profile['country'] == 'NL' ? 'selected' : '' ?>>Nederland</option>
                                                                    <option value="AN" <?= $profile['country'] == 'AN' ? 'selected' : '' ?>>Netherlands Antilles</option>
                                                                    <option value="NC" <?= $profile['country'] == 'NC' ? 'selected' : '' ?>>Nouvelle-Calédonie</option>
                                                                    <option value="NZ" <?= $profile['country'] == 'NZ' ? 'selected' : '' ?>>New Zealand</option>
                                                                    <option value="NI" <?= $profile['country'] == 'NI' ? 'selected' : '' ?>>Nicaragua</option>
                                                                    <option value="NE" <?= $profile['country'] == 'NE' ? 'selected' : '' ?>>Niger</option>
                                                                    <option value="NG" <?= $profile['country'] == 'NG' ? 'selected' : '' ?>>Nigeria</option>
                                                                    <option value="NU" <?= $profile['country'] == 'NU' ? 'selected' : '' ?>>Niue</option>
                                                                    <option value="NF" <?= $profile['country'] == 'NF' ? 'selected' : '' ?>>Norfolk Island</option>
                                                                    <option value="MP" <?= $profile['country'] == 'MP' ? 'selected' : '' ?>>Northern Mariana Islands</option>
                                                                    <option value="NO" <?= $profile['country'] == 'NO' ? 'selected' : '' ?>>Norge</option>
                                                                    <option value="OM" <?= $profile['country'] == 'OM' ? 'selected' : '' ?>>عُمان</option>
                                                                    <option value="PK" <?= $profile['country'] == 'PK' ? 'selected' : '' ?>>پاکستان</option>
                                                                    <option value="PW" <?= $profile['country'] == 'PW' ? 'selected' : '' ?>>Palau</option>
                                                                    <option value="PS" <?= $profile['country'] == 'PS' ? 'selected' : '' ?>>فلسطين</option>
                                                                    <option value="PA" <?= $profile['country'] == 'PA' ? 'selected' : '' ?>>Panamá</option>
                                                                    <option value="PG" <?= $profile['country'] == 'PG' ? 'selected' : '' ?>>Papua New Guinea</option>
                                                                    <option value="PY" <?= $profile['country'] == 'PY' ? 'selected' : '' ?>>Paraguay</option>
                                                                    <option value="PE" <?= $profile['country'] == 'PE' ? 'selected' : '' ?>>Perú</option>
                                                                    <option value="PH" <?= $profile['country'] == 'PH' ? 'selected' : '' ?>>Pilipinas</option>
                                                                    <option value="PN" <?= $profile['country'] == 'PN' ? 'selected' : '' ?>>Pitcairn</option>
                                                                    <option value="PL" <?= $profile['country'] == 'PL' ? 'selected' : '' ?>>Polska</option>
                                                                    <option value="PT" <?= $profile['country'] == 'PT' ? 'selected' : '' ?>>Portugal</option>
                                                                    <option value="PR" <?= $profile['country'] == 'PR' ? 'selected' : '' ?>>Puerto Rico</option>
                                                                    <option value="QA" <?= $profile['country'] == 'QA' ? 'selected' : '' ?>>قطر</option>
                                                                    <option value="RE" <?= $profile['country'] == 'RE' ? 'selected' : '' ?>>Réunion</option>
                                                                    <option value="RO" <?= $profile['country'] == 'RO' ? 'selected' : '' ?>>România</option>
                                                                    <option value="RU" <?= $profile['country'] == 'RU' ? 'selected' : '' ?>>Россия</option>
                                                                    <option value="RW" <?= $profile['country'] == 'RW' ? 'selected' : '' ?>>Rwanda</option>
                                                                    <option value="BL" <?= $profile['country'] == 'BL' ? 'selected' : '' ?>>Saint-Barthélemy</option>
                                                                    <option value="SH" <?= $profile['country'] == 'SH' ? 'selected' : '' ?>>Saint Helena</option>
                                                                    <option value="KN" <?= $profile['country'] == 'KN' ? 'selected' : '' ?>>Saint Kitts And Nevis</option>
                                                                    <option value="LC" <?= $profile['country'] == 'LC' ? 'selected' : '' ?>>Saint Lucia</option>
                                                                    <option value="MF" <?= $profile['country'] == 'MF' ? 'selected' : '' ?>>Saint-Martin</option>
                                                                    <option value="PM" <?= $profile['country'] == 'PM' ? 'selected' : '' ?>>Saint-Pierre-et-Miquelon</option>
                                                                    <option value="VC" <?= $profile['country'] == 'VC' ? 'selected' : '' ?>>Saint Vincent And Grenadines</option>
                                                                    <option value="WS" <?= $profile['country'] == 'WS' ? 'selected' : '' ?>>Samoa</option>
                                                                    <option value="SM" <?= $profile['country'] == 'SM' ? 'selected' : '' ?>>San Marino</option>
                                                                    <option value="ST" <?= $profile['country'] == 'ST' ? 'selected' : '' ?>>São Tomé e Príncipe</option>
                                                                    <option value="SA" <?= $profile['country'] == 'SA' ? 'selected' : '' ?>>المملكة العربية السعودية</option>
                                                                    <option value="SN" <?= $profile['country'] == 'SN' ? 'selected' : '' ?>>Sénégal</option>
                                                                    <option value="RS" <?= $profile['country'] == 'RS' ? 'selected' : '' ?>>Srbija</option>
                                                                    <option value="SC" <?= $profile['country'] == 'SC' ? 'selected' : '' ?>>Seychelles</option>
                                                                    <option value="SL" <?= $profile['country'] == 'SL' ? 'selected' : '' ?>>Sierra Leone</option>
                                                                    <option value="SG" <?= $profile['country'] == 'SG' ? 'selected' : '' ?>>Singapore</option>
                                                                    <option value="SK" <?= $profile['country'] == 'SK' ? 'selected' : '' ?>>Slovensko</option>
                                                                    <option value="SI" <?= $profile['country'] == 'SI' ? 'selected' : '' ?>>Slovenija</option>
                                                                    <option value="SB" <?= $profile['country'] == 'SB' ? 'selected' : '' ?>>Solomon Islands</option>
                                                                    <option value="SO" <?= $profile['country'] == 'SO' ? 'selected' : '' ?>>Soomaaliya</option>
                                                                    <option value="ZA" <?= $profile['country'] == 'ZA' ? 'selected' : '' ?>>South Africa</option>
                                                                    <option value="GS" <?= $profile['country'] == 'GS' ? 'selected' : '' ?>>South Georgia And Sandwich Isl.</option>
                                                                    <option value="ES" <?= $profile['country'] == 'ES' ? 'selected' : '' ?>>España</option>
                                                                    <option value="LK" <?= $profile['country'] == 'LK' ? 'selected' : '' ?>>ශ්‍රී ලංකා</option>
                                                                    <option value="SD" <?= $profile['country'] == 'SD' ? 'selected' : '' ?>>السودان</option>
                                                                    <option value="SS" <?= $profile['country'] == 'SS' ? 'selected' : '' ?>>South Sudan</option>
                                                                    <option value="SR" <?= $profile['country'] == 'SR' ? 'selected' : '' ?>>Suriname</option>
                                                                    <option value="SJ" <?= $profile['country'] == 'SJ' ? 'selected' : '' ?>>Svalbard And Jan Mayen</option>
                                                                    <option value="SZ" <?= $profile['country'] == 'SZ' ? 'selected' : '' ?>>Swaziland</option>
                                                                    <option value="SE" <?= $profile['country'] == 'SE' ? 'selected' : '' ?>>Sverige</option>
                                                                    <option value="CH" <?= $profile['country'] == 'CH' ? 'selected' : '' ?>>Schweiz</option>
                                                                    <option value="SY" <?= $profile['country'] == 'SY' ? 'selected' : '' ?>>سوريا</option>
                                                                    <option value="TW" <?= $profile['country'] == 'TW' ? 'selected' : '' ?>>台灣</option>
                                                                    <option value="TJ" <?= $profile['country'] == 'TJ' ? 'selected' : '' ?>>Тоҷикистон</option>
                                                                    <option value="TZ" <?= $profile['country'] == 'TZ' ? 'selected' : '' ?>>Tanzania</option>
                                                                    <option value="TH" <?= $profile['country'] == 'TH' ? 'selected' : '' ?>>ประเทศไทย</option>
                                                                    <option value="TL" <?= $profile['country'] == 'TL' ? 'selected' : '' ?>>Timor-Leste</option>
                                                                    <option value="TG" <?= $profile['country'] == 'TG' ? 'selected' : '' ?>>Togo</option>
                                                                    <option value="TK" <?= $profile['country'] == 'TK' ? 'selected' : '' ?>>Tokelau</option>
                                                                    <option value="TO" <?= $profile['country'] == 'TO' ? 'selected' : '' ?>>Tonga</option>
                                                                    <option value="TT" <?= $profile['country'] == 'TT' ? 'selected' : '' ?>>Trinidad And Tobago</option>
                                                                    <option value="TN" <?= $profile['country'] == 'TN' ? 'selected' : '' ?>>تونس</option>
                                                                    <option value="TR" <?= $profile['country'] == 'TR' ? 'selected' : '' ?>>Türkiye</option>
                                                                    <option value="TM" <?= $profile['country'] == 'TM' ? 'selected' : '' ?>>Türkmenistan</option>
                                                                    <option value="TC" <?= $profile['country'] == 'TC' ? 'selected' : '' ?>>Turks And Caicos Islands</option>
                                                                    <option value="TV" <?= $profile['country'] == 'TV' ? 'selected' : '' ?>>Tuvalu</option>
                                                                    <option value="UG" <?= $profile['country'] == 'UG' ? 'selected' : '' ?>>Uganda</option>
                                                                    <option value="UA" <?= $profile['country'] == 'UA' ? 'selected' : '' ?>>Україна</option>
                                                                    <option value="AE" <?= $profile['country'] == 'AE' ? 'selected' : '' ?>>الإمارات العربية المتحدة</option>
                                                                    <option value="GB" <?= $profile['country'] == 'GB' ? 'selected' : '' ?>>United Kingdom</option>
                                                                    <option value="US" <?= $profile['country'] == 'US' ? 'selected' : '' ?>>United States</option>
                                                                    <option value="UM" <?= $profile['country'] == 'UM' ? 'selected' : '' ?>>United States Outlying Islands</option>
                                                                    <option value="UY" <?= $profile['country'] == 'UY' ? 'selected' : '' ?>>Uruguay</option>
                                                                    <option value="UZ" <?= $profile['country'] == 'UZ' ? 'selected' : '' ?>>Oʻzbekiston</option>
                                                                    <option value="VU" <?= $profile['country'] == 'VU' ? 'selected' : '' ?>>Vanuatu</option>
                                                                    <option value="VE" <?= $profile['country'] == 'VE' ? 'selected' : '' ?>>Venezuela</option>
                                                                    <option value="VN" <?= $profile['country'] == 'VN' ? 'selected' : '' ?>>Việt Nam</option>
                                                                    <option value="VG" <?= $profile['country'] == 'VG' ? 'selected' : '' ?>>Virgin Islands, British</option>
                                                                    <option value="VI" <?= $profile['country'] == 'VI' ? 'selected' : '' ?>>Virgin Islands, U.S.</option>
                                                                    <option value="WF" <?= $profile['country'] == 'WF' ? 'selected' : '' ?>>Wallis-et-Futuna</option>
                                                                    <option value="EH" <?= $profile['country'] == 'EH' ? 'selected' : '' ?>>الصحراء الغربية</option>
                                                                    <option value="YE" <?= $profile['country'] == 'YE' ? 'selected' : '' ?>>اليمن</option>
                                                                    <option value="ZM" <?= $profile['country'] == 'ZM' ? 'selected' : '' ?>>Zambia</option>
                                                                    <option value="ZW" <?= $profile['country'] == 'ZW' ? 'selected' : '' ?>>Zimbabwe</option>

                                                                  </select>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                Şehir
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="city" value="<?php echo e($profile['city']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                İlçe
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="state" value="<?php echo e($profile['state']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                Adres
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="address1" value="<?php echo e($profile['address1']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  Posta Kodu
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <input name="postcode" value="<?php echo e($profile['postcode']); ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"alert type="text">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]" >
                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                    <div class="grid gap-y-2">
                                                        <div class="flex items-center gap-x-3 justify-between">
                                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.firstname">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  Üyelik Tipi
                                                                </span>
                                                            </label>
                                                        </div>

                                                        <div class="grid auto-cols-fr gap-y-2">
                                                            <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                <div class="min-w-0 flex-1">
                                                                    <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)]  dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="membertype">
                                                                      <option value="3" <?= $profile['groupid'] == '3' ? 'selected' : '' ?>>Bireysel</option>
                                                                      <option value="1" <?= $profile['groupid'] == '1' ? 'selected' : '' ?>>Kurumsal</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div id="alert"></div>

                                        <?php
                                        $tc = '';
                                        $dogumyil = '';
                                        $eksikler = [];

                                        if (!empty($profile['customfields']) && is_array($profile['customfields'])) {
                                            foreach ($profile['customfields'] as $field) {
                                                if ($field['id'] == 3) $tc = $field['value'] ?? '';
                                                if ($field['id'] == 4) $dogumyil = $field['value'] ?? '';
                                            }
                                        }

                                        if (empty($profile['firstname']))    $eksikler[] = "Ad";
                                        if (empty($profile['lastname']))     $eksikler[] = "Soyad";
                                        if (empty($profile['address1']))     $eksikler[] = "Adres";
                                        if (empty($profile['city']))         $eksikler[] = "Şehir";
                                        if (empty($profile['state']))        $eksikler[] = "İl";
                                        if (empty($profile['postcode']))     $eksikler[] = "Posta Kodu";
                                        if (empty($tc))                      $eksikler[] = "TC Kimlik Numarası";
                                        if (empty($dogumyil))                $eksikler[] = "Doğum Yılı";
                                        ?>

                                        <?php if (!empty($eksikler)): ?>
                                            <div class="alert alert-danger">
                                              <div style="margin-top:20px;" class="bg-red-100 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert">
                                                <svg style="margin-right:5px;" aria-hidden="true" class="flex-shrink-0 h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"></path>
                                                </svg>
                                                <div>
                                                  <span class="font-medium">Bilgilendirme! </span>
                                                  Lütfen eksik profil bilgilerinizi tamamlayınız. (<?php foreach ($eksikler as $alan): ?> <?= $alan ?><?php endforeach; ?>)
                                                </div>
                                              </div>
                                            </div>
                                        <?php endif; ?>

                                        <button id="update-submit-btn" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);width:100%;margin-top:20px;" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom- 400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Değişiklikleri Kaydet</button>
                                    </div>
                                </div>
                                </form>
                                <?php
                                $userAgent = $_SERVER['HTTP_USER_AGENT']; // Tarayıcı bilgisini al
                                $browserName = strtok($userAgent, '/'); // "/" karakterinden önceki kısmı al

                                if ($browserName === "SSMobil") { ?>
                                  <form id="logout" action="<?php echo e(route('logout')); ?>"  method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="fi-section-content-ctn border-t border-gray-200 dark:border-white/10">
                                      <div class="fi-section-content p-6">
                                        <button id="logout" type="submit"  style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);width:100%;margin-top:20px;" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom- 400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Hesabımı Sil</button>
                                      </div>
                                    </div>
                                  </form>
                                <?php } ?>
                            </section>
                        </div>
                </div>
            </div>
        </section>
    </div>

</main>
<script>
function toggleMembertypeVisibility() {
    const selectElement = document.querySelector('select[name="membertype"]');
    const companyNameDiv = document.querySelector('.companyDiv');
    const taxOfficeDiv = document.querySelector('.taxOfficeDiv');
    const taxNumberDiv = document.querySelector('.taxNumberDiv');

    if (!selectElement || !companyNameDiv || !taxOfficeDiv || !taxNumberDiv) return;

    const selectedValue = selectElement.value;
    const show = selectedValue === '1';

    companyNameDiv.style.display = show ? 'block' : 'none';
    taxOfficeDiv.style.display = show ? 'block' : 'none';
    taxNumberDiv.style.display = show ? 'block' : 'none';

    selectElement.removeEventListener('change', toggleMembertypeVisibility); // temizle
    selectElement.addEventListener('change', toggleMembertypeVisibility);
}

(function() {
    // Sayfa yüklendiğinde hemen çalışsın
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', toggleMembertypeVisibility);
    } else {
        toggleMembertypeVisibility();
    }

    // Livewire güncellemesi sonrası tekrar çalışsın
    document.addEventListener('livewire:load', function () {
        Livewire.hook('message.processed', () => {
            toggleMembertypeVisibility();
        });
    });
})();
</script>

<?php if ($profile['email_verified'] == null): ?>
  <script type="text/javascript">
  $(document).ready(function() {
    $(document).on("submit", "#verify-mail-form", function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr("action");
        var method = form.attr("method");
        var data = form.serialize();
        var button = form.find("button#submit-btn");
        var originalButtonText = button.text();

        button.text("Doğrulama kodu gönderiliyor, lütfen bekleyiniz..").prop("disabled", true);

        $.ajax({
            url: url,
            method: method,
            data: data,
            success: function(response) {
                if (response.status === 'success') {
                    button.text("Doğrulama kodu başarılı bir şekilde gönderildi!").prop("disabled", false);
                } else {
                    $("#alert").html('<div style="margin-top:20px;" class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert"><svg style="margin-right:5px;" aria-hidden="true" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/></svg> <span class="sr-only">Info</span><div><span class="font-medium">Hata! </span> ' + response.message + '</div></div>');
                    button.text(originalButtonText).prop("disabled", false);
                }
                //button.text("Doğrulama kodu başarılı bir şekilde gönderildi!").prop("disabled", false);
            },
            error: function(xhr, status, error) {
                $("#alert").html('<div class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm">Form gönderilirken bir hata oluştu. ' + xhr.status + ': ' + xhr.statusText + '</div>');
                button.text(originalButtonText).prop("disabled", false);
            }
        });
    });
  });
</script>
<?php endif; ?>
<script>
$(document).ready(function() {
    $(document).on("submit", "#update-client-form", function(e) {
        e.preventDefault();

        var form = $(this);
        var url = form.attr("action");
        var method = form.attr("method");
        var data = form.serialize();
        var button = form.find("button#update-submit-btn");
        var originalButtonText = button.text();

        button.text("Lütfen bekleyiniz..").prop("disabled", true);

        $.ajax({
            url: url,
            method: method,
            data: data,
            dataType: "json", // JSON beklediğimizi belirtiyoruz
            success: function(response) {
                if (response && response.status === 'success') {
                    $("#alert").html(`
                        <div style="margin-top:20px;" class="bg-green-50 dark:bg-gray-800 dark:text-green-400 flex items-center p-4 rounded-lg text-green-800 text-sm" role="alert">
                            <svg style="margin-right:5px;" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                            </svg>
                            <div><span class="font-medium">Başarılı! </span> ${response.message}</div>
                        </div>
                    `);
                } else {
                    let errorMsg = response && response.message ? response.message : 'Bilinmeyen bir hata oluştu!';
                    $("#alert").html(`
                        <div style="margin-top:20px;" class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert">
                            <svg style="margin-right:5px;" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                            </svg>
                            <div><span class="font-medium">Hata! </span> ${errorMsg}</div>
                        </div>
                    `);
                }
                button.text(originalButtonText).prop("disabled", false);
            },
            error: function(xhr, status, error) {
                let errorMsg = "Form gönderilirken bir hata oluştu.";
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMsg = xhr.responseJSON.message;
                }

                $("#alert").html(`
                    <div class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm">
                        ${errorMsg}
                    </div>
                `);
                button.text(originalButtonText).prop("disabled", false);
            }
        });
    });
});
</script>


<?php echo $__env->make("layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/profile.blade.php ENDPATH**/ ?>