<?php $pageTitle = 'Anasayfa'; ?>
<?php echo $__env->make("layouts.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style media="screen">
  .icon {width: 20px;}
  .dark .icon{
    fill:white;
  }
  .ssmobil-mb-50{
    margin-bottom: 50px !important;
  }
</style>

<?php
setcookie("app_client_id", $userid, time() + (365 * 24 * 60 * 60), "/"); // 1 yıl geçerli
?>
<main class="ssmobil-mb-50 fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Göstergeler
                    </h1>
                </div>
            </header>
            <?php if (isset($sepet_get)): ?>
              <div class="flex items-center p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400" role="alert">
                <svg class="shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                </svg>
                <a href="/cart">
                  <div>
                    <span class="font-medium" style="margin-left:5px;margin-right:5px;"> Hatırlatma!</span>Sepetinizde ürünler var, incelemek için hemen tıklayın!
                  </div>
                </a>
              </div>
            <?php endif; ?>
            <div class="ssmobil-dash fi-wi-stats-overview-stats-ctn grid gap-6 md:grid-cols-2 xl:grid-cols-4">
              <a href="hostings">
                <div class="fi-wi-stats-overview-stat relative rounded-xl bg-white p-6 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10">
                    <div class="grid gap-y-2">
                        <div class="flex items-center gap-x-2">
                            <svg class="icon icon-lg fill-current text-gray-900 dark:text-gray-100" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 400.001 400" xml:space="preserve">
                              <path d="M373.509,51.66H352.76V33.114c0-7.312-5.932-13.246-13.246-13.246H60.485c-7.314,0-13.246,5.935-13.246,13.246v68.875
                              c0,7.316,5.932,13.245,13.246,13.245h279.029c7.314,0,13.246-5.929,13.246-13.245V78.146h20.749v243.711H352.76v-23.842
                              c0-7.316-5.932-13.246-13.246-13.246H60.485c-7.314,0-13.246,5.93-13.246,13.246v23.842H26.491v-108.61H47.24v21.19
                              c0,7.313,5.932,13.244,13.246,13.244h279.029c7.314,0,13.246-5.931,13.246-13.244v-68.872c0-7.315-5.932-13.245-13.246-13.245
                              H60.485c-7.314,0-13.246,5.93-13.246,13.245v21.19H26.491C11.885,186.756,0,198.64,0,213.246v108.609
                              c0,14.606,11.884,26.486,26.491,26.486H47.24v18.546c0,7.313,5.932,13.246,13.246,13.246h279.029
                              c7.314,0,13.246-5.935,13.246-13.246v-18.546h20.749c14.606,0,26.491-11.88,26.491-26.486V78.148
                              C400,63.54,388.115,51.66,373.509,51.66z M109.052,88.304c-11.462,0-20.751-9.293-20.751-20.75
                              c0-11.462,9.29-20.751,20.751-20.751c11.459,0,20.749,9.289,20.749,20.751C129.801,79.011,120.511,88.304,109.052,88.304z
                              M219.867,80.798c0,5.483-4.448,9.931-9.937,9.931c-5.485,0-9.933-4.447-9.933-9.931V54.31c0-5.488,4.446-9.936,9.933-9.936
                              c5.487,0,9.937,4.447,9.937,9.936V80.798z M264.016,80.798c0,5.483-4.445,9.931-9.933,9.931c-5.485,0-9.933-4.447-9.933-9.931
                              V54.31c0-5.488,4.446-9.936,9.933-9.936s9.933,4.447,9.933,9.936V80.798z M308.167,80.798c0,5.483-4.446,9.931-9.935,9.931
                              c-5.486,0-9.934-4.447-9.934-9.931V54.31c0-5.488,4.446-9.936,9.934-9.936c5.486,0,9.935,4.447,9.935,9.936V80.798z
                              M288.3,186.759c0-5.486,4.446-9.936,9.934-9.936c5.486,0,9.935,4.449,9.935,9.936v26.488c0,5.486-4.446,9.937-9.935,9.937
                              c-5.486,0-9.934-4.449-9.934-9.937V186.759z M244.15,186.759c0-5.486,4.446-9.936,9.933-9.936s9.933,4.449,9.933,9.936v26.488
                              c0,5.486-4.445,9.937-9.933,9.937c-5.485,0-9.933-4.449-9.933-9.937V186.759z M200,186.759c0-5.486,4.447-9.936,9.934-9.936
                              c5.485,0,9.936,4.449,9.936,9.936v26.488c0,5.486-4.448,9.937-9.936,9.937c-5.486,0-9.934-4.45-9.934-9.937V186.759z
                              M109.052,179.25c11.459,0,20.749,9.29,20.749,20.752s-9.29,20.752-20.749,20.752c-11.462,0-20.751-9.29-20.751-20.752
                              S97.59,179.25,109.052,179.25z M109.052,353.203c-11.462,0-20.751-9.289-20.751-20.751c0-11.457,9.29-20.75,20.751-20.75
                              c11.459,0,20.749,9.293,20.749,20.75C129.801,343.914,120.511,353.203,109.052,353.203z M219.867,345.696
                              c0,5.487-4.448,9.936-9.937,9.936c-5.485,0-9.933-4.446-9.933-9.936v-26.488c0-5.481,4.446-9.93,9.933-9.93
                              c5.487,0,9.937,4.445,9.937,9.93V345.696z M264.016,345.696c0,5.487-4.445,9.936-9.933,9.936c-5.485,0-9.933-4.446-9.933-9.936
                              v-26.488c0-5.481,4.446-9.93,9.933-9.93s9.933,4.445,9.933,9.93V345.696z M308.167,345.696c0,5.487-4.446,9.936-9.935,9.936
                              c-5.486,0-9.934-4.446-9.934-9.936v-26.488c0-5.481,4.446-9.93,9.934-9.93c5.486,0,9.935,4.445,9.935,9.93V345.696z" fill-rule="evenodd"/>
                            </svg>

                            <span class="fi-wi-stats-overview-stat-label text-sm font-medium text-gray-500 dark:text-gray-400">
                                Hostinglerim
                            </span>
                        </div>

                        <div class="fi-wi-stats-overview-stat-value text-3xl font-semibold tracking-tight text-gray-950 dark:text-white">
                            <?php echo e($productCountHosting); ?>

                        </div>
                    </div>
                </div>
                </a>
                <a href="domains">
                <div class="fi-wi-stats-overview-stat relative rounded-xl bg-white p-6 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10">
                    <div class="grid gap-y-2">
                        <div class="flex items-center gap-x-2">
                            <svg class="icon icon-lg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"   viewBox="0 0 24 24" enable-background="new 0 0 24 24">
	                          	<path d="M 12 2 C 8.4 2 5.10625 4 3.40625 7 L 5.8125 7 C 6.7125 5.9 7.8875 5 9.1875 4.5 C 8.8875 5.2 8.7 6.1 8.5 7 L 10.59375 7 C 10.99375 5 11.7 4 12 4 C 12.3 4 13 5 13.5 7 L 15.59375 7 C 15.39375 6.1 15.2125 5.2 14.8125 4.5 C 16.1125 5 17.2875 5.9 18.1875 7 L 20.59375 7 C 18.89375 4 15.6 2 12 2 z M 0 9 L 1.3125 15 L 2.6875 15 L 3.59375 11.5 L 4.40625 15 L 5.6875 15 L 7 9 L 5.59375 9 L 5 12.8125 L 4.09375 9 L 2.90625 9 L 2.09375 12.8125 L 1.40625 9 L 0 9 z M 8.5 9 L 9.6875 15 L 11.1875 15 L 12 11.5 L 12.8125 15 L 14.1875 15 L 15.5 9 L 14.09375 9 L 13.40625 12.8125 L 12.59375 9 L 11.40625 9 L 10.59375 12.8125 L 9.90625 9 L 8.5 9 z M 17 9 L 18.3125 15 L 19.6875 15 L 20.5 11.5 L 21.3125 15 L 22.6875 15 L 24 9 L 22.59375 9 L 21.90625 12.8125 L 21.09375 9 L 19.90625 9 L 19.09375 12.8125 L 18.40625 9 L 17 9 z M 3.40625 17 C 5.10625 20 8.4 22 12 22 C 15.6 22 18.89375 20 20.59375 17 L 18.1875 17 C 17.2875 18.1 16.1125 19 14.8125 19.5 C 15.1125 18.8 15.39375 17.9 15.59375 17 L 13.5 17 C 13 19 12.4 20 12 20 C 11.6 20 11 19 10.5 17 L 8.5 17 C 8.7 17.9 8.9125 18.8 9.3125 19.5 C 7.9125 19 6.7125 18.1 5.8125 17 L 3.40625 17 z"/>
                            </svg>

                            <span class="fi-wi-stats-overview-stat-label text-sm font-medium text-gray-500 dark:text-gray-400">
                                Domainlerim
                            </span>

                        </div>

                        <div class="fi-wi-stats-overview-stat-value text-3xl font-semibold tracking-tight text-gray-950 dark:text-white">
                            <?php echo e($domainCount); ?>

                        </div>
                    </div>
                </div>
                </a>
                <a href="servers">
                <div class="fi-wi-stats-overview-stat relative rounded-xl bg-white p-6 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10">
                    <div class="grid gap-y-2">
                        <div class="flex items-center gap-x-2">
                            <svg class="icon icon-lg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"   viewBox="0 0 60 60" xml:space="preserve">
                              <path d="M0,24.108v11.783c0,0.974,0.314,1.868,0.835,2.608h58.329C59.686,37.76,60,36.865,60,35.892V24.108
                           		c0-0.974-0.314-1.868-0.835-2.608H0.835C0.314,22.24,0,23.135,0,24.108z M52,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                           		S51.448,30.5,52,30.5z M50,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S49.448,27.5,50,27.5z M48,30.5c0.552,0,1,0.448,1,1
                           		s-0.448,1-1,1s-1-0.448-1-1S47.448,30.5,48,30.5z M46,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S45.448,27.5,46,27.5z
                           		 M44,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S43.448,30.5,44,30.5z M42,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1
                           		s-1-0.448-1-1S41.448,27.5,42,27.5z M40,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S39.448,30.5,40,30.5z M38,27.5
                           		c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S37.448,27.5,38,27.5z M36,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                           		S35.448,30.5,36,30.5z M34,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S33.448,27.5,34,27.5z M10.5,25.5
                           		c2.481,0,4.5,2.019,4.5,4.5s-2.019,4.5-4.5,4.5S6,32.481,6,30S8.019,25.5,10.5,25.5z"/>
	                           <path d="M59.165,19.5C59.686,18.76,60,17.865,60,16.892V5.108C60,2.567,57.933,0.5,55.392,0.5H4.608C2.067,0.5,0,2.567,0,5.108
                           		v11.783c0,0.974,0.314,1.868,0.835,2.608H59.165z M52,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S51.448,11.5,52,11.5z
                           		 M50,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S49.448,8.5,50,8.5z M48,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1
                           		s-1-0.448-1-1S47.448,11.5,48,11.5z M46,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S45.448,8.5,46,8.5z M44,11.5
                           		c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S43.448,11.5,44,11.5z M42,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                           		S41.448,8.5,42,8.5z M40,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S39.448,11.5,40,11.5z M38,8.5c0.552,0,1,0.448,1,1
                           		s-0.448,1-1,1s-1-0.448-1-1S37.448,8.5,38,8.5z M36,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S35.448,11.5,36,11.5z
                           		 M34,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S33.448,8.5,34,8.5z M10.5,6.5c2.481,0,4.5,2.019,4.5,4.5
                           		s-2.019,4.5-4.5,4.5S6,13.481,6,11S8.019,6.5,10.5,6.5z"/>
	                           <path d="M0.835,40.5C0.314,41.24,0,42.135,0,43.108v11.783C0,57.433,2.067,59.5,4.608,59.5h50.783c2.541,0,4.608-2.067,4.608-4.608
                           		V43.108c0-0.974-0.314-1.868-0.835-2.608H0.835z M10.5,53.5C8.019,53.5,6,51.481,6,49s2.019-4.5,4.5-4.5S15,46.519,15,49
                           		S12.981,53.5,10.5,53.5z M34,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S34.552,48.5,34,48.5z M36,51.5
                           		c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S36.552,51.5,36,51.5z M38,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1
                           		S38.552,48.5,38,48.5z M40,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S40.552,51.5,40,51.5z M42,48.5c-0.552,0-1-0.448-1-1
                           		s0.448-1,1-1s1,0.448,1,1S42.552,48.5,42,48.5z M44,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S44.552,51.5,44,51.5z
                           		 M46,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S46.552,48.5,46,48.5z M48,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1
                           		s1,0.448,1,1S48.552,51.5,48,51.5z M50,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S50.552,48.5,50,48.5z M52,51.5
                           		c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S52.552,51.5,52,51.5z"/>
                            </svg>
                            <span class="fi-wi-stats-overview-stat-label text-sm font-medium text-gray-500 dark:text-gray-400">
                                Sunucularım
                            </span>
                        </div>

                        <div class="fi-wi-stats-overview-stat-value text-3xl font-semibold tracking-tight text-gray-950 dark:text-white">
                            <?php echo e($productCountServer); ?>

                        </div>
                    </div>
                </div>
                </a>
                <a href="others">
                <div class="fi-wi-stats-overview-stat relative rounded-xl bg-white p-6 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10">
                    <div class="grid gap-y-2">
                        <div class="flex items-center gap-x-2">
                            <svg class="icon icon-lg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"   viewBox="0 0 60 60" xml:space="preserve">
                              <path d="M0,24.108v11.783c0,0.974,0.314,1.868,0.835,2.608h58.329C59.686,37.76,60,36.865,60,35.892V24.108
                              c0-0.974-0.314-1.868-0.835-2.608H0.835C0.314,22.24,0,23.135,0,24.108z M52,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                              S51.448,30.5,52,30.5z M50,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S49.448,27.5,50,27.5z M48,30.5c0.552,0,1,0.448,1,1
                              s-0.448,1-1,1s-1-0.448-1-1S47.448,30.5,48,30.5z M46,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S45.448,27.5,46,27.5z
                               M44,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S43.448,30.5,44,30.5z M42,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1
                              s-1-0.448-1-1S41.448,27.5,42,27.5z M40,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S39.448,30.5,40,30.5z M38,27.5
                              c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S37.448,27.5,38,27.5z M36,30.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                              S35.448,30.5,36,30.5z M34,27.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S33.448,27.5,34,27.5z M10.5,25.5
                              c2.481,0,4.5,2.019,4.5,4.5s-2.019,4.5-4.5,4.5S6,32.481,6,30S8.019,25.5,10.5,25.5z"/>
                             <path d="M59.165,19.5C59.686,18.76,60,17.865,60,16.892V5.108C60,2.567,57.933,0.5,55.392,0.5H4.608C2.067,0.5,0,2.567,0,5.108
                              v11.783c0,0.974,0.314,1.868,0.835,2.608H59.165z M52,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S51.448,11.5,52,11.5z
                               M50,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S49.448,8.5,50,8.5z M48,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1
                              s-1-0.448-1-1S47.448,11.5,48,11.5z M46,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S45.448,8.5,46,8.5z M44,11.5
                              c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S43.448,11.5,44,11.5z M42,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1
                              S41.448,8.5,42,8.5z M40,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S39.448,11.5,40,11.5z M38,8.5c0.552,0,1,0.448,1,1
                              s-0.448,1-1,1s-1-0.448-1-1S37.448,8.5,38,8.5z M36,11.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S35.448,11.5,36,11.5z
                               M34,8.5c0.552,0,1,0.448,1,1s-0.448,1-1,1s-1-0.448-1-1S33.448,8.5,34,8.5z M10.5,6.5c2.481,0,4.5,2.019,4.5,4.5
                              s-2.019,4.5-4.5,4.5S6,13.481,6,11S8.019,6.5,10.5,6.5z"/>
                             <path d="M0.835,40.5C0.314,41.24,0,42.135,0,43.108v11.783C0,57.433,2.067,59.5,4.608,59.5h50.783c2.541,0,4.608-2.067,4.608-4.608
                              V43.108c0-0.974-0.314-1.868-0.835-2.608H0.835z M10.5,53.5C8.019,53.5,6,51.481,6,49s2.019-4.5,4.5-4.5S15,46.519,15,49
                              S12.981,53.5,10.5,53.5z M34,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S34.552,48.5,34,48.5z M36,51.5
                              c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S36.552,51.5,36,51.5z M38,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1
                              S38.552,48.5,38,48.5z M40,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S40.552,51.5,40,51.5z M42,48.5c-0.552,0-1-0.448-1-1
                              s0.448-1,1-1s1,0.448,1,1S42.552,48.5,42,48.5z M44,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S44.552,51.5,44,51.5z
                               M46,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S46.552,48.5,46,48.5z M48,51.5c-0.552,0-1-0.448-1-1s0.448-1,1-1
                              s1,0.448,1,1S48.552,51.5,48,51.5z M50,48.5c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S50.552,48.5,50,48.5z M52,51.5
                              c-0.552,0-1-0.448-1-1s0.448-1,1-1s1,0.448,1,1S52.552,51.5,52,51.5z"/>
                            </svg>
                            <span class="fi-wi-stats-overview-stat-label text-sm font-medium text-gray-500 dark:text-gray-400">
                                <?php
                                $userAgent = $_SERVER['HTTP_USER_AGENT'];
                                echo (strpos($userAgent, 'SSMobil') === 0) ? 'Diğer' : 'Diğer Hizmetler';
                                ?>
                            </span>
                        </div>

                        <div class="fi-wi-stats-overview-stat-value text-3xl font-semibold tracking-tight text-gray-950 dark:text-white">
                            <?php echo e($productCountOther); ?>

                        </div>
                    </div>
                </div>
                </a>
            </div>

        </section>
    </div>

    <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
        <div class="fi-ta">
            <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                <div x-bind:hidden="! (true || (selectedRecords.length &amp;&amp; 0))" x-show="true || (selectedRecords.length &amp;&amp; 0)" class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                    <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                        <div class="grid gap-y-1">
                            <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                 Taleplerim
                            </h3>
                        </div>
                    </div>

                    <div  class="fi-ta-header-toolbar flex items-center justify-between gap-x-4 px-4 py-3 sm:px-6" style="display: none;">
                        <div class="flex shrink-0 items-center gap-x-4"></div>
                    </div>
                </div>

                <div class="fi-ta-content relative divide-y divide-gray-200 dark:divide-white/10 dark:border-t-white/10">
                    <table class="fi-ta-table w-full table-auto divide-y divide-gray-200 text-start dark:divide-white/5">
                      <?php if(!empty($recentTickets)): ?>
                      <thead class="divide-y divide-gray-200 dark:divide-white/5">

                          <tr class="bg-gray-50 dark:bg-white/5">

                              <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-certificate-type-id">
                                  <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                      <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                          Destek Talebi Adı
                                      </span>
                                  </span>
                              </th>

                              <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-ended-at" style="width: 1%;">
                                  <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                      <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                          Durum
                                      </span>
                                  </span>
                              </th>
                          </tr>
                      </thead>

                      <tbody class="divide-y divide-gray-200 whitespace-nowrap dark:divide-white/5">
                <?php $__currentLoopData = $recentTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="fi-ta-row [@media(hover:hover)]:transition [@media(hover:hover)]:duration-75" >
                        <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-certificate-type-id">
                            <div class="fi-ta-col-wrp">
                                <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                    <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                        <div class="flex">
                                            <div class="flex max-w-max" style="">
                                                <div class="fi-ta-text-item inline-flex items-center gap-1.5 fi-color-custom">
                                                    <span class="fi-ta-text-item-label text-sm leading-6 text-custom-600 dark:text-custom-400 font-semibold" style="--c-400: 77, 148, 219; --c-600: 0, 92, 184;">
                                                        <a href="/tickets/details/<?php echo e($ticket['tid']); ?>"><?php echo e($ticket['subject']); ?></a>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="text-sm text-gray-500 dark:text-gray-400">
                                          <a href="/tickets/details/<?php echo e($ticket['tid']); ?>">Son güncelleme: <?php echo date_format(date_create($ticket['lastreply']), "d/m/Y H:i") ?></a>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </td>


                        <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-ended-at" key="7glaVX7h3ef5m9xC1cw1.table.record.1.column.ended_at">
                            <div class="fi-ta-col-wrp">
                                <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                    <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                        <div class="flex">
                                            <div class="flex max-w-max" style="">
                                                <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                    <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white" style="">
                                                        <div class="grid grid-flow-col justify-stretch" style="width: 280px;">
                                                            <div class=""><?php
                                                            if ($ticket['status'] == "Open") {
                                                              echo "Açık";
                                                            }
                                                            if ($ticket['status'] == "Cevaplandı") {
                                                              echo "Yanıtlandı";
                                                            }
                                                            if ($ticket['status'] == "Customer-Reply") {
                                                              echo "Yanıtladınız";
                                                            }
                                                            if ($ticket['status'] == "Beklemede") {
                                                              echo "Beklemede";
                                                            }
                                                            if ($ticket['status'] == "İşlem Devam Ediyor") {
                                                              echo "İşlem Devam Ediyor";
                                                            }
                                                            if ($ticket['status'] == "Kapandı") {
                                                              echo "Kapatıldı";
                                                            }if ($ticket['status'] == "Closed") {
                                                              echo "Kapatıldı";
                                                            }
                                                             ?></div>
                                                        </div>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php else: ?>
    <tr class="fi-ta-row [@media(hover:hover)]:transition [@media(hover:hover)]:duration-75" >
        <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-certificate-type-id">
            <div class="fi-ta-col-wrp">
                <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                    <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                        <p style="text-align:center;font-size: 17px;" class="text-sm text-gray-500 dark:text-gray-400">
                          Herhangi bir destek talebiniz bulunmamaktadır.
                        </p>
                    </div>
                </div>
            </div>
        </td>

    </tr>
    <?php endif; ?>




                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
        <div class="fi-ta">
            <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                    <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                        <div class="grid gap-y-1">
                            <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                Aktif Faturalarım
                            </h3>
                        </div>
                    </div>

                    <div  class="fi-ta-header-toolbar flex items-center justify-between gap-x-4 px-4 py-3 sm:px-6" style="display: none;">
                        <div class="flex shrink-0 items-center gap-x-4"></div>
                    </div>
                </div>

                <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                    <table class="fi-ta-table w-full table-auto divide-y divide-gray-200 text-start dark:divide-white/5">
                        <thead class="divide-y divide-gray-200 dark:divide-white/5">
                          <?php if(!empty($unpaidInvoices)): ?>
                            <tr class="bg-gray-50 dark:bg-white/5">

                                <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-certificate-type-id" style="">
                                    <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                        <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                            Fatura Türü
                                        </span>
                                    </span>
                                </th>

                                <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-ended-at" style="width: 1%;">
                                    <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                        <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                            Tarih
                                        </span>
                                    </span>
                                </th>
                            </tr>
                        </thead>

                        <tbody class="divide-y divide-gray-200 whitespace-nowrap dark:divide-white/5">
                            <?php $__currentLoopData = $unpaidInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr class="fi-ta-row [@media(hover:hover)]:transition [@media(hover:hover)]:duration-75" >

                                <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-certificate-type-id">
                                    <div class="fi-ta-col-wrp">
                                        <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                            <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                <div class="flex">

                                                    <div class="flex max-w-max" style="">
                                                        <div class="fi-ta-text-item inline-flex items-center gap-1.5 fi-color-custom">
                                                            <span class="fi-ta-text-item-label text-sm leading-6 text-custom-600 dark:text-custom-400 font-semibold" style="--c-400: 77, 148, 219; --c-600: 0, 92, 184;">
                                                            <a target="_blank" href="invoices/view/<?php echo e($invoice['id']); ?>"> Fatura no: <b> <?php echo e($invoice['id']); ?> </b></a>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>

                                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                                     <a target="_blank" href="invoices/view/<?php echo e($invoice['id']); ?>"> $<?php echo e($invoice['total']); ?></a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-ended-at" key="7glaVX7h3ef5m9xC1cw1.table.record.1.column.ended_at">
                                    <div class="fi-ta-col-wrp">
                                        <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                            <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                <div class="flex">
                                                    <div class="flex max-w-max" style="">
                                                        <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                            <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white" style="">
                                                                <div class="grid grid-flow-col justify-stretch" style="width: 280px;">
                                                                    <div class=""> <?php echo date_format(date_create($invoice['date']), "d/m/Y H:i") ?> </div>
                                                                    <div class="text-primary-500 dark:text-primary-400">- - --&gt;</div>
                                                                    <div class="text-custom-600 dark:text-custom-400 font-medium" style="--c-400: var(--danger-400); --c-600: var(--danger-600);">
                                                                        <?php echo date_format(date_create($invoice['duedate']), "d/m/Y H:i") ?>
                                                                    </div>
                                                                </div>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php else: ?>
                            <tr class="fi-ta-row [@media(hover:hover)]:transition [@media(hover:hover)]:duration-75" >
                                <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-certificate-type-id">
                                    <div class="fi-ta-col-wrp">
                                        <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                            <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                <p style="text-align:center;font-size: 17px;" class="text-sm text-gray-500 dark:text-gray-400">
                                                  Herhangi bir ödenmemiş faturanız bulunmamaktadır.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</main>
<?php echo $__env->make("layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/dashboard.blade.php ENDPATH**/ ?>