<?php $pageTitle = 'Ürün Detayları'; ?>
<?php echo $__env->make("layouts.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style media="screen">
    .mbtn {
        width: 23.5%;
    }

    .label-mobile {
        display: none;
    }

    .label-desktop {
        display: block;
    }

    .label {
        padding: 5px 10px;
        border-radius: 3px;
        font-size: 14px;
        color: white;
        text-align: center;
    }

    .label-default {
        background-color: #777;
    }

    .label-default[href]:hover,
    .label-default[href]:focus {
        background-color: #5e5e5e;
    }

    .label-primary {
        background-color: #337ab7;
    }

    .label-primary[href]:hover,
    .label-primary[href]:focus {
        background-color: #286090;
    }

    .label-success {
        background-color: #5cb85c;
    }

    .label-success[href]:hover,
    .label-success[href]:focus {
        background-color: #449d44;
    }

    .label-info {
        background-color: #5bc0de;
    }

    .label-info[href]:hover,
    .label-info[href]:focus {
        background-color: #31b0d5;
    }

    .label-warning {
        background-color: #f0ad4e;
    }

    .label-warning[href]:hover,
    .label-warning[href]:focus {
        background-color: #ec971f;
    }

    .label-danger {
        background-color: #d9534f;
    }

    .label-danger[href]:hover,
    .label-danger[href]:focus {
        background-color: #c9302c;
    }

    @media only screen and (max-width: 600px) {
        .mr-15 {
            margin-left: 15px;
        }
        .mbtn {
            width: 100%;
            margin-bottom: 5px;
        }
        .label-mobile {
            display: block;
        }
        .label-desktop {
            display: none;
        }
    }
    .btn-console:disabled,
.power-action:disabled {
    background-color: #3a3a3a !important;
    color: #aaa !important;
    cursor: not-allowed !important;
    opacity: 0.6 !important;
}
</style>
<?php
$statusClasses = [
   "Active" => "label-success",
   "Suspended" => "label-warning",
   "Terminated" => "label-danger",
   "Cancelled" => "label-default"
];
$status = $servers['status'];
$cssClass = isset($statusClasses[$status]) ? $statusClasses[$status] : "label-default";
?>


    <main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
        <div class="fi-page fi-dashboard-page">
            <section class="flex flex-col gap-y-8 py-8">
                <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                    <div>
                        <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                            Sunucu Detayları
                        </h1>
                    </div>
                </header>
            </section>
        </div>
            <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Sunucu Bilgileri
                                        </h3>
                                    </div>
                                </div>
                            </div>

                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                <div class="">
                                    <div class="px-6 py-4">
                                        <div class="flex items-center">
                                            <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full label-desktop">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                          <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd" />
                                      </svg>
                                            </div>
                                            <div style="margin-left: 10px;" class="ml-4">
                                                <h1 class="text-xl font-semibold text-gray-900 dark:text-white"><?php echo e($servers['domain']); ?></h1>
                                                <p class="text-gray-600 dark:text-gray-400">
                                                    <?php echo str_replace("-", " ", $servers['name']); ?>
                                                </p>
                                            </div>
                                            <span class="label-desktop label <?php echo $cssClass; ?>  ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                    <?php
                                    if ($servers['status'] == "Active") {
                                      echo "Aktif";
                                    }
                                    if ($servers['status'] == "Expired") {
                                      echo "Süresi Doldu";
                                    }
                                    if ($servers['status'] == "Terminated") {
                                      echo "Kapatıldı";
                                    }
                                    if ($servers['status'] == "Cancelled") {
                                      echo "İptal Edildi";
                                    }
                                     ?>
                                  </span>

                                        </div>
                                        <div style="margin-top:10px;" class="mt-4">
                                            <span style="margin-bottom:5px;border-radius: .5rem;" class="label-mobile label <?php echo $cssClass; ?>  ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                  <?php

                                  if ($servers['status'] == "Active") {
                                    echo "Aktif";
                                  }
                                  if ($servers['status'] == "Expired") {
                                    echo "Süresi Doldu";
                                  }
                                  if ($servers['status'] == "Terminated") {
                                    echo "Kapatıldı";
                                  }
                                  if ($servers['status'] == "Cancelled") {
                                    echo "İptal Edildi";
                                  }
                                   ?>
                                </span>

                                        </div>
                                    </div>
                                    <div class="border-t dark:border-gray-700">
                                        <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                                          <div class="py-2 px-6 flex justify-between">
                                              <dt class="text-gray-600 dark:text-gray-400">Hostname</dt>
                                              <dd class="font-medium text-gray-900 dark:text-gray-200"><?php echo e($servers['domain']); ?></dd>
                                          </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Yenileme Tutarı</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">$<?php echo e($servers['recurringamount']); ?></dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Sonraki Ödeme Tarihi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                  <?php echo date_format(date_create($servers['nextduedate']), "d/m/Y"); ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Ödeme şekli</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                  <?php
                                                  if ($servers['paymentmethod'] == "banktransfer") {
                                                    echo "Banka Transferi";
                                                  }
                                                  if ($servers['paymentmethod'] == "PayTR") {
                                                    echo "Kredi Kartı";
                                                  }
                                                  ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Kayıt Tarihi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                      <?php echo date_format(date_create($servers['regdate']), "d/m/Y"); ?>
                                                </dd>
                                            </div>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Sunucu Ayrıntıları
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                              <div class="">
                                  <div class="px-6 py-4">

                                      <div style="margin-top:10px;" class="mt-4">
                                          <?php if (isset($vm)): ?>
                                            <button onclick="manageVM(this, '<?php echo e($vm['vm']); ?>', 'start')" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Başlat</button>

                                            <button onclick="manageVM(this, '<?php echo e($vm['vm']); ?>', 'stop')" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Durdur</button>

                                            <button onclick="manageVM(this, '<?php echo e($vm['vm']); ?>', 'restart')" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Yeniden Başlat</button>
                                          <?php endif; ?>
                                          <a target="_blank" href="/cancel/<?php echo e($servers['id']); ?>" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                            <span class="fi-btn-label">
                                              İptal Talebi
                                            </span>
                                          </a>
                                          <form action="<?php echo e(route('verifyvm')); ?>" method="POST" class="inline epp-form">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="vmname" value="<?php echo e($servers['domain']); ?>">
                                              <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="btn-console mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" onclick="window.dialog.showModal();">Konsola Bağlan</button>
                                            </form>

                                            <button data-action="start" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="power-action btn-start mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Gücü Aç</button>

                                            <button id="vm-status" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Sunucu Durumu</button>

                                            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
                                            <script type="text/javascript">
                                              document.querySelectorAll('.fi-ac-btn-action').forEach(button => {
                                                button.addEventListener('click', function () {
                                                  const action = this.getAttribute('data-action');
                                                  const domain = '<?php echo e($servers['domain']); ?>';

                                                  const actionTexts = {
                                                    start: {
                                                      title: 'Cihazı Açmak İstiyor Musunuz?',
                                                      confirm: 'Evet, Aç!',
                                                      cancel: 'Vazgeç'
                                                    },

                                                  };

                                                  const { title, confirm, cancel } = actionTexts[action];

                                                  Swal.fire({
                                                    title: title,
                                                    icon: 'warning',
                                                    showCancelButton: true,
                                                    confirmButtonText: confirm,
                                                    cancelButtonText: cancel,
                                                    reverseButtons: true
                                                  }).then((result) => {
                                                    if (result.isConfirmed) {
                                                      fetch('<?php echo e(route("console.process")); ?>', {
                                                        method: 'POST',
                                                        headers: {
                                                          'Content-Type': 'application/json',
                                                          'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                                                        },
                                                        body: JSON.stringify({ domain, action })
                                                      })
                                                      .then(res => res.json())
                                                      .then(data => {
                                                        Swal.fire({
                                                          title: 'İşlem Tamam',
                                                          text: data.message || 'İşlem başarıyla gerçekleşti.',
                                                          icon: 'success',
                                                          timer: 2000,
                                                          showConfirmButton: false
                                                        });
                                                      })
                                                      .catch(() => {
                                                        Swal.fire('Hata!', 'Bir sorun oluştu.', 'error');
                                                      });
                                                    }
                                                  });
                                                });
                                              });

                                              function updateVmStatus() {
                                                fetch("<?php echo e(route('ajax.vmStatus')); ?>", {
                                                  method: "POST",
                                                  headers: {
                                                    "Content-Type": "application/json",
                                                    "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                                                  },
                                                  body: JSON.stringify({
                                                    domain: "<?php echo e($servers['domain']); ?>"
                                                  })
                                                })
                                                .then(res => res.json())
                                                .then(data => {
                                                  const el = document.getElementById("vm-status");
                                                  const btnStart = document.querySelector('.btn-start');
                                                  const btnConsole = document.querySelector('.btn-console');

                                                  if (data.status === "success") {
                                                    if (data.power === "POWERED_ON") {
                                                      el.textContent = "🟢 Sunucu Açık";
                                                      btnStart.disabled = true;
                                                      if (btnConsole) btnConsole.disabled = false;
                                                    } else if (data.power === "POWERED_OFF") {
                                                      el.textContent = "🔴 Sunucu Kapalı";
                                                      btnStart.disabled = false;
                                                      if (btnConsole) btnConsole.disabled = true;
                                                    } else {
                                                      el.textContent = "⚠️ Bilinmeyen durum";
                                                      btnStart.disabled = true;
                                                      if (btnConsole) btnConsole.disabled = true;
                                                    }
                                                  } else {
                                                    el.textContent = "⚠️ Durum alınamadı";
                                                    btnStart.disabled = true;
                                                    if (btnConsole) btnConsole.disabled = true;
                                                  }

                                                  [btnStart, btnConsole].forEach(btn => {
                                                    if (btn) {
                                                      if (btn.disabled) {
                                                        btn.classList.add('opacity-50', 'cursor-not-allowed');
                                                      } else {
                                                        btn.classList.remove('opacity-50', 'cursor-not-allowed');
                                                      }
                                                    }
                                                  });
                                                })
                                                .catch(() => {
                                                  document.getElementById("vm-status").textContent = "⚠️ Hata oluştu";
                                                });
                                              }

                                              updateVmStatus();
                                              setInterval(updateVmStatus, 20000);
                                            </script>
                                      </div>
                                      <div id="vmAlert" style="margin-top: 10px;"></div>
                                  </div>
                              </div>
                            </div>
                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                <div class="">
                                    <div class="border-t dark:border-gray-700">
                                        <dl class="divide-y divide-gray-200 dark:divide-gray-700">

                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Birincil iP Adresi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200"><?php echo e($servers['dedicatedip']); ?></dd>
                                            </div>
                                            <?php if (session('verifystatus') == 'true'): ?>
                                              <div class="py-2 px-6 flex justify-between">
                                                  <dt class="text-gray-600 dark:text-gray-400">Kullanıcı Adı</dt>

                                                  <dd class="font-medium text-gray-900 dark:text-gray-200 flex items-center">
                                                      <span class="password-dots" id="username"><?php echo e(str_repeat('•', strlen($servers['username']))); ?></span>
                                                      <button style="margin-left: 10px;" onclick="toggleVisibility('username', '<?php echo e($servers['username']); ?>')" class="ml-2">
                                                          <svg class="w-6 h-6 text-gray-800 dark:text-gray-200" fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                               viewBox="0 0 442.04 442.04" xml:space="preserve">
                                                              <g>
                                                                  <g>
                                                                      <path d="M221.02,341.304c-49.708,0-103.206-19.44-154.71-56.22C27.808,257.59,4.044,230.351,3.051,229.203
                                                                          c-4.068-4.697-4.068-11.669,0-16.367c0.993-1.146,24.756-28.387,63.259-55.881c51.505-36.777,105.003-56.219,154.71-56.219
                                                                          c49.708,0,103.207,19.441,154.71,56.219c38.502,27.494,62.266,54.734,63.259,55.881c4.068,4.697,4.068,11.669,0,16.367
                                                                          c-0.993,1.146-24.756,28.387-63.259,55.881C324.227,321.863,270.729,341.304,221.02,341.304z M29.638,221.021
                                                                          c9.61,9.799,27.747,27.03,51.694,44.071c32.83,23.361,83.714,51.212,139.688,51.212s106.859-27.851,139.688-51.212
                                                                          c23.944-17.038,42.082-34.271,51.694-44.071c-9.609-9.799-27.747-27.03-51.694-44.071
                                                                          c-32.829-23.362-83.714-51.212-139.688-51.212s-106.858,27.85-139.688,51.212C57.388,193.988,39.25,211.219,29.638,221.021z"/>
                                                                  </g>
                                                                  <g>
                                                                      <path d="M221.02,298.521c-42.734,0-77.5-34.767-77.5-77.5c0-42.733,34.766-77.5,77.5-77.5c18.794,0,36.924,6.814,51.048,19.188
                                                                          c5.193,4.549,5.715,12.446,1.166,17.639c-4.549,5.193-12.447,5.714-17.639,1.166c-9.564-8.379-21.844-12.993-34.576-12.993
                                                                          c-28.949,0-52.5,23.552-52.5,52.5s23.551,52.5,52.5,52.5c28.95,0,52.5-23.552,52.5-52.5c0-6.903,5.597-12.5,12.5-12.5
                                                                          s12.5,5.597,12.5,12.5C298.521,263.754,263.754,298.521,221.02,298.521z"/>
                                                                  </g>
                                                                  <g>
                                                                      <path d="M221.02,246.021c-13.785,0-25-11.215-25-25s11.215-25,25-25c13.786,0,25,11.215,25,25S234.806,246.021,221.02,246.021z"/>
                                                                  </g>
                                                              </g>
                                                          </svg>
                                                      </button>
                                                  </dd>
                                              </div>
                                              <div class="py-2 px-6 flex justify-between">
                                                  <dt class="text-gray-600 dark:text-gray-400">Şifre</dt>
                                                  <dd class="font-medium text-gray-900 dark:text-gray-200 flex items-center">
                                                      <span class="password-dots" id="password"><?php echo e(str_repeat('•', strlen($servers['password']))); ?></span>
                                                      <button style="margin-left: 10px;" onclick="togglePasswordVisibility('password', '<?php echo e($servers['password']); ?>')" class="ml-2">
                                                          <svg class="w-6 h-6 text-gray-800 dark:text-gray-200" fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                               viewBox="0 0 442.04 442.04" xml:space="preserve">
                                                              <g>
                                                                  <g>
                                                                      <path d="M221.02,341.304c-49.708,0-103.206-19.44-154.71-56.22C27.808,257.59,4.044,230.351,3.051,229.203
                                                                          c-4.068-4.697-4.068-11.669,0-16.367c0.993-1.146,24.756-28.387,63.259-55.881c51.505-36.777,105.003-56.219,154.71-56.219
                                                                          c49.708,0,103.207,19.441,154.71,56.219c38.502,27.494,62.266,54.734,63.259,55.881c4.068,4.697,4.068,11.669,0,16.367
                                                                          c-0.993,1.146-24.756,28.387-63.259,55.881C324.227,321.863,270.729,341.304,221.02,341.304z M29.638,221.021
                                                                          c9.61,9.799,27.747,27.03,51.694,44.071c32.83,23.361,83.714,51.212,139.688,51.212s106.859-27.851,139.688-51.212
                                                                          c23.944-17.038,42.082-34.271,51.694-44.071c-9.609-9.799-27.747-27.03-51.694-44.071
                                                                          c-32.829-23.362-83.714-51.212-139.688-51.212s-106.858,27.85-139.688,51.212C57.388,193.988,39.25,211.219,29.638,221.021z"/>
                                                                  </g>
                                                                  <g>
                                                                      <path d="M221.02,298.521c-42.734,0-77.5-34.767-77.5-77.5c0-42.733,34.766-77.5,77.5-77.5c18.794,0,36.924,6.814,51.048,19.188
                                                                          c5.193,4.549,5.715,12.446,1.166,17.639c-4.549,5.193-12.447,5.714-17.639,1.166c-9.564-8.379-21.844-12.993-34.576-12.993
                                                                          c-28.949,0-52.5,23.552-52.5,52.5s23.551,52.5,52.5,52.5c28.95,0,52.5-23.552,52.5-52.5c0-6.903,5.597-12.5,12.5-12.5
                                                                          s12.5,5.597,12.5,12.5C298.521,263.754,263.754,298.521,221.02,298.521z"/>
                                                                  </g>
                                                                  <g>
                                                                      <path d="M221.02,246.021c-13.785,0-25-11.215-25-25s11.215-25,25-25c13.786,0,25,11.215,25,25S234.806,246.021,221.02,246.021z"/>
                                                                  </g>
                                                              </g>
                                                          </svg>
                                                      </button>
                                                  </dd>
                                              </div>
                                            <?php endif; ?>
                                            <?php foreach ($servers['configoptions']['configoption'] as $data): ?>
                                              <?php if ($data['option'] == "Operating System" || $data['option'] == "CPU" || $data['option'] == "Memory" || $data['option'] == "HardDisk"): ?>
                                                <?php else: ?>
                                                  <?php if ($data['id'] == 15): ?>

                                                    <div class="py-2 px-6 flex justify-between">
                                                        <dt class="text-gray-600 dark:text-gray-400"><?php echo e($data['option']); ?></dt>
                                                        <dd style="text-align:right;" class="font-medium text-gray-900 dark:text-gray-200">
                                                            <?php echo e($data['value']); ?>

                                                            <?php
                                                            if ($servers['assignedips'] == null) {

                                                            }else {
                                                              echo '<br>';
                                                              $assigned_ips = $servers['assignedips'];
                                                              $ips_array = explode(',', $assigned_ips);
                                                              foreach ($ips_array as $ip) {
                                                                echo $ip . "<br>";
                                                              }
                                                            }

                                                            ?>
                                                        </dd>
                                                    </div>
                                                    <?php else: ?>
                                                      <div class="py-2 px-6 flex justify-between">
                                                          <dt class="text-gray-600 dark:text-gray-400"><?php echo e($data['option']); ?></dt>
                                                          <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                              <?php echo e($data['value']); ?>

                                                          </dd>
                                                      </div>
                                                  <?php endif; ?>
                                              <?php endif; ?>

                                            <?php endforeach; ?>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <style media="screen">
            .password-dots {
              font-family: 'Arial', sans-serif;
              letter-spacing: 0.2em;
            }

            </style>
            <script>
            function toggleVisibility(id, actualValue) {
                const element = document.getElementById(id);
                if (element.textContent === '•'.repeat(actualValue.length)) {
                    element.textContent = actualValue;
                    element.classList.remove('password-dots');
                } else {
                    element.textContent = '•'.repeat(actualValue.length);
                    element.classList.add('password-dots');
                }
            }

            function togglePasswordVisibility(id, actualValue) {
                const element = document.getElementById(id);
                if (element.textContent === actualValue) {
                    element.textContent = '•'.repeat(actualValue.length);
                    element.classList.add('password-dots');
                } else {
                    element.textContent = actualValue;
                    element.classList.remove('password-dots');
                }
            }
            </script>
            <script type="text/javascript">
            $(document).ready(function () {
  $(document).on("submit", "form.epp-form", function (e) {
    e.preventDefault();
    var form = $(this);
    var url = form.attr("action");
    var method = form.attr("method");
    var data = form.serialize();
    var button = form.find("button");
    var originalButtonText = button.text();

    button.text("SMS gönderiliyor...");
    button.prop("disabled", true);

    $.ajax({
      url: url,
      method: method,
      data: data,
      success: function (response) {
        $("#eppstatus-message").hide();
        $("#epperror-message").hide();

        if (response.status === "success") {
          $("#eppstatus-message-text").html(response.message);
          $("#eppstatus-message").show();

          // ✅ SMS başarıyla gönderildi, şimdi modal'ı aç
          if (window.dialog && typeof window.dialog.showModal === 'function') {
            window.dialog.showModal();
          }
        } else {
          $("#epperror-message-text").html(response.message);
          $("#epperror-message").show();
        }

        button.text(originalButtonText);
        button.prop("disabled", false);
      },
      error: function () {
        $("#eppstatus-message").hide();
        $("#epperror-message").hide();
        $("#epperror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
        $("#epperror-message").show();

        button.text(originalButtonText);
        button.prop("disabled", false);
      },
    });
  });
});

$(document).ready(function () {
  $(document).on("submit", "form.verify-form", function (e) {
    e.preventDefault();

    var form = $(this);
    var url = form.attr("action");
    var method = form.attr("method");
    var data = form.serialize();
    var button = form.find("button");
    var originalButtonText = button.text();

    button.text("Lütfen bekleyiniz...");
    button.prop("disabled", true);

    $.ajax({
      url: url,
      method: method,
      data: data,
      success: function (response) {
        $("#verifystatus-message").hide();
        $("#verifyerror-message").hide();

        if (response.status === "success") {
          $("#verifystatus-message-text").html(response.message);
          $("#verifystatus-message").show();

          // ✅ 3 saniye sonra redirect yap
          setTimeout(function () {
            window.location.href = response.redirect_url;
          }, 3000);
        } else {
          $("#verifyerror-message-text").html(response.message);
          $("#verifyerror-message").show();
        }

        button.text(originalButtonText);
        button.prop("disabled", false);
      },
      error: function () {
        $("#verifystatus-message").hide();
        $("#verifyerror-message").hide();

        $("#verifyerror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
        $("#verifyerror-message").show();

        button.text(originalButtonText);
        button.prop("disabled", false);
      }
    });
  });
});
            </script>
            <style media="screen">

            dialog {
              min-width: 30%;

            background: white;
            max-width: 400px;
            padding-top: 2rem;
            border-radius: 20px;
            border: 0;
            box-shadow: 0 5px 30px 0 rgb(0 0 0 / 10%);
            animation: fadeIn 1s ease both;
            &::backdrop {
              animation: fadeIn 1s ease both;
              background: rgb(255 255 255 / 40%);
              z-index: 2;
              backdrop-filter: blur(20px);
            }
            .x {
              filter: grayscale(1);
              border: none;
              background: none;
              position: absolute;
              top: 15px;
              right: 10px;
              transition: ease filter, transform 0.3s;
              cursor: pointer;
              transform-origin: center;
              &:hover {
                filter: grayscale(0);
                transform: scale(1.1);
              }
            }
            h2 {
              font-weight: 600;
              font-size: 2rem;
              padding-bottom: 1rem;
            }
            p {
              font-size: 1rem;
              line-height: 1.3rem;
              padding: 0.5rem 0;
              a {
                &:visited {
                  color: rgb(var(--vs-primary));
                }
              }
            }
            }

            @keyframes fadeIn {
            from {
              opacity: 0;
            }
            to {
              opacity: 1;
            }
            }

            </style>

            <dialog id="dialog" class="fi-simple-main  w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
                <div class="fi-simple-page">
                    <section class="grid auto-cols-fr gap-y-6">
                        <header class="fi-simple-header flex flex-col items-center">
                            <img style="width: 50%;" alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo flex mb-4">
                            <img style="width: 50%;" alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo flex mb-4">
                            <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                                Doğrulama Kodu
                            </h1>
                            <p style="text-align: center;">Konsola güvenli bir şekilde bağlanabilmeniz için lütfen SMS doğrulama kodunuzu giriniz! </p>
                        </header>

                        <form action="<?php echo e(route('consolecreate')); ?>" method="post" class="verify-form fi-form grid gap-y-6">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="action" value="verify">
                            <input type="hidden" name="vmname" value="<?php echo e($servers['domain']); ?>">
                            <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                    <div data-field-wrapper="" class="fi-fo-field-wrp">
                                        <div class="grid gap-y-2">
                                            <div class="flex items-center gap-x-3 justify-between">
                                                <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                    <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        Doğrulama Kodu
                                                        <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                    </span>
                                                </label>
                                            </div>
                                            <div class="grid auto-cols-fr gap-y-2">
                                                <div
                                                    class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                >
                                                    <div class="min-w-0 flex-1">
                                                        <input
                                                            class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                            autocomplete="on"
                                                            autofocus="autofocus"
                                                            name="code"
                                                            required="required"
                                                            type="text"
                                                        />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="fi-form-actions">
                                <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                                    <button
                                        style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);"
                                        class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                        type="submit"
                                        id="submit-button"
                                    >
                                        <span class="fi-btn-label">Kodu Doğrula</span>
                                    </button>
                                </div>
                            </div>
                            <div id="response-message">
                              <div id="verifystatus-message" style="display: none;">
                                <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                  <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                  </svg>
                                  <span class="sr-only">Info</span>
                                  <div>
                                    <span class="font-medium">Doğrulama Başarılı, Yönlendiriliyorsunuz! </span> <span id="verifystatus-message-text"></span>
                                  </div>
                                </div>
                              </div>
                              <div id="verifyerror-message" style="display: none;">
                                <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                  <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                  </svg>
                                  <span class="sr-only">Info</span>
                                  <div>
                                    <span class="font-medium">Hata! </span> <span id="verifyerror-message-text"></span>
                                  </div>
                                </div>
                              </div>
                            </div>
                        </form>

                    </section>
                </div>

                <button onclick="window.dialog.close();" aria-label="close" class="x">❌</button>
            </dialog>
    </main>
    <?php echo $__env->make("layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/servers_details.blade.php ENDPATH**/ ?>