<?php
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\cPanelController;
use App\Http\Controllers\PleskController;
use App\Http\Controllers\CancellationController;
use App\Http\Controllers\DomainController;
use App\Http\Controllers\PostDataController;
use App\Http\Controllers\FTPController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\EInvoiceController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\HomeSes;
use App\Http\Controllers\SSLController;
use App\Http\Controllers\VmwareController;
use App\Http\Controllers\DnsController;

Route::middleware(['web'])->group(function () {
    Route::match(['get', 'post'], '/cart', [CartController::class, 'showCart'])->name('cart.show')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');

Route::get('/password-reset', [AuthController::class, 'passwordReset'])->name('passwordreset.form');

Route::get('/password/reset/redeem/{token?}', [AuthController::class, 'passwordResetPage'])->name('passwordreset.form');

Route::post('/password-reset', [AuthController::class, 'resetpassword'])->name('passwordreset');
Route::post('/password-update', [AuthController::class, 'passwordresetform'])->name('passwordresetform');

Route::get('/register', [ClientController::class, 'showRegister'])->name('register');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [ClientController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/verify', [AuthController::class, 'showVerificationForm'])->name('verify')->middleware('check.verification');
Route::post('/verify', [AuthController::class, 'verify']);
Route::post('/resend-verification', [AuthController::class, 'sendResendVerification'])->name('resend.verification');
Route::middleware(['auth.client', 'verify.sms'])->group(function () {
  Route::post('/update-client', [ClientController::class, 'UpdateClient'])->name('update-client');
});
Route::get('/everify/{verificationcode}', [ClientController::class, 'VerifyEmail']);
Route::get('/e-invoice/{id}', [EInvoiceController::class, 'GetInvoice']);
Route::match(['get', 'post'], '/getclient', [HomeSes::class, 'getClient'])->name('getClient')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

Route::middleware(['auth.client', 'verify.sms', 'whmcs.profile.complete'])->group(function () {
Route::post('/console/verify', [VmwareController::class, 'verifyvm'])->name('verifyvm');
Route::post('/console/verifys', [VmwareController::class, 'consolecreate'])->name('consolecreate');
Route::get('/console/{autokey}', [VmwareController::class, 'consoleView'])->name('console.console');
Route::post('/console/process', [VmwareController::class, 'processConsoleAction'])->name('console.process');
Route::post('/ajax/vm-status', [AuthController::class, 'getVmStatusAjax'])->name('ajax.vmStatus');
Route::post('/dns/{domain}', [DnsController::class, 'getZone'])->name('dns.getZone');
Route::post('/dns/{domain}/apply', [DnsController::class, 'updateRecord'])->name('dns.apply');
Route::post('/dns/{domain}/delete', [DnsController::class, 'deleteRecord'])->name('dns.delete');
    Route::post('/manage-vm', [VmWareController::class, 'manageVM'])->name('manage_vm');
    Route::post('/ssl-csrcreate', [SSLController::class, 'csrcreate'])->name('ssl.csrcreate');
    Route::post('/ssl-csrupdate', [SSLController::class, 'csrupdate'])->name('ssl.csrupdate');
    Route::post('/cart/send', [AuthController::class, 'addOrder'])->name('cart.send');
    Route::post('/sepet/onayla', [AuthController::class, 'siparisOnayla'])->name('sepet.onayla');
    Route::get('/dashboard', [AuthController::class, 'showDashboard'])->name('dashboard');
    Route::get('/profile', [AuthController::class, 'profile'])->name('profile');
    Route::get('/blog', [AuthController::class, 'blog'])->name('blog');
    Route::get('/blog/details/{blogurl}', [AuthController::class, 'blogdetails'])->name('blogdetails');
    Route::get('/hostings', [AuthController::class, 'showHostings'])->name('hostings');
    Route::get('/domains', [AuthController::class, 'showDomains'])->name('domains');
    Route::get('/servers', [AuthController::class, 'Servers'])->name('servers');
    Route::get('/others', [AuthController::class, 'others'])->name('others');
    Route::get('/kurumsal-mail', [AuthController::class, 'kurumsalmail'])->name('kurumsal-mail');
    Route::get('/tickets', [AuthController::class, 'tickets'])->name('tickets');
    Route::get('/invoices', [AuthController::class, 'invoice'])->name('invoices');
    Route::get('/invoices/view/{id}', [AuthController::class, 'invoiceView'])->name('invoices.invoiceView');
    Route::get('/domains/details/{id}', [AuthController::class, 'Domainsshow'])->name('domains.show');
    Route::get('/others/details/{id}', [AuthController::class, 'othersDetails'])->name('others.othersDetails');
    Route::get('/hostings/details/{id}', [AuthController::class, 'show'])->name('hostings.show');
    Route::get('/servers/details/{id}', [AuthController::class, 'serverDetails'])->name('servers.serverDetails');
    Route::get('/tickets/details/{id}', [AuthController::class, 'ticketsDetails'])->name('tickets.ticketsDetails');
    Route::post('cpanel/login', [cPanelController::class, 'login'])->name('cpanel.login');
    Route::post('domain/save', [DomainController::class, 'save'])->name('domain.save');
    Route::post('resave/save', [PostDataController::class, 'save'])->name('resave.save');
    Route::post('plesk/login', [PleskController::class, 'login'])->name('plesk.login');
    Route::post('/ftp', [FTPController::class, 'handle']);
    Route::post('/submit-ticket', [TicketController::class, 'submitTicket'])->name('submit-ticket');

    Route::post('/new-ticket', [TicketController::class, 'newTicket'])->name('new-ticket');
    Route::post('/send-verify-mail', [ClientController::class, 'sendVerifyMail'])->name('send.verify.mail');
    Route::get('download/attachment/{ticketId}/{filename}/{relatedid}/{type}', [App\Http\Controllers\TicketController::class, 'downloadAttachment'])->name('download.attachment');
    Route::get('/cancel/{serviceId}', function ($serviceId) {
        return view('cancellation_form', compact('serviceId'));
    })->name('cancel.form');
    Route::post('/cancel/request', [CancellationController::class, 'requestCancellation'])->name('cancel.request');
});

Route::get('/', function () {
    if (Session::has('client')) {
        return redirect()->route('dashboard');
    } else {
        return redirect()->route('login');
    }
});
