<?php $pageTitle = 'Destek Taleplerim'; ?>
@include("layouts.header")
<style media="screen">
  .icon {width: 20px;fill:white;}
</style>

<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Destek Taleplerim
                    </h1>
                </div>
            </header>
            <div>
              <style media="screen">
                .bg-color-blue{background-color: #3f70d1; color:white;}
              </style>
                <div class="grid flex-1 auto-cols-fr gap-y-8">
                    <div class="flex flex-col gap-y-6">
                        <div class="fi-ta">
                          <div id="reply-section" class="bg-color-blue dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                              <div class="flex justify-between items-center">
                                  <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">Yeni Destek Talebi Gönder</h2>
                                  <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                              </div>
                          </div>
                          <form style="margin-bottom:20px;" method="POST" action="{{ route('new-ticket') }}" enctype="multipart/form-data" id="reply-form" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mt-4 hidden">
                            @csrf
                            <div style="display:none;" class="grid grid-cols-2 gap-4 mb-4">
                              <div>
                                <label class="block text-gray-700 dark:text-gray-300">İsim</label>
                                <input type="hidden" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100" disabled>
                              </div>
                              <div>
                                <label class="block text-gray-700 dark:text-gray-300">E-posta Adresi</label>
                                <input type="hidden"  class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100" disabled>
                              </div>
                            </div>
                            <div class="mb-4">
                              <label class="block text-gray-700 dark:text-gray-300">Başlık</label>
                              <input name="title" type="text" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                            </div>
                            <div class="grid grid-cols-subgrid gap-4 col-span-3">
                              <div class="col-start-1">
                                <div>
                                  <label class="block text-gray-700 dark:text-gray-300">Departman</label>
                                  <select name="department" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                                    <option value="1" selected="selected"> Genel </option>
                                    <option value="2"> Hosting </option>
                                    <option value="4"> Satış </option>
                                    <option value="3"> Ödeme Bildirimi </option>
                                    <option value="6"> Muhasebe </option>
                                    <option value="5"> Ödeme Bildirimi </option>
                                    <option value="7"> Alan Adı </option>
                                    <option value="8"> Hosting </option>
                                    <option value="9"> VPS &amp; VDS &amp; Sunucu </option>
                                    <option value="10"> Network ( IP Sorunları ) </option>
                                  </select>
                                </div>
                              </div>

                              <div class="col-start-2">
                                <div>
                                  <label class="block text-gray-700 dark:text-gray-300">İlgili Hizmet</label>
                                  <select name="related_service" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                                    <option value="" selected>Yok</option>
                                      <?php if (!empty($products['products']['product'])): ?>
                                        <?php foreach ($products['products']['product'] as $product): ?>
                                          <?php
                                          if ($product['status'] == "Active") {
                                            $status = "Aktif";
                                          }
                                          if ($product['status'] == "Suspended") {
                                            $status = "Askıya Alındı";
                                          }
                                          if ($product['status'] == "Terminated") {
                                            $status = "Kapatıldı";
                                          }
                                          if ($product['status'] == "Cancelled") {
                                            $status = "İptal Edildi";
                                          }
                                          ?>
                                          <option value="S<?php echo $product['id']; ?>">
                                            <?php echo str_replace("-", " ", $product['translated_name']) . " | " . $product['domain'] . " (" . $status . ") "; ?>
                                          </option>
                                        <?php endforeach; ?>
                                      <?php else: ?>
                                        <option disabled>Aktif Ürün hizmetiniz yok</option>
                                      <?php endif; ?>

                                      <?php if (!empty($domains['domains']['domain'])): ?>
                                        <?php foreach ($domains['domains']['domain'] as $domain): ?>
                                          <?php
                                          if ($domain['status'] == "Active") {
                                            $status = "Aktif";
                                          } elseif ($domain['status'] == "Expired") {
                                            $status = "Süresi Doldu";
                                          } elseif ($domain['status'] == "Terminated") {
                                            $status = "Kapatıldı";
                                          } elseif ($domain['status'] == "Cancelled") {
                                            $status = "İptal Edildi";
                                          } elseif ($domain['status'] == "Grace") {
                                            $status = "Bitmek Üzere";
                                          } else {
                                            $status = $domain['status'];
                                          }
                                          ?>
                                          <option value="D<?php echo $domain['id']; ?>">
                                            <?php echo $domain['domainname'] . " (" . $status . ") "; ?>
                                          </option>
                                        <?php endforeach; ?>
                                      <?php else: ?>
                                        <option disabled>Aktif Ürün hizmetiniz yok</option>
                                      <?php endif; ?>
                                  </select>
                                </div>
                              </div>
                              <div class="col-start-3">
                                <div>
                                  <label class="block text-gray-700 dark:text-gray-300">Öncelik</label>
                                  <select name="priority" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                                    <option value="High"> Yüksek </option>
                                    <option value="Medium" selected="selected"> Orta </option>
                                    <option value="Low"> Düşük </option>
                                  </select>
                                </div>
                              </div>
                            </div>
                            <div class="mb-4">
                              <label class="block text-gray-700 dark:text-gray-300">Mesaj</label>
                              <textarea name="message" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100" rows="5"></textarea>
                            </div>
                            <div class="flex justify-start">
                              <button style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);width:20%;" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom- 400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Gönder</button>
                            </div>
                          </form>
                            <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                                <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                    <table class="fi-ta-table w-full table-auto divide-y divide-gray-200 text-start dark:divide-white/5">
                                        <thead class="divide-y divide-gray-200 dark:divide-white/5">
                                            <tr class="bg-gray-50 dark:bg-white/5">
                                              <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-name" style="">
                                                  <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                                      <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                                          #
                                                      </span>
                                                  </span>
                                              </th>
                                                <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-name" style="">
                                                    <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                                        <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                                            Destek Talebi Adı
                                                        </span>
                                                    </span>
                                                </th>
                                                <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-name" style="">
                                                    <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                                        <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                                            Durum
                                                        </span>
                                                    </span>
                                                </th>
                                                <th class="fi-ta-header-cell px-3 py-3.5 sm:first-of-type:ps-6 sm:last-of-type:pe-6 fi-table-header-cell-name" style="">
                                                    <span class="group flex w-full items-center gap-x-1 whitespace-nowrap justify-start">
                                                        <span class="fi-ta-header-cell-label text-sm font-semibold text-gray-950 dark:text-white">
                                                            İşlemler
                                                        </span>
                                                    </span>
                                                </th>

                                            </tr>
                                        </thead>
                                        <?php $sira = 0; ?>
                                        <tbody id="table-body" class="divide-y divide-gray-200 whitespace-nowrap dark:divide-white/5">
                                            <?php if (isset($tickets['tickets']['ticket'])): ?>
                                              @foreach ($tickets['tickets']['ticket'] as $ticket)
                                              <?php $sira = $sira + 1; ?>
                                            <tr>
                                              <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-name">
                                                  <div class="fi-ta-col-wrp">
                                                          <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                              <div class="flex">
                                                                  <div class="flex max-w-max" style="">
                                                                      <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                                          <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white font-medium" style="">
                                                                            {{$sira}}
                                                                          </span>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                  </div>
                                              </td>
                                              <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-name">
                                                  <div class="fi-ta-col-wrp">
                                                          <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                              <div class="flex">
                                                                  <div class="flex max-w-max" style="">
                                                                      <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                                          <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white font-medium" style="">
                                                                            {{$ticket['subject']}}
                                                                          </span>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                              <p class="text-sm text-gray-500 dark:text-gray-400">Son güncelleme: {{$ticket['date']}}</p>
                                                          </div>
                                                  </div>
                                              </td>


                                              <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-name">
                                                  <div class="fi-ta-col-wrp">
                                                          <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                              <div class="flex">
                                                                  <div class="flex max-w-max" style="">
                                                                      <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                                          <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white font-medium" style="">
                                                                            <?php
                                                                            if ($ticket['status'] == "Open") {
                                                                              echo "Açık";
                                                                            }
                                                                            if ($ticket['status'] == "Cevaplandı") {
                                                                              echo "Yanıtlandı";
                                                                            }
                                                                            if ($ticket['status'] == "Customer-Reply") {
                                                                              echo "Yanıtladınız";
                                                                            }
                                                                            if ($ticket['status'] == "Beklemede") {
                                                                              echo "Beklemede";
                                                                            }
                                                                            if ($ticket['status'] == "İşlem Devam Ediyor") {
                                                                              echo "İşlem Devam Ediyor";
                                                                            }
                                                                            if ($ticket['status'] == "Kapandı") {
                                                                              echo "Kapatıldı";
                                                                            }if ($ticket['status'] == "Closed") {
                                                                              echo "Kapatıldı";
                                                                            }
                                                                            if ($ticket['status'] == "On Hold") {
                                                                              echo "Beklemede";
                                                                            }
                                                                             ?>
                                                                          </span>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                  </div>
                                              </td>
                                              <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-name">
                                                  <div class="fi-ta-col-wrp">
                                                          <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                              <div class="flex">
                                                                  <div class="flex max-w-max" style="">
                                                                      <div class="fi-ta-text-item inline-flex items-center gap-1.5">
                                                                          <span class="fi-ta-text-item-label text-sm leading-6 text-gray-950 dark:text-white font-medium" style="">
                                                                              <a style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" href="tickets/details/{{$ticket['tid']}}">GÖRÜNTÜLE</a>
                                                                          </span>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                  </div>
                                              </td>
                                            </tr>
                                          @endforeach
                                              <?php else: ?>
                                                <tr class="fi-ta-row [@media(hover:hover)]:transition [@media(hover:hover)]:duration-75">
                                                  <td colspan="6" class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-table-cell-certificate-type-id">
                                                    <div class="fi-ta-col-wrp">
                                                      <div class="flex w-full disabled:pointer-events-none justify-start text-start">
                                                        <div class="fi-ta-text grid w-full gap-y-1 px-3 py-4">
                                                          <p style="text-align: center; font-size: 17px;" class="text-sm text-gray-500 dark:text-gray-400">
                                                            Herhangi bir destek talebiniz bulunmamaktadır.
                                                          </p>
                                                        </div>
                                                      </div>
                                                    </div>
                                                  </td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <nav role="navigation" class="fi-pagination grid grid-cols-[1fr_auto_1fr] items-center gap-x-3 fi-ta-pagination px-3 py-3 sm:px-6">
                                  <span id="pagination-overview" class="fi-pagination-overview text-sm font-medium text-gray-700 dark:text-gray-200"></span>
                                  <div class="col-start-2 justify-self-center">
                                    <label class="fi-pagination-records-per-page-select">
                                      <div  class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500">
                                        <div class="items-center gap-x-3 ps-3 flex border-e border-gray-200 pe-3 ps-3 dark:border-white/10">
                                          <span class="fi-input-wrp-label whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                            sayfa başına
                                          </span>
                                        </div>
                                        <div class="min-w-0 flex-1">
                                          <select id="records-per-page" class="fi-select-input block w-full border-none bg-transparent py-1.5 pe-8 text-base text-gray-950 transition duration-75 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] dark:text-white dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] sm:text-sm sm:leading-6 [&amp;_optgroup]:bg-white [&amp;_optgroup]:dark:bg-gray-900 [&amp;_option]:bg-white [&amp;_option]:dark:bg-gray 900 ps-3">
                                            <option value="10">10</option>
                                            <option value="25">25</option>
                                            <option value="50">50</option>
                                            <option value="100">100</option>
                                          </select>
                                        </div>
                                      </div>
                                    </label>
                                  </div>
                                  <div class="pagination" id="pagination-controls"></div>
                                  <div class="col-span-full sm:hidden flex justify-between items-center mt-3">
                                    <button id="mobile-prev-btn" class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white px-4 py-2 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 disabled:opacity-50 disabled:cursor-not-allowed">
                                      Önceki
                                    </button>

                                    <select id="mobile-records-per-page" class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white px-4 py-2 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600">
                                      <option value="10">10</option>
                                      <option value="25">25</option>
                                      <option value="50">50</option>
                                      <option value="100">100</option>
                                    </select>

                                    <button id="mobile-next-btn" class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white px-4 py-2 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 disabled:opacity-50 disabled:cursor-not-allowed">
                                      Sonraki
                                    </button>
                                  </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>
<script>
document.getElementById("records-per-page").addEventListener("change", function () {
    rowsPerPage = parseInt(this.value); // Yeni değeri al ve güncelle
    currentPage = 1; // Sayfayı yeniden başlat
    renderTable(currentPage); // Tabloyu güncelle
    renderPagination(); // Sayfalama düğmelerini güncelle
});
    let rowsPerPage = parseInt(document.getElementById("records-per-page").value);
    let currentPage = 1;

    // Tablo satırlarını ve sayfalama düğmelerini ayarla
    function renderTable(page) {
        const rows = document.querySelectorAll("#table-body tr");
        const totalRows = rows.length;
        const start = (page - 1) * rowsPerPage;
        const end = start + rowsPerPage;

        rows.forEach((row, index) => {
            row.style.display = index >= start && index < end ? "table-row" : "none";
        });

        updateOverview();
    }

      function updateOverview() {
        const rows = document.querySelectorAll("#table-body tr");
        const totalRows = rows.length;
        const start = (currentPage - 1) * rowsPerPage + 1;
        const end = Math.min(start + rowsPerPage - 1, totalRows);

        const overviewText = `Toplam ${totalRows} sonuçtan ${start} ile ${end} arası görüntüleniyor`;
        document.getElementById("pagination-overview").textContent = overviewText;
      }

    function renderPagination() {
        const rows = document.querySelectorAll("#table-body tr");
        const pageCount = Math.ceil(rows.length / rowsPerPage);
        const paginationControls = document.getElementById("pagination-controls");
        paginationControls.innerHTML = "";

        // <ol> yapısı
        const ol = document.createElement("ol");
        ol.className =
            "fi-pagination-items justify-self-end rounded-lg bg-white shadow-sm ring-1 ring-gray-950/10 dark:bg-white/5 dark:ring-white/20";

        // Önceki butonu
        const prevLi = document.createElement("li");
        prevLi.className =
            "fi-pagination-item group/item border-x-[0.5px] border-gray-200 first:border-s-0 last:border-e-0 dark:border-white/10";
        const prevButton = document.createElement("button");
        prevButton.type = "button";
        prevButton.ariaLabel = "Önceki";
        prevButton.innerHTML = `
            <svg class="fi-pagination-item-icon h-5 w-5 text-gray-400 transition duration-75 group-hover/button:text-gray-500 dark:text-gray-500 dark:group-hover/button:text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M11.78 5.22a.75.75 0 0 1 0 1.06L8.06 10l3.72 3.72a.75.75 0 1 1-1.06 1.06l-4.25-4.25a.75.75 0 0 1 0-1.06l4.25-4.25a.75.75 0 0 1 1.06 0Z" clip-rule="evenodd"></path>
            </svg>`;
        prevButton.className =
            "fi-pagination-item-button group/button relative flex overflow-hidden p-2 outline-none transition duration-75 group-first/item:rounded-s-lg group-last/item:rounded-e-lg hover:bg-gray-50 focus-visible:z-10 focus-visible:ring-2 focus-visible:ring-primary-600 dark:hover:bg-white/5 dark:focus-visible:ring-primary-500";
        prevButton.addEventListener("click", () => {
            if (currentPage > 1) {
                currentPage--;
                renderTable(currentPage);
                renderPagination();
            }
        });
        prevLi.appendChild(prevButton);
        ol.appendChild(prevLi);

        // Sayfa numaraları
        for (let i = 1; i <= pageCount; i++) {
            const li = document.createElement("li");
            li.className =
                "fi-pagination-item group/item border-x-[0.5px] border-gray-200 first:border-s-0 last:border-e-0 dark:border-white/10";
            if (i === currentPage) {
                li.classList.add("fi-active");
            }

            const button = document.createElement("button");
            button.type = "button";
            button.ariaLabel = `${i}. sayfaya git`;
            button.className =
                "fi-pagination-item-button group/button relative flex overflow-hidden p-2 outline-none transition duration-75 group-first/item:rounded-s-lg group-last/item:rounded-e-lg hover:bg-gray-50 focus-visible:z-10 focus-visible:ring-2 focus-visible:ring-primary-600 dark:hover:bg-white/5 dark:focus-visible:ring-primary-500";
            button.innerHTML = `<span class="fi-pagination-item-label px-1.5 text-sm font-semibold ${
                i === currentPage
                    ? "text-primary-600 dark:text-primary-400"
                    : "text-gray-700 dark:text-gray-200"
            }">${i}</span>`;
            button.addEventListener("click", () => {
                currentPage = i;
                renderTable(currentPage);
                renderPagination();
            });
            li.appendChild(button);
            ol.appendChild(li);
        }

        // Sonraki butonu
        const nextLi = document.createElement("li");
        nextLi.className =
            "fi-pagination-item group/item border-x-[0.5px] border-gray-200 first:border-s-0 last:border-e-0 dark:border-white/10";
        const nextButton = document.createElement("button");
        nextButton.type = "button";
        nextButton.ariaLabel = "Sonraki";
        nextButton.innerHTML = `
            <svg class="fi-pagination-item-icon h-5 w-5 text-gray-400 transition duration-75 group-hover/button:text-gray-500 dark:text-gray-500 dark:group-hover/button:text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10 8.22 6.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd"></path>
            </svg>`;
        nextButton.className =
            "fi-pagination-item-button group/button relative flex overflow-hidden p-2 outline-none transition duration-75 group-first/item:rounded-s-lg group-last/item:rounded-e-lg hover:bg-gray-50 focus-visible:z-10 focus-visible:ring-2 focus-visible:ring-primary-600 dark:hover:bg-white/5 dark:focus-visible:ring-primary-500";
        nextButton.addEventListener("click", () => {
            if (currentPage < pageCount) {
                currentPage++;
                renderTable(currentPage);
                renderPagination();
            }
        });
        nextLi.appendChild(nextButton);
        ol.appendChild(nextLi);

        paginationControls.appendChild(ol);
    }

    function initPagination() {
        renderTable(currentPage);
        renderPagination();
    }

    initPagination();
    // Mobil butonları seç
    const mobilePrevBtn = document.getElementById("mobile-prev-btn");
    const mobileNextBtn = document.getElementById("mobile-next-btn");

    const mobileRecordsPerPage = document.getElementById("mobile-records-per-page");

    // Mobil Select olay dinleyicisi
    mobileRecordsPerPage.addEventListener("change", function () {
      rowsPerPage = parseInt(this.value); // Yeni değeri al ve güncelle
      document.getElementById("records-per-page").value = this.value; // Masaüstü select ile senkronize et
      currentPage = 1; // Sayfayı yeniden başlat
      renderTable(currentPage); // Tabloyu güncelle
      renderPagination(); // Sayfalama düğmelerini güncelle
      updateMobileButtons(); // Mobil butonları güncelle
    });

    // Masaüstü Select ile Mobil Select'i senkronize et
    document.getElementById("records-per-page").addEventListener("change", function () {
      mobileRecordsPerPage.value = this.value;
    });

    // Mobil butonları güncelleyen fonksiyon
    function updateMobileButtons() {
      const rows = document.querySelectorAll("#table-body tr");
      const pageCount = Math.ceil(rows.length / rowsPerPage);

      // "Önceki" butonu durumu
      mobilePrevBtn.disabled = currentPage === 1;

      // "Sonraki" butonu durumu
      mobileNextBtn.disabled = currentPage === pageCount;
    }

    // Mobil "Önceki" butonuna tıklama olayı
    mobilePrevBtn.addEventListener("click", () => {
      if (currentPage > 1) {
        currentPage--;
        renderTable(currentPage);
        renderPagination();
        updateMobileButtons();
      }
    });

    // Mobil "Sonraki" butonuna tıklama olayı
    mobileNextBtn.addEventListener("click", () => {
      const rows = document.querySelectorAll("#table-body tr");
      const pageCount = Math.ceil(rows.length / rowsPerPage);

      if (currentPage < pageCount) {
        currentPage++;
        renderTable(currentPage);
        renderPagination();
        updateMobileButtons();
      }
    });

    // Başlangıçta mobil butonları güncelle
    updateMobileButtons();

</script>
<script>
document.getElementById('reply-section').addEventListener('click', function() {
  var replyForm = document.getElementById('reply-form');
  if (replyForm.classList.contains('hidden')) {
    replyForm.classList.remove('hidden');
  } else {
    replyForm.classList.add('hidden');
  }
});
</script>


@include("layouts.footer")
