<?php
$userAgent = $_SERVER['HTTP_USER_AGENT']; $browserName = strtok($userAgent, '/'); if ($browserName === "SSMobil") { ?>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .app-body {
            display: flex;
            justify-content: center;
            align-items: flex-end;
        }

        .application-bottom-nav {
            position: fixed;
            bottom: 20px;
            width: 90%;
            max-width: 450px;
            background-color: #2962FF;
            border-radius: 50px;
            display: flex;
            justify-content: flex-start;
            align-items: center;
            padding: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            overflow-x: auto;
            white-space: nowrap;
            scrollbar-width: none;
            scroll-behavior: smooth;
        }

        .application-bottom-nav::-webkit-scrollbar {
            display: none;
        }

        .application-nav-item {
            color: #A6C8FF;
            text-decoration: none;
            display: flex;
            flex-direction: row;
            align-items: center;
            font-size: 16px;
            padding: 10px 15px;
            transition: color 0.3s ease;
            border-radius: 30px;
            flex-shrink: 0;
        }

        .application-nav-item.active {
            background-color: white;
            color: #2962FF;
            padding: 10px 20px;
            font-weight: bold;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .application-nav-item:not(.active) span {
            display: none;
        }

        .application-nav-item svg {
            width: 24px;
            height: 24px;
        }
    </style>
<div class="app-body">
  <div class="application-bottom-nav" id="navMenu">
    <a href="{{ route('dashboard') }}" class="application-nav-item @if(request()->routeIs('dashboard')) active @endif">
        <svg fill="currentColor" viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>
        <span>Anasayfa</span>
    </a>
    <a href="{{ route('domains') }}" class="application-nav-item @if(request()->is('domains*')) active @endif">

      <svg fill="currentColor" version="1.0" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
      <g transform="translate(0 512) scale(.1 -.1)">
      <path d="m2360 4679c-172-16-342-55-525-120-473-167-901-536-1148-991l-37-68h178 177l29 48c36 57 138 187 206 262 38 42 53 53 64 45 7-5 50-34 94-64l80-54-39-109c-22-60-39-113-39-118 0-6 52-10 123-10h123l19 56c10 30 22 57 26 60 4 2 43-10 86-27 43-18 120-45 172-61l94-28h517 516l99 31c55 17 133 44 173 60s77 29 82 29 19-27 31-60l22-60h118c69 0 119 4 119 10 0 5-18 58-39 119l-39 109 80 53c44 30 87 59 95 64 11 8 27-4 69-50 66-72 202-249 217-282 10-23 12-23 188-23h178l-46 83c-413 747-1221 1177-2063 1096zm253-352c45-96 93-280 133-507 15-88 20-138 13-145-13-13-386-12-398 0-6 6 0 64 15 150 41 236 79 377 131 498 22 49 29 57 53 57s31-8 53-53zm-372-59c-31-95-78-299-98-430-11-76-22-118-30-118-19 0-212 65-271 91l-53 24 56 90c69 109 148 207 225 278 61 57 180 141 187 133 3-3-4-33-16-68zm700 27c79-51 193-161 263-253 52-69 126-186 126-201 0-21-316-130-330-114-4 4-15 58-24 118-20 126-79 376-106 447-10 26-14 48-8 48 5 0 41-20 79-45zm-1227-137c-4-7-22-33-39-58-18-25-45-69-61-97-16-29-32-53-36-53-11 0-98 63-98 71 0 4 6 9 13 13 6 3 57 35 112 70 101 66 122 76 109 54zm1807-58c52-33 101-65 109-70 13-8 10-14-14-34-43-36-79-53-83-40-2 5-30 52-63 103s-60 94-60 97c0 11 25-1 111-56z"/>
      <path d="m580 2975c0-4 213-741 236-817 5-16 20-18 127-18h123l57 208c31 114 62 240 68 280 7 40 14 70 17 67s16-56 29-118c12-61 42-184 65-272l43-160 244-6 27 88c15 48 73 238 129 421l102 332h-126-126l-44-207c-24-115-51-254-59-310-9-57-19-103-23-103-3 0-12 28-18 63-7 34-39 173-72 310l-61 247h-102-101l-68-267c-37-148-70-287-73-310-4-24-10-43-14-43s-12 33-19 73c-6 39-32 179-57 310l-46 237h-129c-71 0-129-2-129-5z"/>
      <path d="m1930 2968c1-7 54-195 119-418l119-405h122 123l49 170c26 94 58 218 70 278 11 59 23 105 25 103 3-2 13-46 23-98 10-51 39-175 65-276l48-182h122 122l123 403c68 221 125 410 128 420 4 15-6 17-120 17h-125l-41-197c-46-216-72-362-72-399 0-46-18-23-29 39-7 34-39 173-73 310l-60 247h-102-102l-52-202c-29-112-63-252-77-312-13-59-26-110-28-112-2-3-9 28-16 68-6 40-32 182-58 316l-47 242h-128c-96 0-128-3-128-12z"/>
      <path d="m3280 2968c0-7 54-195 119-418l118-405 242-6 20 68c66 227 85 298 102 387 11 55 21 102 23 104 3 2 9-23 15-55 20-103 30-145 78-325l46-178h122 121l123 403c68 221 126 410 129 420 4 15-6 17-121 17h-125l-6-27c-3-16-19-91-36-168-35-161-70-357-70-391 0-47-19-32-30 23-6 32-39 172-73 311l-61 252h-102-101l-41-157c-23-87-55-216-72-288-49-210-45-200-58-125-6 36-33 179-59 318l-47 252h-128c-96 0-128-3-128-12z"/>
      <path d="m660 1615c0-11 54-112 93-175 198-316 493-591 819-765 354-188 786-274 1179-235 315 32 622 130 882 284 329 193 612 486 801 829l37 67h-179-178l-22-39c-27-47-141-194-210-271-39-43-54-53-65-45-9 6-51 35-94 65l-79 54 38 109c21 59 38 112 38 118 0 5-51 9-119 9h-119l-23-63-23-64-90 37c-50 21-131 49-181 64l-90 26h-516-516l-113-36c-63-20-138-47-169-60-30-14-60-23-67-20s-20 30-30 60l-18 56h-123c-72 0-123-4-123-10 0-5 16-53 36-107 19-54 36-103 37-110 2-10-166-133-182-133-18 0-202 223-257 312l-29 48h-172c-95 0-173-2-173-5zm2035-164 70-6-3-40c-6-70-70-377-97-465-15-47-38-111-52-142-22-50-29-58-53-58s-31 8-59 72c-18 39-48 132-67 205-40 156-86 415-76 425 14 14 220 20 337 9zm-561-108c12-109 66-354 100-459 38-118 39-117-52-57-115 75-305 292-375 430l-17 31 68 28c81 33 231 82 253 83 12 1 18-13 23-56zm934 41c89-25 262-94 262-105 0-17-90-154-156-237-36-45-95-108-132-140-74-63-170-127-178-119-3 3 6 42 20 86 32 102 69 265 91 401 20 120 22 130 31 130 3 0 31-7 62-16zm-1478-222c0-4 27-50 60-101 34-51 59-96 56-98-9-9-226 125-226 139 0 4 19 20 43 37 41 30 67 38 67 23zm2005-24c25-17 45-34 45-37-1-12-229-156-236-149-2 2 16 31 40 65 23 34 53 82 67 107 13 25 27 46 31 46s28-14 53-32z"/>
      </g>
      </svg>
        <span>Domainlerim</span>
    </a>
    <a href="{{ route('hostings') }}" class="application-nav-item @if(request()->is('hostings*')) active @endif">
      <svg fill="currentColor" version="1.0" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
      <g transform="translate(0 512) scale(.1 -.1)">
      <path d="m705 4846c-41-18-83-69-90-109-3-18-5-246-3-508l3-476 29-37c54-71-98-66 1929-64l1834 3 37 29c59 45 66 72 66 266v170h135 135v-1560-1560h-134-135l-3 183-3 184-29 37c-54 71 98 66-1929 64l-1834-3-37-29c-59-45-66-72-66-266v-170h-135-135v695 695h135 135v-152c0-176 13-220 78-260l37-23 1800-3c1284-2 1814 0 1850 8 57 12 84 32 114 81 20 33 21 46 21 513 0 465-1 481-21 522-12 26-36 53-57 66l-37 23-1800 3c-1284 2-1814 0-1850-8-57-12-84-32-114-81-19-31-21-50-21-190v-156l-167-5c-141-4-177-9-225-27-66-26-146-97-177-158-39-78-42-147-39-893l3-715 23-58c29-70 103-149 169-180 42-19 70-23 228-27l180-5 5-152c5-165 10-180 74-227l27-21h1849 1849l27 21c64 47 69 62 72 229l3 154 182 3c170 3 185 5 232 28 69 33 139 107 167 177l23 58v1625 1625l-24 58c-31 80-110 158-188 187-49 19-85 23-225 28l-167 5-3 148c-3 161-8 176-72 223l-27 21-1837 2c-1512 2-1842 0-1867-11zm2067-323c42-37 48-72 48-268 0-203-6-235-55-273-54-43-157-21-191 40-20 35-19 429 0 467 36 68 140 86 198 34zm540 15c15-6 37-25 48-43 18-30 20-50 20-240 0-174-3-211-16-235-52-87-191-78-230 16-20 47-20 391 0 437 32 75 93 98 178 65zm590-15c42-37 48-72 48-268 0-203-6-235-55-273-54-43-153-23-189 38-23 40-24 426-1 470 34 66 141 84 197 33zm-2397-27c138-64 195-213 132-348-45-98-118-149-225-156-155-11-282 108-282 263 0 193 202 322 375 241zm1244-1654c64-34 71-62 71-280 0-171-2-197-20-231-43-86-157-94-219-15-20 25-21 39-21 236 0 232 5 253 63 288 40 25 82 25 126 2zm572-5c56-37 59-52 59-275 0-225-5-247-63-282-61-38-144-14-179 51-16 29-18 59-18 227 0 171 2 197 19 231 35 68 119 90 182 48zm558 5c64-34 71-62 71-280 0-171-2-197-20-231-43-86-157-94-219-15-20 25-21 39-21 236 0 232 5 253 63 288 40 25 82 25 126 2zm-2363-45c96-49 143-128 144-237 0-207-214-333-394-232-127 72-173 226-104 358 28 55 102 117 157 133 56 16 141 6 197-22zm1246-1658c51-37 58-68 58-276 0-159-3-193-18-222-35-70-109-94-180-57-57 29-62 52-62 283 0 189 2 211 19 237 11 16 30 35 43 42 37 21 106 17 140-7zm558 5c56-34 60-53 60-279 0-190-2-210-20-240-23-38-67-59-117-57-44 2-78 23-103 65-18 29-20 51-20 225 0 210 6 242 55 280 34 27 104 29 145 6zm572-5c51-37 58-68 58-276 0-159-3-193-18-222-35-70-109-94-180-57-57 29-62 52-62 283 0 189 2 211 19 237 11 16 30 35 43 42 37 21 106 17 140-7zm-2387-33c119-56 176-168 150-297-18-90-94-177-175-199-178-50-349 75-350 255 0 192 202 323 375 241z"/>
      </g>
      </svg>
        <span>Hostinglerim</span>
    </a>
    <a href="{{ route('servers') }}" class="application-nav-item @if(request()->is('servers*')) active @endif">
        <svg fill="currentColor" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
        <g transform="translate(0 512) scale(.1 -.1)">
        <path d="m279 5056c-70-26-117-56-163-102-57-59-92-129-106-214-13-83-13-1034 0-1113 5-32 20-83 34-113l25-54h2490 2491l25 49c42 85 46 150 42 717-4 563-3 553-54 650-33 61-101 124-173 158l-65 31-2255 2c-1840 1-2262-1-2291-11zm753-516c77-29 143-82 188-152 149-230 4-549-266-587-167-24-340 70-411 223-24 53-28 73-28 156 0 85 3 102 31 160 89 188 294 272 486 200zm1908-155c58-30 67-90 21-136-44-44-108-33-137 24-20 37-3 91 34 112 35 18 47 18 82 0zm368-21c31-36 29-79-7-115-33-32-58-36-100-14-84 43-39 174 54 160 17-3 40-16 53-31zm340 4c39-38 23-117-29-138-58-25-119 16-119 79 1 82 87 115 148 59zm340 0c25-24 30-82 9-109-16-21-51-39-76-39-34 0-81 48-81 84 0 83 87 120 148 64zm340 0c25-24 30-82 9-109-16-21-51-39-76-39-34 0-81 48-81 84 0 83 87 120 148 64zm-1215-239c50-23 61-91 22-133-65-71-178 0-141 88 22 53 66 69 119 45zm361-15c18-19 26-37 26-61 0-76-93-114-147-60s-16 147 60 147c24 0 42-8 61-26zm340 1c53-49 20-145-52-147-51-2-86 30-90 80-3 34 2 47 22 67 33 33 84 34 120 0zm341 0c33-32 33-84 3-119-52-58-148-21-148 57 0 76 93 115 145 62zm340 0c36-35 37-87 2-122-54-54-147-16-147 60s93 115 145 62z"/>
        <path d="m57 3257c-8-13-23-45-33-73-17-45-19-93-22-578-3-566 1-632 43-717l25-49h2489 2489l15 23c8 13 23 45 33 73 17 45 19 93 22 578 3 566-1 632-43 717l-25 49h-2489-2489l-15-23zm975-337c108-40 202-141 235-252 9-34 14-79 11-127-13-277-308-450-555-325-235 119-284 433-97 617 108 107 264 140 406 87zm1903-154c62-26 74-89 26-137-33-33-74-38-109-13-54 38-47 124 12 150 39 16 31 16 71 0zm340 0c62-26 74-89 26-137-37-37-78-38-115-4-54 50-26 137 52 154 1 1 18-5 37-13zm373-23c31-34 29-83-4-117-30-29-62-33-103-11-65 33-52 133 19 158 26 9 64-4 88-30zm340 4c32-30 30-86-4-121-54-53-143-16-144 59-1 81 86 118 148 62zm340 0c49-45 12-147-53-147-80 0-123 82-75 143 33 41 85 43 128 4zm-1197-256c48-48 36-111-27-137-73-30-140 38-110 111 26 62 89 74 137 26zm322 17c79-41 53-158-36-161-51-1-87 33-87 85 0 69 64 108 123 76zm340 0c52-27 63-88 23-134-49-58-146-21-146 56 0 67 66 109 123 78zm346-3c50-25 58-96 16-135-82-77-198 44-119 124 30 29 62 33 103 11zm355-10c71-65 0-178-89-141-62 26-74 89-26 137 37 37 78 38 115 4z"/>
        <path d="m45 1611c-42-85-46-150-42-717 4-563 3-553 54-650 33-61 101-124 173-158l65-31h2265 2265l65 31c120 57 199 163 220 294 12 81 13 1020 1 1107-5 35-21 88-35 118l-25 55h-2490-2491l-25-49zm960-303c96-24 191-107 239-208 130-274-109-593-406-541-317 56-437 431-208 657 97 96 229 129 375 92zm2310-191c39-56-4-137-72-137-75 0-113 91-61 147 35 38 103 33 133-10zm340 0c39-56-4-137-72-137-71 0-109 85-63 143 33 42 104 39 135-6zm337 6c27-25 24-88-7-118-52-53-145-15-145 58 0 40 31 84 63 89 27 5 66-8 89-29zm336 3c52-55 14-146-61-146-93 0-120 129-35 164 37 16 71 10 96-18zm-1383 18c19-8 45-55 45-83 0-11-12-33-26-50-50-60-148-25-148 52 0 66 64 106 129 81zm193-280c26-30 28-70 6-102-57-82-186-17-153 77 22 63 102 76 147 25zm331 10c39-33 42-80 7-120-50-58-146-21-146 55 1 81 78 117 139 65zm340 0c39-33 42-80 7-120-50-58-146-21-146 55 1 81 78 117 139 65zm324 14c33-17 46-39 46-78 0-42-16-65-54-80-51-19-115 20-115 71 0 75 63 120 123 87zm346-3c41-20 55-68 35-110-28-60-103-69-144-18-29 37-26 79 9 114 33 32 58 36 100 14z"/>
        </g>
        </svg>

        <span>Sunucularım</span>
    </a>
    <a href="{{ route('others') }}" class="application-nav-item @if(request()->is('others*')) active @endif">
        <svg fill="currentColor" version="1.0" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
<g transform="translate(0 512) scale(.1 -.1)">
<path d="m2390 5110c-393-25-787-146-1131-350-677-401-1128-1086-1234-1875-22-161-22-489 0-650 103-767 533-1437 1190-1850 285-180 659-312 1020-360 161-22 489-22 650 0 769 103 1436 532 1850 1190 135 213 263 529 319 785 43 195 57 338 57 560 0 305-35 533-127 809-217 652-688 1189-1309 1491-388 189-840 277-1285 250zm340-355c483-24 986-250 1359-611 371-358 593-803 661-1322 14-107 14-403 0-518-60-490-265-922-606-1273-358-371-803-593-1322-661-107-14-403-14-518 0-490 60-922 265-1273 606-371 358-593 803-661 1322-14 107-14 403 0 518 60 490 265 922 606 1273 341 353 758 571 1249 651 80 14 300 28 360 24 22-2 87-6 145-9z"/>
<path d="m2507 3465c-45-15-82-47-105-90-15-26-17-74-20-332l-3-302-302-3c-332-3-337-4-391-68-72-86-45-212 58-268 27-15 71-17 333-20l302-3 3-302c3-332 4-337 68-391 65-54 155-54 220 0 59 51 60 54 60 388v305l308 3c323 3 327 4 380 52 36 32 54 75 54 126s-18 94-54 126c-53 48-57 49-380 52l-308 3v305c0 334-1 337-60 387-27 23-88 48-115 47-5-1-27-7-48-15z"/>
</g>
</svg>

        <span>Diğer Hizmetlerim</span>
    </a>
    <a style="display:none;" href="{{ route('invoices') }}" class="application-nav-item @if(request()->is('invoices*')) active @endif">
        <svg fill="currentColor" version="1.0" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
        <g transform="translate(0 512) scale(.1 -.1)">
        <path d="m1170 4893c-115-19-246-89-336-178-80-79-131-164-166-275l-23-75v-1995-1995l22-40c40-76 105-115 188-115s108 19 360 271c132 131 243 239 246 239s74-102 158-228c102-152 163-235 187-252 53-35 145-40 205-10 28 14 135 112 299 276l255 254 260-261c143-144 274-267 292-275 67-29 167-11 222 39 13 12 87 116 163 232 77 116 144 214 149 220 6 6 103-84 252-232 157-157 255-247 279-257 121-51 262 22 288 149 7 34 10 667 8 2015-3 1853-4 1968-21 2025-63 211-210 371-409 443l-73 27-1390 1c-765 1-1401 0-1415-3zm2777-443c36-21 61-44 80-77l28-48 3-1692c1-931-1-1693-5-1693-5 0-76 68-158 151-83 83-163 158-180 166-67 36-187 12-241-49-12-12-85-119-164-237l-142-214-241 241c-133 132-257 247-276 257-43 22-125 22-176 1-28-12-115-92-282-258l-241-241-151 226c-82 124-165 237-183 250-53 41-116 52-180 33-48-14-68-30-208-171-85-85-158-155-162-155-5 0-8 751-8 1668 0 1809-3 1722 54 1796 14 18 44 43 68 55l43 21h1335 1335l52-30z"/>
        <path d="m1636 4035c-45-16-99-65-121-111-33-70-10-179 51-236 65-61 21-58 986-58 592 0 896 4 921 11 46 13 109 67 131 113 46 98-5 229-109 277-38 18-85 19-930 18-731 0-897-2-929-14z"/>
        <path d="m1632 2970c-147-59-178-258-56-358 61-50 97-53 585-50 443 3 444 3 492 26 122 61 153 220 61 322-66 72-46 70-581 69-267 0-488-4-501-9z"/>
        <path d="m3115 2961c-49-22-99-77-115-126-28-86 15-194 98-242 46-27 50-28 207-28 146 0 164 2 201 22 81 43 120 115 112 209-6 67-47 129-109 161-39 21-55 23-198 23-129 0-163-4-196-19z"/>
        <path d="m1636 2115c-45-16-99-65-121-111-33-70-10-179 51-236 62-58 62-58 561-58 305 0 471 4 498 11 77 22 145 115 145 199s-68 177-145 199c-63 17-938 14-989-4z"/>
        <path d="m3125 2115c-74-26-135-114-135-195 0-84 68-177 145-199 51-14 288-14 338 0 46 13 109 67 131 113 33 69 14 170-42 230-52 55-92 66-252 65-99 0-158-4-185-14z"/>
        </g>
        </svg>

        <span>Faturalarım</span>
    </a>
    <a href="{{ route('tickets') }}" class="application-nav-item @if(request()->is('tickets*')) active @endif">
        <svg version="1.0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.000000 512.000000" fill="currentColor">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
 stroke="none">
<path d="M2435 4789 c-248 -16 -442 -64 -677 -170 -211 -96 -387 -218 -553
-384 -298 -298 -471 -640 -542 -1070 -15 -95 -18 -172 -17 -570 0 -439 1 -464
22 -541 66 -248 228 -441 451 -540 113 -51 290 -81 358 -62 51 14 102 65 113
113 14 59 13 1300 -1 1350 -15 52 -77 115 -115 116 -166 7 -309 -31 -466 -125
l-48 -28 0 79 c0 87 29 274 59 373 114 390 378 728 728 933 362 212 806 273
1224 167 154 -40 342 -124 484 -219 412 -274 677 -733 702 -1215 l6 -120 -44
27 c-65 41 -167 87 -229 103 -82 22 -207 33 -247 22 -51 -14 -102 -65 -113
-113 -14 -59 -13 -1300 1 -1350 15 -52 77 -115 115 -116 106 -5 269 22 327 53
29 15 30 4 6 -43 -102 -200 -303 -417 -514 -555 -66 -43 -255 -144 -269 -144
-2 0 -6 25 -8 56 -4 47 -10 61 -40 90 -20 21 -51 39 -74 44 -55 13 -500 12
-547 -1 -54 -15 -106 -65 -117 -114 -13 -56 -12 -342 1 -390 15 -51 77 -115
115 -116 156 -7 328 12 518 57 139 33 241 70 391 144 492 242 840 663 979
1182 57 213 61 269 61 828 0 449 -3 529 -19 625 -70 427 -246 777 -541 1070
-393 393 -919 590 -1480 554z m-1155 -2550 l0 -450 -22 7 c-42 12 -108 56
-153 100 -196 190 -195 499 3 691 45 45 136 103 160 103 9 0 12 -97 12 -451z
m2648 414 c270 -157 312 -539 84 -760 -45 -45 -136 -103 -159 -103 -10 0 -13
97 -13 451 l0 450 23 -7 c12 -3 41 -18 65 -31z"/>
</g>
</svg>


        <span>Destek Taleplerim</span>
    </a>
    <a href="{{ route('blog') }}" class="application-nav-item @if(request()->is('blog*')) active @endif">
<svg version="1.1" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 113.8 122.9" style="enable-background:new 0 0 113.8 122.9" xml:space="preserve"><g><path d="M46.5,12.6c11.8,0,30.3,0.1,42.1,0.1c1.3,0,2.6,0.1,3.9,0.4c1.2,0.2,2.4,0.6,3.6,1.1c1.1,0.5,2.2,1.1,3.3,1.8 c1,0.7,2,1.5,2.9,2.4c0.9,0.9,1.7,1.9,2.4,2.9c0.7,1,1.3,2.1,1.8,3.3c0.5,1.1,0.8,2.3,1.1,3.6c0.2,1.3,0.4,2.5,0.4,3.9v39.1 c0,1.3-0.1,2.6-0.4,3.9c-0.2,1.3-0.6,2.4-1.1,3.6c-0.5,1.1-1.1,2.2-1.8,3.3c-0.7,1-1.5,2-2.4,2.9l0,0c-1,0.9-2,1.8-3,2.4 c-1,0.7-2.1,1.3-3.2,1.8c-1.1,0.5-2.3,0.8-3.5,1.1c-1.2,0.2-2.5,0.4-3.9,0.4H73.8c-0.5,0-0.9,0.1-1.3,0.3c-0.4,0.2-0.7,0.5-1,0.8 l0,0c-1.2,1.5-2.4,3-3.7,4.5c-1.3,1.4-2.6,2.8-4.1,4.1c-1.4,1.3-2.9,2.5-4.4,3.7c-1.5,1.2-3.1,2.3-4.7,3.4c-1.5,1-3.2,2-4.9,2.9 c-1.7,0.9-3.4,1.7-5.1,2.5c-0.2,0.1-0.4,0.1-0.6,0c-0.3-0.2-0.4-0.6-0.3-0.9c0.3-0.6,0.6-1.1,0.9-1.7c0.3-0.5,0.6-1.1,0.8-1.7l0,0 c0.5-1.1,1-2.2,1.4-3.4c0.5-1.2,0.9-2.4,1.3-3.6c0.4-1.1,0.8-2.3,1.1-3.5c0.4-1.2,0.7-2.4,1-3.6c0.1-0.4,0.2-0.7,0.2-1.1 c0-0.8-0.3-1.5-0.9-2.1l0,0c-0.5-0.5-1.3-0.9-2.1-0.9H30.4c-1.3,0-2.6-0.1-3.9-0.4c-1.2-0.2-2.4-0.6-3.5-1l0,0 c-1.1-0.4-2.2-1-3.2-1.7c-1.1-0.7-2.1-1.6-3.1-2.5l0,0c-0.9-0.9-1.7-1.9-2.4-2.9c-0.7-1-1.3-2.1-1.8-3.3c-0.5-1.1-0.8-2.3-1.1-3.6 c-0.2-1.3-0.4-2.5-0.4-3.9V46.3c0-4-5.2-4-6-1.2v25.9c0,1.7,0.2,3.4,0.5,5c0.3,1.6,0.8,3.2,1.4,4.7c0.6,1.5,1.4,2.9,2.3,4.3 c0.9,1.4,2,2.7,3.2,3.9c1.2,1.2,2.5,2.3,3.9,3.2c1.3,0.9,2.8,1.7,4.3,2.3l0,0c1.5,0.6,3.1,1.1,4.7,1.4c1.6,0.3,3.3,0.5,5,0.5h12.3 c0.1,0,0.2,0,0.2,0c0.4,0.1,0.6,0.5,0.4,0.9l0,0c-0.2,0.8-0.5,1.5-0.7,2.3l0,0c-0.4,1.1-0.8,2.2-1.2,3.3c-0.4,1-0.9,2.1-1.3,3.1 c0,0.1,0,0.1,0,0.2c-0.4,1-0.9,2-1.5,3c-0.6,1-1.2,1.9-2,2.9c-0.7,0.9-1.6,1.9-2.5,2.9l0,0c-0.9,1-1.9,1.9-3,2.9 c-0.6,0.6-0.9,1.3-1,2.1c0,0.8,0.2,1.5,0.8,2.1c0.4,0.4,0.9,0.7,1.4,0.9c0.5,0.2,1.1,0.2,1.6,0c2.2-0.6,4.4-1.3,6.6-2 c2.1-0.7,4.2-1.5,6.2-2.4c2-0.9,4-1.8,5.9-2.8c1.9-1,3.7-2.1,5.5-3.3l0,0c1.8-1.1,3.5-2.4,5.1-3.7c1.7-1.3,3.2-2.7,4.8-4.1l0,0 c1.3-1.2,2.5-2.5,3.7-3.8c1.2-1.3,2.4-2.7,3.5-4.1c0.1-0.2,0.3-0.3,0.6-0.3h13c1.7,0,3.4-0.2,5-0.5c1.6-0.3,3.2-0.8,4.7-1.4l0,0 c1.5-0.6,2.9-1.4,4.3-2.3c1.4-0.9,2.7-2,3.9-3.2c1.2-1.2,2.3-2.5,3.2-3.9c0.9-1.4,1.7-2.8,2.3-4.3c0.6-1.5,1.1-3.1,1.4-4.7 c0.3-1.6,0.5-3.3,0.5-5V31.9c0-1.7-0.2-3.4-0.5-5c-0.3-1.6-0.8-3.2-1.4-4.7c-0.6-1.5-1.4-2.9-2.3-4.3c-0.9-1.4-2-2.7-3.2-3.9 c-1.2-1.2-2.5-2.3-3.9-3.2c-1.3-0.9-2.8-1.7-4.3-2.3l0,0c-1.5-0.6-3.1-1.1-4.7-1.4c-1.6-0.3-3.3-0.5-5-0.5 c-12.3,0-31.2-0.1-43.5-0.1C42.2,7.4,42,12.6,46.5,12.6L46.5,12.6L46.5,12.6z M24.3,39.2c1.9,0.6,3.8,1.2,5.7,1.8 c1.9,0.6,3.8,1.3,5.7,1.9c4.5,1.4,7,2.3,7.5,2.4c0.5,0.1,0.2-1.9-0.9-6.3l-3.6-13.7l-0.3-0.3L24.3,39.2L24.3,39.2L24.3,39.2 L24.3,39.2L24.3,39.2z M33.2,19.7L14.9,0.5C14.3,0,13.7-0.2,13,0.2L0.4,12.4c-0.5,0.6-0.6,1.3,0.1,2l18.6,19.5L33.2,19.7L33.2,19.7 L33.2,19.7z M42.1,72.9c-1.6,0-2.8-1.2-2.9-2.8c0-1.6,1.2-2.8,2.8-2.9L67,66.8l5.7-0.4c1.6-0.1,2.9,1.1,3,2.6 c0.1,1.6-1.1,2.9-2.6,3l-5.7,0.4C67.4,72.4,44.6,72.8,42.1,72.9L42.1,72.9L42.1,72.9z M51,55.1c-1.6,0-2.8-1.3-2.8-2.8 c0-1.6,1.3-2.8,2.8-2.8h35.6c1.6,0,2.8,1.3,2.8,2.8c0,1.6-1.3,2.8-2.8,2.8H51L51,55.1L51,55.1z M63.6,38.2c-1.6,0-2.8-1.3-2.8-2.8 s1.3-2.8,2.8-2.8h23c1.6,0,2.8,1.3,2.8,2.8c0,1.6-1.3,2.8-2.8,2.8H63.6L63.6,38.2L63.6,38.2z"/></g></svg>

        <span>Blog & Haberler</span>
    </a>
</div>
</div>
<script>
        document.addEventListener("DOMContentLoaded", function() {
            setTimeout(() => {
                let navMenu = document.getElementById("navMenu");
                let activeItem = document.querySelector(".application-nav-item.active");
                if (activeItem) {
                    let leftOffset = activeItem.offsetLeft - (navMenu.clientWidth / 2) + (activeItem.clientWidth / 2);
                    navMenu.scrollTo({ left: leftOffset, behavior: "smooth" });
                }
            }, 500); // WebView yükleme süresi için bekleme
        });
    </script>


    <?php
  }
 ?>
</div>

<div
    x-cloak
    x-data="{}"
    x-on:click="$store.sidebar.close()"
    x-show="$store.sidebar.isOpen"
    x-transition.opacity.300ms
    class="fi-sidebar-close-overlay fixed inset-0 z-30 bg-gray-950/50 transition duration-500 dark:bg-gray-950/75 lg:hidden"
></div>

<aside
    x-data="{}"
    x-cloak="-lg"
    x-bind:class="
    $store.sidebar.isOpen
        ? 'fi-sidebar-open w-[--sidebar-width] translate-x-0 shadow-xl ring-1 ring-gray-950\/5 dark:ring-white\/10 rtl:-translate-x-0 lg:sticky'                    : 'w-[--sidebar-width] -translate-x-full rtl:translate-x-full lg:sticky'
"
    class="fi-sidebar fixed inset-y-0 start-0 z-30 flex flex-col h-screen content-start bg-white transition-all dark:bg-gray-900 lg:z-0 lg:bg-transparent lg:shadow-none lg:ring-0 lg:transition-none dark:lg:bg-transparent lg:translate-x-0 rtl:lg:-translate-x-0 fi-main-sidebar"
>
    <div class="overflow-x-clip">
        <header class="fi-sidebar-header flex h-16 items-center bg-white px-6 ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 lg:shadow-sm">
            <div>
                <a href="https://serversistemleri.com" wire:navigate>
                  <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp"  class="l-none fi-logo flex" />
                  <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp"  class="d-none fi-logo flex" />
                </a>
            </div>
        </header>
    </div>
    @include("layouts.menu")
</aside>
</div>

<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=<?php echo rand(); ?>" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>

</body>
</html>
