<?php $pageTitle = 'Ürün Detayları'; ?>
@include("layouts.header")
<style media="screen">
.mbtn{
  width: 19.2%;
}
.label-mobile{
  display: none;
}
.label-desktop{
  display: block;
}
.label {
  padding: 5px 10px;
  border-radius: 3px;
  font-size: 14px;
  color: white;
  text-align: center;
}

.label-default {
  background-color: #777;
}

.label-default[href]:hover,
.label-default[href]:focus {
  background-color: #5e5e5e;
}

.label-primary {
  background-color: #337ab7;
}

.label-primary[href]:hover,
.label-primary[href]:focus {
  background-color: #286090;
}

.label-success {
  background-color: #5cb85c;
}

.label-success[href]:hover,
.label-success[href]:focus {
  background-color: #449d44;
}

.label-info {
  background-color: #5bc0de;
}

.label-info[href]:hover,
.label-info[href]:focus {
  background-color: #31b0d5;
}

.label-warning {
  background-color: #f0ad4e;
}

.label-warning[href]:hover,
.label-warning[href]:focus {
  background-color: #ec971f;
}

.label-danger {
  background-color: #d9534f;
}

.label-danger[href]:hover,
.label-danger[href]:focus {
  background-color: #c9302c;
}
@media only screen and (max-width: 600px) {
.mr-15 {
  margin-left: 15px;
}
.mbtn{
  width: 100%;
  margin-bottom:5px;
}
.label-mobile{
  display: block;
}
.label-desktop{
  display: none;
}
}

</style>
<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Hosting Detayları
                    </h1>
                </div>
            </header>
        </section>
    </div>
<?php

$module = null;
foreach ($server['servers'] as $srv) {
  if ($srv['id'] == $product['serverid']) {
      $module = $srv['module'];
      break;
  }
}
$statusClasses = [
   "Active" => "label-success",
   "Suspended" => "label-warning",
   "Terminated" => "label-danger",
   "Cancelled" => "label-default"
];
$status = $product['status'];
$cssClass = isset($statusClasses[$status]) ? $statusClasses[$status] : "label-default";

$whmcsFilePath = storage_path('app/public/whmcs_data.json');
if (file_exists($whmcsFilePath)) {
    $whmcs_data = json_decode(file_get_contents($whmcsFilePath), true);
} else {
    $whmcs_data = [];
}
?>
    <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
        <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
            <div class="fi-ta">
                <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                    <div  class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                        <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                            <div class="grid gap-y-1">
                                <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                    Hosting Bilgilerim
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                      <div class="">
                          <div class="px-6 py-4">
                              <div class="flex items-center">
                                  <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                      <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                          <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd" />
                                      </svg>
                                  </div>
                                  <div style="margin-left: 10px;" class="ml-4">
                                      <h1 class="text-xl font-semibold text-gray-900 dark:text-white"><?php echo str_replace("-", " ", $product['name']); ?></h1>
                                      <p class="text-gray-600 dark:text-gray-400">{{$product['domain']}}</p>
                                  </div>
                                  <span class="label-desktop label <?php echo $cssClass; ?> ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                    <?php
                                    if ($product['status'] == "Active") {
                                      echo "Aktif";
                                    }
                                    if ($product['status'] == "Suspended") {
                                      echo "Askıya Alındı";
                                    }
                                    if ($product['status'] == "Terminated") {
                                      echo "Kapatıldı";
                                    }
                                    if ($product['status'] == "Cancelled") {
                                      echo "İptal Edildi";
                                    }
                                     ?>
                                  </span>
                              </div>
                              <div style="margin-top:10px;" class="mt-4">
                                <span style="margin-bottom:5px;border-radius: .5rem;" class="label-mobile label <?php echo $cssClass; ?> ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                  <?php
                                  if ($product['status'] == "Active") {
                                    echo "Aktif";
                                  }
                                  if ($product['status'] == "Suspended") {
                                    echo "Askıya Alındı";
                                  }
                                  if ($product['status'] == "Terminated") {
                                    echo "Kapatıldı";
                                  }
                                  if ($product['status'] == "Cancelled") {
                                    echo "İptal Edildi";
                                  }
                                   ?>
                                </span>
                                  <a target="_blank" href="https://{{$product['domain']}}" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                    <span class="fi-btn-label">
                                      Görüntüle
                                    </span>
                                  </a>
                                  <?php if ($module == "cpanel"): ?>
                                    <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
                                        @csrf
                                        <input type="hidden" name="serverid" value="{{ $product['serverid'] }}">
                                        <input type="hidden" name="username" value="{{ $product['username'] }}">
                                        <?php if ($product['groupname'] == "SS-WEB-HOSTING-BAYI") {
                                          $button = "Giriş Yap";
                                          ?>
                                          <input type="hidden" name="type" value="reselleraccount">
                                          <?php
                                        }else {
                                          $button = "Giriş Yap";
                                        } ?>
                                        <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"><?php echo $button; ?></button>
                                    </form>
                                  <?php else: ?>
                                    <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
                                        @csrf
                                        <input type="hidden" name="serverid" value="{{ $product['serverid'] }}">
                                        <input type="hidden" name="username" value="{{ $product['username'] }}">
                                        <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Giriş Yap</button>
                                    </form>
                                  <?php endif; ?>

                                  <a target="_blank" href="https://serversistemleri.com/whois-sorgulama?domain={{$product['domain']}}" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                    <span class="fi-btn-label">
                                      WHOIS Bilgisi
                                    </span>
                                  </a>
                                    <form action="{{ route('domain.save') }}" method="POST" class="hostingrenew-form" style="display: contents;">
                                      @csrf
                                      <input type="hidden" name="action" value="hostingrenew">
                                      <input type="hidden" name="serviceid" value="<?php echo $product['id']; ?>">
                                      <select name="period" style="text-align: center; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                        <option selected disabled>Süre Uzat</option>
                                        <?php
                                          $turkish_cycles = [
                                            'monthly' => '1 Aylık',
                                            'quarterly' => '3 Aylık',
                                            'semiannually' => '6 Aylık',
                                            'annually' => '1 Yıllık',
                                            'biennially' => '2 Yıllık',
                                            'triennially' => '3 Yıllık'
                                          ];

                                          foreach ($whmcs_data['products']['products']['product'] as $product_data) {
                                            if ($product_data['pid'] == $product['pid'] && isset($product_data['pricing']['USD'])) {
                                              foreach ($product_data['pricing']['USD'] as $cycle => $price) {
                                                if ($price > 0 && !in_array($cycle, ['prefix', 'suffix', 'msetupfee', 'qsetupfee', 'ssetupfee', 'asetupfee', 'bsetupfee', 'tsetupfee'])) {
                                                  $turkish_name = isset($turkish_cycles[$cycle]) ? $turkish_cycles[$cycle] : $cycle; // Eğer Türkçe çeviri varsa kullan
                                                  ?>
                                                  <option value="<?php echo $cycle; ?>"><?php echo $turkish_name; ?> ($<?php echo $price; ?>)</option>
                                                  <?php
                                                }
                                              }
                                            }
                                          }
                                        ?>
                                      </select>
                                    </form>
                                  <a target="_blank" href="https://hostingsistemleri.com/cancel/{{$product['id']}}" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                    <span class="fi-btn-label">
                                      İptal Talebi
                                    </span>
                                  </a>
                              </div>
                          </div>
                          <div class="border-t dark:border-gray-700">
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Yenileme Tutarı</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200">${{$product['recurringamount']}}</dd>
                                  </div>
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Fatura Kesim Döngüsü</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200"><?php
                                      if ($product['billingcycle'] == "Annually") {
                                        echo "Yıllık";
                                      } elseif ($product['billingcycle'] == "Monthly") {
                                        echo "Aylık";
                                      } elseif ($product['billingcycle'] == "Quarterly") {
                                        echo "Üç Aylık";
                                      } elseif ($product['billingcycle'] == "Semi-Annually") {
                                        echo "Altı Aylık";
                                      } elseif ($product['billingcycle'] == "Biennially") {
                                        echo "İki Yıllık";
                                      } elseif ($product['billingcycle'] == "Triennially") {
                                        echo "Üç Yıllık";
                                      } else {
                                        echo "Bilinmeyen faturalama döngüsü";
                                      }
                                        ?></dd>
                                  </div>
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Ödeme şekli</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200"><?php
                                        if ($product['paymentmethod'] == "banktransfer") {
                                          echo "Banka Transferi";
                                        }
                                        if ($product['paymentmethod'] == "paytr") {
                                          echo "Kredi Kartı";
                                        }
                                       ?></dd>
                                  </div>
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Kayıt Tarihi</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200"><?php echo date_format(date_create($product['regdate']), "d-m-Y") ?></dd>
                                  </div>
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Sonraki Son Ödeme Tarihi</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200"><?php echo date_format(date_create($product['nextduedate']), "d-m-Y") ?></dd>
                                  </div>
                              </dl>
                          </div>
                      </div>
                    </div>
                </div>
            </div>
        </div>

        <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
    <div class="fi-ta">
        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
            <div  class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                    <div class="grid gap-y-1">
                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                            Hosting Yönetim Kısayolları
                        </h3>
                    </div>
                </div>

                <div class="fi-ta-header-toolbar flex items-center justify-between gap-x-4 px-4 py-3 sm:px-6" style="display: none;">
                    <div class="flex shrink-0 items-center gap-x-4"></div>
                </div>
            </div>

            <?php if ($module == "cpanel"): ?>
<div class="px-6 py-4">
<div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-4 gap-6 mt-6">
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Email_Accounts" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/email_accounts.png" alt="E-Posta Hesapları" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">E-Posta Hesapları</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="FileManager_Home" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/file_manager.png" alt="Dosya Yöneticisi" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Dosya Yöneticisi</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Email_Forwarders" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/forwarders.png" alt="İleticiler" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">İleticiler</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Email_AutoResponders" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/autoresponders.png" alt="Otomatik Cevaplayıcılar" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Otomatik Cevaplayıcılar</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Backups_Home" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/backup.png" alt="Yedekleme" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Yedekleme</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Database_MySQL" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/mysql_databases.png" alt="Veri Tabanları" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Veri Tabanları</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Database_phpMyAdmin" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/php_my_admin.png" alt="phpMyAdmin" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">phpMyAdmin</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('cpanel.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="Domains_SubDomains" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/subdomains.png" alt="Subdomain'ler" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Subdomain'ler</p>
            </button>
        </form>
    </div>
    <?php if ($product['groupname'] == 'SS-WEB-HOSTING-BAYI'): ?>
      <div class="text-center">
        <button onclick="document.getElementById('dns-manager').showModal();" style="cursor: pointer;">
            <img src="/img/addon_domains.png" alt="Addon Domain'ler" class="mx-auto" />
            <p class="mt-2 text-blue-600 dark:text-blue-400">DNS Yönetimi</p>
        </button>
      </div>
      <style media="screen">

      dialog {
        min-width: 30%;

      background: white;
      max-width: 400px;
      padding-top: 2rem;
      border-radius: 20px;
      border: 0;
      box-shadow: 0 5px 30px 0 rgb(0 0 0 / 10%);
      animation: fadeIn 1s ease both;
      &::backdrop {
        animation: fadeIn 1s ease both;
        background: rgb(255 255 255 / 40%);
        z-index: 2;
        backdrop-filter: blur(20px);
      }
      .x {
        filter: grayscale(1);
        border: none;
        background: none;
        position: absolute;
        top: 15px;
        right: 10px;
        transition: ease filter, transform 0.3s;
        cursor: pointer;
        transform-origin: center;
        &:hover {
          filter: grayscale(0);
          transform: scale(1.1);
        }
      }
      h2 {
        font-weight: 600;
        font-size: 2rem;
        padding-bottom: 1rem;
      }
      p {
        font-size: 1rem;
        line-height: 1.3rem;
        padding: 0.5rem 0;
        a {
          &:visited {
            color: rgb(var(--vs-primary));
          }
        }
      }
      }

      @keyframes fadeIn {
      from {
        opacity: 0;
      }
      to {
        opacity: 1;
      }
      }

      </style>
        <dialog id="dns-manager" class="fi-simple-main  w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
                <section class="grid auto-cols-fr gap-y-6">
                    <header class="fi-simple-header flex flex-col items-center">
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" style="width: 250px;" class="d-none  fi-logo flex mb-4" />
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" style="width: 250px;" class="l-none  fi-logo flex mb-4" />
                        <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                            DNS Yönetimi
                          </h1>
                        </header>

                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                          @foreach($securedDomains as $item)
                          <form action="{{ route('dns.getZone', ['domain' => $item['domain']]) }}" method="POST">
                            @csrf
                            <input type="hidden" name="hash" value="{{ $item['hash'] }}">
                            <input type="hidden" name="serverId" value="<?php echo $srv['id']; ?>">
                            <button type="submit"
                            class="w-full text-left flex items-center p-4 rounded-2xl border border-gray-200 dark:border-gray-700
                            bg-white dark:bg-gray-900 shadow-sm hover:shadow-md
                            hover:bg-gray-50 dark:hover:bg-gray-800 transition-all duration-200">
                            <div class="flex flex-col overflow-hidden">
                              <span class="font-semibold text-gray-800 dark:text-white truncate w-full" title="{{ $item['domain'] }}">
                                {{ $item['domain'] }}
                              </span>
                              <span class="text-sm text-gray-500 dark:text-gray-400">
                                DNS’ini yönetmek için tıkla
                              </span>
                            </div>
                          </button>
                        </form>
                        @endforeach
                      </div>
                    </section>
                  </div>
                  <button onclick="this.closest('dialog').close();" aria-label="close" class="x">❌</button>
                </dialog>
                <?php else: ?>
                  <div class="text-center">
                    <?php
                    $securedDomain = $securedDomains[0];
                     ?>
                    <form action="{{ route('dns.getZone', ['domain' => $securedDomain['domain']]) }}" method="post">
                      @csrf
                           <input type="hidden" name="hash" value="{{ $securedDomain['hash'] }}">
                             <input type="hidden" name="serverId" value="<?php echo $srv['id']; ?>">
                           <button type="submit"  style="cursor: pointer;">
                               <img src="/img/addon_domains.png" alt="Addon Domain'ler" class="mx-auto" />
                               <p class="mt-2 text-blue-600 dark:text-blue-400">DNS Yönetimi</p>
                           </button>
                    </form>

                  </div>
    <?php endif; ?>

</div>
</div>
<?php endif; ?>
<?php if ($module == "plesk"): ?>
<div class="px-6 py-4">
<div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-4 gap-6 mt-6">
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/email-address/list" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/email_accounts.png" alt="E-Posta Hesapları" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">E-Posta Hesapları</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/app/installed" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/cron_jobs.png" alt="Uygulamalar" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Uygulamalar</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/file-manager/list" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/file_manager.png" alt="Dosya Yöneticisi" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Dosya Yöneticisi</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/statistics/details" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/awstats.png" alt="İstatistik" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">İstatistik</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/database/list" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/mysql_databases.png" alt="Veri Tabanları" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Veri Tabanları</p>
            </button>
        </form>
    </div>
    <div class="text-center">
        <form action="{{ route('plesk.login') }}" method="POST" class="inline" target="_blank">
            @csrf
            <input type="hidden" name="serverid" value="{{ $product['serverid'] }}" />
            <input type="hidden" name="app" value="/smb/user/list" />
            <input type="hidden" name="username" value="{{ $product['username'] }}" />
            <button style="cursor: pointer;" type="submit">
                <img src="/img/email_accounts.png" alt="Kullanıcılar" class="mx-auto" />
                <p class="mt-2 text-blue-600 dark:text-blue-400">Kullanıcılar</p>
            </button>
        </form>
    </div>
</div>
</div>
<?php endif; ?>

        </div>
    </div>
</div>
    </div>
    <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(1, minmax(0, 1fr));margin-top:25px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
        <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
            <div class="fi-ta">
                <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                    <div  class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                        <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                            <div class="grid gap-y-1">
                                <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                    Detaylı Bilgilendirme
                                </h3>
                            </div>
                        </div>

                        <div class="fi-ta-header-toolbar flex items-center justify-between gap-x-4 px-4 py-3 sm:px-6" style="display: none;">
                            <div class="flex shrink-0 items-center gap-x-4"></div>
                        </div>
                    </div>

                    <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                      <div class="">
                          <div class="border-t dark:border-gray-700">
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between">
                                    <dt class="text-gray-600 dark:text-gray-400">Nameserver 1</dt>
                                    <dd class="font-medium text-gray-900 dark:text-gray-200">unna1.serversistemleri.com <span class="text-primary-500 dark:text-primary-400">- - --&gt;</span> 193.3.35.2</dd>
                                  </div>
                              </dl>
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Nameserver 2</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200">unna2.serversistemleri.com <span class="text-primary-500 dark:text-primary-400">- - --&gt;</span> 193.3.35.3</dd>
                                  </div>
                              </dl>
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400">Sunucu Hostname</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200">{{$product['serverhostname']}}</dd>
                                  </div>
                              </dl>
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between">
                                      <dt class="text-gray-600 dark:text-gray-400 ">Sunucu iP Adresi</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200">{{$product['serverip']}}</dd>
                                  </div>
                              </dl>

                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between items-center">
                                      <dt class="text-gray-600 dark:text-gray-400">cPanel/FTP Kullanıcı Adı</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200 flex items-center">
                                          <span class="password-dots" id="username">{{ str_repeat('•', strlen($product['username'])) }}</span>
                                          <button style="margin-left: 10px;" onclick="toggleVisibility('username', '{{ $product['username'] }}')" class="ml-2">
                                              <svg class="w-6 h-6 text-gray-800 dark:text-gray-200" fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                   viewBox="0 0 442.04 442.04" xml:space="preserve">
                                                  <g>
                                                      <g>
                                                          <path d="M221.02,341.304c-49.708,0-103.206-19.44-154.71-56.22C27.808,257.59,4.044,230.351,3.051,229.203
                                                              c-4.068-4.697-4.068-11.669,0-16.367c0.993-1.146,24.756-28.387,63.259-55.881c51.505-36.777,105.003-56.219,154.71-56.219
                                                              c49.708,0,103.207,19.441,154.71,56.219c38.502,27.494,62.266,54.734,63.259,55.881c4.068,4.697,4.068,11.669,0,16.367
                                                              c-0.993,1.146-24.756,28.387-63.259,55.881C324.227,321.863,270.729,341.304,221.02,341.304z M29.638,221.021
                                                              c9.61,9.799,27.747,27.03,51.694,44.071c32.83,23.361,83.714,51.212,139.688,51.212s106.859-27.851,139.688-51.212
                                                              c23.944-17.038,42.082-34.271,51.694-44.071c-9.609-9.799-27.747-27.03-51.694-44.071
                                                              c-32.829-23.362-83.714-51.212-139.688-51.212s-106.858,27.85-139.688,51.212C57.388,193.988,39.25,211.219,29.638,221.021z"/>
                                                      </g>
                                                      <g>
                                                          <path d="M221.02,298.521c-42.734,0-77.5-34.767-77.5-77.5c0-42.733,34.766-77.5,77.5-77.5c18.794,0,36.924,6.814,51.048,19.188
                                                              c5.193,4.549,5.715,12.446,1.166,17.639c-4.549,5.193-12.447,5.714-17.639,1.166c-9.564-8.379-21.844-12.993-34.576-12.993
                                                              c-28.949,0-52.5,23.552-52.5,52.5s23.551,52.5,52.5,52.5c28.95,0,52.5-23.552,52.5-52.5c0-6.903,5.597-12.5,12.5-12.5
                                                              s12.5,5.597,12.5,12.5C298.521,263.754,263.754,298.521,221.02,298.521z"/>
                                                      </g>
                                                      <g>
                                                          <path d="M221.02,246.021c-13.785,0-25-11.215-25-25s11.215-25,25-25c13.786,0,25,11.215,25,25S234.806,246.021,221.02,246.021z"/>
                                                      </g>
                                                  </g>
                                              </svg>
                                          </button>
                                      </dd>
                                  </div>
                              </dl>
                              <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                  <div class="py-2 px-6 flex justify-between items-center">
                                      <dt class="text-gray-600 dark:text-gray-400">cPanel/FTP Şifre</dt>
                                      <dd class="font-medium text-gray-900 dark:text-gray-200 flex items-center">
                                          <span class="password-dots" id="password">{{ str_repeat('•', strlen($product['password'])) }}</span>
                                          <button style="margin-left: 10px;" onclick="togglePasswordVisibility('password', '{{ $product['password'] }}')" class="ml-2">
                                              <svg class="w-6 h-6 text-gray-800 dark:text-gray-200" fill="currentColor" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                   viewBox="0 0 442.04 442.04" xml:space="preserve">
                                                  <g>
                                                      <g>
                                                          <path d="M221.02,341.304c-49.708,0-103.206-19.44-154.71-56.22C27.808,257.59,4.044,230.351,3.051,229.203
                                                              c-4.068-4.697-4.068-11.669,0-16.367c0.993-1.146,24.756-28.387,63.259-55.881c51.505-36.777,105.003-56.219,154.71-56.219
                                                              c49.708,0,103.207,19.441,154.71,56.219c38.502,27.494,62.266,54.734,63.259,55.881c4.068,4.697,4.068,11.669,0,16.367
                                                              c-0.993,1.146-24.756,28.387-63.259,55.881C324.227,321.863,270.729,341.304,221.02,341.304z M29.638,221.021
                                                              c9.61,9.799,27.747,27.03,51.694,44.071c32.83,23.361,83.714,51.212,139.688,51.212s106.859-27.851,139.688-51.212
                                                              c23.944-17.038,42.082-34.271,51.694-44.071c-9.609-9.799-27.747-27.03-51.694-44.071
                                                              c-32.829-23.362-83.714-51.212-139.688-51.212s-106.858,27.85-139.688,51.212C57.388,193.988,39.25,211.219,29.638,221.021z"/>
                                                      </g>
                                                      <g>
                                                          <path d="M221.02,298.521c-42.734,0-77.5-34.767-77.5-77.5c0-42.733,34.766-77.5,77.5-77.5c18.794,0,36.924,6.814,51.048,19.188
                                                              c5.193,4.549,5.715,12.446,1.166,17.639c-4.549,5.193-12.447,5.714-17.639,1.166c-9.564-8.379-21.844-12.993-34.576-12.993
                                                              c-28.949,0-52.5,23.552-52.5,52.5s23.551,52.5,52.5,52.5c28.95,0,52.5-23.552,52.5-52.5c0-6.903,5.597-12.5,12.5-12.5
                                                              s12.5,5.597,12.5,12.5C298.521,263.754,263.754,298.521,221.02,298.521z"/>
                                                      </g>
                                                      <g>
                                                          <path d="M221.02,246.021c-13.785,0-25-11.215-25-25s11.215-25,25-25c13.786,0,25,11.215,25,25S234.806,246.021,221.02,246.021z"/>
                                                      </g>
                                                  </g>
                                              </svg>
                                          </button>
                                      </dd>
                                  </div>
                              </dl>
                              <style media="screen">
                              .password-dots {
                                font-family: 'Arial', sans-serif;
                                letter-spacing: 0.2em;
                              }
                              </style>
                              <script>
                              function toggleVisibility(id, actualValue) {
                                  const element = document.getElementById(id);
                                  if (element.textContent === '•'.repeat(actualValue.length)) {
                                      element.textContent = actualValue;
                                      element.classList.remove('password-dots');
                                  } else {
                                      element.textContent = '•'.repeat(actualValue.length);
                                      element.classList.add('password-dots');
                                  }
                              }

                              function togglePasswordVisibility(id, actualValue) {
                                  const element = document.getElementById(id);
                                  if (element.textContent === actualValue) {
                                      element.textContent = '•'.repeat(actualValue.length);
                                      element.classList.add('password-dots');
                                  } else {
                                      element.textContent = actualValue;
                                      element.classList.remove('password-dots');
                                  }
                              }

                              </script>
                              <script>
                                  document.addEventListener("DOMContentLoaded", function () {
                                      const form = document.querySelector(".hostingrenew-form");
                                      const selectElement = form.querySelector('select[name="period"]');

                                      selectElement.addEventListener("change", function () {
                                          if (selectElement.value) {
                                              // Seçili option'ı geçici olarak sakla
                                              const selectedOption = selectElement.options[selectElement.selectedIndex];
                                              const originalText = selectedOption.text;

                                              // Seçenek metnini "Bekleyiniz..." olarak değiştir
                                              selectedOption.text = "Bekleyiniz...";

                                              const formData = new FormData(form);

                                              fetch("{{ route('domain.save') }}", {
                                                  method: "POST",
                                                  body: formData,
                                                  headers: {
                                                      "X-CSRF-TOKEN": "{{ csrf_token() }}",
                                                      Accept: "application/json",
                                                  },
                                              })
                                              .then((response) => {
                                                  if (!response.ok) {
                                                      throw new Error("HTTP hatası: " + response.status);
                                                  }
                                                  return response.json();
                                              })
                                              .then((data) => {
                                                  if (data.success && data.invoiceid) {
                                                      // Başarılı yanıt ve invoiceid varsa yönlendir
                                                      window.location.href = `https://sspanel.serversistemleri.com/invoices/view/${data.invoiceid}`;
                                                  } else {
                                                      alert("İşlem başarısız oldu: " + (data.message || "Bilinmeyen bir hata oluştu."));
                                                      selectedOption.text = originalText; // Eski seçeneği geri yükle
                                                  }
                                              })
                                              .catch((error) => {
                                                  console.error("Hata:", error);
                                                  alert("Bir hata oluştu. Lütfen tekrar deneyin.");
                                                  selectedOption.text = originalText; // Hata durumunda eski metni geri al
                                              });
                                          }
                                      });
                                  });
                              </script>



                          </div>
                      </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
@include("layouts.footer")
