<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;
use Illuminate\Support\Facades\Session;

class SSLController extends Controller
{

    protected $whmcs;

    // Constructor injection for WhmcsService
    public function __construct(WhmcsService $whmcs)
    {
      $this->whmcs = $whmcs;
    }

    // csrcreate method to handle form data for testing
    public function csrcreate(Request $request)
    {
      $productId = $request->input('productId');
      $clientId = session('client');

      $privateKey = openssl_pkey_new([
          "private_key_bits" => 2048,
          "private_key_type" => OPENSSL_KEYTYPE_RSA,
      ]);

      // CSR oluşturma için konfigürasyon
      $dn = [
          "countryName" => $request->input('countryName'),
          "stateOrProvinceName" => $request->input('stateOrProvinceName'),
          "localityName" => $request->input('localityName'),
          "organizationName" => $request->input('organizationName'),
          "commonName" => $request->input('domainName'),
          "emailAddress" => $request->input('emailAddress')
      ];

      // CSR oluşturma
      $csr = openssl_csr_new($dn, $privateKey);

      // CSR'yi PEM formatında çıkartma
      openssl_csr_export($csr, $csrOutput);
      openssl_pkey_export($privateKey, $privateKeyOutput);
      $this->whmcs->updateCSR($productId, $csrOutput);

              $mailtemplate = 'Sayın Yöneticimiz, <br><br>

              ' . $productId . ' numaralı ürün için CSR güncelleme işlemi başarıyla tamamlanmıştır. <br><br>
              SSL hizmetinizi aktif hale getirmenizi rica ederiz. Hizmetinize erişmek için aşağıdaki bağlantıya tıklayabilirsiniz: <br><br>
              <a target="_blank" href="https://sspanel.serversistemleri.com/unna1612/clientsservices.php?userid='.$clientId.'&id='.$productId.'">Ürün Detaylarını Görüntüle</a> <br><br>
              Saygılarımızla, <br>
              Server Sistemleri Otomasyon Ekibi';

              $this->whmcs->SendAdminEmail('CSR Kodu Oluşturuldu!', $mailtemplate);
        return response()->json([
            'success' => true,
            'message' => $csrOutput
        ]);

    }

    public function csrupdate(Request $request){
      $productId = $request->input('productId');
      $clientId = session('client');

      $csrCode = $request->input('csrCode');
      $response = $this->whmcs->updateCSR($productId, $csrCode);


      if (isset($response['result']) && $response['result'] === 'success') {
        $mailtemplate = 'Sayın Yöneticimiz, <br><br>

        ' . $productId . ' numaralı ürün için CSR güncelleme işlemi başarıyla tamamlanmıştır. <br><br>
        SSL hizmetinizi aktif hale getirmenizi rica ederiz. Hizmetinize erişmek için aşağıdaki bağlantıya tıklayabilirsiniz: <br><br>
        <a target="_blank" href="https://sspanel.serversistemleri.com/unna1612/clientsservices.php?userid='.$clientId.'&id='.$productId.'">Ürün Detaylarını Görüntüle</a> <br><br>
        Saygılarımızla, <br>
        Server Sistemleri Otomasyon Ekibi';

        $this->whmcs->SendAdminEmail('CSR Kodu Gönderildi!', $mailtemplate);

        return response()->json([
            'success' => true,
            'message' => 'Sonuç Başarılı'
        ]);

      } else {
        return response()->json([
            'success' => false,
            'message' => 'Sonuç Başarısız'
        ]);
      }
    }
}
