<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum EducationLevel: int implements HasLabel
{
    case ELEMENTARY_EDUCATION = 1;
    case MIDDLE_SCHOOL_EDUCATION = 2;
    case HIGH_SCHOOL_DIPLOMA = 3;
    case ASSOCIATES_DEGREE = 4;
    case BACHELORS_DEGREE = 5;
    case MASTERS_DEGREE = 6;
    case DOCTORAL_DEGREE = 7;
    case OTHER_EDUCATION = 8;

    public function getLabel(): string
    {
        return match ($this) {
            self::ELEMENTARY_EDUCATION      => 'İlkokul',
            self::MIDDLE_SCHOOL_EDUCATION   => 'Ortaokul',
            self::HIGH_SCHOOL_DIPLOMA       => 'Lise',
            self::ASSOCIATES_DEGREE         => 'Önlisans',
            self::BACHELORS_DEGREE          => 'Üniversite',
            self::MASTERS_DEGREE            => 'Yüksek Lisans',
            self::DOCTORAL_DEGREE           => 'Doktora',
            self::OTHER_EDUCATION           => 'Diğer',
        };
    }
}
