<?php
// POST ile gelen verileri alıyoruz
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $selectedProductId = isset($_POST['productId']) ? $_POST['productId'] : null;
    $selectedProductType = isset($_POST['productType']) ? $_POST['productType'] : null;

    // Gelen POST verilerini kontrol ediyoruz
    if ($selectedProductId && $selectedProductType) {

        $urun = $whmcs->GetProducts($selectedProductId);
        $basePrice = $urun['pricing']['USD']['monthly'];
        $basePricetry = $urun['pricing']['TRY']['monthly'];
?>
<style media="screen">
.radio-card {
    display: flex;
    align-items: center;
    justify-content: flex-start;
    gap: 10px; /* Radyo butonu ile yazı arasına boşluk ekler */
    width: calc(50% - 10px);
    padding: 12px;
    background-color: #fff;
    margin: 3px 5px;
    border-radius: 4px;
    cursor: pointer; /* Tüm kartın tıklanabilir olduğunu belirtmek için imleci değiştirir */
    border: 2px solid #e6e9eb;
    font-size: 14px;
    line-height: 1;
    position: relative;
}

.radio-card input {
    cursor: pointer; /* Radio butonunun tıklanabilir olduğunu belirtir */
}

.radio-card span {
    cursor: pointer; /* Span da tıklanabilir olur */
}


.banner {
  margin: 0;
  box-sizing: border-box;
  clear: both;
  padding-top: clamp(9rem, 5.5vw + 1rem, 15rem);
  padding-bottom: clamp(9rem, 5.5vw + 1rem, 15rem);
}

        .config-card {
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
        }
        .config-card:hover {
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: 0.3s;
        }
        .config-summary {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .summary-heading {
            font-size: 1.2rem;
            font-weight: bold;
        }
        .summary-content {
            padding: 10px;
            background-color: #f1f1f1;
            margin-bottom: 10px;
        }
        .total-price {
            font-size: 1.5rem;
            font-weight: bold;
            color: #28a745;
        }
        .submit-btn {
            background-color: #28a745;
            color: white;
            font-size: 1.2rem;
            padding: 10px 20px;
            border-radius: 8px;
            width: 100%;
            border: none;
        }
        .submit-btn:hover {
            background-color: #218838;
        }
        .os-group, .panel-group {
            display: none;
        }
        .os-group.active, .panel-group.active {
            display: block;
        }
        .radio-card.selected {
          border: 2px solid black;
          font-weight: bold;
        }
</style>
<script>
let basePrice = <?php echo $basePrice; ?>;
let selectedConfig = {
    os: { priceusd: 0, pricetry: 0, pid: null },
    controlPanel: { priceusd: 0, pricetry: 0, pid: null },
    ipAddress: { priceusd: 0, pricetry: 0, pid: null },
    backupService: { priceusd: 0, pricetry: 0, pid: null }
};

// Seçim yapıldığında fiyat, isim ve pid güncellemesi
function updateSelection(optionType, pricetry, priceusd, name, pid) {
    selectedConfig[optionType] = {
        pricetry: parseFloat(pricetry),
        priceusd: parseFloat(priceusd),
        pid: pid
    };
    document.getElementById(optionType + 'Selection').innerText = name;
    document.getElementById(optionType + 'Input').value = pid;
    updateTotalPrice();
    if (optionType === 'os') {
        toggleControlPanels(name);
    }
}


// Fiyat hesaplama
function updateTotalPrice() {
    let totalPriceusd = basePrice;  // USD için başlangıç değeri
    let totalPricetry = <?php echo $basePricetry; ?>;  // TRY için başlangıç değeri

    // Seçilen konfigürasyonların fiyatlarını topla
    for (let config in selectedConfig) {
        totalPriceusd += selectedConfig[config].priceusd;
        totalPricetry += selectedConfig[config].pricetry;
    }

    // Güncellenen toplam fiyatları ekrana yazdır
    document.getElementById('totalPriceusd').innerText = '$' + totalPriceusd.toFixed(2);
    document.getElementById('totalPricetry').innerText = '₺' + totalPricetry.toFixed(2);
}


// Sayfa yüklendiğinde otomatik ilk seçili olanları seçme
document.addEventListener("DOMContentLoaded", function() {
    // İşletim sistemi, kontrol paneli, IP adresi ve backup hizmetleri için ilk seçili olanları bulalım
    let selectedOS = document.querySelector('input[name="os"]:checked');
    let selectedControlPanel = document.querySelector('input[name="panel"]:checked');
    let selectedIPAddress = document.querySelector('input[name="ekip"]:checked');
    let selectedBackup = document.querySelector('input[name="backup"]:checked');

    // İlk seçili olanların fiyatlarını ve isimlerini güncelle
    if (selectedOS) {
        updateSelection('os', selectedOS.getAttribute('onclick').match(/'([\d.]+)'/)[0], selectedOS.getAttribute('onclick').match(/'([\d.]+)'/)[1], selectedOS.getAttribute('onclick').match(/'([^']+)'/)[2].replace(/'/g, ''), selectedOS.getAttribute('pid'));
    }
    if (selectedControlPanel) {
        updateSelection('controlPanel', selectedControlPanel.getAttribute('onclick').match(/'([\d.]+)'/)[0], selectedControlPanel.getAttribute('onclick').match(/'([\d.]+)'/)[1], selectedControlPanel.getAttribute('onclick').match(/'([^']+)'/)[2].replace(/'/g, ''), selectedControlPanel.getAttribute('pid'));
    }
    if (selectedIPAddress) {
        updateSelection('ipAddress', selectedIPAddress.getAttribute('onclick').match(/'([\d.]+)'/)[0], selectedIPAddress.getAttribute('onclick').match(/'([\d.]+)'/)[1], selectedIPAddress.getAttribute('onclick').match(/'([^']+)'/)[2].replace(/'/g, ''), selectedIPAddress.getAttribute('pid'));
    }
    if (selectedBackup) {
        updateSelection('backupService', selectedBackup.getAttribute('onclick').match(/'([\d.]+)'/)[0], selectedBackup.getAttribute('onclick').match(/'([\d.]+)'/)[1], selectedBackup.getAttribute('onclick').match(/'([^']+)'/)[2].replace(/'/g, ''), selectedBackup.getAttribute('pid'));
    }

    // Sayfa yüklendiğinde ilk seçilen işletim sistemi için kontrol panellerini güncelle
    toggleControlPanels();
});

    // Kontrol panellerini işletim sistemine göre aktif/deaktif yap
function toggleControlPanels() {
    // Seçilen işletim sistemi
    let selectedOS = document.querySelector('input[name="os"]:checked').getAttribute('typeos');

    // Linux ve Windows için kontrol panelleri
    let linuxPanels = ['cpanel-100-hesap', 'direct-admin-limitsiz-hesap', 'plesk-panel-limitsiz-hesap', 'isp-manager'];
    let windowsPanels = ['plesk-panel-limitsiz-hesap', 'direct-admin-limitsiz-hesap'];

    // İlk olarak tüm panelleri devre dışı bırak
    linuxPanels.concat(windowsPanels).forEach(function(panel) {
        let panelElement = document.getElementById(panel);
        if (panelElement) {
            panelElement.disabled = true;
        }
    });

    if (selectedOS === 'Windows') {
        // Windows seçildiyse sadece Windows panellerini etkinleştir
        windowsPanels.forEach(function(panel) {
            let panelElement = document.getElementById(panel);
            if (panelElement) {
                panelElement.disabled = false;
            }
        });
    } else {
        // Linux veya başka bir OS seçildiyse sadece Linux panellerini etkinleştir
        linuxPanels.forEach(function(panel) {
            let panelElement = document.getElementById(panel);
            if (panelElement) {
                panelElement.disabled = false;
            }
        });
    }
}

document.addEventListener("DOMContentLoaded", function() {
    const radios = document.querySelectorAll('.form-check-input');

    // Sayfa yüklendiğinde otomatik olarak seçili olanları kontrol et
    radios.forEach(radio => {
        if (radio.checked) {
            radio.parentElement.classList.add('selected');
            toggleControlPanels();  // Sayfa yüklendiğinde mevcut durumu kontrol etmek için ekledik
        }
    });

    // Her radio butonuna değişiklik olayı ekle
    radios.forEach(radio => {
        radio.addEventListener('change', function() {
            // Önce tüm radio-card'lardan 'selected' sınıfını kaldır
            radios.forEach(r => {
                r.parentElement.classList.remove('selected');
            });

            // Eğer seçilen radio işaretlenmişse, parent olan radio-card'a 'selected' sınıfı ekle
            if (this.checked) {
                this.parentElement.classList.add('selected');
                toggleControlPanels();  // İşletim sistemi değişikliğinde kontrol panellerini güncelle
            }
        });
    });
});

</script>
<section class="banner bg-dark premium-network">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-xxl-12 col-xl-8">
        <div class="text-center">
          <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            Server Kurulum
          </h1>
          <p class="text-white mb-0 max-text-60 mx-auto text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            Sunucu ayarlarını yapmaya hazır mısınız!
          </p>
        </div>
      </div>
    </div>
  </div>
</section>
<?php
function slugify($string) {
    // Türkçe karakterleri İngilizce karakterlere dönüştür
    $turkish = ['ı', 'ğ', 'ü', 'ş', 'ö', 'ç', 'İ', 'Ğ', 'Ü', 'Ş', 'Ö', 'Ç'];
    $english = ['i', 'g', 'u', 's', 'o', 'c', 'I', 'G', 'U', 'S', 'O', 'C'];
    $string = str_replace($turkish, $english, $string);

    // Boşlukları tire ile değiştir ve fazladan olanları temizle
    $string = preg_replace('/[^A-Za-z0-9]+/', '-', $string);

    // Başta ve sonda kalan tireleri temizle
    $string = trim($string, '-');

    // Küçük harfe çevir
    return strtolower($string);
}
 ?>
<div class="container my-5">
    <div class="row">
        <div class="col-md-8">
            <h6 class="mt-4">İşletim Sistemi</h6>
            <div class="row hizmetalani">
                <?php
                $osfirst = true;
                foreach($urun['configoptions']['configoption'][3]['options']['option'] as $os) {
                    $originalName = $os['name'];
                    $osType = '';
                    if (strpos($originalName, 'linuxOS') !== false) {
                        $osType = 'Linux';
                        $osName = str_replace('linuxOS ', '', $originalName);
                    } elseif (strpos($originalName, 'winOS') !== false) {
                        $osType = 'Windows';
                        $osName = str_replace('winOS ', '', $originalName);
                    } elseif (strpos($originalName, 'ubuntuOS') !== false) {
                        $osType = 'Ubuntu';
                        $osName = str_replace('ubuntuOS ', '', $originalName);
                    } else {
                        $osName = $originalName; // Eğer tanımsız bir OS varsa, olduğu gibi kullan.
                    } ?>
                    <label class="radio-card" for="<?php echo slugify($osName); ?>">
                        <input class="form-check-input"
                               type="radio"
                               name="os"
                               id="<?php echo slugify($osName); ?>"
                               <?php if ($osfirst) { echo 'checked'; $osfirst = false; } ?>
                               typeos="<?php echo $osType; ?>"
                               pid="<?php echo $os['id']; ?>"
                               onclick="updateSelection('os', '<?php echo $os['pricing']['TRY']['monthly']; ?>', '<?php echo $os['pricing']['USD']['monthly']; ?>', '<?php echo $osName; ?>', '<?php echo $os['id']; ?>')">
                        <span><?php echo $osName; ?> - <usd><?php echo $os['pricing']['USD']['monthly']; ?></usd><try><?php echo $os['pricing']['TRY']['monthly']; ?></try></span>
                    </label>
                <?php } ?>
            </div>

            <h6 class="mt-4">Kontrol Paneli Seçin</h6>
            <div class="row hizmetalani">
            		<?php $panelfirst = true; foreach($urun['configoptions']['configoption'][0]['options']['option'] as $panel) { ?>
            				<label class="radio-card" for="<?php echo slugify($panel['name']); ?>">
            						<input class="form-check-input" pid="<?php echo $panel['id']; ?>" type="radio" name="panel" id="<?php echo slugify($panel['name']); ?>" <?php if ($panelfirst) { echo 'checked'; $panelfirst = false; } ?>  onclick="updateSelection('controlPanel', '<?php echo $panel['pricing']['TRY']['monthly']; ?>', '<?php echo $panel['pricing']['USD']['monthly']; ?>', '<?php echo $panel['name']; ?>', '<?php echo $panel['id']; ?>')">
            						<span><?php echo $panel['name']; ?> -  <usd><?php echo $panel['pricing']['USD']['monthly']; ?></usd><try><?php echo $panel['pricing']['TRY']['monthly']; ?></try></span>
            				</label>
            		<?php } ?>
            </div>
            <!-- IP Adresi -->
            <h6 class="mt-4">Ek IP Adresi</h6>
            <div class="row hizmetalani">
                <?php $ipfirst = true; foreach($urun['configoptions']['configoption'][2]['options']['option'] as $ip) { ?>
                    <label class="radio-card" for="<?php echo slugify($ip['name']); ?>">
                        <input class="form-check-input"  pid="<?php echo $ip['id']; ?>" type="radio" name="ekip" id="<?php echo slugify($ip['name']); ?>" <?php if ($ipfirst) { echo 'checked'; $ipfirst = false; } ?>  onclick="updateSelection('ipAddress', '<?php echo $ip['pricing']['TRY']['monthly']; ?>', '<?php echo $ip['pricing']['USD']['monthly']; ?>', '<?php echo $ip['name']; ?>', '<?php echo $ip['id']; ?>')">
                        <span><?php echo $ip['name']; ?> -  <usd><?php echo $ip['pricing']['USD']['monthly']; ?></usd><try><?php echo $ip['pricing']['TRY']['monthly']; ?></try></span>
                    </label>
                <?php } ?>
            </div>



            <!-- Backup Hizmeti -->
            <h6 class="mt-4">Backup Hizmeti</h6>
            <div class="row hizmetalani">
                <?php $first = true; foreach($urun['configoptions']['configoption'][1]['options']['option'] as $backup) { ?>
                    <label class="radio-card" for="<?php echo slugify($backup['name']); ?>">
                        <input class="form-check-input" pid="<?php echo $backup['id']; ?>" type="radio" name="backup" id="<?php echo slugify($backup['name']); ?>" <?php if ($first) { echo 'checked'; $first = false; } ?>  onclick="updateSelection('backupService', '<?php echo $backup['pricing']['TRY']['monthly']; ?>', '<?php echo $backup['pricing']['USD']['monthly']; ?>', '<?php echo $backup['name']; ?>', '<?php echo $backup['id']; ?>')">
                        <span><?php echo $backup['name']; ?> -  <usd><?php echo $backup['pricing']['USD']['monthly']; ?></usd><try><?php echo $backup['pricing']['TRY']['monthly']; ?></try></span>
                    </label>
                <?php } ?>
            </div>
        </div>

        <!-- Kurulum Özeti -->
        <div class="col-md-4">
            <form id="orderForm">
                <div class="config-summary">
                    <h5 class="summary-heading">Kurulum Özeti</h5>
                    <div class="summary-content">
                        <p><strong>Ürün Adı:</strong> <span><?php echo $urun['name']; ?></span></p>
                        <p><strong>İşletim Sistemi:</strong> <span id="osSelection">AlmaLinux 8</span></p>
                        <p><strong>Kontrol Paneli:</strong> <span id="controlPanelSelection">Kontrol Paneli İstemiyorum</span></p>
                        <p><strong>IP Adresi:</strong> <span id="ipAddressSelection">IP Adresi İstemiyorum</span></p>
                        <p><strong>Backup Hizmeti:</strong> <span id="backupServiceSelection">Backup Hizmeti İstemiyorum</span></p>
                    </div>

                    <div class="summary-content">
                        <p><strong>Ödeme Şekli:</strong> Aylık</p>
                    </div>

                    <div class="summary-content">
                        <try><p class="total-price" id="totalPricetry">₺<?php echo $basePricetry; ?></p></try>
                        <usd><p class="total-price" id="totalPriceusd">$<?php echo $basePrice; ?></p></usd>
                    </div>
                    <?php
                     function random_string($length = 6) {
                       $characters = 'abcdefghijklmnopqrstuvwxyz';
                       $characters_length = strlen($characters);
                       $random_string = '';
                       for ($i = 0; $i < $length; $i++) {
                         $random_string .= $characters[rand(0, $characters_length - 1)];
                       }
                       return $random_string;
                     }
                     ?>
                    <input type="text" name="hostname" id="hostname" class="form-control" style="margin-bottom:10px;" value="<?php echo "server." . random_string(6) . ".ssplus"; ?>" placeholder="Hostname">
                    <input type="hidden" name="productId" value="<?php echo $urun['pid']; ?>">
                    <input type="hidden" name="os" id="osInput" value="15">
                    <input type="hidden" name="controlPanel" id="controlPanelInput" value="1">
                    <input type="hidden" name="ipAddress" id="ipAddressInput" value="9">
                    <input type="hidden" name="backupService" id="backupServiceInput" value="4">
                    <button type="submit" class="submit-btn" id="submitOrder">Siparişi Ver</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
       const decreaseBtn = document.getElementById('decrease');
       const increaseBtn = document.getElementById('increase');
       const numberInput = document.getElementById('number-input');

       decreaseBtn.addEventListener('click', function () {
           let currentValue = parseInt(numberInput.value);
           if (currentValue > 0) {
               numberInput.value = currentValue - 1;
           }
       });

       increaseBtn.addEventListener('click', function () {
           let currentValue = parseInt(numberInput.value);
           numberInput.value = currentValue + 1;
       });
   </script>
<?php
    } else {
        ?>
        <section class="banner bg-dark premium-network">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-xxl-12 col-xl-8">
                <div class="text-center">
                  <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                    Server Kurulum
                  </h1>
                  <p class="text-white mb-0 max-text-60 mx-auto text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                    Lütfen önce ürün seçimi yapınız!
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>
        <?php
    }
}else {
  ?>
  <section class="banner bg-dark premium-network">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xxl-12 col-xl-8">
          <div class="text-center">
            <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
              Server Kurulum
            </h1>
            <p class="text-white mb-0 max-text-60 mx-auto text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
              Lütfen önce ürün seçimi yapınız!
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php
}
?>
<script type="text/javascript">
document.getElementById('orderForm').addEventListener('submit', function(event) {
    event.preventDefault(); // Formun varsayılan submit davranışını engelle

    const submitButton = document.getElementById('submitOrder');

    // Butonu tıkladıktan sonra "Lütfen Bekleyiniz" mesajını göster
    submitButton.disabled = true; // Butonun tekrar tıklanmasını engelle
    submitButton.innerHTML = '<span class="fa-solid fa-shopping-basket"></span> Lütfen Bekleyiniz!';

    // Form verilerini al
    const productId = document.querySelector('input[name="productId"]').value;
    const os = document.getElementById('osInput').value;
    const hostname = document.getElementById('hostname').value;
    const controlPanel = document.getElementById('controlPanelInput').value;
    const ipAddress = document.getElementById('ipAddressInput').value;
    const backupService = document.getElementById('backupServiceInput').value;

    // Ürün nesnesi oluştur
    const product = {
        productId: productId,
        domain: hostname,
        action: "cloudserver",
        itemName: "Cloud Server",
        type: "cloudserver",
        price: 0,
        pers: [
            { os: os },
            { controlPanel: controlPanel },
            { ipAddress: ipAddress },
            { backupService: backupService },
        ]
    };

    // Sepete ekleme işlemi
    addToCart(product);

    // Sepeti sunucuya gönderme işlemi
    sendCartToServer(product, submitButton);
});

// Sepete ürün ekle
function addToCart(product) {
    let cart = JSON.parse(localStorage.getItem('cart')) || [];
    cart.push(product);
    localStorage.setItem('cart', JSON.stringify(cart));
    console.log('Ürün sepete eklendi:', product);
}

// Sepeti sunucuya gönderme fonksiyonu
function sendCartToServer(product, submitButton) {
    fetch('/require/pages/add-to-cart.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify([product]) // Sepet verisini JSON formatında gönderiyoruz
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'success') {
            console.log('Sepet sunucuya başarıyla kaydedildi:', data.cart);
            window.location.href = './sepet'; // Ödeme sayfasına yönlendirme
        } else {
            console.error('Sepet kaydedilemedi:', data.message);
            submitButton.innerHTML = 'Hata oluştu. Tekrar deneyiniz.'; // Hata durumunda mesaj
            submitButton.disabled = false; // Tekrar tıklanabilir hale getir
        }
    })
    .catch(error => {
        console.error('Sunucuya gönderim sırasında bir hata oluştu:', error);
        submitButton.innerHTML = 'Hata oluştu. Tekrar deneyiniz.'; // Hata durumunda mesaj
        submitButton.disabled = false; // Tekrar tıklanabilir hale getir
    });
}

// Rastgele UUID üretmek için basit bir fonksiyon
function generateUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}

</script>
