<?php
include 'pages/inc/plans.php';
// JSON dosyasının yolu
$json_file_path = 'whmcs_data.json';

// JSON dosyasını yükle ve array'e çevir
if (file_exists($json_file_path)) {
    $json_data = file_get_contents($json_file_path);
    $whmcs_data = json_decode($json_data, true);
} else {
    die('Hata: JSON dosyası bulunamadı.');
}

// WHMCS sınıfı
class WHMCS {
    private $whmcs_data;

    public function __construct($whmcs_data) {
        $this->whmcs_data = $whmcs_data;
    }

    // GetProducts fonksiyonu
    public function GetProducts($product_id) {
        // JSON dosyasındaki ürünleri kontrol et
        if (isset($this->whmcs_data['products']) && isset($this->whmcs_data['products']['products']['product'])) {
            foreach ($this->whmcs_data['products']['products']['product'] as $product) {
                if ($product['pid'] == $product_id) {
                    return $product; // Ürünü döndür
                }
            }
        }
        return 'Hata: Ürün bulunamadı.'; // Ürün bulunamazsa hata döndür
    }

    // GetTLDPricing fonksiyonu
    public function GetTLDPricing($domain_extension) {
        // JSON dosyasındaki TLD fiyatlarını kontrol et
        if (isset($this->whmcs_data['tldPricing']) && isset($this->whmcs_data['tldPricing']['pricing'])) {
            if (isset($this->whmcs_data['tldPricing']['pricing'][$domain_extension])) {
                return $this->whmcs_data['tldPricing']['pricing'][$domain_extension]; // Domain fiyatını döndür
            } else {
                return 'Hata: ' . $domain_extension . ' uzantısı için fiyat bulunamadı.';
            }
        }
        return 'Hata: TLD fiyatları bulunamadı.'; // Fiyatlar bulunamazsa hata döndür
    }

    public function GetTLDList() {
        $prices = []; // Fiyatları tutacak dizi

        // JSON verisini kontrol et
        if (isset($this->whmcs_data['tldPricing']) &&
            isset($this->whmcs_data['tldPricing']['pricing']) &&
            is_array($this->whmcs_data['tldPricing']['pricing'])) {

            foreach ($this->whmcs_data['tldPricing']['pricing'] as $extension => $price) {
                // Her bir TLD'nin fiyatlarını düzenliyoruz
                $prices[$extension] = [
                    'categories' => $price['categories'] ?? [],
                    'register' => isset($price['register']) ? array_map('floatval', $price['register']) : [],
                    'renew' => isset($price['renew']) ? array_map('floatval', $price['renew']) : [],
                    'transfer' => isset($price['transfer'][1]) ? floatval($price['transfer'][1]) : null,
                    'addons' => $price['addons'] ?? [],
                    'group' => $price['group'] ?? null,
                ];
            }
        } else {
            return 'Hata: TLD fiyatları bulunamadı.'; // Fiyatlar bulunamazsa hata döndür
        }

        return $prices; // Fiyatları döndür
    }



    // GetCurrencies fonksiyonu
    public function GetCurrencies($currency_code) {
        // JSON dosyasındaki para birimlerini kontrol et
        if (isset($this->whmcs_data['currencies']) && isset($this->whmcs_data['currencies']['currencies']['currency'])) {
            foreach ($this->whmcs_data['currencies']['currencies']['currency'] as $currency) {
                if ($currency['code'] == $currency_code) {
                    // Rate değerini 33,99 gibi bir formatta ayarla
                    return number_format($currency['rate'], 2, '.', '');
                }
            }
        }
        return 'Hata: ' . $currency_code . ' para birimi bulunamadı.'; // Para birimi bulunamazsa hata döndür
    }

    public function ProGet($gid) {
    $products_in_group = [];

    // JSON dosyasındaki ürünleri kontrol et
    if (isset($this->whmcs_data['products']) && isset($this->whmcs_data['products']['products']['product'])) {
        foreach ($this->whmcs_data['products']['products']['product'] as $product) {
            if ($product['gid'] == $gid) {
                $products_in_group[] = $product; // Ürünü gruba ekle
            }
        }

        if (!empty($products_in_group)) {
            return $products_in_group; // Kategori içindeki ürünleri döndür
        } else {
            return 'Hata: Bu kategoriye ait ürün bulunamadı.'; // Kategoriye ait ürün bulunamazsa hata döndür
        }
    }

    return 'Hata: Ürünler bulunamadı.'; // Ürünler bulunamazsa hata döndür
}
}

// WHMCS nesnesini oluştur
$whmcs = new WHMCS($whmcs_data);

$adres = "Mevlana Mah. Issıkgöl Cad. No:99 K:5 D:74 Gökdemir Plaza Gebze\Kocaeli";
?>
