<?php $pageTitle = 'Doğrulama Kodu'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="icon" href="https://sspanel.serversistemleri.com/favicon.ico" />

    <title>{{ $pageTitle }} - Server Sistemleri</title>

    <style>
           [x-cloak=""],
           [x-cloak="x-cloak"],
           [x-cloak="1"] {
               display: none !important;
           }

           @media (max-width: 1023px) {
               [x-cloak="-lg"] {
                   display: none !important;
               }
           }

           @media (min-width: 1024px) {
               [x-cloak="lg"] {
                   display: none !important;
               }
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
       <style>
           :root {
               --danger-50: 254, 242, 242;
               --danger-100: 254, 226, 226;
               --danger-200: 254, 202, 202;
               --danger-300: 252, 165, 165;
               --danger-400: 248, 113, 113;
               --danger-500: 239, 68, 68;
               --danger-600: 220, 38, 38;
               --danger-700: 185, 28, 28;
               --danger-800: 153, 27, 27;
               --danger-900: 127, 29, 29;
               --danger-950: 69, 10, 10;
               --gray-50: 250, 250, 250;
               --gray-100: 244, 244, 245;
               --gray-200: 228, 228, 231;
               --gray-300: 212, 212, 216;
               --gray-400: 161, 161, 170;
               --gray-500: 113, 113, 122;
               --gray-600: 82, 82, 91;
               --gray-700: 63, 63, 70;
               --gray-800: 39, 39, 42;
               --gray-900: 24, 24, 27;
               --gray-950: 9, 9, 11;
               --info-50: 239, 246, 255;
               --info-100: 219, 234, 254;
               --info-200: 191, 219, 254;
               --info-300: 147, 197, 253;
               --info-400: 96, 165, 250;
               --info-500: 59, 130, 246;
               --info-600: 37, 99, 235;
               --info-700: 29, 78, 216;
               --info-800: 30, 64, 175;
               --info-900: 30, 58, 138;
               --info-950: 23, 37, 84;
               --primary-50: 244, 250, 252;
               --primary-100: 232, 244, 249;
               --primary-200: 198, 228, 241;
               --primary-300: 164, 211, 232;
               --primary-400: 96, 179, 215;
               --primary-500: 28, 146, 198;
               --primary-600: 25, 131, 178;
               --primary-700: 21, 110, 149;
               --primary-800: 17, 88, 119;
               --primary-900: 14, 72, 97;
               --primary-950: 8, 44, 59;
               --success-50: 240, 253, 244;
               --success-100: 220, 252, 231;
               --success-200: 187, 247, 208;
               --success-300: 134, 239, 172;
               --success-400: 74, 222, 128;
               --success-500: 34, 197, 94;
               --success-600: 22, 163, 74;
               --success-700: 21, 128, 61;
               --success-800: 22, 101, 52;
               --success-900: 20, 83, 45;
               --success-950: 5, 46, 22;
               --warning-50: 255, 251, 235;
               --warning-100: 254, 243, 199;
               --warning-200: 253, 230, 138;
               --warning-300: 252, 211, 77;
               --warning-400: 251, 191, 36;
               --warning-500: 245, 158, 11;
               --warning-600: 217, 119, 6;
               --warning-700: 180, 83, 9;
               --warning-800: 146, 64, 14;
               --warning-900: 120, 53, 15;
               --warning-950: 69, 26, 3;
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

       <link rel="preconnect" href="https://fonts.bunny.net" />
       <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

       <style>
           :root {
               --font-family: "Inter";
               --sidebar-width: 20rem;
               --collapsed-sidebar-width: 4.5rem;
               --default-theme-mode: light;
           }
       </style>


       <!-- Livewire Styles -->
       <style>
           [wire\:loading][wire\:loading],
           [wire\:loading\.delay][wire\:loading\.delay],
           [wire\:loading\.inline-block][wire\:loading\.inline-block],
           [wire\:loading\.inline][wire\:loading\.inline],
           [wire\:loading\.block][wire\:loading\.block],
           [wire\:loading\.flex][wire\:loading\.flex],
           [wire\:loading\.table][wire\:loading\.table],
           [wire\:loading\.grid][wire\:loading\.grid],
           [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
               display: none;
           }
           [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
           [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
           [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
           [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
           [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
           [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
           [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
           [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
               display: none;
           }
           [wire\:offline][wire\:offline] {
               display: none;
           }
           [wire\:dirty]:not(textarea):not(input):not(select) {
               display: none;
           }
           :root {
               --livewire-progress-bar-color: #2299dd;
           }
           [x-cloak] {
               display: none !important;
           }
           .otp-display {
               display: flex;
               gap: 10px;
               justify-content: center;
               margin-bottom: 1rem;
           }

           .otp-digit {
               width: 15.6%;
               height: 50px;
               font-size: 24px;
               text-align: center;
               border: 2px solid #e5e7eb;
               border-radius: 8px;
               background: white;
               display: flex;
               align-items: center;
               justify-content: center;
               transition: all 0.2s;
               color: #1f2937;
           }

           .dark .otp-digit {
               background: rgba(255, 255, 255, 0.05);
               border-color: rgba(255, 255, 255, 0.2);
               color: white;
           }

           .otp-digit.filled {
               border-color: #1c92c6;
               background: #f0f9ff;
           }

           .dark .otp-digit.filled {
               border-color: #1c92c6;
               background: rgba(28, 146, 198, 0.1);
           }

           .otp-digit.active {
               border-color: #1c92c6;
               box-shadow: 0 0 0 3px rgba(28, 146, 198, 0.1);
           }

           @media only screen and (max-width: 600px) {
               .otp-digit {
                   width: 15.5%;
                   height: 45px;
                   font-size: 20px;
               }
           }

       </style>
   </head>
<body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
    <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
        <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
                <section class="grid auto-cols-fr gap-y-6">
                    <header class="fi-simple-header flex flex-col items-center">
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo mb-4" style="width: 250px;" />
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo mb-4" style="width: 250px;" />
                        <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                            SMS Doğrulama
                        </h1>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-2 text-center">
                            Telefonunuza gönderilen 6 haneli kodu girin
                        </p>
                    </header>

                    <form id="form" class="fi-form grid gap-y-6">
                        @csrf
                        <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center justify-between gap-x-3">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="code">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Doğrulama Kodu
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>

                                        <!-- OTP Display -->
                                        <div class="otp-display" id="otp-display">
                                            <div class="otp-digit active" data-index="0">-</div>
                                            <div class="otp-digit" data-index="1">-</div>
                                            <div class="otp-digit" data-index="2">-</div>
                                            <div class="otp-digit" data-index="3">-</div>
                                            <div class="otp-digit" data-index="4">-</div>
                                            <div class="otp-digit" data-index="5">-</div>
                                        </div>

                                        <!-- Hidden Input -->
                                        <input
                                            type="text"
                                            id="code"
                                            name="code"
                                            inputmode="numeric"
                                            pattern="[0-9]*"
                                            maxlength="6"
                                            autocomplete="one-time-code"
                                            required
                                            style="position:absolute; opacity:0; width:1px; height:1px;"
                                            aria-label="Doğrulama kodu" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="fi-form-actions">
                            <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                                <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" type="submit" id="submit-button">
                                    <span class="fi-btn-label">Kodu Doğrula</span>
                                </button>
                            </div>

                            <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]" style="margin-top:10px;">
                                <button id="resendSmsBtn" disabled type="button" name="button" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                    <span class="fi-btn-label">Kodu tekrar gönder (60)</span>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div id="error-message" style="display: none;margin-bottom: -10px;">
                    <div class="flex items-center p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                    <svg style="margin-right: 5px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                    </svg>
                    <span class="sr-only">Info</span>
                    <div>
                    <span class="font-medium">Hata!</span> Doğrulama kodu hatalı. Lütfen tekrar deneyin!
                    </div>
                    </div>
                    </div>
                </section>
            </div>
        </main>
    </div>
</div>
<meta name="csrf-token" content="{{ csrf_token() }}">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        (function() {
            'use strict';

            const codeInput = document.getElementById('code');
            const otpDisplay = document.getElementById('otp-display');
            const digits = otpDisplay.querySelectorAll('.otp-digit');
            const submitButton = document.getElementById('submit-button');

            // Update display digits
            function updateDisplay(value) {
                const chars = value.split('');
                digits.forEach((digit, index) => {
                    if (chars[index]) {
                        digit.textContent = chars[index];
                        digit.classList.add('filled');
                    } else {
                        digit.textContent = '-';
                        digit.classList.remove('filled');
                    }
                    digit.classList.remove('active');
                });

                // Set active on next empty digit
                const nextIndex = chars.length < 6 ? chars.length : 5;
                digits[nextIndex].classList.add('active');

                // Auto-submit when 6 digits entered
                if (value.length === 6) {
                    setTimeout(() => {
                        submitButton.click();
                    }, 300);
                }
            }

            // Listen for input changes
            codeInput.addEventListener('input', (e) => {
                let value = e.target.value.replace(/\D/g, '').slice(0, 6);
                e.target.value = value;
                updateDisplay(value);
            });

            // Click on digit to focus input
            digits.forEach((digit, index) => {
                digit.addEventListener('click', () => {
                    codeInput.focus();
                    codeInput.click();
                });
            });

            // WebOTP API - Auto-read SMS
            // WebOTP API - Auto-read SMS (user-gesture şart!)
            function startWebOTP() {
              if (!('OTPCredential' in window) || !navigator.credentials) return;

              const ac = new AbortController();
              // 60 saniye dinlesin
              const timer = setTimeout(() => ac.abort(), 60000);

              navigator.credentials.get({
                otp: { transport: ['sms'] },
                signal: ac.signal
              }).then(otp => {
                clearTimeout(timer);
                if (otp && otp.code) {
                  // Sadece rakamları al ve 6 haneye kes
                  const code = (otp.code || '').replace(/\D/g, '').slice(0, 6);
                  codeInput.value = code;
                  updateDisplay(code);
                }
              }).catch(() => {
                // süre doldu/iptal/izin yok -> sessiz geç
              });
            }

            // İlk kullanıcı etkileşiminde tetikle (bir kez)
            document.addEventListener('click', startWebOTP, { once: true });
            document.addEventListener('focusin', startWebOTP, { once: true });

            // Focus input on page load
            setTimeout(() => {
                codeInput.focus();
            }, 300);

            $(document).ready(function () {
                let countdown = 60; // Başlangıçta 60 saniye geri sayım
                let button = $('#resendSmsBtn');

                // Geri sayım başlatma fonksiyonu
                function startCountdown() {
                    button.prop('disabled', true); // Butonu devre dışı bırak
                    let interval = setInterval(function () {
                        countdown--;
                        button.text(`Kodu tekrar gönder (${countdown})`);

                        if (countdown <= 0) {
                            clearInterval(interval);
                            button.text("Kodu tekrar gönder");
                            button.prop('disabled', false); // Süre bitince butonu aktif et
                        }
                    }, 1000);
                }

                // Sayfa açılınca geri sayımı başlat
                startCountdown();

                // Butona tıklanınca SMS gönderme isteği
                button.click(function () {
                    $.ajax({
                        url: "{{ route('resend.verification') }}",
                        type: "POST",
                        data: {},
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (response) {
                            $('#message').text(response.message);
                            if (response.success) {
                                countdown = 60; // Geri sayımı sıfırla
                                startCountdown(); // Yeni geri sayımı başlat
                            }
                        },
                        error: function () {
                            $('#message').text("Bir hata oluştu, lütfen tekrar deneyin.");
                        }
                    });
                });
            });

            // Form submit handler
            $('#form').on('submit', function(e) {
                e.preventDefault();
                var submitButton = $('#submit-button');
                var originalText = submitButton.find('.fi-btn-label').text();

                submitButton.prop('disabled', true);
                submitButton.find('.fi-btn-label').text('Lütfen bekleyin...');

                var formData = $(this).serialize();

                $.ajax({
                    url: '{{ route('verify') }}',
                    type: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            window.location.href = response.redirect;
                        } else {
                            $('#error-message').show();
                            submitButton.prop('disabled', false);
                            submitButton.find('.fi-btn-label').text(originalText);
                        }
                    },
                    error: function() {
                        $('#error-message').show();
                        submitButton.prop('disabled', false);
                        submitButton.find('.fi-btn-label').text(originalText);
                    }
                });
            });
        })();
        </script>


<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>
</body>
</html>
