<?php

namespace App\Http\EFatura;

use Illuminate\Support\Facades\Session;

class Client
{
    private $session_id = null;
    private $hata;

    public function __construct($service_url)
    {
        Util::$service_url = $service_url;
    }

    public function getHata()
    {
        return $this->hata;
    }

    public function setHata($hataKod, $hataMesaj)
    {
        $this->hata = array(
            "KOD" => $hataKod,
            "MESAJ" => $hataMesaj
        );
    }

    public function getSessionId()
    {
        return (is_null($this->session_id) ? Session::get("EFATURA_SESSION") : $this->session_id);
    }

    public function setSessionId($session_id)
    {
        Session::put("EFATURA_SESSION", $session_id);
        $this->session_id = $session_id;
    }

    public function login($username, $password)
    {
        $header = new RequestHeader();
        $header->session_id = "-1";
        $param = $header->getArray();
        $param["USER_NAME"] = $username;
        $param["PASSWORD"] = $password;
        $request = new Request();
        $session = $request->send("Login", $param);

        if ($session && !empty($session->SESSION_ID)) {
            $this->setSessionId($session->SESSION_ID);
            return true;
        } else {
            $this->setHata($request->hataKod, $request->hataMesaj);
            return false;
        }
    }

    public function getSingleInvoice($faturaNo = null, $faturaUUID = null, $gelen = false, $contentType = "PDF")
    {
        if (is_null($faturaNo) && is_null($faturaUUID)) {
            return false;
        } else {
            $req_header = new RequestHeader();
            $req_header->session_id = $this->getSessionId();
            $send_data = $req_header->getArray();

            $send_data["INVOICE_CONTENT_TYPE"] = $contentType;
            $send_data["HEADER_ONLY"] = "N";
            $send_data["INVOICE_SEARCH_KEY"]["LIMIT"] = 1;
            $send_data["INVOICE_SEARCH_KEY"]["LIMITSpecified"] = true;

            $send_data["INVOICE_SEARCH_KEY"]["DIRECTION"] = ($gelen ? "IN" : "OUT");
            $send_data["INVOICE_SEARCH_KEY"]["ID"] = $faturaNo;

            $req = new Request();
            $sonuc = $req->send("GetInvoice", $send_data);
            $this->setHata($req->hataKod, $req->hataMesaj);

            if (!isset($sonuc->INVOICE)) {
                return [
                    "error" => "Fatura bilgisi alınamadı",
                    "details" => $this->getHata()
                ];
            }

            $invoice = $sonuc->INVOICE;

            return array(
                "CONTENT" => $invoice->CONTENT->_ ?? null,
                "SENDER" => $invoice->HEADER->SENDER ?? null,
                "RECEIVER" => $invoice->HEADER->RECEIVER ?? null,
                "SUPPLIER" => $invoice->HEADER->SUPPLIER ?? null,
                "CUSTOMER" => $invoice->HEADER->CUSTOMER ?? null,
                "ISSUE_DATE" => $invoice->HEADER->ISSUE_DATE ?? null,
                "PAYABLE_AMOUNT" => isset($invoice->HEADER->PAYABLE_AMOUNT) ? $invoice->HEADER->PAYABLE_AMOUNT->_ . " " . $invoice->HEADER->PAYABLE_AMOUNT->currencyID : null,
                "PARABIRIMI" => $invoice->HEADER->PAYABLE_AMOUNT->currencyID ?? null,
                "FROM" => $invoice->HEADER->FROM ?? null,
                "TO" => $invoice->HEADER->TO ?? null,
                "PROFILEID" => $invoice->HEADER->PROFILEID ?? null,
                "STATUS" => $invoice->HEADER->STATUS ?? null,
                "STATUS_DESCRIPTION" => $invoice->HEADER->STATUS_DESCRIPTION ?? null,
                "ACIKLAMA" => Util::invoiceStatus($invoice->HEADER->STATUS ?? null),
                "GIB_STATUS_CODE" => $invoice->HEADER->GIB_STATUS_CODE ?? null,
                "GIB_STATUS_DESCRIPTION" => $invoice->HEADER->GIB_STATUS_DESCRIPTION ?? null,
                "RESPONSE_CODE" => $invoice->HEADER->RESPONSE_CODE ?? null,
                "RESPONSE_DESCRIPTION" => $invoice->HEADER->RESPONSE_DESCRIPTION ?? null,
                "FILENAME" => $invoice->HEADER->FILENAME ?? null,
                "HASH" => $invoice->HEADER->HASH ?? null,
                "CDATE" => $invoice->HEADER->CDATE ?? null,
                "ENVELOPE_IDENTIFIER" => $invoice->HEADER->ENVELOPE_IDENTIFIER ?? null,
                "INTERNETSALES" => $invoice->HEADER->INTERNETSALES ?? null,
                "EARCHIVE" => $invoice->HEADER->EARCHIVE ?? null,
                "TRXID" => $invoice->TRXID ?? null,
                "UUID" => $invoice->UUID ?? null,
                "ID" => $invoice->ID ?? null
            );
        }
    }

}
