<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Services\WhmcsService; // Bu satırı eklediğinizi varsayıyorum

class PleskController extends Controller
{
    protected $whmcsService;

    public function __construct(WhmcsService $whmcsService)
    {
        $this->whmcsService = $whmcsService;
    }

    public function login(Request $request)
    {
        $app = $request->input('app');
        $serverId = $request->input('serverid');
        $login_username = $request->input('username');

        try {
            $servername = DB::connection('whmcs')->table('tblservers')
                ->where('id', $serverId)
                ->value('hostname');
            $admin_username = DB::connection('whmcs')->table('tblservers')
                ->where('id', $serverId)
                ->value('username');
            $admin_password_encrypted = DB::connection('whmcs')->table('tblservers')
                ->where('id', $serverId)
                ->value('password');
        } catch (\Exception $e) {
            Log::error('Veri tabanı hatası: ' . $e->getMessage());
            die('Access hash bilgisi alınamadı.');
        }

        $plesk_url = "https://$servername:8443/enterprise/control/agent.php";
        $login_url = "https://$servername:8443/enterprise/rsession_init.php";

        $user_ip = base64_encode($_SERVER['REMOTE_ADDR']);
        $response = $this->whmcsService->getDecryptedPassword($admin_password_encrypted);

        if ($response['result'] !== 'success') {
            Log::error("Şifre çözme işlemi başarısız: " . $response['message']);
            die('Şifre çözme işlemi başarısız.');
        }

        $decryptedPassword = $response['password'];

        $request_xml = '<?xml version="1.0" encoding="UTF-8"?>
        <packet version="1.6.9.1">
            <server>
                <create_session>
                    <login>' . $login_username . '</login>
                    <data>
                        <user_ip>' . $user_ip . '</user_ip>
                        <source_server></source_server>
                    </data>
                </create_session>
            </server>
        </packet>';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $plesk_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request_xml);

        $headers = [
            'Content-Type: text/xml',
            'HTTP_AUTH_LOGIN: ' . $admin_username,
            'HTTP_AUTH_PASSWD: ' . $decryptedPassword,
            'HTTP_PRETTY_PRINT: TRUE',
            'Content-Length: ' . strlen($request_xml)
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // SSL doğrulamasını kapat (güvenli olmayan bağlantılar için önerilmez)
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        // İsteği gönder ve cevabı al
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'cURL Hatası: ' . curl_error($ch);
            exit;
        }
        curl_close($ch);

        // XML cevabını işle
        $xml_response = simplexml_load_string($response);
        if (isset($xml_response->server->create_session->result->id)) {
            $session_token = (string) $xml_response->server->create_session->result->id;

            // Otomatik giriş bağlantısı oluştur
            $login_url = "https://$servername:8443/enterprise/rsession_init.php?PLESKSESSID=" . $session_token;

            // Başarılı giriş sonrası yönlendirme URL'si (kullanıcı email listesine yönlendir)
            //$success_redirect_url = "/smb/email-address/list"; // Bu URL'yi gerekli sayfaya göre güncelleyin
            $success_redirect_url = $app;
            // Başarısız giriş sonrası yönlendirme URL'si (opsiyonel)
            $failure_redirect_url = "/login_failed";

            // Tam giriş URL'si
            $full_login_url = $login_url . "&success_redirect_url=" . urlencode($success_redirect_url) . "&failure_redirect_url=" . urlencode($failure_redirect_url);
            return redirect($full_login_url);
        } else {
            die('Giriş yapılamadı, lütfen bizimle ile iletişime geçin!');
        }
    }


}
