<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use GuzzleHttp\Promise;
use Illuminate\Http\Request;
use App\Services\WhmcsService;
use App\Services\TopluSmsService;
use App\Libraries\DomainNameAPI_PHPLibrary;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\DatabaseController;
use App\Services\VmwareClient;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\cPanelController;
use Symfony\Component\HttpFoundation\Cookie as SymfonyCookie;
class AuthController extends Controller
{
    protected $whmcs;
    protected $smsService;
    protected $db;

    public function __construct(WhmcsService $whmcs, TopluSmsService $smsService)
    {
        $this->whmcs = $whmcs;
        $this->smsService = $smsService;
        $this->db = new DatabaseController();
    }

    public function showLoginForm()
    {
        return view('auth.login');
    }

    public function login(Request $request)
{
    $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    $response = $this->whmcs->validateLogin($request->email, $request->password);

    if ($response['result'] === 'success') {
        $mailadress = $request->email;
        $clientDetails = $this->whmcs->getClientDetailsMail($mailadress);

        // IP ve hostname
        $user_ip = request()->ip();
        $hostname = gethostbyaddr($user_ip);
        $this->db->UserLoginController('tblusers', ['email' => $mailadress], ['last_hostname' => $hostname, 'last_ip' => $user_ip]);

        // Client ID belirleme
         $userAgent = $_SERVER['HTTP_USER_AGENT']; // Tarayıcı bilgisini al
         $browserName = strtok($userAgent, '/'); // "/" karakterinden önceki kısmı al

          if (isset($clientDetails['userid'])) {
            $clientId = $clientDetails['userid'];
          } else {
            $tblcontacts = $this->db->GetData('tblcontacts', ['email' => $mailadress]);
            $firstItem = $tblcontacts->first();
            if ($firstItem) {
              $clientId = $firstItem->userid;
            }
          }

        // Session kayıtları
        Session::put('client', $clientId);
        Session::put('client_firstname', $clientDetails['firstname']);
        Session::put('client_lastname', $clientDetails['lastname']);
        Session::put('client_phone', $clientDetails['phonenumber']);

        // Giriş logu
        $this->db->addLog('login_log', $clientId, "Kullanıcı başarılı giriş yaptı. IP: $user_ip, hostname: $hostname.");

        // "Beni hatırla" kontrolü
        if ($request->has('remember')) {
          $rememberToken = Str::random(60);
          if ($browserName === "SSMobil") {
            Cookie::queue('remember_client', $rememberToken, 60 * 24 * 365);
          }else {
            Cookie::queue('remember_client', $rememberToken, 60 * 24 * 30); // 30 gün süreli cookie (dakika cinsinden)
          }
              $this->db->InsertData('sspanel_token', [
                'user_id' => $clientId,
                'token' => $rememberToken,
                'user_agent' => $userAgent,
                'ip_address' => $user_ip,
                'created_at' => now()
              ]);
        }

        // Telefon kontrolü
        if (strlen($clientDetails['phonenumber']) === 10) {
            if (in_array($clientId, [416, 285, 428, 440, 99, 202])) {
                Session::put('verifystatus', 'true');
                return redirect()->route('dashboard');
            } else {
                $this->sendVerificationSms($clientDetails['phonenumber'], $clientId, $clientDetails['firstname'], $clientDetails['lastname']);
                return redirect()->route('verify');
            }
        } else {
            return redirect()->back()->withErrors(['email' => 'Telefon numarası hatalı!'])->withInput();
        }
    }

    return redirect()->back()->withErrors(['email' => 'Kullanıcı adı veya Şifre Hatalı!'])->withInput();
}

    public function sendResendVerification(Request $request)
        {

            $phone = Session::get('client_phone');
            $clientId = Session::get('client');
            if (!$phone) {
                Log::error('Hata: Telefon numarası session içinde bulunamadı.');
                return response()->json(['success' => false, 'message' => 'Telefon numarası bulunamadı.'], 400);
            }

            try {
                $this->sendVerificationSms($phone, $clientId);
                Log::info('SMS başarıyla gönderildi.');
                return response()->json(['success' => true, 'message' => 'Doğrulama kodu tekrar gönderildi.']);
            } catch (\Exception $e) {
                Log::error('SMS gönderme hatası: ' . $e->getMessage());
                return response()->json(['success' => false, 'message' => 'SMS gönderilirken hata oluştu.'], 500);
            }
        }


    public function sendVerificationSms($phoneNumber, $clientId)
    {
        $verificationCode = rand(100000, 999999);

        Session::put("verification_code_{$clientId}", $verificationCode);

        $message = "Sayın Müşterimiz,\nDoğrulama Kodunuz: " . $verificationCode . "\n\nTeşekkür Ederiz!";
        //$message = "Hesabınıza erişmek için $verificationCode kodunu kullanın. Bu kodu asla paylaşmayın.";
        $response = $this->smsService->sendSms($phoneNumber, $message);

        $this->db->addLog('verification_code', $clientId, $message);

        if (strpos($response, '<code>200</code>') !== false) {
            Session::put('verification_sent', true);
            return true;
        } else {
            Log::error('SMS gönderimi başarısız:', ['response' => $response]);
            return false;
        }
    }

    public function showVerificationForm()
    {
        $phoneNumber = Session::get('client_phone');

        if (!$phoneNumber) {
            return redirect()->route('login');
        }

        return view('auth.verify', compact('phoneNumber'));
    }


    public function verify(Request $request)
    {
        $request->validate([
            'code' => 'required|numeric',
        ]);

        $clientId = Session::get('client');
        $storedCode = Session::get("verification_code_{$clientId}");

        if ($storedCode && $storedCode == $request->code) {
            Session::forget("verification_code_{$clientId}");
            Session::forget('verification_sent');
            Session::put('verifystatus', 'true');

            $clientDetails = $this->whmcs->getClientDetails($clientId);

            // Eksik alanlar kontrolü
            if (empty($clientDetails['postcode']) || empty($clientDetails['city']) || empty($clientDetails['state']) || empty($clientDetails['address1'])) {
                return response()->json(['success' => true, 'redirect' => route('profile'), 'message' => 'true']);
                $this->db->addLog('verification_status', $clientId, "Kullanıcı Doğrulama kodunu başarılı bir şekilde doğruladı ve profilinde eksik veri olduğu için profiline otomatik giriş yaptı..");
            }
            $sepet_get = Session::get('cart_data');
            if (!empty($sepet_get)) {
                return response()->json(['success' => true, 'redirect' => route('cart.show')]);
                $this->db->addLog('verification_status', $clientId, "Kullanıcı Doğrulama kodunu başarılı bir şekilde doğruladı ve sepete giriş yaptı.");
            }
            return response()->json(['success' => true, 'redirect' => route('dashboard')]);
            $this->db->addLog('verification_status', $clientId, "Kullanıcı Doğrulama kodunu başarılı bir şekilde doğruladı ve sisteme giriş yaptı.");

        } else {
            return response()->json(['success' => false]);
        }
    }


    public function logout(Request $request)
    {
        try {
            $clientId = Session::get('client');

            // Log yaz
            if ($clientId) {
                $this->db->addLog('logout', $clientId, "Kullanıcı başarılı bir şekilde çıkış yaptı.");
            }

            // Laravel Auth logout
            Auth::logout();

            // Oturum verilerini temizle
            Session::flush();

            // Oturumu geçersiz kıl ve CSRF tokenini yenile
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            // Laravel cookie'lerini temizle
            $cookies = $request->cookies->keys();
            foreach ($cookies as $cookieName) {
                Cookie::queue(Cookie::forget($cookieName));
            }

            // Custom çerezleri sil (manuel olarak eklediğinler varsa)
            setcookie("app_client_id", null, time() - 3600, "/");
            setcookie("sspanel_session", null, time() - 3600, "/");

            // remember_token çerezi (bizimki: remember_client)
            Cookie::queue(Cookie::forget('remember_client'));

            // Geri login sayfasına yönlendir
            return redirect()->route('login');
        } catch (\Exception $e) {
            \Log::error("Logout işlemi sırasında hata: " . $e->getMessage());
            return redirect()->route('login')->withErrors(['logout' => 'Çıkış işlemi sırasında bir hata oluştu.']);
        }
    }
    public function showDashboard()
  {
      $clientId = Session::get('client');
      $sepet_get = Session::get('cart_data');
      if (!$clientId) {
          return redirect()->route('login')->with('error', 'Oturum bulunamadı.');
      }

      $this->db->addLog('dashboard_log', $clientId, "Kullanıcı başarılı bir şekilde dashboard sayfasına giriş yaptı.");
      $dashboards = $this->whmcs->getdashboard($clientId);
      return view('dashboard', [
          'productCountServer' => $dashboards['count']['servers'] ?? 0,
          'productCountHosting' => $dashboards['count']['hostings'] ?? 0,
          'productCountOther' => $dashboards['count']['others'] ?? 0,
          'domainCount' => $dashboards['count']['domains'] ?? 0,
          'unpaidInvoices' => $dashboards['count']['invoices'] ?? 0,
          'recentTickets' => $dashboards['count']['tickets'] ?? 0,
          'sepet_get' => $sepet_get ?? null,
          'userid' => $clientId,

      ]);
  }



    public function showHostings()
    {

        $clientId = Session::get('client');
        $this->db->addLog('hosting_log', $clientId, "Kullanıcı başarılı bir şekilde hostinglerim sayfasına giriş yaptı.");
        $products = $this->whmcs->gethostingapp($clientId);


        return view('hostings', [
            'hostingProducts' => $products['product'],
        ]);
    }

    public function show($id)
    {
        $clientId = Session::get('client');
        $product = $this->whmcs->getProductDetails($clientId, $id);

        $this->db->addLog('hostings_log', $clientId, "Kullanıcı $id numaralı ürün sayfasına geçiş yaptı ve yönetmeye başladı.");

        if (!$product || $clientId != $product['clientid']) {
            abort(404);
        }

        $server_id = $product['serverid'];
        $servers = $this->whmcs->getServerDetails($server_id);
        if ($product['groupname'] == 'SS-WEB-HOSTING-BAYI') {
          $resellerUsername = $product['username'];
          $controller = new cPanelController();
          $domain_lists = $controller->getResellerDomains($server_id, $resellerUsername);
          $data = $domain_lists->getData(true);
          $securedDomains = [];
          foreach ($data['domains'] ?? [] as $domain) {
              $securedDomains[] = [
                  'domain' => $domain,
                  'hash' => hash_hmac('sha256', $domain, $clientId . env('DOMAIN_HASH_SECRET')),
              ];
          }
          $securedDomains[] = [
              'domain' => $product['domain'],
              'hash' => hash_hmac('sha256', $product['domain'], $clientId . env('DOMAIN_HASH_SECRET')),
          ];
        }else {
          $tek_domain = $product['domain'];
          $securedDomains[] = [
              'domain' => $tek_domain,
              'hash' => hash_hmac('sha256', $tek_domain, $clientId . env('DOMAIN_HASH_SECRET')),
          ];
        }

        return view('hosting_details', [
            'product' => $product,
            'server' => $servers,
            'securedDomains' => $securedDomains ?? null,
        ]);
    }


    public function Domainsshow($id)
    {
        $clientId = Session::get('client');
        $this->db->addLog('domains_log', $clientId, "Kullanıcı $id numaralı domain sayfasına geçiş yaptı ve yönetmeye başladı.");
        $product = $this->whmcs->getClientDomainDetails($id);
        $whois = $this->whmcs->getDomainWhoisInfo($id);
        $dna = new DomainNameAPI_PHPLibrary('ugurakkaya', 'Unna2021**1612hello');
        $result = $dna->GetDetails($product['domains']['domain'][0]['domainname']);
        $user_id = $product['domains']['domain'][0]['userid'];
        if (!$product) {
            abort(404);
        }

        if ($clientId == $user_id) {
          return view('domains_details', [
              'product' => $product,
              'whois' => $whois,
              'dna' => $result,
              'clientId' => $clientId,
          ]);
        }else {
          abort(404);
        }


    }

    public function showDomains()
    {
        $clientId = Session::get('client');
        $this->db->addLog('domain_log', $clientId, "Kullanıcı başarılı bir şekilde domainlerim sayfasına geçiş yaptı.");
        $domains = $this->whmcs->getClientDomains($clientId);
        return view('domains', [
            'domains' => isset($domains['domains']['domain']) ? $domains['domains']['domain'] : [],
        ]);
    }

    public function serverDetails($id)
    {
        $clientId = Session::get('client');
        $product = $this->whmcs->getProductDetails($clientId, $id);
        $this->db->addLog('servers_log', $clientId, "Kullanıcı $id numaralı ürüne geçiş yaptı ve yönetmeye başladı.");
        if (!$product) {
            abort(404);
          }
          $hosting = DB::table('tblhosting')
          ->where('id', $id)
          ->where('userid', $clientId)
          ->first();

          if (!$hosting) {
            abort(403, 'Bu sunucu size ait değil.');
          }

          $vmware = new VmwareClient();
          $vm = $vmware->getVM($hosting->domain); // Domain, VM adı olacak şekilde kayıtlı

          $status = 'Bilinmiyor';
          if ($vm && !empty($vm['vm'])) {
            $status = $vmware->getVMStatus($vm['vm']);
          }

        // VmWareController'dan getVM fonksiyonunu çağırarak VM bilgilerini al
        //$vmController = new VmWareController();
        //$vmDetails = $vmController->getVM($product['customfields']['customfield'][0]['value']);

        return view('servers_details', [
            'servers' => $product,
            'serverstatus' => $status
        ]);
    }

    public function getVmStatusAjax(Request $request)
    {
        $clientId = Session::get('client');
        $domain = $request->input('domain');

        $vm = DB::table('tblhosting')
            ->where('domain', $domain)
            ->where('userid', $clientId)
            ->first();

        if (!$vm) {
            return response()->json(['status' => 'error', 'message' => 'Yetkisiz erişim!']);
        }

        $vmware = new VmwareClient();
        $info = $vmware->getVM($domain);
        if (!$info || empty($info['vm'])) {
            return response()->json(['status' => 'error', 'message' => 'VM bulunamadı']);
        }

        $status = $vmware->getVMStatus($info['vm']);
        return response()->json(['status' => 'success', 'power' => $status]);
    }


    public function othersDetails($id)
    {
        $clientId = Session::get('client');
        $product = $this->whmcs->getProductDetails($clientId, $id);
        $profile = $this->whmcs->getClientDetails($clientId);
        if ($product['groupname'] == 'SmarterMail') {
            $mailLoginButton = $this->whmcs->ModuleCustom('OpenLinkApi', $id);
            $getUserDetails = $this->whmcs->ModuleCustom('UserGetApi', $id);
        }


        $this->db->addLog('orhers_log', $clientId, "Kullanıcı $id numaralı ürüne geçiş yaptı ve yönetmeye başladı.");
        if (!$product) {
            abort(404);
        }

        return view('others_details', [
            'servers' => $product,
            'sslcreate' => $profile,
            'othersId' => $id,
            'mailLoginButton' => $mailLoginButton['message'] ?? null,
            'getUserDetails' => $getUserDetails ?? null
        ]);
    }

    public function Servers()
    {
        $clientId = Session::get('client');
        $products = $this->whmcs->getserversapp($clientId);
        $this->db->addLog('server_log', $clientId, "Kullanıcı başarılı bir şekilde Sunucularım sayfasına geçiş yaptı.");
        return view('servers', [
            'servers' => $products['product'],
        ]);
    }

    public function others()
    {
        $clientId = Session::get('client');
        $products = $this->whmcs->getothersapp($clientId);
        $this->db->addLog('other_log', $clientId, "Kullanıcı başarılı bir şekilde Diğer Hizmetler sayfasına geçiş yaptı.");
        return view('others', [
            'servers' => $products['product'],
        ]);
    }

    public function kurumsalmail()
    {
        $clientId = Session::get('client');
        $products = $this->whmcs->getkurumsalmail($clientId);
        $this->db->addLog('other_log', $clientId, "Kullanıcı başarılı bir şekilde kurumsalmail sayfasına geçiş yaptı.");
        return view('kurumsal-mail', [
            'servers' => $products['product'],
        ]);
    }

    public function invoice()
    {
        $clientId = Session::get('client');
        $invoice = $this->whmcs->getClientInvoicesAll($clientId);
        $this->db->addLog('invoice_log', $clientId, "Kullanıcı başarılı bir şekilde Faturalarım sayfasına geçiş yaptı.");
        $efatura = $this->db->GetData('edm_data', ['userId' => $clientId]);

        return view('invoices', [
            'servers' => $invoice,
            'efatura' => $efatura
        ]);
    }

    public function invoiceView($id)
    {
        $clientId = Session::get('client');
        $invoice = $this->whmcs->getClientInvoicesId($id);
        $client = $this->whmcs->getClientDetails($clientId);
        $payment = $this->whmcs->GetPayMethods($clientId);
        if ($invoice['userid'] == $clientId) {
          $this->db->addLog('invoices_log', $clientId, "Kullanıcı başarılı bir şekilde $id numaralı faturayı görüntüledi.");
          return view('invoices_view', [
              'invoice' => $invoice,
              'client' => $client,
              'payment' => $payment
          ]);
        }else {
          $this->db->addLog('invoices_log', $clientId, "$id KAÇAK.");
          echo "Yetkisiz Erişim";
        }

    }

    public function tickets(){
        $clientId = Session::get('client');
        $this->db->addLog('ticket_log', $clientId, "Kullanıcı başarılı bir şekilde Destek Taleplerim sayfasına geçiş yaptı.");
        $limit = 10000;
        $tickets = $this->whmcs->getClientTickets($clientId, $limit);
        $products = $this->whmcs->getClientProductsTickets($clientId);
        $domains = $this->whmcs->getClientDomains($clientId);
      return view('tickets', [
        'tickets' => $tickets,
        'products' => $products,
        'domains' => $domains,
        'clientId' => $clientId
      ]);

    }

    public function ticketsDetails($id){
        $clientId = Session::get('client');
        $tickets = $this->whmcs->GetTicket($id);
        $this->db->addLog('tickets_log', $clientId, "Kullanıcı başarılı bir şekilde $id numaralı destek talebini görüntüledi.");
      return view('tickets_details', [
        'tickets' => $tickets,

      ]);
    }

    public function profile(){
      $clientId = Session::get('client');
      $profile = $this->whmcs->getClientDetails($clientId);
      $this->db->addLog('profile_log', $clientId, "Kullanıcı başarılı bir şekilde Profilim sayfasına geçiş yaptı.");
      return view('profile', [
        'profile' => $profile
      ]);
    }



    public function siparisOnayla(Request $request)
    {

        // Formdan gelen veriyi al
        $data = $request->all();
        $clientId = session('client');  // Client ID session'dan alınır

        $items = $data['items'];  // Gelen ürünler
        //$pay_old = $data['paymentmethod'] ?? 'banktransfer';
        $pay = "banktransfer";
        // WHMCS API'ye gönderilecek parametreler
        $orderData = [
            'action' => 'addOrder',
            'clientid' => $clientId,
            'paymentmethod' => $pay,  // Ödeme yöntemi
            'noinvoice' => false,
            'noemail' => false,
            'noinvoiceemail' => false,
            'acceptorder' => true,
            'pid' => [],
            'domain' => [],
            'domaintype' => [],
            'regperiod' => [],
            'eppcode'  => [],
            'billingcycle' => [],
            'configoptions1' => [],
            'configoptions2' => [],
            'configoptions3' => [],
            'configoptions4' => [],
            'nameserver1' => 'unna1.serversistemleri.com', // Varsayılan nameserver1
            'nameserver2' => 'unna2.serversistemleri.com', // Varsayılan nameserver2
            'customfields' => [],
        ];

        // Ürünleri işleyerek parametreleri doldur
        foreach ($items as $item) {
            if ($item['type'] === 'hosting') {
                // Hosting domain'ini register işlemine sokmuyoruz, sadece hosting ile ilişkilendiriyoruz
                $orderData['domain'][] = $item['domain'] ?? null;  // Hosting için domain
                $orderData['pid'][] = $item['pid'] ?? null;  // Hosting ürünü ID'si
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';  // Hosting fatura döngüsü
                $orderData['domaintype'][] = '';  // Hosting için domaintype boş bırakılır
                $orderData['regperiod'][] = '';  // Hosting için kayıt periyodu yok
            } elseif ($item['type'] === 'register') {
                // Sadece domain kayıt işlemi
                $orderData['domain'][] = $item['domain'] ?? null;
                $orderData['domaintype'][] = 'register';  // Domain kayıt işlemi
                $orderData['regperiod'][] = $item['regperiod'] ?? 1;  // Kayıt süresi
                $orderData['billingcycle'][] = '';  // Domain kaydı için faturalandırma döngüsü yok
                $orderData['pid'][] = '';  // Domain kaydı için ürün ID'si gerekmez
              }elseif ($item['type'] === 'cloudserver') {
                $orderData['domain'][] = $item['domain'] ?? null;  // Hostname olarak kullanılacak alan
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';  // Faturalandırma döngüsü
                $orderData['pid'][] = $item['pid'];  // Ürün ID'si, zorunlu
                $orderData['configoptions1'][] = $item['configoptions1'];
                $orderData['configoptions2'][] = $item['configoptions2'];
                $orderData['configoptions3'][] = $item['configoptions3'];
                $orderData['configoptions4'][] = $item['configoptions4'];
              }elseif ($item['type'] === 'kurumsalmail') {
                $orderData['domain'][] = $item['domain'] ?? null;  // Hosting için domain
                $orderData['pid'][] = $item['pid'] ?? null;  // Hosting ürünü ID'si
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';  // Hosting fatura döngüsü
                $orderData['domaintype'][] = '';  // Hosting için domaintype boş bırakılır
                $orderData['regperiod'][] = '';  // Hosting için kayıt periyodu yok
              }elseif ($item['type'] === 'yedek') {
                $orderData['domain'][] = $item['domain'] ?? null;  // Hostname olarak kullanılacak alan
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';  // Faturalandırma döngüsü
                $orderData['pid'][] = $item['pid'];  // Ürün ID'si, zorunlu
              } elseif ($item['type'] === 'nasbarindirma') {
                $orderData['pid'][] = $item['pid'];
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';
              } elseif ($item['type'] === 'sunucubarindirma') {
                $orderData['pid'][] = $item['pid'];
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';
              } elseif ($item['type'] === 'license') {
                $orderData['pid'][] = $item['pid'];
                $orderData['billingcycle'][] = $item['billingcycle'] ?? 'monthly';
                $orderData['license_1'] = "Sunucu Lisansı";
                $orderData['license_2'] = $item['domain'] ?? null;
                }elseif ($item['type'] === 'transfer') {
                $orderData['domaintype'][]   = 'transfer';
                $orderData['domain'][]       = $item['domain'];   // domain adı
                $orderData['regperiod'][]    =  1;   // genelde 1 yıl uzar
                $orderData['eppcode'][]      = $item['eppcode'];
                }elseif ($item['type'] === 'ssl') {
                  // SSL sertifika siparişi
                  $orderData['domain'][]        = $item['domain'] ?? null;          // Sertifika için CN
                  $orderData['pid'][]           = $item['pid'] ?? null;             // SSL ürün ID
                  $orderData['billingcycle'][]  = $item['billingcycle'] ?? 'annually';
                  $orderData['domaintype'][]    = '';                               // Domain register değil
                  $orderData['regperiod'][]     = '';                               // Kayıt periyodu yok
        }
}
        $response = $this->whmcs->addOrder($orderData);

        if (isset($response['result']) && $response['result'] === 'success') {
            session()->forget('cart_data');
            $this->db->addLog('sepetsend_log', $clientId, 'Kullanıcı ' .$response['invoiceid']. ' Fatura numaralı hizmeti için sipariş oluşturdu.');
            return response()->json(['success' => true, 'faturano' => $response['invoiceid'], 'pay' => $pay]);

        } else {
            return response()->json(['success' => false, 'message' => 'Sipariş oluşturulamadı' . $pay]);
            $this->db->addLog('sepetsend_log', $clientId, 'Kullanıcı Siparişini oluşturamadı. Bir hata alındı');
        }
    }

    public function passwordReset(){
      return view('auth.password-reset');
    }

    public function resetpassword(Request $request){

        $response = $this->whmcs->ResetPassword($request->code);

        if (isset($response['result']) && $response['result'] === 'success') {
            return response()->json(['message' => 'Şifre sıfırlama bilgisi mail adresinize gönderildi.']);
            $this->db->addLog('sepetsend_log', $request->code, 'Şifre sıfırlama bilgisi mail adresinize gönderildi.');
        }

        return response()->json(['message' => 'Geçersiz istek!'], 400);
    }

    public function passwordResetPage($token = null)
    {
        try {

            $user = DB::connection('whmcs')->table('tblusers')->where('reset_token', $token)->first();
            if (!$user) {
                $status = 'Geçersiz veya süresi dolmuş token.';
                $token_time = false;
            }else {
              $token_time = $user->reset_token_expiry;
              $resetTokenExpiry = $token_time;
              $expiryTimestamp = strtotime($resetTokenExpiry);
              $currentTimestamp = time();
              $timeDifferenceInSeconds = abs($expiryTimestamp - $currentTimestamp);
              $timeDifferenceInHours = $timeDifferenceInSeconds / 3600;
              $status_short = $timeDifferenceInHours < 2;
              $status = $status_short ? 'true' : 'false';

              $this->db->addLog('sepetsend_log', $user->id, 'Kullanıcı Şifresini sıfırladı.');
            }

        } catch (Exception $e) {
            error_log('Veri tabanı hatası: ' . $e->getMessage());
            die('Veritabanı bağlantı hatası.');
        }

        return view('auth.passpage', [
            'token' => $token,
            'status' => $status
        ]);
    }

    public function passwordresetform(Request $request)
    {
        try {

            $password = $request->input('password');
            $password2 = $request->input('password2');
            $token = $request->input('token');

            if ($password !== $password2) {
                return response()->json(['message' => 'Şifreler aynı değil'], 400);
            }

            if (empty($token)) {
                return response()->json(['message' => 'Geçersiz token'], 400);
            }

            $updated = DB::connection('whmcs')->table('tblusers')
                ->where('reset_token', $token)
                ->update([
                    'password' => password_hash($password, PASSWORD_BCRYPT),
                    'reset_token' => ' ',
                    'updated_at' => now()->format('Y-m-d H:i:s'),
                ]);

            if ($updated) {
                return response()->json(['message' => 'Şifre başarıyla güncellendi']);
            } else {
                return response()->json(['message' => 'Güncelleme başarısız veya kullanıcı bulunamadı']);
            }
        } catch (\Exception $e) {
            return response()->json(['message' => 'Bir hata oluştu: ' . $e->getMessage()], 500);
        }
    }

    public function blog(){
      return view('blog');
    }

    public function blogdetails($blogurl){
      return view('blog-details', [
        'blogurl' => $blogurl
      ]);
    }

}
