<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Colors\Color;

enum EmployeeCertificateType: int implements HasLabel, HasColor
{
    case ADR_DRIVER_TRAINING        = 1;
    case TRAVEL_HEALTH_INSURANCE    = 2;
    case TACHOGRAPH_DRIVER_CARD     = 3;

    public function getLabel(): string
    {
        return match ($this) {
            self::ADR_DRIVER_TRAINING       => 'SRC-5 Belgesi (ADR)',
            self::TRAVEL_HEALTH_INSURANCE   => 'Seyahat Sağlık Sigortası',
            self::TACHOGRAPH_DRIVER_CARD    => 'Sürücü Kartı',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::ADR_DRIVER_TRAINING       => Color::rgb('rgb(0, 102, 204)'),      // Medium Blue
            self::TRAVEL_HEALTH_INSURANCE   => Color::rgb('rgb(0, 153, 51)'),       // Dark Green
            self::TACHOGRAPH_DRIVER_CARD    => Color::rgb('rgb(255, 128, 0)'),      // Deep Orange
        };
    }

    public function getIcon(): string
    {
        return 'heroicon-s-document-text';
    }
}
