<?php
// Güvenlik: $_GET['page'] parametresini güvenli hale getir
$page_param = isset($_GET["page"]) ? strip_tags($_GET["page"]) : null;

if ($page_param) {
    // Switch case için kontrol
    // Uzanti kontrolü için güvenli bir yöntem
    $is_uzanti = false;
    $uzanti_part = "";
    if (strpos($page_param, "uzanti") !== false) {
        $parts = explode('/', trim($page_param, '/'));
        if (in_array("uzanti", $parts)) {
            $is_uzanti = true;
            $uzanti_part = end($parts);
            // Uzantıyı sanitize et (sadece a-z0-9.)
            $uzanti_part = preg_replace('/[^a-z0-9.]/i', '', $uzanti_part);
        }
    }

    // Switch case'de direkt değişken kullanmak yerine if-else yapısı veya switch içinde statik değerler
    // Ancak mevcut yapı switch üzerine kurulu. Safe match yapalım.

    // REQUEST_URI ile karşılaştırma yapan mantığı burada temizleyelim
    // Orijinal kod: case "/".strstr($_GET["page"], "uzanti"):
    // Bu mantık biraz garip, "uzanti" kelimesinden sonrasını alıyor.

    if ($is_uzanti) {
        $page_title = "En uygun fiyatlı ." . htmlspecialchars($uzanti_part) . " domain sorgulama";
    } else {
        switch ($page_param) {
            case "/bireysel-hosting":
                $page_title = "Uygun Fiyatlı Bireysel Hosting - 0.50$'dan Başlayan Fiyatlarla | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un bireysel hosting hizmeti ile web sitenizi hızlı, güvenli ve uygun fiyatlarla yayınlayın. Sınırsız alan, yüksek hız ve 7/24 destek sunan hosting paketlerimizle, online varlığınızı güçlendirin. İhtiyacınıza uygun bireysel hosting çözümleri ile site performansınızı artırın, kesintisiz hizmet avantajlarından yararlanın!";
                $page_keywords = "bireysel hosting, SSD web hosting, yüksek performanslı hosting, güvenilir web barındırma, limitsiz trafik hosting, uygun fiyatlı hosting paketleri, ücretsiz SSL sertifikalı hosting, hazır site eklentili hosting, cPanel ve Plesk destekli hosting, haftalık yedeklemeli hosting, 450'den fazla uygulama desteği, Türkçe yönetim panelli hosting, web sitesi oluşturucu ile hosting, ekonomik hosting çözümleri, standart hosting paketleri, profesyonel hosting hizmetleri, uzman hosting seçenekleri, limitsiz e-posta hesaplı hosting, limitsiz MySQL veritabanı hosting, subdomain destekli hosting";
                break;

            case "/kurumsal-hosting":
                $page_title = "Şirketiniz İçin En İyi Kurumsal Hosting - Sadece 2.90$! | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un kurumsal hosting hizmeti ile işletmenize özel, yüksek performanslı ve güvenilir bir altyapı sağlayın. SSD destekli sunucular, %99.9 uptime garantisi ve 7/24 teknik destek ile web sitenizin kesintisiz çalışmasını sağlayın. Güçlü kaynaklar, hızlı veri aktarımı ve esnek ölçeklenebilirlik ile profesyonel çözümler sunuyoruz. İşletmenize değer katacak kurumsal hosting paketlerimizle, dijital dünyada fark yaratın!";
                $page_keywords = "kurumsal hosting, enterprise seviye hosting, optimize edilmiş SSD web hosting, yüksek performanslı hosting, güvenilir web barındırma, kesintisiz erişim hosting, limitsiz trafik hosting, limitsiz e-posta hosting, limitsiz MySQL hosting, ücretsiz SSL sertifikalı hosting, hazır site eklentili hosting, cPanel destekli hosting, Plesk destekli hosting, haftalık yedeklemeli hosting, 450'den fazla uygulama desteği, Türkçe yönetim panelli hosting, web sitesi oluşturucu ile hosting, profesyonel web çözümleri, güçlü yedekleme hizmetleri, yenilikçi web çözümleri";
                break;

            case "/bayi-hosting":
                $page_title = "Bayi Hosting - 9.90$'dan Başlayan Fiyatlarla | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un bayi hosting hizmeti ile kendi hosting işinizi kurun ve müşterilerinize profesyonel çözümler sunun. SSD destekli yüksek performanslı sunucular, %99.9 uptime garantisi ve gelişmiş yönetim paneli ile tüm süreçleri kolayca yönetin. Esnek kaynak kullanımı, beyaz etiket (whitelabel) desteği ve 7/24 teknik destek ile hosting işinizi büyütün. Güvenilir ve ölçeklenebilir bayi hosting çözümlerimizle, siz de dijital dünyada güçlü bir marka olun!";
                $page_keywords = "bayi hosting, reseller hosting, cPanel bayi hosting, Plesk bayi hosting, yüksek performanslı bayi hosting, güvenilir bayi barındırma, limitsiz alt hesaplı hosting, SSD destekli bayi hosting, ücretsiz SSL sertifikalı hosting, sınırsız trafik bayi hosting, beyaz etiket hosting, özel marka bayi hosting, haftalık yedeklemeli bayi hosting, sınırsız MySQL veritabanı, sınırsız e-posta hesaplı hosting, 450'den fazla uygulama desteği, Türkçe yönetim panelli bayi hosting, WHM bayi yönetimi, bayi hosting paketleri, özel bayi çözümleri";
                break;

            case "/domain-sorgulama":
                $page_title = "Hemen Domain Sorgula ve 0.99$'dan Başlayan Fiyatlarla Kendi Alan Adını Kaydet  | Server Sistemleri";
                $page_description = "ServerSistemleri.com ile alan adınızı kolayca sorgulayın ve 0.99$'dan başlayan fiyatlarla hemen kaydedin. Güvenilir ve hızlı domain kayıt hizmetimizle, markanızı en iyi şekilde temsil edecek alan adını şimdi alın. Kaçırılmayacak fırsatlarla ucuz domain kampanyalarımızı keşfedin!";
                $page_keywords = "domain sorgulama, alan adı sorgulama, ücretsiz domain sorgulama, hızlı domain sorgulama, alan adı kayıt, domain tescil, domain kaydı, ucuz domain, güvenilir domain sorgulama, popüler domain uzantıları, .com domain sorgulama, .net domain sorgulama, .org domain sorgulama, .com.tr domain sorgulama, premium domain sorgulama, whois sorgulama, anında domain kaydı, domain transfer, domain yönetimi, en iyi domain sorgulama";
                break;

            case "/whois-sorgulama":
                $page_title = "Domain Kimin? WHOIS Sorgulama ile Hemen Öğren! | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un ücretsiz WHOIS sorgulama servisi ile bir alan adının kime ait olduğunu anında öğrenin. Domain kayıt bilgileri, yenileme (expire) süresi ve sahiplik detaylarını kolayca sorgulayarak güncel bilgilere erişin. Güvenilir ve hızlı WHOIS hizmetimizle, alan adı sahipliği hakkında detaylı bilgi alın!";
                $page_keywords = "whois sorgulama, domain whois sorgulama, alan adı whois sorgulama, ücretsiz whois sorgulama, hızlı whois sorgulama, domain bilgileri, domain kayıt bilgileri, whois bilgileri, alan adı kayıt tarihi, domain tescil sorgulama, domain sahibi öğrenme, IP whois sorgulama, alan adı IP adresi, DNS kayıtları sorgulama, whois veritabanı, domain expiration date, domain transfer bilgileri, güncel whois bilgileri, güvenilir whois sorgulama, detaylı whois analizi";
                break;

            case "/domain-transferi":
                $page_title = "Domain Transferi - Hızlı ve Güvenli Alan Adı Taşıma | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un domain transfer hizmeti ile alan adınızı hızlı, güvenli ve uygun fiyatlarla kolayca taşıyın. Avantajlı fiyatlar, özel kampanyalar ve ek hizmet fırsatlarıyla domain transferini zahmetsiz hale getiriyoruz. Web varlığınızı güçlendirmek için hemen transfer işleminizi başlatın!";
                $page_keywords = "domain transferi, alan adı transferi, domain taşıma, hızlı domain transferi, ücretsiz domain transferi, güvenilir domain transferi, domain transfer hizmeti, domain transfer ücreti, domain taşıma işlemi, .com domain transferi, .net domain transferi, .org domain transferi, .com.tr domain transferi, ICANN onaylı domain transferi, kolay domain transfer, domain transfer süreci, domain transfer kodu, whois korumalı domain transferi, toplu domain transferi, en iyi domain transfer hizmeti";
                break;

            case "/domain-fiyat-listesi":
                $page_title = "Uygun Fiyatlı Domainler - Güncel Alan Adı Fiyat Listesi Burada! | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un güncel domain fiyat listesi ile alan adınızı en uygun fiyatlarla hemen kaydedin. Popüler uzantılar için cazip fiyatlar, transfer fırsatları ve yenileme ücretlerini kolayca karşılaştırın. Uygun maliyetli ve güvenilir domain kayıt hizmetimizle markanızı online dünyada güvence altına alın!";
                $page_keywords = "domain fiyat listesi, alan adı fiyatları, ucuz domain fiyatları, en uygun domain fiyatları, domain tescil fiyatları, domain kayıt ücretleri, popüler domain uzantıları, .com domain fiyatı, .net domain fiyatı, .org domain fiyatı, .com.tr domain fiyatı, premium domain fiyatları, indirimli domain kayıt, domain transfer fiyatları, yıllık domain ücretleri, güvenilir domain sağlayıcı, en iyi domain fiyatları, domain kampanyaları, toplu domain satın alma, domain yenileme ücretleri";
                break;

            case "/ssd-bulut-sunucular":
                $page_title = "SSD Bulut Sunucu Kiralama - Hızlı, Güvenli ve Esnek Çözümler | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un SSD bulut sunucu hizmeti ile yüksek performans, güvenlik ve esneklikten ödün vermeden projelerinizi hayata geçirin. SSD destekli altyapımız sayesinde hızlı veri işleme, düşük gecikme süresi ve maksimum verimlilik sunuyoruz. %99.9 uptime garantisi, ölçeklenebilir kaynaklar ve 7/24 teknik destek ile ihtiyaçlarınıza özel çözümler sağlayın. Güçlü, güvenilir ve optimize edilmiş SSD bulut sunucu çözümlerimizle işinizi bir adım öne taşıyın!";
                $page_keywords = "SSD bulut sunucular, yüksek performanslı bulut sunucu, hızlı bulut sunucu, güvenilir bulut sunucu, ölçeklenebilir bulut sunucu, SSD VPS sunucu, SSD VDS sunucu, bulut barındırma, esnek kaynaklı bulut sunucu, Türkiye lokasyon bulut sunucu, Avrupa lokasyon bulut sunucu, anında teslim bulut sunucu, KVM sanallaştırma, güçlü altyapılı bulut sunucu, optimize edilmiş bulut sunucu, bulut sunucu yönetimi, uygun fiyatlı bulut sunucu, bulut sunucu fiyatları, profesyonel bulut çözümleri, kurumsal bulut sunucu hizmeti";
                break;

            case "/sunucu-barindirma":
                $page_title = "Sunucu Barındırma - Türkiye ve Avrupa Lokasyonlu Veri Merkezleri | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un sunucu barındırma hizmeti ile fiziksel sunucularınızı güvenli, kesintisiz ve yüksek performanslı veri merkezlerimizde barındırın. Tier 3 standartlarında altyapımız, %99.9 uptime garantisi ve 7/24 teknik destek ile sunucularınız her zaman güvende. Yüksek hızda internet erişimi, yedekli enerji sistemleri ve güçlü güvenlik önlemleriyle iş sürekliliğinizi kesintisiz hale getirin. Profesyonel sunucu barındırma çözümlerimizle, projelerinizi en iyi altyapıda çalıştırın!";
                $page_keywords = "sunucu barındırma, colocation hizmeti, veri merkezi barındırma, güvenilir sunucu barındırma, yüksek hızlı sunucu barındırma, Türkiye lokasyon sunucu barındırma, Avrupa lokasyon sunucu barındırma, profesyonel sunucu barındırma, kesintisiz internet erişimi, 7/24 teknik destekli sunucu barındırma, uygun fiyatlı sunucu barındırma, özel kabinet kiralama, veri merkezi altyapısı, DDoS korumalı sunucu barındırma, yüksek bant genişliği, network güvenliği, kurumsal sunucu barındırma, güçlü altyapılı veri merkezi, enerji yedekliliği, Tier 3 veri merkezi";
                break;

            case "/nas-barindirma":
                $page_title = "NAS Barındırma - Güvenli ve Yüksek Hızlı Veri Depolama Çözümleri | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un NAS barındırma hizmeti ile verilerinizi güvenli, yüksek performanslı ve kesintisiz bir altyapıda saklayın. Tier 3 veri merkezimizde sunulan yedekli enerji, yüksek hızda internet erişimi ve gelişmiş güvenlik önlemleri sayesinde NAS cihazlarınızı maksimum verimlilikle kullanabilirsiniz. %99.9 uptime garantisi, esnek kapasite seçenekleri ve 7/24 teknik destek ile veri yönetiminizi güvence altına alın. Profesyonel NAS barındırma çözümlerimizle verilerinizi güvenli ve erişilebilir tutun!";
                $page_keywords = "NAS barındırma, NAS sunucu barındırma, güvenilir NAS barındırma, yüksek hızlı NAS barındırma, veri merkezi NAS barındırma, Türkiye lokasyon NAS barındırma, Avrupa lokasyon NAS barındırma, kurumsal NAS çözümleri, profesyonel NAS barındırma, yedekleme amaçlı NAS barındırma, bulut tabanlı NAS çözümleri, kesintisiz erişimli NAS barındırma, uygun fiyatlı NAS hizmetleri, 7/24 teknik destekli NAS barındırma, RAID destekli NAS barındırma, NAS veri depolama, yüksek bant genişliği, NAS güvenlik çözümleri, uzaktan erişimli NAS barındırma, güçlü altyapılı NAS barındırma";
                break;
            case "/kurumsal-mail":
                $page_title = "Kurumsal Mail Hizmeti - Markanıza Özel Güvenli ve Hızlı E-Posta | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un kurumsal mail hizmeti ile işletmenize özel, güvenli ve profesyonel e-posta çözümleri sunuyoruz. %99.9 uptime garantisi, güçlü spam koruması ve gelişmiş güvenlik önlemleri ile e-postalarınızı sorunsuz bir şekilde yönetin. Özel alan adınızla marka bilinirliğinizi artırın, kesintisiz iletişim sağlayın ve iş süreçlerinizi daha verimli hale getirin. Yüksek kapasiteli ve güvenilir kurumsal e-posta hizmetimizle, profesyonel iletişim deneyimini keşfedin!";
                $page_keywords = "kurumsal mail, iş e-postası, profesyonel e-posta hizmeti, güvenilir kurumsal e-posta, özel alan adı e-posta, şirket e-posta hizmeti, e-posta barındırma, güvenli e-posta çözümleri, sınırsız kurumsal e-posta, güçlü spam filtreleme, POP3 ve IMAP destekli mail, e-posta arşivleme, mobil uyumlu e-posta, uygun fiyatlı kurumsal mail, Exchange alternatifi e-posta, yüksek kapasiteli e-posta, 7/24 destekli kurumsal e-posta, kesintisiz e-posta iletişimi, e-posta güvenliği, SSL/TLS şifreli e-posta";
                break;

            case "/yedek":
                $page_title = "Veri Yedekleme Çözümleri - Kaybolmadan Önce Önlem Alın! | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un yedekleme hizmeti ile verilerinizi güvenli, otomatik ve kesintisiz bir şekilde koruyun. Günlük, haftalık veya özel yedekleme seçenekleri ile veri kaybı riskini en aza indirin ve kritik bilgilerinizi her zaman erişilebilir tutun. Şifrelenmiş yedekleme, yüksek hızda geri yükleme ve %99.9 uptime garantisi ile iş sürekliliğinizi güvence altına alın. Profesyonel yedekleme çözümlerimizle, verilerinizi güvende tutun ve geleceğe güvenle bakın!";
                $page_keywords = "yedekleme hizmeti, bulut yedekleme, güvenli veri yedekleme, otomatik yedekleme çözümleri, yedekleme ve geri yükleme, sunucu yedekleme, günlük yedekleme, haftalık yedekleme, bulut tabanlı yedekleme, NAS yedekleme, RAID destekli yedekleme, uygun fiyatlı yedekleme, profesyonel yedekleme hizmeti, veri kaybına karşı yedekleme, uzaktan erişimli yedekleme, kesintisiz veri koruma, yedekleme depolama alanı, şifreli yedekleme, hızlı yedekleme çözümleri, kurumsal yedekleme hizmetleri";
                break;

            case "/ssl":
                $page_title = "Uygun Fiyatlı SSL Sertifikaları - Güvenli ve SEO Dostu | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un SSL sertifika hizmeti ile web sitenizi güvenli hale getirin ve ziyaretçilerinize şifrelenmiş, korumalı bir deneyim sunun. Google dostu HTTPS protokolü ile arama motorlarında üst sıralarda yer alın, veri güvenliğinizi artırın ve müşteri güvenini kazanın. Hızlı kurulum, güçlü şifreleme ve uygun fiyatlı SSL sertifikalarımızla sitenizi hemen koruma altına alın!";
                $page_keywords = "SSL sertifikası, güvenli SSL, ücretsiz SSL, profesyonel SSL sertifikası, web sitesi güvenliği, HTTPS sertifikası, güvenilir SSL hizmeti, uygun fiyatlı SSL, wildcard SSL, EV SSL sertifikası, DV SSL sertifikası, OV SSL sertifikası, e-ticaret için SSL, SSL kurulumu, anında SSL aktivasyonu, SSL şifreleme, 256-bit SSL, SEO dostu SSL, Google dostu SSL, kurumsal SSL çözümleri";
                break;

            case "/lisanslar":
                $page_title = "cPanel, Plesk ve ISP Manager Lisanslama Hizmetleri | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un lisans hizmetleri ile sunucu ve yazılım ihtiyaçlarınızı güvenli, yasal ve uygun maliyetlerle karşılayın. cPanel, Plesk, DirectAdmin, Windows Server ve diğer popüler yazılım lisanslarıyla projelerinizi güvenilir bir altyapıya taşıyın. Anında aktif edilen lisanslarla zaman kaybetmeden kullanıma başlayın ve 7/24 teknik destek avantajımızla sorunsuz bir deneyim yaşayın. Güvenilir ve uygun fiyatlı lisans çözümlerimizi keşfedin!";
                $page_keywords = "yazılım lisansları, sunucu lisansları, cPanel lisansı, Plesk lisansı, DirectAdmin lisansı, Windows Server lisansı, Linux lisansları, WHMCS lisansı, CloudLinux lisansı, LiteSpeed lisansı, SQL Server lisansı, güvenilir lisans çözümleri, uygun fiyatlı yazılım lisansları, kurumsal lisans hizmetleri, lisans satın alma, aylık ve yıllık lisanslar, orijinal yazılım lisansı, lisans yönetimi, anında lisans aktivasyonu, profesyonel lisans çözümleri";
                break;

            case "/araclar":
                $page_title = "Kullanışlı Web Araçları | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un ücretsiz araçlar bölümü ile web siteniz ve sunucularınız için ihtiyaç duyduğunuz teknik kontrolleri hızla gerçekleştirin. DNS, IP, SSL, DMARC, MX ve WHOIS sorgulama gibi gelişmiş araçlarımızla alan adı ve sunucu bilgilerinizi anında analiz edin. Hızlı, güvenilir ve kullanıcı dostu altyapımız sayesinde işlemlerinizi zahmetsizce tamamlayın. Profesyonel hosting ve domain araçlarımızı hemen keşfedin!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/araclar/dns-sorgulama":
                $page_title = "Ücretsiz DNS Sorgulama - Anında IP ve Nameserver Bilgilerini Al! | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un DNS sorgulama aracı ile bir alan adının DNS kayıtlarını hızlı ve kolay bir şekilde kontrol edin. A, CNAME, MX, TXT ve diğer DNS kayıtlarını anında görüntüleyerek yapılandırmalarınızı doğrulayın. Güvenilir ve kullanıcı dostu altyapımız sayesinde web sitenizin yönlendirme ayarlarını ve sunucu bilgilerini zahmetsizce analiz edin. Anında ve doğru sonuçlar için DNS sorgulama aracımızı hemen kullanın!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/araclar/ssl-sorgulama":
                $page_title = "Ücretsiz SSL Sorgulama - Sertifika Detaylarını ve Süresini Öğren | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un SSL sorgulama aracı ile bir web sitesinin SSL sertifikasını anında kontrol edin. Sertifikanın geçerliliğini, süresini, güvenlik seviyesini ve şifreleme detaylarını kolayca öğrenin. Güvenilir ve hızlı SSL analiz aracımız sayesinde sitenizin HTTPS bağlantısını doğrulayın ve olası güvenlik açıklarını önceden tespit edin. Web sitenizin güvenliğini sağlamak için SSL sertifikanızı hemen kontrol edin!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/araclar/ip-sorgulama":
                $page_title = "Ücretsiz IP Sorgulama - IP Adresinizi ve Detaylarını Görün | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un IP sorgulama aracı ile anlık olarak IP adresinizi öğrenin ve detaylı bağlantı bilgilerine erişin. IP adresinizin konumunu, servis sağlayıcısını ve ağ bilgilerini hızlıca analiz edin. Güvenilir ve kullanıcı dostu altyapımız sayesinde internet bağlantınızı kontrol edin ve IP adresiniz hakkında detaylı bilgi edinin. Hemen kullanarak IP adresinizi sorgulayın!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/araclar/dmarc-sorgulama":
                $page_title = "Ücretsiz DMARC Sorgulama - E-Posta Kimlik Doğrulamanızı Test Edin | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un DMARC sorgulama aracı ile e-posta güvenliğinizi anında analiz edin. Alan adınızın DMARC kayıtlarını kontrol ederek sahtecilik (spoofing) ve kimlik avı (phishing) saldırılarına karşı koruma seviyenizi değerlendirin. SPF ve DKIM yapılandırmalarınızı doğrulayarak e-postalarınızın güvenliğini artırın. Güvenilir ve hızlı DMARC kontrol aracımız ile e-posta sisteminizi güvence altına alın!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/araclar/mx-sorgulama":
                $page_title = "Ücretsiz MX Sorgulama - Alan Adınızın Mail Kayıtlarını Görün | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un MX sorgulama aracı ile alan adınızın e-posta yönlendirme ayarlarını anında kontrol edin. MX (Mail Exchange) kayıtlarınızı analiz ederek e-postalarınızın doğru sunucuya yönlendirildiğinden emin olun. Güvenilir ve hızlı MX kayıt sorgulama hizmetimiz ile e-posta sisteminizin yapılandırmasını doğrulayın ve olası teslimat sorunlarını önleyin. Mail sunucu ayarlarınızı hemen kontrol edin!";
                $page_keywords = "web araçları, hosting araçları, sunucu yönetim araçları, domain araçları, IP sorgulama, whois sorgulama, DNS sorgulama, SSL kontrol aracı, MX kayıt kontrolü, nameserver sorgulama, hız testi araçları, güvenlik araçları, bağlantı test araçları, ping ve traceroute araçları, SEO analiz araçları, online web araçları, ücretsiz hosting araçları, sistem yöneticisi araçları, profesyonel web yönetim araçları, teknik destek araçları";
                break;

            case "/sepet":
                $page_title = "Sepetiniz - Satın Alma İşleminizi Tamamlayın | Server Sistemleri";
                break;

            case "/hosting-kurulum":
                $page_title = "Hosting Kurulumu - Hızlı ve Kolay Web Hosting Ayarları | Server Sistemleri";
                break;

            case "/server-kurulum":
                $page_title = "Server Kurulumu - Hızlı ve Güvenilir Sunucu Yapılandırması | Server Sistemleri";
                break;

            case "/hakkimizda":
                 $page_title = "Hakkımızda - Server Sistemleri Kimdir? | Güvenilir Hosting Hizmetleri";
                 $page_description = "ServerSistemleri.com, yılların getirdiği tecrübe ile 2004 yılında kurulmuştur. Server Sistemleri, Kaliteli Hizmet, Uygun Fiyat felsefesi ile kurulduğu günden bu yana faaliyetlerini sürdüren bir Data Center (Veri Merkezi) firması olup, bu kapsamda istikrarlı bir şekilde kendisini geliştirmekte ve yenilemektedir.";
                 $page_keywords = "";
                 break;

            case "/banka-hesap-bilgileri":
                $page_title = "Banka Hesap Bilgileri - Ödeme Yapabileceğiniz Bankalar | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un banka hesap bilgileri sayfasından ödeme işlemleriniz için güncel hesap numaralarımıza ulaşabilirsiniz. Güvenli ve hızlı ödeme için havale ve EFT seçeneklerini kullanarak işlemlerinizi sorunsuz gerçekleştirin. Banka bilgilerimizi inceleyerek, ödemenizi doğru hesaplara yönlendirdiğinizden emin olun. Kesintisiz hizmet ve güvenilir ödeme altyapımızla işlemlerinizi kolayca tamamlayın!";
                $page_keywords = "";
                break;

            case "/fatura-bilgileri":
                $page_title = "Fatura Bilgileri - Ödeme ve Faturalandırma Detayları | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un fatura bilgileri sayfasından ödeme işlemleriniz için gerekli fatura detaylarına ulaşabilirsiniz. Tüm hizmetlerimiz için kesilen faturalar hakkında bilgi alabilir, fatura düzenleme süreçleri ve ödeme yöntemleriyle ilgili detayları inceleyebilirsiniz. Şeffaf ve güvenilir faturalandırma sistemimiz ile işlemlerinizi sorunsuz gerçekleştirin!";
                $page_keywords = "";
                break;

            case "/kvkk":
                $page_title = "KVKK - Kişisel Verilerin Korunması Politikamız | Server Sistemleri";
                $page_description = "ServerSistemleri.com olarak, kişisel verilerinizi 6698 sayılı Kişisel Verilerin Korunması Kanunu (KVKK) çerçevesinde güvenli bir şekilde işliyor ve koruyoruz. Veri gizliliği politikamız hakkında detaylı bilgi almak, haklarınızı öğrenmek ve kişisel verilerinizin nasıl işlendiğini incelemek için KVKK sayfamızı ziyaret edin. Güvenliğiniz bizim için önceliklidir!";
                $page_keywords = "";
                break;

            case "/sozlesmeler":
                $page_title = "Sözleşmeler - Hizmet Şartları ve Kullanım Koşulları | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un sözleşmeler sayfasında, hizmetlerimizle ilgili tüm yasal metinlere ulaşabilirsiniz. Kullanım koşulları, gizlilik politikası, mesafeli satış sözleşmesi ve diğer yasal belgeleri inceleyerek haklarınızı ve yükümlülüklerinizi öğrenin. Şeffaf ve güvenilir hizmet anlayışımızla, kullanıcılarımızın haklarını koruyor ve yasal süreçleri açık bir şekilde sunuyoruz.";
                $page_keywords = "";
                break;

            case "/sozlesmeler/mesafeli-satis-sozlesmesi":
                $page_title = "Mesafeli Satış Sözleşmesi - Online Hizmet Satış Koşulları | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un Mesafeli Satış Sözleşmesi sayfasında, online olarak satın aldığınız hizmetlerin yasal çerçevede düzenlenen şartlarını inceleyebilirsiniz. Tüketici hakları, iade koşulları ve sözleşme yükümlülükleri hakkında detaylı bilgiye ulaşarak güvenli bir alışveriş deneyimi yaşayabilirsiniz. Şeffaf ve müşteri odaklı hizmet anlayışımızla, tüm yasal süreçleri açık ve anlaşılır bir şekilde sunuyoruz.";
                $page_keywords = "";
                break;

            case "/sozlesmeler/gizlilik-sozlesmesi":
                $page_title = "Gizlilik Sözleşmesi - Kişisel Verilerin Korunması | Server Sistemleri";
                $page_description = "ServerSistemleri.com’un Mesafeli Satış Sözleşmesi sayfasında, online olarak satın aldığınız hizmetlerin yasal çerçevede düzenlenen şartlarını inceleyebilirsiniz. Tüketici hakları, iade koşulları ve sözleşme yükümlülükleri hakkında detaylı bilgiye ulaşarak güvenli bir alışveriş deneyimi yaşayabilirsiniz. Şeffaf ve müşteri odaklı hizmet anlayışımızla, tüm yasal süreçleri açık ve anlaşılır bir şekilde sunuyoruz.";
                $page_keywords = "";
                break;
            default:
                $page_title = "Server Sistemleri : Türkiye'nin Hosting ve Bulut Sunucu Sağlayıcısı";
                $page_description = "ServerSistemleri.com, sınırsız web hosting, domain sorgulama ve kayıt, reseller hosting, VDS sunucu ve SSL hizmetlerinde en iyi fiyatları sunarak işletmenize güç katıyor. %99.9 çalışma garantisi, yüksek performanslı altyapı ve güvenilir hizmet anlayışıyla kesintisiz internet çözümleri sağlıyoruz. Profesyonel destek ekibimizle her zaman yanınızdayız";
                $page_keywords = "";
                break;
        }
    }
}
?>
