<style media="screen">
/* Genel link stilleri */
.custom-link {
    color: #fff;
    text-decoration: none;
    margin: 0 6px;
    padding: 5px 7px;
    border-radius: 5px;
    background-color: rgba(255, 255, 255, 0.1);
    transition: background-color 0.3s ease, color 0.3s ease;
    display: inline-block;
}

.custom-link:hover {
    background-color: #fff;
    color: #000;
}

/* Mobilde linklerin gizlenmesi */
@media (max-width: 768px) {
    .links {
        display: none; /* Linkleri gizle */
    }
    .domain-submit-box {
        top: 100%;
        right: 0;
        width: 100%;
        margin-top: 2px;
    }
    .domain-submit-box .btn-primary {
        width: 100%;
    }
}

@media only screen and (max-width: 1124px) {
    .domain-search {
        border-radius: 9px 9px 0px 0px;
    }
    .domain-submit-box button {
        border-radius: 0px 0px 9px 9px;
    }
    .domain-ext {
        display: none;
    }

}
[class*=" ssicon-"],
[class^="ssicon-"] {
    font-size: 18px;
    margin-top: 7px;
    color: black;
}
.ozellik-alani:hover {
    background-color: #eff1fa;
    border-radius: 5px;
}
.disnone {
    display: none;
}

usd,
try {
    display: none;
}

html.TRY try {
    display: inline-block;
}

html.TRY usd {
    display: none;
}

html.USD usd {
    display: inline-block;
}

html.USD try {
    display: none;
}

.domain-whois a,
button {
    text-decoration: none;
}
/* Masaüstünde fiyat gizlensin */
.fiyat,
.kime-ait {
  display: none;
}

/* Mobilde fiyat görünsün */
@media (max-width: 768px) {
    span.price {
        font-size: 100% !important;
    }
    .domain-price-old {
        display: none !important;
    }
    .mobile-center {
        justify-content: center !important;
    }
    .domain-button {
        padding: 5px;
    }
    .whois-results .result .domain-button .whois {
        display: none !important;
    }
    .mobile-prices {
        display: none !important;
    }
    .kime-ait {
        color: #455cc7 !important;
        display: block !important;
    }
    .fiyat{
      background-color: rgba(0, 0, 0, 0) !important;
      border: 1px solid black;
      font-size: 18px;
      font-weight: 600;
    padding: 4px 12px;
    text-align: center;
        border-radius: 3px;
        display: block;
        color: black;
    }
    /*.fiyat {
        font-size: 18px;
        line-height: 32px;
        display: block;
        background-color: #4caf50;
        min-width: 118px;
        color: #fff;
        border-radius: 3px;
        font-weight: 600;
        padding: 4px 12px;
        text-align: center;
        cursor: pointer;
        text-decoration: none;
    }*/
}

register {
    color: #4caf50;
}
transfer {
    color: #455cc7;
}
dikcizgi {
    margin-right: 5px;
    margin-left: 5px;
    border-right: 1px solid black;
}

@media (min-width: 1400px) {
    .container-xxl,
    .container-xl,
    .container-lg,
    .container-md,
    .container-sm,
    .container {
        max-width: 1200px;
    }
}
</style>
<section class="bg-warning-2">
    <div class="domain-search-box home-9-hero pt-60 pb-60 px-2" style="background-image: url(<?php echo $site_url; ?>assets/img/home-domain-search.webp);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="col-12">
                        <div class="domain-form-one mx-auto position-relative mt-8 sal-animate ss-domain_pricing_content col-lg-12 heading-white mb-4 mb-sm-4 mb-lg-0">
                            <div class="row domain-form-container ss-animate fadeInUp ss-animated">
                                <form id="queryDomain" class="col-12 domain-form" action="domain-sorgulama" method="get">
                                    <div class="form-group domain-name">
                                        <div class="domain-name-background"></div>
                                        <input class="" id="domain" name="domain" type="text" placeholder="Hayalinizdeki Alan Adını Hemen Bulun!" />
                                    </div>
                                    <div class="form-group domain-select">
                                        <input type="submit" value="Sorgula" />
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="links mt-4 text-center">
                        <a target="_blank" href="https://serversistemleri.com/domain-sorgulama" class="custom-link"> <i class="fa-solid fa-chevron-right" style="margin-right: 5px; font-size: 15px;"></i>Domain Sorgulama</a>
                        <a target="_blank" href="https://serversistemleri.com/domain-transferi" class="custom-link"><i class="fa-solid fa-chevron-right" style="margin-right: 5px; font-size: 15px;"></i>Domain Transfer</a>
                        <a target="_blank" href="https://sspanel.serversistemleri.com/" class="custom-link"><i class="fa-solid fa-chevron-right" style="margin-right: 5px; font-size: 15px;"></i>Domain Yenile</a>
                        <a target="_blank" href="https://serversistemleri.com/whois-sorgulama" class="custom-link"><i class="fa-solid fa-chevron-right" style="margin-right: 5px; font-size: 15px;"></i>Whois Sorgulama</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    document.getElementById('queryDomain').addEventListener('submit', function(e) {
        var domainInput = document.getElementById('domain');
        var domainValue = domainInput.value.trim();

        // www. ile başlıyorsa onu kaldır
        if(domainValue.toLowerCase().startsWith('www.')) {
            domainValue = domainValue.substring(4);
            domainInput.value = domainValue; // input'a temiz halini tekrar yaz
        }
    });
</script>
<section class="ss-section domain-whois disnone" style="background: white;">
	<div class="container">
		<div class="row justify-content-center mb-5">
			<div class="col-md-12 ss-animate fadeInUp ss-animated">

				<div class="heading-section text-center">
					<h2>Sorgulama Sonuçları</h2>
				</div>
				<div class="whois-results">
					<div class="results ss-animate fadeInUp ss-animated" id="results">
						<div class="title">Sorgulanan Domainler</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</section>
<div class="pt-60 pb-60 bg-primary bg-opacity-5">
    <div class="pb-60">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-lg-12">
                    <h2 class="sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                      Domain Avantajları
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row g-4">
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-eye-blocked" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz Whois Gizleme
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızın kimlik bilgilerini ücretsiz olarak saklayabilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-language" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                              Ücretsiz DNS Yönetimi
                            </h6>
                        </div>
                        <p class="mb-0">
                            A Kaydı, Name Server Kaydı, MX Kaydı gibi işlemleri ücretsiz yapabilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-transfer" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz Yönlendirme
                            </h6>
                        </div>
                        <p class="mb-0">
                            Domain adresinizi farklı bir domain adresine ücretsiz yönlendirebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-locked" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                              Ücretsiz Domain Kilidi
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızı olası izinsiz transferlere karşı ücretsiz kilitleyebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-expand2" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                              Ücretsiz İç Transfer
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızı firmamızda bulunan farklı bir hesaba ücretsiz transfer edebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-cogs" style="font-size: 46px;color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Domain Yönetimi
                            </h6>
                        </div>
                        <p class="mb-0">
                          Tüm alan adlarınızı SS-Panel'den kolayca yönetebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$faq = [
    [
        "question" => "Domain Sorgulama Ücretli Midir?",
        "answer" => "Hayır. Domain sorgulama için hiçbir ücret ödemenize gerek yoktur."
    ],
    [
        "question" => "Süresi Biten Alan Adlarımı Nasıl Yenilerim?",
        "answer" => "SS-PANELE giriş yaparak domainlerim sekmesinden yenileme yapmak istediğiniz alan adını seçerek hemen yenileyebilirsiniz."
    ],
    [
        "question" => "Domain Transfer İçin Ne Yapmalıyım?",
        "answer" => "Domain transferinizi gerçekleştirmek için alan adınızın şu anda bulunduğu firmadan “Transfer Kodu” temin etmeniz gerekir ve ardından domain transfer sayfamıza giderek ilgili kodu girip domain transferini başlatabilirsiniz."
    ],
    [
        "question" => "Domain Satın Alma İçin Ne Yapmalıyım?",
        "answer" => "Satın almak istediğiniz anahtar kelime ve domain uzantısını domain arama bölümüne girin ve müsait durumdaki alan adını sepete atarak, ödemenizi yapın ve siparişinizi tamamlayın."
    ],
    [
        "question" => "Nasıl Ödeme Yapabilirim?",
        "answer" => "Kredi Kartı veya Banka Havalesi olarak ödeme yapabilirsiniz."
    ],
    [
        "question" => "Domainlerim Ne Zaman Aktif Olur?",
        "answer" => "Kredi kartı ile yapılan ödemeler anlık, banka havalesi ile yapılan işlemlerde ödeme teyidi 24 saat içerisinde yapılarak domainleriniz aktive edilir."
    ],
    [
        "question" => "Domainlerimi Neden ServerSistemleri'den Tescil Ettirmeliyim?",
        "answer" => "ServerSistemleri.com 1500+ den fazla domain uzantısını tescil etmekte olan çok nadir domain firmalarından birisidir. Domainleriniz özel müşteri temsilcisi ve destek ekiplerimizce 24 saat yönetilmektedir."
    ],
    [
        "question" => "Domain (Alan Adı) Nedir?",
        "answer" => "Domain, internet sitenizin webteki açık adresidir. Web adresinizi ziyaret etmek isteyen kişiler, domaini tarayıcıya yazarak internet sitenize ulaşır. Bir web sitesi açmak için domain satın almak zorundasınız."
    ],
    [
        "question" => "Domain Kime Ait, Nasıl Sorgularım?",
        "answer" => "Domain kime ait gibi bilgileri Whois sorgulama araçlarından öğrenebilirsiniz."
    ],
    [
        "question" => "Domain (Alan Adı) Tescili Nedir?",
        "answer" => "Alan adı, internet sitenizin web dünyasındaki adresidir. Alan adları bir IP adresi üzerinden çalışabilir. Eğer bir internet sitesi açmak istiyorsanız öncelikli olarak bir domain tescili yapmanız gereklidir."
    ],
    [
        "question" => "Domain Uzantısı Nedir?",
        "answer" => "Domain yani alan adı uzantısı, internet siteniz için tescil ettiğiniz domainin noktadan sonra başlayan kısmıdır. (Örn: .com.tr, .com, .org vb.)"
    ],
    [
        "question" => "Kayıt İşlemi Tamamlanan Domain Değiştirilebilir Mi?",
        "answer" => "Domain kayıt edildikten sonra, tescil edilen domain değiştirilemez ve ücret iadesi yapılamaz. Domain seçimi yaparken domain satın alma kurallarına dikkat etmenizi tavsiye ederiz."
    ],
    [
        "question" => "Hangi Domain Uzantısını Satın Almalıyım?",
        "answer" => "Dünyada en fazla .COM ve .NET domainleri satılmaktadır. İçerik farkı gözetmeden her web sitesi bu uzantıları kullanabilmektedir. Örneğin Rusya’da .ru domain uzantısı, Almanya'da .de domain uzantısı daha fazla satılmaktadır."
    ],
    [
        "question" => "İyi Bir Domain Nasıl Seçilir?",
        "answer" => "Domain tercih ederken dikkat ediniz. Markanızı veya firmanızı en iyi şekilde temsil edecek alan adınıza karar vermeniz gerekir. Akıcı, anlaşılır, kısa, kolay telaffuz edilen ve tire ile ayrılmayan bir domain seçin."
    ],
    [
        "question" => "Domain Satın Alma Yaparken Dikkat Etmem Gerekenler Nelerdir?",
        "answer" => "İnternet sitenizin konusu ile ilgili anahtar kelimeler içeren domainler daha akılda kalıcı olacaktır ve arama motoru sıralamasında ön sıralarda gelmenizi sağlayacaktır. Tescil edeceğiniz alan adının marka kaydı olup olmadığını kontrol edin."
    ],
    [
        "question" => "Domain Nasıl Transfer Edilir?",
        "answer" => "Tescil etmiş olduğunuz domainlerinizi, tescil tarihinden 60 gün geçtikten sonra transfer edebilirsiniz. Domain transfer sayfası üzerinden domain transferinizi başlatabilirsiniz."
    ],
    [
        "question" => "Domaini Satın Aldım, Web Sitemi Nasıl Aktive Ederim?",
        "answer" => "Domain satın aldıktan sonra yapmanız gereken tek işlem hosting satın almanızdır. Hosting satın aldıktan sonra NameServer adreslerini yönlendirmeniz yeterlidir."
    ],
    [
        "question" => "Domain İç Transfer İçin Ücret Ödemem Gerekli Mi?",
        "answer" => "ServerSistemleri üzerinde domain iç transferi ücretsizdir."
    ],
    [
        "question" => "Domain Süresi Bitince Ne Zaman Açığa Çıkar?",
        "answer" => "Domain süresi bitince hemen açığa çıkmaz. ServerSistemleri domain yenileme kurallarına göre, -20 gün içinde .com .net .org gibi domainleri yenileyebilirsiniz."
    ],
    [
        "question" => "Domain Sorgulama Nedir?",
        "answer" => "Bir alan adı kayıt etmeden önce domainin müsait mi sorgulamak gereklidir. Bu işleme domain sorgulama denir. Kayıtlı bir domainin Whois bilgilerine ulaşmak için Whois sayfamızı kullanabilirsiniz."
    ],
    [
        "question" => "Domain Tescili Neden Ücretlidir?",
        "answer" => "Domain kayıt işlemleri ICANN ve IANA tarafından yürütülmektedir. Sistemin sağlıklı işlemesi ve gerekli giderleri karşılamak için domain ücretsiz olarak tescil edilemez."
    ],
    [
        "question" => "Satın Almak İstediğim Domain Kayıtlı, Ne Yapabilirim?",
        "answer" => "Bazı domain uzantılarında belgeli işlem yapılmaktadır. Jenerik diye tanımlanan .com, .net, .org, vb. domainler ilk gelen alır kuralı ile çalışmaktadır."
    ],
    [
        "question" => "Kredi Kartı ile Domain Alırsam Hemen Aktif Olur mu?",
        "answer" => "Kredi kartı ile yapılan domain satın alma sonrası belge gerektirmeyen domain uzantıları hemen aktif olur. Belge gerektiren domainler için ödeme sonrası destek ekibimiz sizinle irtibata geçecektir."
    ],
    [
        "question" => "Kayıtlı Domain Değiştirilebilir Mi?",
        "answer" => "Tescil edilen bir domain maalesef değiştirilemez."
    ],
    [
        "question" => "Hosting Satın Almak Zorunlu Mu?",
        "answer" => "Domain aldığınız zaman hosting almak mecburi değildir. Ücretsiz DNS Yönetimi ve Domain Yönlendirme hizmetlerinden faydalanabilirsiniz."
    ],
    [
        "question" => "Domainim İçin DNS Oluşturabilir Miyim?",
        "answer" => "Alan adınız için özel DNS yani name server oluşturma işlemini ServerSistemleri müşteri paneliniz üzerinden yapabilirsiniz. Teknik destek ekibimizden destek alabilirsiniz."
    ],
    [
        "question" => "Domain Whois Gizleme Nedir?",
        "answer" => "Domain Whois Gizleme, alan adı satın alırken kullandığınız bilgilerinin başkaları tarafından gözükmesini engelleyen bir servistir. serversistemleri.com üzerinden Whois gizleme ücretsizdir."
    ],
    [
        "question" => "ServerSistemleri Nameserver Adresleri Nedir?",
        "answer" => "ServerSistemleri.com sunucularımızın nameserver adresleri unna1.serversistemleri.com ve unna2.serversistemleri.com'dur."
    ],
    [
        "question" => "Domain Adresimi ServerSistemleri.com'dan Başka Bir Firmaya Transfer Ettirebilir Miyim?",
        "answer" => "Evet. Dilediğiniz zaman domaininizi başka bir firmaya transfer edebilirsiniz."
    ]
];

 ?>
 <div class="pt-60 pb-120">
   <div class="pb-40">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-md-10 col-lg-8 col-xl-7">
                   <div class="text-center sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                       <h2>
                           Sıkça Sorulan Sorular
                       </h2>
                   </div>
               </div>
           </div>
       </div>
   </div>
   <div class="container">
       <div class="row g-4 justify-content-center">
           <div class="col-12">
               <?php $faq_sira = 0; ?>
               <div class="accordion border-0 vps-hosting-accordion" id="accordionFaq2">
                 <div class="row">
                   <?php foreach ($faq as $key): ?>
                       <?php $faq_sira = $faq_sira + 1; ?>
                     <div class="col-sm-6">
                       <div class="accordion-item border rounded-3 mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                           <h2 class="accordion-header">
                               <button class="accordion-button bg-transparent collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-<?php echo $faq_sira; ?>" aria-expanded="false" aria-controls="faq-<?php echo $faq_sira; ?>">
                                   <span class="text-body fs-16 fw-bold"><?php echo $key['question']; ?></span>
                               </button>
                           </h2>
                           <div id="faq-<?php echo $faq_sira; ?>" class="accordion-collapse collapse" data-bs-parent="#faq-<?php echo $faq_sira; ?>" style="">
                               <div class="accordion-body pt-0">
                                   <?php echo $key['answer']; ?>
                               </div>
                           </div>
                       </div>
                     </div>
                   <?php endforeach; ?>
                 </div>
               </div>
           </div>
       </div>
   </div>
</div>

<script type="text/javascript">
function checkAndUpdateButtonBasedOnCart() {
    // LocalStorage'dan cart verisini al ve JSON olarak parse et
    var cart = JSON.parse(localStorage.getItem('cart') || '[]');

    // Tüm domain-to-cart butonlarını seç
    var domainButtons = document.querySelectorAll('.domain-to-cart');

    // Sepetteki domainleri kontrol et
    domainButtons.forEach(function(button) {
        var domain = button.getAttribute('data-domain');

        // Cart içindeki verilerde, type "domain" ve belirli domain ile eşleşen öğeleri bul
        var isInCart = cart.some(function(item) {
            return item.type === 'domain' && item.domain === domain;
        });

        // Eğer domain sepetteyse butonu güncelle
        if (isInCart) {
            button.classList.remove("register");
            button.classList.add("register");
            button.innerHTML = '<span class="fa-solid fa-basket-shopping"></span> Ödeme Yap'; // Buton içeriğini güncelleme
            button.onclick = null; // Tekrar tıklamayı devre dışı bırakma
        }
    });
}

// Her 500 milisaniyede bir butonu kontrol et ve sepete göre güncelle
var intervalID = setInterval(function() {
    if (document.querySelectorAll('.domain-to-cart').length > 0) {
        checkAndUpdateButtonBasedOnCart();
        clearInterval(intervalID); // İşlem tamamlandıysa kontrolü durdur
    }
}, 500);




function domainAddCart(domain, element, premium, price) {
    element.innerHTML = '<span class="icon-spinner"></span> Bekleyiniz';

    const product = {
        productId: generateUUID(), // Rastgele UUID oluşturulur
        domain: domain,
        action: "registration",
        itemName: premium ? "Premium Domain Kaydı" : "Domain Kaydı", // Premium durumu
        type: "domain", // Domain türü
        price: price, // Fiyat bilgisi
        premium: premium, // Premium bilgisi
        pers: [] // İsteğe bağlı boş bir alan
    };

    // LocalStorage'a ekleme işlemi
    addToCart(product);

    // Sepeti sunucuya gönderme işlemi
    sendCartToServer(product, element);
}

// Sepete ürün ekle
function addToCart(product) {
    let cart = JSON.parse(localStorage.getItem('cart')) || [];

    // Ürünü sepete ekliyoruz
    cart.push(product);

    // Sepeti tekrar LocalStorage'a kaydet
    localStorage.setItem('cart', JSON.stringify(cart));

    console.log('Ürün sepete eklendi:', product);
}

// Sepeti sunucuya gönderme fonksiyonu
function sendCartToServer(product, element) {
    fetch('/require/pages/add-to-cart.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify([product]) // Sepet verisini JSON formatında gönderiyoruz
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'success') {
            console.log('Sepet sunucuya başarıyla kaydedildi:', data.cart);
            element.href = './sepet';
            element.onclick = '';
            element.innerHTML = '<span class="fa-solid fa-basket-shopping"></span> Ödeme Yap';
        } else {
            console.error('Sepet kaydedilemedi:', data.message);
        }
    })
    .catch(error => {
        console.error('Sunucuya gönderim sırasında bir hata oluştu:', error);
        element.innerHTML = 'Hata oluştu. Tekrar deneyiniz.';
    });
}

// Rastgele UUID üretmek için basit bir fonksiyon
function generateUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}

</script>
