<?php $pageTitle = 'Doğrulama Kodu'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="icon" href="https://sspanel.serversistemleri.com/favicon.ico" />

    <title>{{ $pageTitle }} - Server Sistemleri</title>

    <style>
           [x-cloak=""],
           [x-cloak="x-cloak"],
           [x-cloak="1"] {
               display: none !important;
           }

           @media (max-width: 1023px) {
               [x-cloak="-lg"] {
                   display: none !important;
               }
           }

           @media (min-width: 1024px) {
               [x-cloak="lg"] {
                   display: none !important;
               }
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
       <style>
           :root {
               --danger-50: 254, 242, 242;
               --danger-100: 254, 226, 226;
               --danger-200: 254, 202, 202;
               --danger-300: 252, 165, 165;
               --danger-400: 248, 113, 113;
               --danger-500: 239, 68, 68;
               --danger-600: 220, 38, 38;
               --danger-700: 185, 28, 28;
               --danger-800: 153, 27, 27;
               --danger-900: 127, 29, 29;
               --danger-950: 69, 10, 10;
               --gray-50: 250, 250, 250;
               --gray-100: 244, 244, 245;
               --gray-200: 228, 228, 231;
               --gray-300: 212, 212, 216;
               --gray-400: 161, 161, 170;
               --gray-500: 113, 113, 122;
               --gray-600: 82, 82, 91;
               --gray-700: 63, 63, 70;
               --gray-800: 39, 39, 42;
               --gray-900: 24, 24, 27;
               --gray-950: 9, 9, 11;
               --info-50: 239, 246, 255;
               --info-100: 219, 234, 254;
               --info-200: 191, 219, 254;
               --info-300: 147, 197, 253;
               --info-400: 96, 165, 250;
               --info-500: 59, 130, 246;
               --info-600: 37, 99, 235;
               --info-700: 29, 78, 216;
               --info-800: 30, 64, 175;
               --info-900: 30, 58, 138;
               --info-950: 23, 37, 84;
               --primary-50: 244, 250, 252;
               --primary-100: 232, 244, 249;
               --primary-200: 198, 228, 241;
               --primary-300: 164, 211, 232;
               --primary-400: 96, 179, 215;
               --primary-500: 28, 146, 198;
               --primary-600: 25, 131, 178;
               --primary-700: 21, 110, 149;
               --primary-800: 17, 88, 119;
               --primary-900: 14, 72, 97;
               --primary-950: 8, 44, 59;
               --success-50: 240, 253, 244;
               --success-100: 220, 252, 231;
               --success-200: 187, 247, 208;
               --success-300: 134, 239, 172;
               --success-400: 74, 222, 128;
               --success-500: 34, 197, 94;
               --success-600: 22, 163, 74;
               --success-700: 21, 128, 61;
               --success-800: 22, 101, 52;
               --success-900: 20, 83, 45;
               --success-950: 5, 46, 22;
               --warning-50: 255, 251, 235;
               --warning-100: 254, 243, 199;
               --warning-200: 253, 230, 138;
               --warning-300: 252, 211, 77;
               --warning-400: 251, 191, 36;
               --warning-500: 245, 158, 11;
               --warning-600: 217, 119, 6;
               --warning-700: 180, 83, 9;
               --warning-800: 146, 64, 14;
               --warning-900: 120, 53, 15;
               --warning-950: 69, 26, 3;
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

       <link rel="preconnect" href="https://fonts.bunny.net" />
       <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

       <style>
           :root {
               --font-family: "Inter";
               --sidebar-width: 20rem;
               --collapsed-sidebar-width: 4.5rem;
               --default-theme-mode: light;
           }
       </style>

       <script>
           const theme = localStorage.getItem("theme") ?? "system";
           if (theme === "dark" || (theme === "system" && window.matchMedia("(prefers-color-scheme: dark)").matches)) {
               document.documentElement.classList.add("dark");
           }
       </script>

       <!-- Livewire Styles -->
       <style>
           [wire\:loading][wire\:loading],
           [wire\:loading\.delay][wire\:loading\.delay],
           [wire\:loading\.inline-block][wire\:loading\.inline-block],
           [wire\:loading\.inline][wire\:loading\.inline],
           [wire\:loading\.block][wire\:loading\.block],
           [wire\:loading\.flex][wire\:loading\.flex],
           [wire\:loading\.table][wire\:loading\.table],
           [wire\:loading\.grid][wire\:loading\.grid],
           [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
               display: none;
           }
           [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
           [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
           [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
           [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
           [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
           [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
           [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
           [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
               display: none;
           }
           [wire\:offline][wire\:offline] {
               display: none;
           }
           [wire\:dirty]:not(textarea):not(input):not(select) {
               display: none;
           }
           :root {
               --livewire-progress-bar-color: #2299dd;
           }
           [x-cloak] {
               display: none !important;
           }
       </style>
   </head>
<body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
    <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
        <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
                <section class="grid auto-cols-fr gap-y-6">
                    <header class="fi-simple-header flex flex-col items-center">
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" style="width: 250px;" class="l-none fi-logo flex mb-4" />
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" style="width: 250px;" class="d-none fi-logo flex mb-4" />
                    </header>
                      <h1 style="text-align:center;" class="text-4xl font-bold tracking-tight text-gray-900 sm:text-5xl md:text-6xl">
                      <span class="block">
                      <span class="text-transparent bg-clip-text bg-gradient-to-tr to-cyan-500 from-blue-600">
                      {{ $message }}
                      </span>

                      </span>
                      </h1>

                      <?php if (isset($client_firstname)) {
                        ?>
                        <a href="/dashboard" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" id="submit-button">
                        <span class="fi-btn-label">ANA SAYFAYA DÖN</span>
                        </a>
                        <?php
                      }else {
                        ?>
                        <a href="/login" style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" id="submit-button">
                        <span class="fi-btn-label">GİRİŞ YAP</span>
                        </a>
                        <?php
                      } ?>
                </section>
            </div>
        </main>
    </div>
</div>


<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>
</body>
</html>
