let formSubmitted = false

document.addEventListener(
    'submit',
    () => (formSubmitted = true),
)

shouldPreventNavigation = () => {
    if (formSubmitted) {
        return
    }

    return (
        window.jsMd5(
            JSON.stringify($wire.data).replace(/\\/g, ''),
        ) !== $wire.savedDataHash ||
        $wire?.__instance?.effects?.redirect
    )
}

const showUnsavedChangesAlert = () => {
    return confirm(@js(__('filament-panels::unsaved-changes-alert.ozn123')))
}

document.addEventListener('livewire:navigate', (event) => {
    if (typeof @this !== 'undefined') {
        if (!shouldPreventNavigation()) {
            return
        }

        if (showUnsavedChangesAlert()) {
            return
        }

        event.preventDefault()
    }
})

window.addEventListener('beforeunload', (event) => {
    if (!shouldPreventNavigation()) {
        return
    }

    event.preventDefault()
    event.returnValue = true
})
