<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;

class LoadClientProducts
{
    public function handle($request, Closure $next)
    {
        if (Session::has('client')) {
            $clientId = Session::get('client');
            $products = getClientProducts($clientId);

            if (isset($products['products']['product'])) {
                view()->share('clientProducts', $products['products']['product']);
            } else {
                view()->share('clientProducts', []);
            }
        } else {
            view()->share('clientProducts', []);
        }

        return $next($request);
    }
}
