<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Session;

class TicketController extends Controller
{
    protected $whmcs;

    public function __construct(WHMCSService $whmcs)
    {
        $this->whmcs = $whmcs;
    }

    public function submitTicket(Request $request)
    {
        $clientId = Session::get('client');
        $ticketId = $request->input('ticket_id');
        $message = $request->input('message');
        $attachment = $request->file('user_avatar');

        $response = $this->whmcs->addTicketReply($clientId, $ticketId, $message, $attachment);

        if ($response['result'] == 'success') {
            return redirect()->back()->with('success', 'Mesaj başarıyla gönderildi!');
        } else {
            return redirect()->back()->with('error', 'Mesaj gönderilirken bir hata oluştu: ' . $response['message']);
        }
    }

    public function downloadAttachment($ticketId, $filename, $relatedid, $type)
    {
  
        $api_url = 'https://customer.serversistemleri.com/includes/api.php';
        $api_identifier = 'X0dhrkxgQIaNChaDxsR8UNaXmZTp2GbD';
        $api_secret = 'o44R1QTQTVJ1ElyuitGZjFNj6gXc28h8';

        // API talep parametrelerini oluşturma
        $postfields = array(
            'action' => 'GetTicketAttachment',
            'identifier' => $api_identifier,
            'secret' => $api_secret,
            'relatedid' => $relatedid,
            'type' => $type,
            'index' => 0, // Varsayılan olarak ilk dosyayı indir
            'responsetype' => 'json',
        );

        // CURL oturumunu başlatma
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postfields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        // API talebini gönderme ve yanıtı alma
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
            exit;
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Yanıtı işleme
        $response_data = json_decode($response, true);

        if ($http_code == 200 && isset($response_data['result']) && $response_data['result'] == 'success') {
            // Dosya içeriğini base64 olarak alıyoruz ve decode ediyoruz
            $file_data = base64_decode($response_data['data']);

            // Dosya içeriğini ve türünü ayarlayın
            return response($file_data)
                ->header('Content-Type', 'application/octet-stream')
                ->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
        } else {
            return redirect()->back()->with('error', 'Dosya indirilemedi.');
        }
    }

    public function newTicket(Request $request)
    {

        $clientId = Session::get('client');
        $subject = $request->input('title');
        $deptid = $request->input('department');
        $relatedService = $request->input('related_service');
        $priority = $request->input('priority');
        $message = $request->input('message');


        // Call WHMCS API to open a new ticket
        $response = $this->whmcs->openTicket($clientId, $priority, $message, $subject, $deptid, $relatedService);

        if ($response['result'] == 'success') {
            return redirect()->back()->with('success', 'Destek Talebi Başarı ile oluşturuldu');
        } else {
            return redirect()->back()->with('error', 'Mesaj gönderilirken bir hata oluştu: ' . $response['message']);
        }
    }


}
