<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\EFatura\Client;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\DatabaseController;

class EInvoiceController extends Controller
{
  protected $db;

    public function __construct()
    {
        $this->db = new DatabaseController();
      }
    public function getInvoice($id)
    {

        $efatura = $this->db->GetData('edm_data', ['uuid' => $id]);
        $firstItem = $efatura->first();
        if ($firstItem) {
            $edm_id = $firstItem->edm_id;
        } else {
            echo "Kayıt bulunamadı.";
        }
        // Dosya yolunu belirle
        $directoryPath = "/home/ssplus/sspanel.serversistemleri.com/resources/e-invoice/";
        $filePath = $directoryPath . "/{$id}.pdf";

        // Dosya mevcutsa doğrudan indirme işlemi yap
        if (File::exists($filePath)) {
            return Response::download($filePath);
        }

        // Dosya mevcut değilse $client işlemlerini yap
        $client = new Client("https://portal2.edmbilisim.com.tr/EFaturaEDM/EFaturaEDM.svc?singleWsdl");
        $login = $client->login("sspanelapi", "Unna1612**//");

        if (!$login) {
            return response()->json(['error' => 'Login failed.', 'details' => $client->getHata()], 500);
        }

        $invoiceDetails = $client->getSingleInvoice($edm_id);

        if (!$invoiceDetails) {
            return response()->json(['error' => 'Invoice not found.'], 404);
        }

        // Base64 kodlu PDF içeriğini al
        $pdfContent = $invoiceDetails;

        // Dizin mevcut değilse oluştur
        if (!File::exists($directoryPath)) {
            File::makeDirectory($directoryPath, 0755, true);
        }

        // PDF dosyasını kaydetme
        File::put($filePath, $pdfContent);

        // PDF dosyasını otomatik olarak indirme
        return Response::download($filePath)->deleteFileAfterSend(false);
    }
}
