<?php

namespace App\Filament\Resources\EmployeeResource\Pages;

use App\Filament\Resources\EmployeeResource;
use Filament\Actions;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Pages\ManageRelatedRecords;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\MaxWidth;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Contracts\Support\Htmlable;

class ManageBankAccounts extends ManageRelatedRecords
{
    protected static string $resource = EmployeeResource::class;

    protected static string $relationship = 'bankAccounts';

    protected static ?string $navigationIcon = 'heroicon-m-banknotes';
    protected static ?string $navigationLabel = 'Hesap Numaraları';

    private static ?string $modelLabel = 'Hesap Numarası';

    public function getTitle(): string | Htmlable
    {
        return self::$navigationLabel;
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Banka')
                    ->maxLength(255)
                    ->required(),

                Forms\Components\TextInput::make('iban')
                    ->label('IBAN')
                    ->maxLength(34)
                    // ->unique(modifyRuleUsing: function (Unique $rule) {
                    //     return $rule->where('model_id', 1);
                    // })
                    ->mask('aa99 9999 9999 9999 9999 9999 99')
                    ->required(),

                Forms\Components\TextInput::make('branch_name')
                    ->label('Şube')
                    ->maxLength(255),

                Forms\Components\TextInput::make('account_number')
                    ->label('Hesap Numarası')
                    ->maxLength(255),
            ])
            ->columns(1);
    }

    public function table(Table $table): Table
    {
        return $table
            // ->recordTitleAttribute('name')
            // ->recordTitle(fn ($record): string => {$record->name})
            // ->heading('Clients')
            // ->description('Manage your clients here.')
            // ->modelLabel(self::$modelLabel)
            ->searchDebounce('1000ms')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Banka')
                    ->weight(FontWeight::Medium)
                    ->searchable(),

                Tables\Columns\TextColumn::make('iban')
                    ->label('IBAN')
                    ->copyable()
                    ->copyMessageDuration(1100),

                Tables\Columns\TextColumn::make('branch_name')
                    ->label('Şube'),

                Tables\Columns\TextColumn::make('account_number')
                    ->label('Hesap Numarası'),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Oluşturma')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Güncelleme')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->modelLabel(self::$modelLabel)
                    ->modalWidth(MaxWidth::Large)
                    ->slideOver()
                    ->createAnother(false),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make()
                        ->modalHeading(__('filament-actions::view.single.modal.heading', ['label' => self::$modelLabel]))
                        ->modalWidth(MaxWidth::Large)
                        ->slideOver(),

                    Tables\Actions\EditAction::make()
                        ->modalHeading(__('filament-actions::edit.single.modal.heading', ['label' => self::$modelLabel]))
                        ->modalWidth(MaxWidth::Large)
                        ->slideOver(),

                    Tables\Actions\DeleteAction::make()
                        ->modalHeading(__('filament-actions::delete.single.modal.heading', ['label' => self::$modelLabel])),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateHeading(__('filament-tables::table.empty.heading', ['model' => self::$modelLabel]))
            ->emptyStateDescription(__('filament-tables::table.empty.description', ['model' => self::$modelLabel]));
    }
}
