<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CountryResource\Pages;
use App\Filament\Resources\CountryResource\RelationManagers;
use App\Models\Country;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Support\Enums\FontWeight;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CountryResource extends Resource
{
    protected static ?string $model = Country::class;

    protected static ?string $modelLabel = 'Ülke';
    protected static ?string $pluralModelLabel = 'Ülkeler';

    // protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationLabel = 'Ülkeler';
    protected static ?string $navigationGroup = 'Yapılandırma';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make(self::$modelLabel.' Bilgileri')
                    ->columns(4)
                    ->schema([
                        Forms\Components\TextInput::make('name')
                            ->label('Başlık')
                            ->placeholder('Türkiye')
                            ->maxLength(100)
                            ->required(),

                        Forms\Components\TextInput::make('alpha_2')
                            ->label('Alpha 2 Kodu')
                            ->placeholder('TR')
                            ->maxLength(2)
                            ->required(),

                        Forms\Components\TextInput::make('alpha_3')
                            ->label('Alpha 3 Kodu')
                            ->placeholder('TUR')
                            ->maxLength(3)
                            ->required(),

                        Forms\Components\TextInput::make('phone_code')
                            ->label('Telefon Kodu')
                            ->placeholder('90')
                            ->maxLength(5)
                            ->required(),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Ülke')
                    ->weight(FontWeight::Medium)
                    ->searchable(),

                Tables\Columns\TextColumn::make('alpha_2')
                    ->label('Alpha 2 Kodu')
                    ->badge()
                    ->searchable(),

                Tables\Columns\TextColumn::make('alpha_3')
                    ->label('Alpha 3 Kodu')
                    ->badge()
                    ->searchable(),

                Tables\Columns\TextColumn::make('phone_code')
                    ->label('Telefon Kodu')
                    ->searchable(),

                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Durum'),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Oluşturma')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Güncelleme')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\EditAction::make(),
                    // Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCountries::route('/'),
            'create' => Pages\CreateCountry::route('/create'),
            'edit' => Pages\EditCountry::route('/{record}/edit'),
        ];
    }
}
