<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum MilitaryServiceStatus: int implements HasLabel
{
    case COMPLETED      = 1;
    case EXEMPT         = 2;
    case DEFERRED       = 3;
    case NOT_YET_DONE   = 4;
    case ACTIVE_DUTY    = 5;

    public function getLabel(): string
    {
        return match ($this) {
            self::COMPLETED     => 'Tamamladı',
            self::EXEMPT        => 'Muaf',
            self::DEFERRED      => 'Tecilli',
            self::NOT_YET_DONE  => 'Henüz Yapmadı',
            self::ACTIVE_DUTY   => 'Aktif Hizmette',
        };
    }
}
