<?php
$spec = [
  '206-1' => [
      "user" => [
          "name" => "Özellik Alanı",
          "icon" => "ssicon-xtreme-server",
          "desc" => "",
      ],
  ],
  '207-1' => [
    "user" => [
        "name" => "Özellik Alanı",
        "icon" => "ssicon-xtreme-server",
        "desc" => "",
    ],
  ],
  '208-1' => [
    "user" => [
        "name" => "Özellik Alanı",
        "icon" => "ssicon-xtreme-server",
        "desc" => "",
    ],
  ],
  '209-1' => [
    "user" => [
        "name" => "Özellik Alanı",
        "icon" => "ssicon-xtreme-server",
        "desc" => "",
    ],
  ],
];
?>


<style media="screen">
    .banner-bg {
        padding-top: 4rem;
    }
    .fontstyle {
        font-weight: bold;
    }

    .urun-ozellikleri {
        font-size: 18px;
        display: flex;
        align-items: center;
        padding-top: 8px;
        padding-bottom: 8px;
        border-bottom: 1px solid rgba(0, 0, 0, 0.1);
    }

    .urun-ozellikleri i {
        font-size: 24px;
        color: #6c757d;
        transition: color 0.3s ease;
        display: flex;
        justify-content: center;
        align-items: center;
        width: 40px; /* Sabit genişlik */
        height: 40px; /* Sabit yükseklik */
        margin-right: 12px;
    }

    .urun-ozellikleri small {
        font-size: 16px;
        color: #333;
    }

    .urun-ozellikleri:hover {
        background-color: #f4f6fc;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .urun-ozellikleri:hover i {
        color: #495057;
    }
</style>
<style media="screen">
.banner-bg .col-xl-12{
  padding-top: 50px;
}

.banner-bg {
    background-image: linear-gradient(90deg, #000000f5 30%, rgba(8, 15, 44, 0)),
                      url(https://serversistemleri.com/assets/img/nas-barindirma.webp) !important;
    background-size: cover !important;
    background-position: center !important;
}

.text-custom{
  color: black;
}
.banner-bg.soldark{
background: linear-gradient(90deg, #000000f5 30%, rgba(8, 15, 44, 0));
}
/* Mobilde arka plan resmini kaldır ve beyaz yap */
@media (max-width: 768px) {
  .banner-bg {
      background-position: 75% !important;
  }
  .banner-bg .col-xl-12{
    padding-top: 0px;
  }

  .text-custom{
      color: white;
  }
}
</style>
<section class="banner-bg bg-dark ssl-banner">
    <div class="container">
        <div class="row align-items-center g-4">
            <div class="col-xl-12">
                <div class="pb-40">
                    <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">NAS Barındırma</h1>
                    <p class="text-white mb-8 max-text-60 text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                      Türk Telekom altyapıları ile eşzamanlı yedekli olarak sunulan 10 Gbps hat kapasitemiz sayesinde %99,99 ağ erişim garantisi sağlıyoruz. Ayrıca, kullanıcı dostu yönetim panelimiz üzerinden tüm trafik istatistiklerini anlık olarak takip edebilme imkânı sunmaktayız.
                    </p>
                </div>
            </div>

        </div>
    </div>
</section>
<?php $urunler = $whmcs->ProGet(25); ?>
<section class="">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="text-center">
                    <h2 class="mb-8">Türkiye NAS Barındırma</h2>
                </div>
            </div>

            <div class="col-12">
                <div class="tab-content sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                    <div class="tab-pane fade show active" role="tabpanel">
                        <div class="row g-4">
                            <?php foreach ($urunler as $product): ?>

                            <div class="paket-baslat col-xl-3 col-md-6">
                                <div class="paket-ust-3">
                                    <svg id="katman_1" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 282.9 51.7">
                                        <path id="Path_706" d="M280.2,169.9l-4.4,189.7" />
                                        <path id="Path_7061" data-name="Path_706" d="M282,92.7l-1.8,77.2" />
                                        <path id="Path_7062" data-name="Path_706" d="M282.9,51.7l-1,41" />
                                        <path id="Path_7063" data-name="Path_706" d="M.2,51.7L0,12,233.4,0c27.4,0,49.6,23.1,49.6,51.7" />
                                        <path id="Path_7064" data-name="Path_706" d="M.5,92.7l-.2-41" />
                                        <path id="Path_7065" data-name="Path_706" d="M1.1,192.5L.5,92.7" />
                                        <path id="Path_7066" data-name="Path_706" d="M3.3,573.9L1.1,192.5" />
                                        <path id="Path_7067" data-name="Path_706" d="M270.6,579.2l-267.3-5.4" />
                                        <path id="Path_7068" data-name="Path_706" d="M275.8,359.6l-5.1,219.6" />
                                    </svg>
                                </div>
                                <div class="price-card-item-one position-relative overflow-hidden bg-white px-7 py-9 border-end rounded-3" style="border-radius: 0 50px 0 0 !important;">
                                    <div class="text-center">
                                        <img style="height: 82px;" src="<?php echo $site_url; ?>assets/img/icons/add-server.svg" alt="image" class="img-fluid mb-5" />
                                        <h6 class="mb-1"><?php echo str_replace('-', ' ', $product['name']); ?></h6>
                                        <div class="mt-5">
                                            <div class="monthly-price">
                                                <h4 class="mb-0"><try>₺<?php echo $product['pricing']['TRY']['monthly']; ?></try><usd>$<?php echo $product['pricing']['USD']['monthly']; ?></usd></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="monthly-price">
                                      <a class="btn btn-dark btn-arrow btn-lg w-100 fs-14 fw-bolder rounded mt-6" onclick="addToProduct(<?php echo $product['pid']; ?>)">
                                        <span class="btn-arrow__text">
                                          Sepete Ekle
                                          <span class="btn-arrow__icon">
                                            <i class="las la-arrow-right"></i>
                                          </span>
                                        </span>
                                      </a>
                                    </div>
                                    <div class="mt-6">
                                        <ul class="list-unstyled d-flex flex-column gap-1 mb-0">
                                          <?php foreach ($spec[$product['pid']] as $specKey => $specDetails): ?>
                                            <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                              <?php if (isset($specDetails['icon'])): ?>
                                                <i class="<?php echo $specDetails['icon']; ?>"></i>
                                              <?php else: ?>
                                                <i class="fa-solid fa-user-plus"></i>
                                              <?php endif; ?>

                                              <small>
                                                <?php if (isset($specDetails['name'])): ?>
                                                  <span class="fw-bold"><?php echo $specDetails['name']; ?></span>
                                                <?php endif; ?>

                                                <?php if (isset($specDetails['desc'])): ?>
                                                  <span><?php echo $specDetails['desc']; ?></span>
                                                <?php endif; ?>
                                              </small>
                                            </li>
                                          <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container" style="margin-top:30px;">
    <div class="row">
        <div class="col-12">
            <div class="bg-dark px-sm-10 px-6 pt-80 pb-80 rounded-3">
                <div class="row g-4">
                    <div class="col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                        <div class="px-5 py-7 rounded-3 side-blog-item transition">
                            <img style="width:50%;" src="<?php echo $site_url; ?>assets/img/icons/add-server-white.svg" alt="Kolay Kurulum" class="img-fluid mb-3" />
                            <h6 class="text-white mb-3">Kolay NAS Sunucu Kurulumu</h6>
                            <p class="text-white mb-0 text-opacity-75">NAS sunucunuzu dakikalar içinde yapılandırın. Kullanıcı dostu arayüzümüz ile verilerinizi kolayca yönetebilirsiniz.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="400" data-sal-easing="ease-in-out-sine">
                        <div class="px-5 py-7 rounded-3 side-blog-item transition bg-white bg-opacity-5">
                            <img style="width:50%;" src="<?php echo $site_url; ?>assets/img/icons/information-white.svg" alt="Kesintisiz Destek" class="img-fluid mb-3" />
                            <h6 class="text-white mb-3">7/24 Teknik Destek</h6>
                            <p class="text-white mb-0 text-opacity-75">NAS sunucunuzun performansını maksimize etmek için deneyimli teknik ekibimiz 7/24 hizmetinizde.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="500" data-sal-easing="ease-in-out-sine">
                        <div class="px-5 py-7 rounded-3 side-blog-item transition">
                            <img style="width:50%;" src="<?php echo $site_url; ?>assets/img/icons/secure-white.svg" alt="Veri Güvenliği" />
                            <h6 class="text-white mb-3">Yüksek Güvenlik ve Erişilebilirlik</h6>
                            <p class="text-white mb-0 text-opacity-75">NAS sunucularımız gelişmiş güvenlik önlemleri ile verilerinizi korur ve her zaman erişilebilir olmasını sağlar.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="pt-120 pb-120 bg-secondary">
    <div class="pb-60">
        <div class="container">
            <div class="row g-4 align-items-center justify-content-xl-between">
              <div class="container">
                  <div class="row justify-content-center">
                      <div class="col-12">
                          <div class="text-center">
                              <h2 class="text-dark mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                                Hizmetlerimiz ile tanışın!
                              </h2>
                          </div>
                      </div>
                  </div>
              </div>
            </div>
        </div>
    </div>
    <style media="screen">
        .col-sm-6.col-md-4.feature-list__item.sal-animate:hover {
          background: white;
          border-radius: 25px;
        }
        </style>
        <div class="container">
    <div class="row g-4 g-md-0 feature-list">
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-cloud-server1"></i>
                </div>
                <h6 class="mb-5">NAS Depolama Çözümleri</h6>
                <p class="mb-0">
                    NAS sunucularımız, verilerinizi güvenli bir şekilde depolamanıza ve yönetmenize olanak tanır. Her zaman erişilebilir, güvenilir bir altyapı sunuyoruz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-server-eco"></i>
                </div>
                <h6 class="mb-5">Kolay Yönetim Paneli</h6>
                <p class="mb-0">
                    NAS yönetimi için tasarlanan kullanıcı dostu panelimiz, dosyalarınızı kolayca organize etmenize ve paylaşmanıza olanak tanır.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-linux"></i>
                </div>
                <h6 class="mb-5">Gelişmiş Yedekleme Sistemleri</h6>
                <p class="mb-0">
                    NAS sunucularımız, otomatik yedekleme ve veri kurtarma özellikleri ile kritik verilerinizi güvende tutar.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-ftp"></i>
                </div>
                <h6 class="mb-5">Çoklu Kullanıcı Erişimi</h6>
                <p class="mb-0">
                    Aynı anda birden fazla kullanıcı ile NAS depolamanıza erişin ve dosya paylaşımını kolaylaştırın. Tam yetkilendirme seçenekleri sunarız.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-handshake"></i>
                </div>
                <h6 class="mb-5">Esnek Depolama Seçenekleri</h6>
                <p class="mb-0">
                    NAS sunucularımız farklı kapasite seçenekleri ile ihtiyacınıza göre şekillenir. Depolama alanınızı kolayca genişletebilirsiniz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size: 75px;" class="ssicon-dns"></i>
                </div>
                <h6 class="mb-5">Gelişmiş Güvenlik Özellikleri</h6>
                <p class="mb-0">
                    NAS sunucularımız, veri şifreleme ve iki faktörlü kimlik doğrulama gibi güvenlik önlemleriyle verilerinizi korur.
                </p>
            </div>
        </div>
    </div>
</div>

<?php
$faq = [
    [
        "question" => "Herhangi bir gizli ücret mevcut mudur?",
        "answer" => "NAS barındırma hizmetlerimize sitemizde görmüş olduğunuz ücretler ile sadece kanunen zorunlu resmi vergiler eklenerek sahip olursunuz, herhangi bir operasyonel ücret mevcut değildir."
    ],
    [
        "question" => "Uptime oranınız nedir?",
        "answer" => "Tüm NAS barındırma çözümlerimize çok noktadan yedekli donanım altyapımız ve birden fazla operatörden sağlanan network bağlantılarımız ile %99,99 uptime garantisi sunulmaktadır."
    ],
    [
        "question" => "Network Altyapınızda Hangi Donanımı Kullanıyorsunuz?",
        "answer" => "NAS sistemleri için tasarlanan altyapımızda Juniper EX serisi yönlendiriciler kullanılmakta ve sıfır paket kaybı (zero-packet-loss) prensibi ile hizmet verilmektedir."
    ],
    [
        "question" => "NAS sunucularınız hangi işletim sistemini destekliyor?",
        "answer" => "Windows, Linux, BSD işletim sistemleri farklı sürümleri ile birlikte NAS sunucu çözümlerimizde desteklenmektedir."
    ],
    [
        "question" => "NAS sunucularınız hangi sanallaştırma yazılımını kullanıyor?",
        "answer" => "NAS sunucularımız Türkiye ve Almanya lokasyonlarında, sektörün lider sanallaştırma ortamı olan VMware Enterprise Plus sistemi üzerinde çalışmaktadır."
    ],
    [
        "question" => "NAS sunucularınızı nasıl yönetebilirsiniz?",
        "answer" => "Yönetim panelinizden NAS sunucunuzun gerçek zamanlı durumu, disk kullanımını görebilir ve gerektiğinde yedekleme işlemlerini başlatabilirsiniz."
    ],
    [
        "question" => "Sunucularınızda kesintiler veya performans düşüşleri yaşanabilir mi?",
        "answer" => "NAS sunucular anlık olarak takip edilmektedir ve beklenmedik yoğunlukların oluşması durumunda kaynak aktarımı yapılarak verilerinizin kesintisiz şekilde erişilebilir olması sağlanır."
    ],
    [
        "question" => "NAS barındırma hizmeti ile verilerimi nasıl koruyabilirim?",
        "answer" => "NAS barındırma hizmetlerimiz, otomatik yedekleme, RAID yapılandırması ve şifreleme gibi özellikler sunarak verilerinizi güvenli bir şekilde saklamanızı sağlar."
    ]
];
?>


 <div class="pt-60 pb-120">
   <div class="pb-40">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-md-10 col-lg-8 col-xl-7">
                   <div class="text-center sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                       <h2>
                           Sıkça Sorulan Sorular
                       </h2>
                   </div>
               </div>
           </div>
       </div>
   </div>
   <div class="container">
       <div class="row g-4 justify-content-center">
           <div class="col-12">
               <?php $faq_sira = 0; ?>
               <div class="accordion border-0 vps-hosting-accordion" id="accordionFaq2">
                 <div class="row">
                   <?php foreach ($faq as $key): ?>
                       <?php $faq_sira = $faq_sira + 1; ?>
                     <div class="col-sm-6">
                       <div class="accordion-item border rounded-3 mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                           <h2 class="accordion-header">
                               <button class="accordion-button bg-transparent collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-<?php echo $faq_sira; ?>" aria-expanded="false" aria-controls="faq-<?php echo $faq_sira; ?>">
                                   <span class="text-body fs-16 fw-bold"><?php echo $key['question']; ?></span>
                               </button>
                           </h2>
                           <div id="faq-<?php echo $faq_sira; ?>" class="accordion-collapse collapse" data-bs-parent="#faq-<?php echo $faq_sira; ?>" style="">
                               <div class="accordion-body pt-0">
                                   <?php echo $key['answer']; ?>
                               </div>
                           </div>
                       </div>
                     </div>
                   <?php endforeach; ?>
                 </div>
               </div>
           </div>
       </div>
   </div>
</div>
<script type="text/javascript">
// Sepete ekleme işlemi
function addToProduct(productId) {
    const product = {
        productId: productId, // Ürün ID'sini atıyoruz
        domain: "nasbarindirma", // Domain gerekli değilse boş bırakıyoruz
        action: "nasbarindirma", // İşlem türü
        itemName: "NAS Barındırma", // Ürün adı
        type: "nasbarindirma" // Ürün türü
    };

    // Sepete ekleme işlemi
    addToCart(product);

    // Sepeti sunucuya gönderme işlemi
    sendCartToServer(product);
}

// Sepete ürün ekle
function addToCart(product) {
    let cart = JSON.parse(localStorage.getItem('cart')) || [];
    cart.push(product); // Ürünü sepete ekliyoruz
    localStorage.setItem('cart', JSON.stringify(cart));
    console.log('Ürün sepete eklendi:', product);
}

// Sepeti sunucuya gönderme fonksiyonu
function sendCartToServer(product) {
    fetch('/require/pages/add-to-cart.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify([product]) // Sepet verisini JSON formatında gönderiyoruz
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'success') {
            console.log('Sepet sunucuya başarıyla kaydedildi:', data.cart);
            window.location.href = '/sepet'; // İşlem başarılı ise yönlendiriyoruz
        } else {
            console.error('Sepet kaydedilemedi:', data.message);
        }
    })
    .catch(error => {
        console.error('Sunucuya gönderim sırasında bir hata oluştu:', error);
    });
}
</script>
