<?php if ($item['action'] == 'registration'): ?>
  <?php
  $parts = explode('.', $item['domain']);

  if (count($parts) == 2) {
      $extension = $parts[1]; // 'com' veya 'net' gibi
  }
  elseif (count($parts) == 3) {
      $extension = $parts[1] . '.' . $parts[2]; // 'com.tr' gibi
  }
  $domainPrices = $whmcs->GetTLDPricing($extension);
    ?>
  <div class="cart-item">
      <h4>Alan Adı Kaydı</h4>
      <p id="service-duration-<?php echo $item['productId']; ?>" data-domain="<?php echo $item['domain']; ?>">
        <?php echo $item['domain'] ?> - Ürün / Hizmet - (1 Yıl)
      </p>
      <div class="mt-3">
        <div class="row">
          <div class="col-sm-10">
            <usd style="width:100%;">
              <select class="price-usd form-select" data-product-id="<?php echo $item['productId']; ?>" onchange="updateDuration(this)">
                <?php
                $periods = [
                  1 => '1 Yıl',
                  2 => '2 Yıl',
                  3 => '3 Yıl',
                  4 => '4 Yıl',
                  5 => '5 Yıl',
                  6 => '6 Yıl',
                  7 => '7 Yıl',
                  8 => '8 Yıl',
                  9 => '9 Yıl',
                  10 => '10 Yıl',
                ];

                // USD fiyatlarını alalım
                if (isset($domainPrices['register'])) {
                  $pricingUSD = $domainPrices['register'];
                  foreach ($pricingUSD as $year => $priceUSD) {
                    $selected = ($year === 1) ? 'selected' : '';
                    echo '<option value="' . $year . '" data-period="' . $priceUSD . '" ' . $selected . '>' . $periods[$year] . ' - USD ($' . number_format($priceUSD, 2) . ')</option>' . PHP_EOL;
                  }
                }
                ?>
              </select>
            </usd>
            <try style="width:100%;">
              <select class="price-try form-select" data-product-id="<?php echo $item['productId']; ?>" onchange="updateDuration(this)">
                <?php
                if (isset($domainPrices['register'])) {
                  $pricingUSD = $domainPrices['register'];
                  foreach ($pricingUSD as $year => $priceUSD) {
                    $selected = ($year === 1) ? 'selected' : '';
                    echo '<option value="' . $year . '" data-period="' . $priceUSD * $currency_rate . '" ' . $selected . '>' . $periods[$year] . ' - (₺' . number_format($priceUSD * $currency_rate, 2) . ')</option>' . PHP_EOL;
                  }
                }
                ?>
              </select>
            </try>
          </div>
          <div class="col-sm-2">
            <form action="" method="post">
              <input type="hidden" name="delete" value="<?php echo $item['productId']; ?>">
              <button style="width:100%;" type="submit" class="btn btn-warning"><i class="fa-solid fa-trash"></i> Kaldır</button>
            </form>
          </div>
        </div>
        <div style="display:none;">
          <span id="original-price-<?php echo $item['productId']; ?>" class="original-price">0.60</span>
          <span id="discounted-price-<?php echo $item['productId']; ?>" class="discounted-price">0.50 (%20 indirim)</span>
        </div>
      </div>
  </div>
<?php endif; ?>
