<?php
header("Content-Type: application/json; charset=utf-8");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require __DIR__ . '/PHPMailer.php';
require __DIR__ . '/Exception.php';
require __DIR__ . '/SMTP.php';

// Güvelik: Session başlat (Rate limiting için)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$response = [
    "success" => false,
    "message" => ""
];

// Rate Limiting: 60 saniyede bir mail
if (isset($_SESSION['last_mail_sent']) && (time() - $_SESSION['last_mail_sent'] < 60)) {
    $response["message"] = "Çok sık işlem yapıyorsunuz. Lütfen biraz bekleyin.";
    echo json_encode($response);
    exit;
}

// Input Validasyonu
$name = isset($_POST['name']) ? trim(strip_tags($_POST['name'])) : '';
$email = isset($_POST['email']) ? trim(strip_tags($_POST['email'])) : '';
$phone = isset($_POST['phone']) ? trim(strip_tags($_POST['phone'])) : '';
$subject = isset($_POST['subject']) ? trim(strip_tags($_POST['subject'])) : '';
$message = isset($_POST['message']) ? trim(strip_tags($_POST['message'])) : '';

if (empty($name) || empty($email) || empty($message)) {
    $response["message"] = "Lütfen gerekli alanları doldurunuz.";
    echo json_encode($response);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $response["message"] = "Geçersiz e-posta adresi.";
    echo json_encode($response);
    exit;
}

try {
    $mail = new PHPMailer(true);
    $mail->SMTPDebug = 0; // Hata ayıklama çıktısını kapat
    $mail->isSMTP();
    // ÖNERİ: Bu bilgileri environment değişkenlerinden veya config dosyasından çekin.
    $mail->Host       = 'posta.serversistemleri.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'noreply@serversistemleri.com';
    $mail->Password   = '%Sg~~lLz{7Lc';
    $mail->SMTPSecure = 'TLS';
    $mail->Port       = 587;

    $mail->setFrom('noreply@serversistemleri.com', 'İletişim Formu');
    $mail->addAddress('info@fatihsayin.com.tr', 'İletişim Formu');
    $mail->addAddress('info@serversistemleri.com', 'İletişim Formu');
    $mail->ReplyTo = $email;
    $mail->isHTML(true);
    $mail->CharSet = 'utf-8';
    $mail->Subject = 'Web site İletişim Formu: ' . $subject;

    $html = "<h3>Yeni İletişim Mesajı</h3>";
    $html .= "<p><strong>Ad Soyad:</strong> " . htmlspecialchars($name) . "</p>";
    $html .= "<p><strong>E-posta:</strong> " . htmlspecialchars($email) . "</p>";
    $html .= "<p><strong>Telefon:</strong> " . htmlspecialchars($phone) . "</p>";
    $html .= "<p><strong>Konu:</strong> " . htmlspecialchars($subject) . "</p>";
    $html .= "<p><strong>Mesaj:</strong><br>" . nl2br(htmlspecialchars($message)) . "</p>";
    $html .= "<hr><p><small>IP Adresi: " . $_SERVER['REMOTE_ADDR'] . "</small></p>";

    $mail->Body = $html;

    $mail->send();

    $_SESSION['last_mail_sent'] = time();
    $response["success"] = true;
    $response["message"] = "Mesaj başarıyla gönderildi.";
} catch (Exception $e) {
    // Hata detayını kullanıcıya gösterme, logla.
    error_log("Mail Error: " . $mail->ErrorInfo);
    $response["success"] = false;
    $response["message"] = "Mail gönderilemedi. Lütfen daha sonra tekrar deneyin.";
}

// JSON yanıtını düzgün döndür
echo json_encode($response);
exit;
