<?php
session_start();

// POST isteğiyle sepete eklenen ürünleri alıyoruz
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cartItems = json_decode(file_get_contents('php://input'), true);

    // Gelen verilerin geçerli bir array olup olmadığını kontrol et
    if (is_array($cartItems)) {
        // Sepet tanımlı değilse, yeni bir dizi oluştur
        if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = [];
        }

        foreach ($cartItems as $item) {
            // Gelen her bir ürün için gerekli alanların kontrol edilmesi
            if (
                isset($item['productId']) &&
                isset($item['domain']) &&
                isset($item['action']) &&
                !empty($item['domain']) && // Boş domain eklenmesini engeller
                !empty($item['action']) // Boş işlem türü eklenmesini engeller
            ) {
                // Sepete eklenen ürün daha önce var mı kontrolü (domain ve action üzerinden)
                $alreadyInCart = false;
                foreach ($_SESSION['cart'] as $cartItem) {
                    if ($cartItem['domain'] === $item['domain'] && $cartItem['action'] === $item['action']) {
                        $alreadyInCart = true;
                        break;
                    }
                }

                // Ürün zaten sepette değilse sepete ekle
                if (!$alreadyInCart) {
                    $_SESSION['cart'][] = [
                        'productId' => $item['productId'],  // Ürün ID'si
                        'domain' => $item['domain'],        // Domain adı
                        'action' => $item['action'],        // İşlem türü (kayıt, transfer, nameserver, hosting)
                        'itemName' => $item['itemName'],    // Ürün ismi
                        'type' => $item['type'],            // Ürün tipi (domain, hosting)
                        'pers' => $item['pers'] ?? []       // Ek bilgiler, boş dizi olarak tutuluyor
                    ];
                }
            } else {
                // Eksik veya hatalı veri olduğunda hata mesajı döndür
                http_response_code(400);
                echo json_encode(['status' => 'error', 'message' => 'Missing required fields for cart item']);
                exit;
            }
        }

        // İşlem başarılı olursa "200 OK" yanıtı dönelim ve güncellenmiş sepeti gösterelim
        http_response_code(200);
        echo json_encode(['status' => 'success', 'cart' => $_SESSION['cart']]);
    } else {
        // Gelen veri geçerli bir dizi değilse hata döndür
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid data format']);
    }
} else {
    // Geçersiz istek türü
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
