<?php $pageTitle = 'Sepetiniz'; ?>
<?php echo $__env->make("layouts.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php if(!empty($sessionData)): ?>
    <?php
        // Eğer $sessionData zaten bir array ise, json_decode yapmaya gerek yok
        $data = is_array($sessionData) ? $sessionData : json_decode($sessionData, true);
        // $data içinde 'cart' ve 'items' anahtarlarının var olup olmadığını kontrol et
        $items = isset($data['items']) ? $data['items'] : [];

        // WHMCS fiyatlarını içeren JSON dosyasını güvenli bir şekilde kontrol et ve oku
        $whmcsFilePath = '/home/ssplus/sspanel.serversistemleri.com/app/public/whmcs_data.json';
        if (file_exists($whmcsFilePath)) {
            $whmcs_data = json_decode(file_get_contents($whmcsFilePath), true);
        } else {
            $whmcs_data = []; // Dosya bulunamazsa boş array döndür
            Log::error('WHMCS fiyat dosyası bulunamadı: ' . $whmcsFilePath);
        }

        $totalPrice = 0; // Toplam fiyatı sıfırlıyoruz
        $taxRate = 0.20; // KDV oranı %20
        $discountRate = 0.20; // İndirim oranı %20
    ?>
    <?php
    //print_r($sessionData);
    if ($verify == "YOK") {
      header("Location: /");
    }
     ?>
    <main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
        <div class="fi-page fi-dashboard-page">
            <section class="flex flex-col gap-y-8 py-8">
                <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                    <div>
                        <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                            Siparişi Tamamla
                        </h1>
                    </div>
                </header>
            </section>
        </div>
        <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                <div class="fi-ta">
                    <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                        <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">

                        
                        <?php if(!empty($items)): ?>
                        <?php
                            $price = 0;
                            $totalPrice = 0;
                        ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if ($item['type'] == 'hosting'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'hosting') {
                                      // Hosting paketi için
                                      $pid = $item['pid'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">

                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'kurumsalmail'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'kurumsalmail') {
                                      // Hosting paketi için
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'sunucubarindirma'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'sunucubarindirma') {
                                      // Hosting paketi için
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'nasbarindirma'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'nasbarindirma') {
                                      // Hosting paketi için
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">

                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'yedek'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'yedek') {
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'ssl'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'ssl') {
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'license'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'license') {
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $totalPrice = $totalPrice + $price;
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  $productName = $product['name'] ?? 'İsim Yok';
                                              }
                                          }

                                      }
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $productName; ?>
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Ay)
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                                <?php if ($item['type'] == 'cloudserver'): ?>
                                  <?php
                                  if (isset($item['type']) && $item['type'] === 'cloudserver') {
                                      $osmonthly = 0;
                                      $controlmonthly = 0;
                                      $ipmonthly = 0;
                                      $backupmonthly = 0;
                                      $osannually = 0;
                                      $controlannually = 0;
                                      $ipannually = 0;
                                      $backupannually = 0;
                                      // Hosting paketi için
                                      $pid = $item['productId'];
                                      $billingcycle = $item['billingcycle'] ?? 'monthly'; // Eksikse 'monthly' varsayıyoruz
                                      if (isset($whmcs_data['products']['products']['product'])) {
                                          foreach ($whmcs_data['products']['products']['product'] as $product) {
                                              if ($product['pid'] == $pid) {
                                                  $product_name = $product['name'];
                                                  $price = $product['pricing']['USD'][$billingcycle] ?? 0; // USD fiyatını çekiyoruz
                                                  $hf = $product['pricing']['USD'] ?? 0;
                                                  foreach ($product['configoptions']['configoption'][3]['options']['option'] as $option) {
                                                    if ($option['id'] == $item['pers'][0]['os']) {
                                                      $originalName = $option['name'];
                                                      if (strpos($originalName, 'linuxOS') !== false) {
                                                          $osName = str_replace('linuxOS ', '', $originalName);
                                                      } elseif (strpos($originalName, 'winOS') !== false) {
                                                          $osName = str_replace('winOS ', '', $originalName);
                                                      } elseif (strpos($originalName, 'ubuntuOS') !== false) {
                                                          $osName = str_replace('ubuntuOS ', '', $originalName);
                                                      } else {
                                                          $osName = $originalName;
                                                      }
                                                      $osData = "<p id='osPrice' > + <span style='font-weight:bold;'>" . $osName . "</span><usd> $" . $option['pricing']['USD']['monthly'] .  "</usd> </p>";
                                                      $osmonthly +=  $option['pricing']['USD']['monthly'];
                                                      $osannually += $option['pricing']['USD']['annually'];
                                                    }
                                                  }
                                                  foreach ($product['configoptions']['configoption'][0]['options']['option'] as $option) {
                                                    if ($option['id'] == $item['pers'][1]['controlPanel']) {
                                                      $controlData = "<p id='controlPrice' > + <span style='font-weight:bold;'>" . $option['name'] . "</span><usd> $" . $option['pricing']['USD']['monthly'] .  "</usd></p>";
                                                      $controlmonthly +=  $option['pricing']['USD']['monthly'];
                                                      $controlannually += $option['pricing']['USD']['annually'];
                                                    }
                                                  }

                                                  foreach ($product['configoptions']['configoption'][2]['options']['option'] as $option) {
                                                    if ($option['id'] == $item['pers'][2]['ipAddress']) {
                                                      $ipData =  "<p id='ipPrice'> + <span style='font-weight:bold;'>" . $option['name'] . "</span><usd> $" . $option['pricing']['USD']['monthly'] .  "</usd></p>";
                                                      $ipmonthly += $option['pricing']['USD']['monthly'];
                                                      $ipannually += $option['pricing']['USD']['annually'];
                                                    }
                                                  }

                                                  foreach ($product['configoptions']['configoption'][1]['options']['option'] as $option) {
                                                    if ($option['id'] == $item['pers'][3]['backupService']) {
                                                      $backupData =  "<p id='backupPrice'> + <span style='font-weight:bold;'>" . $option['name'] . "</span> <usd> $" . $option['pricing']['USD']['monthly'] .  "</usd> </p>";
                                                      $backupmonthly +=  $option['pricing']['USD']['monthly'];
                                                      $backupannually += $option['pricing']['USD']['annually'];
                                                    }
                                                  }
                                                  $totalPrice = $totalPrice + $price + $osmonthly + $controlmonthly + $ipmonthly + $backupmonthly;

                                                  $monthlyPrice = $osmonthly + $controlmonthly + $ipmonthly + $backupmonthly;
                                                  $annuallyPrice =  $osannually + $controlannually + $ipannually + $backupannually;
                                              }
                                          }

                                      }
                                  }

                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php echo $product_name; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo $item['domain']; ?>
                                                  </p>
                                              </div>
                                          </div>
                                          <?php
                                          $periods = [
                                              'monthly' => '1 Ay',
                                              'annually' => '1 Yıl',
                                              'biennially' => '2 Yıl',
                                              'triennially' => '3 Yıl',
                                          ];
                                           ?>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="billingcycle" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                foreach ($hf as $period => $price) {
                                                                    if (in_array($period, ['monthly', 'annually', 'biennially', 'triennially']) && $price > 0) {
                                                                      if ($period === 'monthly') {
                                                                        $price = $price + $monthlyPrice;
                                                                      }else {
                                                                        $price = $price + $annuallyPrice;
                                                                      }
                                                                        $selected = ($billingcycle == $period) ? 'selected' : ''; // Varsayılan olarak yıllık seçili
                                                                        echo '<option value="' . $period . '" data-period="' . $price . '" ' . $selected . '>' . $periods[$period] . ' - ($' . number_format($price, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                }
                                                                 ?>
                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                    <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                        <div class="min-w-0 flex-1">
                                                            <div class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3">
                                                              <p id="osPrice"> + <span style="font-weight:bold;">Hostname: <?php echo $item['domain'] ?? 'hostname verisi yok'; ?></span> </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <div class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3">
                                                                <?php echo $osData; ?>
                                                              </div>
                                                          </div>
                                                      </div>
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <div class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3">
                                                                <?php echo $controlData; ?>
                                                              </div>
                                                          </div>
                                                      </div>
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <div class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3">
                                                                <?php echo $ipData; ?>
                                                              </div>
                                                          </div>
                                                      </div>
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <div class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3">
                                                                <?php echo $backupData; ?>
                                                              </div>
                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <?php endif; ?>
                                <?php if ($item['type'] == 'register'): ?>
                                  <?php
                                  $domain = explode('.', $item['domain']);
                                  $tld = count($domain) > 2 ? implode('.', array_slice($domain, -2)) : end($domain);

                                  $regperiod = $item['regperiod'];


                                  // JSON'dan ilgili tld ve süre için fiyatı çekiyoruz
                                  if (isset($whmcs_data['tldPricing']['pricing'][$tld]['register'][$regperiod])) {
                                      $price = $whmcs_data['tldPricing']['pricing'][$tld]['register'][$regperiod];
                                      $totalPrice = $totalPrice + $price;
                                      $df = $whmcs_data['tldPricing']['pricing'][$tld]['register'];
                                  }
                                  //print_r($whmcs_data['tldPricing']['pricing']["com.tr"]['register']);
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                      <?php if(isset($item['domaintype'])): ?>
                                                          Alan Adı Kaydı
                                                      <?php elseif(isset($item['pid'])): ?>
                                                          Hosting Paketi
                                                      <?php endif; ?>
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="regperiod" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                $periods = [
                                                                  1 => '1 Yıl',
                                                                  2 => '2 Yıl',
                                                                  3 => '3 Yıl',
                                                                  4 => '4 Yıl',
                                                                  5 => '5 Yıl',
                                                                  6 => '6 Yıl',
                                                                  7 => '7 Yıl',
                                                                  8 => '8 Yıl',
                                                                  9 => '9 Yıl',
                                                                  10 => '10 Yıl',
                                                                ];

                                                                // $df dizisinin varlığını kontrol edin ve kullanın
                                                                if (isset($df) && is_array($df)) {
                                                                    foreach ($df as $year => $priceUSD) {
                                                                        // Seçilen yıl varsayılan olarak 1 yıl
                                                                        $selected = ($item['regperiod'] == $year) ? 'selected' : '';
                                                                        // Fiyatı döviz kuru ile çarpıp formatlayarak seçenekleri oluşturuyoruz
                                                                        echo '<option value="' . $year . '" data-period="' . $priceUSD . '" ' . $selected . '>' . $periods[$year] . ' - ($' . number_format($priceUSD, 2) . ')</option>' . PHP_EOL;
                                                                    }
                                                                } else {
                                                                    echo '<option value="">Fiyat bilgisi bulunamadı</option>';
                                                                }
                                                                ?>

                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>

                                <?php if (isset($item['action']) && $item['action'] == 'transfer'):  ?>
                                  <?php
                                  $domain = explode('.', $item['domain']);
                                  $tld = count($domain) > 2 ? implode('.', array_slice($domain, -2)) : end($domain);

                                  $regperiod = 1;


                                  // JSON'dan ilgili tld ve süre için fiyatı çekiyoruz
                                  if (isset($whmcs_data['tldPricing']['pricing'][$tld]['transfer'][$regperiod])) {
                                      $price = $whmcs_data['tldPricing']['pricing'][$tld]['transfer'][$regperiod];
                                      $totalPrice = $totalPrice + $price;
                                      $df = $whmcs_data['tldPricing']['pricing'][$tld]['transfer'];
                                  }
                                   ?>
                                  <div class="">
                                      <div class="px-6 py-4">
                                          <div class="flex items-center">
                                              <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full">
                                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                                      <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd"></path>
                                                  </svg>
                                              </div>
                                              <div style="margin-left: 10px;" class="ml-4">
                                                  <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                                                    Domain Transferi
                                                  </h1>
                                                  <p class="text-gray-600 dark:text-gray-400">
                                                      <?php echo e($item['domain'] ?? 'Bilinmeyen domain'); ?> - Ürün / Hizmet - (1 Yıl)
                                                  </p>
                                              </div>
                                          </div>
                                          <div style="margin-top: 15px;">
                                              <div class="flex items-center mt-4">
                                                  <div class="w-full grid auto-cols-fr gap-y-2" style="margin-right:10px;">
                                                      <div class="danger fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                          <div class="min-w-0 flex-1">
                                                              <select class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 dark:text-white sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="regperiod" productid="<?php echo e($item['productId']); ?>" onchange="updatePrice(this, '<?php echo e($item['productId']); ?>')">
                                                                <?php
                                                                $periods = [
                                                                  1 => '1 Yıl',
                                                                ];

                                                                if (isset($df) && is_array($df)) {
                                                                  foreach ($df as $year => $priceUSD) {
                                                                    // sadece 1 yıllık olsun
                                                                    if ($year != 1) {
                                                                      continue;
                                                                    }

                                                                    $selected = ($regperiod == $year) ? 'selected' : '';
                                                                    echo '<option value="' . $year . '" data-period="' . $priceUSD . '" ' . $selected . '>'
                                                                    . $periods[$year] . ' - ($' . number_format($priceUSD, 2) . ')</option>' . PHP_EOL;
                                                                  }
                                                                } else {
                                                                  echo '<option value="">Fiyat bilgisi bulunamadı</option>';
                                                                }
                                                                ?>

                                                              </select>
                                                          </div>
                                                      </div>
                                                  </div>
                                                  <form method="POST">
                                                      <?php echo csrf_field(); ?>
                                                      <button name="delete" value="<?php echo e($item['productId']); ?>" style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" type="submit" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                          Kaldır
                                                      </button>
                                                    </form>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </div>
                      </div>
                  </div>
              </div>
              <?php
                  $taxAmount = $totalPrice * $taxRate;
                  $totalWithTax = $totalPrice + $taxAmount;
                  $discountedTotal = $totalWithTax;
              ?>
              <div class="col-span-1 fi-wi-widget fi-wi-table">
                  <div class="fi-ta">
                      <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                          <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                              <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                  <div class="grid gap-y-1">
                                      <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                          Sepet Özeti
                                      </h3>
                                  </div>
                              </div>
                          </div>
                          <div class="w-full lg:w-1/2 bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                              <div class="space-y-4">
                                  <div class="flex justify-between">
                                      <span class="text-gray-600 dark:text-gray-400">Toplam Ürün Fiyatı</span>
                                      <span id="total-price" class="font-medium text-gray-900 dark:text-gray-100">$<?php echo e(number_format($totalPrice, 2)); ?> USD</span>
                                  </div>
                                  <div class="flex justify-between">
                                      <span class="text-gray-600 dark:text-gray-400">KDV %20</span>
                                      <span id="tax-amount" class="font-medium text-gray-900 dark:text-gray-100">$<?php echo e(number_format($taxAmount, 2)); ?> USD</span>
                                  </div>
                                  <div class="flex justify-between border-t pt-4 dark:border-gray-700">
                                      <span class="text-lg font-semibold text-gray-800 dark:text-gray-100">İndirimli Ödenecek Tutar</span>
                                      <span id="discounted-total" class="text-lg font-semibold text-gray-900 dark:text-gray-100">$<?php echo e(number_format($discountedTotal, 2)); ?> USD</span>
                                  </div>
                                  <div class="flex items-center mt-4">
                                      <input type="text" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 text-gray-700 dark:text-gray-300 dark:bg-gray-700 focus:outline-none" placeholder="İndirim Kodunuz" style="margin-right: 10px;" />
                                      <button
                                          style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: ;"
                                          type="submit"
                                          class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                      >
                                          Kullan
                                      </button>
                                  </div>
                                    <form style=" all: unset;" id="orderForm" method="POST" action="<?php echo e(route('sepet.onayla')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php $sepetsira = -1; ?>
                                        <?php foreach ($items as $item): ?>
                                        <?php $sepetsira++; ?>
                                        <?php if ($item['type'] == 'hosting'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="hosting" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['pid']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'register'): ?>
                                         <div id="<?php echo $item['productId']; ?>">
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="register" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][domaintype]" value="register" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][regperiod]" value="<?php echo $item['regperiod']; ?>" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver1]" value="unna1.serversistemleri.com" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver2]" value="unna2.serversistemleri.com" />
                                         </div>
                                        <?php endif; ?>
                                        <?php if (isset($item['action']) && $item['action'] == 'transfer'): ?>
                                         <div id="<?php echo $item['productId']; ?>">
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="transfer" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][domaintype]" value="transfer" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][eppcode]" value="<?php echo $item['pers']['transferkodu'] ?? ''; ?>" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][regperiod]" value="1" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver1]" value="unna1.serversistemleri.com" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver2]" value="unna2.serversistemleri.com" />
                                         </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'cloudserver'): ?>
                                         <div id="<?php echo $item['productId']; ?>">
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="cloudserver" />
                                           <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][configoptions1]" value='<?php echo $item['pers'][0]['os']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][configoptions2]" value='<?php echo $item['pers'][1]['controlPanel']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][configoptions3]" value='<?php echo $item['pers'][2]['ipAddress']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][configoptions4]" value='<?php echo $item['pers'][3]['backupService']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver1]" value='<?php echo $item['domain']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][nameserver2]" value='<?php echo $item['domain']; ?>' />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                         </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'yedek'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="yedek" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'kurumsalmail'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="kurumsalmail" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'sunucubarindirma'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="sunucubarindirma" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'nasbarindirma'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="nasbarindirma" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="<?php echo $item['billingcycle']; ?>" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'ssl'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="ssl" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="annually" />
                                          </div>
                                        <?php endif; ?>
                                        <?php if ($item['type'] == 'license'): ?>
                                          <div id="<?php echo $item['productId']; ?>">
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][type]" value="license" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][domain]" value="<?php echo $item['domain']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][pid]" value="<?php echo $item['productId']; ?>" />
                                            <input type="hidden" name="items[<?php echo $sepetsira; ?>][billingcycle]" value="monthly" />
                                          </div>
                                        <?php endif; ?>
                                        <?php endforeach; ?>

                                        <!-- Kredi Kartı ile Ödeme Butonu -->

                                        <!-- Banka Transferi ile Ödeme Butonu -->
                                        <div style="margin-top:15px;--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
                                        <div class="col-span-1 fi-wi-widget fi-wi-table">
                                            <button
                                                style="width: 100%;--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);"
                                                class="paymentButton mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                                type="button"
                                                data-method="paytr"
                                            >
                                                Kredi Kartı ile Ödeme
                                            </button>
                                        </div>
                                        <div class="col-span-1 fi-wi-widget fi-wi-table">
                                            <button
                                                style="width: 100%;--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);"
                                                class="paymentButton mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                                type="button"
                                                data-method="banktransfer"
                                            >
                                                Banka Transferi ile Ödeme
                                            </button>
                                        </div>
                                        </div>
                                        <input type="hidden" name="paymentmethod" id="paymentmethod" value="" />
                                        <button style="display:none;" type="hidden" id="submitOrder">Siparişi Onayla</button>

                                    </form>

                              </div>
                          </div>

                      </div>
                  </div>
              </div>
                        <?php else: ?>
                            <p>Sepetinizde ürün yok.</p>
                        <?php endif; ?>


            



        </div>
    </main>

    <script type="text/javascript">
        window.onload = function () {
            const currentUrl = new URL(window.location.href);
            //if (currentUrl.searchParams.has("sp")) {
            //    currentUrl.searchParams.delete("sp");
            //    const newUrl = currentUrl.origin + currentUrl.pathname;
            //    window.history.replaceState({}, document.title, newUrl);
            //}
        };
        let productPrices = {};

        // Sayfa yüklendiğinde tüm seçili fiyatları alıp hesaplamayı başlat
        window.onload = function() {
            // Tüm select elementlerini bul
            const selects = document.querySelectorAll('select');

            // Her select elementinin seçili olan fiyatını al ve productPrices'a ekle
            selects.forEach(function(select) {
                const productId = select.getAttribute('productid'); // Artık productid attribute'unu kullanıyoruz
                const selectedPrice = parseFloat(select.options[select.selectedIndex].getAttribute("data-period"));

                // productPrices objesine productId'yi key olarak ekle ve değerini fiyat olarak ayarla
                productPrices[productId] = selectedPrice;

            });

            // İlk hesaplamayı yap
            calculateTotal();
        };

        // Fiyat güncelleme işlemi
        function updatePrice(select, productId) {
            // Yeni seçilen fiyatı ve süresini value'dan al
            const selectedPrice = parseFloat(select.options[select.selectedIndex].getAttribute("data-period"));
            const selectedValue = select.value; // Value içerisindeki değer: '1 year', '1 month', vs.

            // Eski fiyatı kaldır, yeni fiyatı ekle
            if (productPrices.hasOwnProperty(productId)) {
                productPrices[productId] = selectedPrice;
            }
            console.log(productId + " " + selectedPrice);

            // Süreyi ilgili div içinde güncelle
            const productDiv = document.getElementById(productId);
            if (productDiv) {
                // input hidden içinde "billingcycle" ya da "regperiod" gibi alanları bul ve güncelle
                const periodInput = productDiv.querySelector('input[name*="billingcycle"], input[name*="regperiod"]');
                if (periodInput) {
                    // Seçilen value'ya göre 'annually', 'monthly' gibi bilgileri value'ya yazalım
                    if (selectedValue.toLowerCase().includes("year")) {
                        periodInput.value = 'annually'; // Yıllıksa annually yapıyoruz
                    } else if (selectedValue.toLowerCase().includes("month")) {
                        periodInput.value = 'monthly'; // Aylıksa monthly yapıyoruz
                    } else {
                        periodInput.value = selectedValue.toLowerCase(); // Diğer durumlar için value'yu olduğu gibi yaz
                    }
                }
            }

            calculateTotal();
        }

        // Toplam fiyat hesaplama fonksiyonu
        function calculateTotal() {
            // Tüm ürün fiyatlarını topla
            let totalPrice = Object.values(productPrices).reduce((acc, price) => acc + price, 0);

            // Vergi ve indirimli toplam hesaplaması
            const taxAmount = totalPrice * 0.2; // %20 vergi
            const discountedTotal = totalPrice + taxAmount; // Vergi dahil toplam

            document.getElementById("total-price").innerText = `$${totalPrice.toFixed(2)}`;
            document.getElementById("tax-amount").innerText = `$${taxAmount.toFixed(2)}`;
            document.getElementById("discounted-total").innerText = `$${discountedTotal.toFixed(2)}`;
        }
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="text/javascript">
    $(document).ready(function() {
        // Ödeme yöntemi butonları tıklama olayı
        $('.paymentButton').on('click', function() {
            let paymentMethod = $(this).data('method');
            $('#paymentmethod').val(paymentMethod);  // paymentmethod gizli input'una yöntemi ekle
            $(this).text('Lütfen Bekleyiniz...').prop('disabled', true);
            $('#submitOrder').click();
        });

        // Form gönderme işlemi (Siparişi Onayla butonuna basıldığında)
        $('#submitOrder').on('click', function(e) {
            e.preventDefault();

            // Öncelikle ödeme yöntemi seçilip seçilmediğini kontrol edelim
            let selectedPaymentMethod = $('#paymentmethod').val();
            if (selectedPaymentMethod === '') {
                alert('Lütfen bir ödeme yöntemi seçin!');
                return;  // Ödeme yöntemi seçilmediyse formu gönderme
            }

            // Formdaki verileri JSON formatına çeviriyoruz
            let formData = $('#orderForm').serializeArray();
            let jsonData = { items: [] };

            // İşlenecek olan diziyi oluşturma
            $.each(formData, function() {
                let keys = this.name.match(/[^\[\]]+/g);  // Dizi yapısını düzgün işlemek için anahtarları buluyoruz

                if (keys[0] === 'items') {
                    let index = keys[1]; // items dizisinin index'i
                    let field = keys[2]; // items içerisindeki alan (type, domain, vs.)

                    // Eğer items dizisinde bu index yoksa, oluştur
                    if (!jsonData.items[index]) {
                        jsonData.items[index] = {};
                    }

                    // Alanı items dizisindeki objeye ekle
                    jsonData.items[index][field] = this.value;
                } else {
                    jsonData[keys[0]] = this.value; // Diğer verileri (ör. paymentmethod) ekle
                }
            });

            // JSON verisini kontrol etme
            console.log('Gönderilen JSON:', jsonData);

            // Form içerisindeki CSRF token'ı alıyoruz
            let csrfToken = $('input[name="_token"]').val();

            // AJAX isteği ile JSON verisini gönderiyoruz
            $.ajax({
                url: "<?php echo e(route('sepet.onayla')); ?>",  // Laravel'deki rota
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify(jsonData),  // JSON verisini gönderiyoruz

                headers: {
                    'X-CSRF-TOKEN': csrfToken  // CSRF token'ı isteğe ekleniyor
                },
                success: function(response) {
                    if(response.success) {
                        window.location.href = "/invoices/view/" + response.faturano + '?pmet=' + response.pay;
                    } else {
                        alert('Sipariş oluşturulamadı: ' + response.message);
                    }
                },
                error: function(xhr) {
                    console.log('Hata:', xhr.responseText);
                }

            });
        });
    });
</script>
<?php else: ?>
<style media="screen">
.cart-empty {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    color: #6b7280; /* Tailwind text-gray-500 */

    display: flex;
    flex-direction: column;
    align-items: center; /* İkonu ve yazıyı ortalar */
}

.icon {
    width: 64px;
    height: 64px;
    margin-bottom: 16px;
    color: #9ca3af; /* Tailwind text-gray-400 */
}

.title {
    font-size: 1.25rem; /* Tailwind text-lg */
    font-weight: 600;
    color:white;
}

.subtitle {
    font-size: 0.875rem; /* Tailwind text-sm */
    color: #9ca3af; /* Tailwind text-gray-400 */
    color:white;
}

.btn {
    display: inline-block;
    margin-top: 16px;
    padding: 10px 16px;
    background-color: #2563eb; /* Tailwind bg-blue-600 */
    color: white;
    border-radius: 6px;
    text-decoration: none;
    transition: background-color 0.3s ease;
}

.btn:hover {
    background-color: #1e40af; /* Tailwind hover:bg-blue-700 */
}
</style>
<div class="cart-empty">
    <!-- Sepet İkonu -->

    <svg style="fill:white;" class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10 19.5c0 .829-.672 1.5-1.5 1.5s-1.5-.671-1.5-1.5c0-.828.672-1.5 1.5-1.5s1.5.672 1.5 1.5zm3.5-1.5c-.828 0-1.5.671-1.5 1.5s.672 1.5 1.5 1.5 1.5-.671 1.5-1.5c0-.828-.672-1.5-1.5-1.5zm1.336-5l1.977-7h-16.813l2.938 7h11.898zm4.969-10l-3.432 12h-12.597l.839 2h13.239l3.474-12h1.929l.743-2h-4.195z"/></svg>

    <!-- Sepet Boş Yazısı -->
    <p class="title">Sepetiniz Boş</p>
    <p class="subtitle">Alışverişe devam etmek için ürün ekleyin.</p>
</div>




<?php endif; ?>

<?php echo $__env->make("layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/cart/show.blade.php ENDPATH**/ ?>