<?php $pageTitle = 'Ürün Detayları'; ?>
@include("layouts.header")
<style media="screen">
    .mbtn {
        width: 24%;
    }

    .label-mobile {
        display: none;
    }

    .label-desktop {
        display: block;
    }

    .label {
        padding: 5px 10px;
        border-radius: 3px;
        font-size: 14px;
        color: white;
        text-align: center;
    }

    .label-default {
        background-color: #777;
    }

    .label-default[href]:hover,
    .label-default[href]:focus {
        background-color: #5e5e5e;
    }

    .label-primary {
        background-color: #337ab7;
    }

    .label-primary[href]:hover,
    .label-primary[href]:focus {
        background-color: #286090;
    }

    .label-success {
        background-color: #5cb85c;
    }

    .label-success[href]:hover,
    .label-success[href]:focus {
        background-color: #449d44;
    }

    .label-info {
        background-color: #5bc0de;
    }

    .label-info[href]:hover,
    .label-info[href]:focus {
        background-color: #31b0d5;
    }

    .label-warning {
        background-color: #f0ad4e;
    }

    .label-warning[href]:hover,
    .label-warning[href]:focus {
        background-color: #ec971f;
    }

    .label-danger {
        background-color: #d9534f;
    }

    .label-danger[href]:hover,
    .label-danger[href]:focus {
        background-color: #c9302c;
    }

    @media only screen and (max-width: 600px) {
        .mr-15 {
            margin-left: 15px;
        }
        .mbtn {
            width: 100%;
            margin-bottom: 5px;
        }
        .label-mobile {
            display: block;
        }
        .label-desktop {
            display: none;
        }
    }
</style>
<?php
$statusClasses = [
   "Active" => "label-success",
   "Suspended" => "label-warning",
   "Terminated" => "label-danger",
   "Cancelled" => "label-default"
];
$status = $servers['status'];
$cssClass = isset($statusClasses[$status]) ? $statusClasses[$status] : "label-default";
//print_r($servers);
?>

<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Diğer Hizmet Detayları
                    </h1>
                </div>
            </header>
        </section>
    </div>
    <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
        <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
            <div class="fi-ta">
                <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                    <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                        <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                            <div class="grid gap-y-1">
                                <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                    Diğer Hizmet Bilgileri
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                        <div class="">
                            <div class="px-6 py-4">
                                <div class="flex items-center">
                                    <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full label-desktop">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div style="margin-left: 10px;" class="ml-4">
                                        <h1 class="text-xl font-semibold text-gray-900 dark:text-white">{{$servers['domain']}}</h1>
                                        <p class="text-gray-600 dark:text-gray-400">
                                            <?php echo str_replace("-", " ", $servers['name']); ?>
                                        </p>
                                    </div>
                                    <span class="label-desktop label <?php echo $cssClass; ?>  ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                        <?php
                                        if ($servers['status'] == "Active") {
                                            echo "Aktif";
                                        }
                                        if ($servers['status'] == "Expired") {
                                            echo "Süresi Doldu";
                                        }
                                        if ($servers['status'] == "Terminated") {
                                            echo "Kapatıldı";
                                        }
                                        if ($servers['status'] == "Cancelled") {
                                            echo "İptal Edildi";
                                        }
                                        if ($servers['status'] == "Pending") {
                                         echo "Beklemede";
                                        }
                                        ?>
                                    </span>
                                </div>
                                <div style="margin-top:10px;" class="mt-4">
                                    <span style="margin-bottom:5px;border-radius: .5rem;" class="label-mobile label <?php echo $cssClass; ?>  ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                        <?php
                                        if ($servers['status'] == "Active") {
                                            echo "Aktif";
                                        }
                                        if ($servers['status'] == "Expired") {
                                            echo "Süresi Doldu";
                                        }
                                        if ($servers['status'] == "Terminated") {
                                            echo "Kapatıldı";
                                        }
                                        if ($servers['status'] == "Cancelled") {
                                            echo "İptal Edildi";
                                        }
                                        if ($servers['status'] == "Pending") {
                                         echo "Beklemede";
                                        }
                                        ?>
                                    </span>
                                </div>
                            </div>
                            <div class="border-t dark:border-gray-700">
                                <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                                  <?php if ($servers['groupname'] == "Backup Hizmeti"): ?>
                                    <div class="py-2 px-6 flex justify-between">
                                        <dt class="text-gray-600 dark:text-gray-400">Hostname</dt>
                                        <dd class="font-medium text-gray-900 dark:text-gray-200">{{$servers['domain']}}</dd>
                                    </div>
                                  <?php endif; ?>

                                    <div class="py-2 px-6 flex justify-between">
                                        <dt class="text-gray-600 dark:text-gray-400">Yenileme Tutarı</dt>
                                        <dd class="font-medium text-gray-900 dark:text-gray-200">{{$servers['recurringamount']}}$</dd>
                                    </div>
                                    <div class="py-2 px-6 flex justify-between">
                                        <dt class="text-gray-600 dark:text-gray-400">Sonraki Ödeme Tarihi</dt>
                                        <dd class="font-medium text-gray-900 dark:text-gray-200">
                                            <?php echo date_format(date_create($servers['nextduedate']), "d-m-Y"); ?>
                                        </dd>
                                    </div>
                                    <div class="py-2 px-6 flex justify-between">
                                        <dt class="text-gray-600 dark:text-gray-400">Ödeme şekli</dt>
                                        <dd class="font-medium text-gray-900 dark:text-gray-200">
                                            <?php
                                            if ($servers['paymentmethod'] == "banktransfer") {
                                                echo "Banka Transferi";
                                            }
                                            if ($servers['paymentmethod'] == "paytr") {
                                                echo "Kredi Kartı";
                                            }
                                            ?>
                                        </dd>
                                    </div>
                                    <div class="py-2 px-6 flex justify-between">
                                        <dt class="text-gray-600 dark:text-gray-400">Kayıt Tarihi</dt>
                                        <dd class="font-medium text-gray-900 dark:text-gray-200">
                                            <?php echo date_format(date_create($servers['regdate']), "d-m-Y") ?>
                                        </dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($servers['groupname'] == "Tüm SSL Paketleri"): ?>
          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
          <div class="fi-ta">
          <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
              <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                  <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                      <div class="grid gap-y-1">
                          <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                            Diğer Hizmet Ayrıntıları
                          </h3>
                      </div>
                  </div>
              </div>

              <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                  <div class="">
                      <div class="mb-4">
                          <div style="margin-right: 20px; margin-left: 20px; margin-top: 10px;" id="csrForm-button" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                              <div class="flex justify-between items-center">
                                  <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">CSR Oluştur</h2>
                                  <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                              </div>
                          </div>
                          <form id="csrForm" method="post" class="nameserver-form hidden">
                            @csrf
                              <input type="hidden" name="domainName" value="<?php echo $servers['domain']; ?>" />
                              <input type="hidden" name="productId" value="<?php echo $servers['id']; ?>">
                              <div
                                  style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr)); --cols-xl: repeat(2, minmax(0, 1fr)); padding-right: 30px; padding-left: 30px;"
                                  class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6"
                              >
                                  <!-- -->
                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          Ülke Adı
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <input
                                                              name="countryName"
                                                              value="<?php echo $sslcreate['countrycode']; ?>"
                                                              class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                              type="text"
                                                          />
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          İl veya Eyalet
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <input
                                                              name="stateOrProvinceName"
                                                              value="<?php echo $sslcreate['city']; ?>"
                                                              class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                              type="text"
                                                          />
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          İlçe
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <input
                                                              name="localityName"
                                                              value="<?php echo $sslcreate['state']; ?>"
                                                              class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                              type="text"
                                                          />
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <div style="--col-span-default: span 1 / span 1;<?php echo $sscreate['companyname'] ?? 'display:none'; ?>" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          Organizasyon Adı
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <input
                                                              name="organizationName"
                                                              value="<?php echo $sscreate['companyname'] ?? 'Server Sistemleri'; ?>"
                                                              class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                              type="text"
                                                          />
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          E-Posta Adresi
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <input
                                                          name="emailAddressDisabled"
                                                          value="admin@<?php echo $servers['domain']; ?>"
                                                          class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                          type="text"
                                                          disabled
                                                          />
                                                          <input
                                                          type="hidden"
                                                          name="emailAddress"
                                                          value="admin@<?php echo $servers['domain']; ?>"
                                                          />
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                  <!-- -->
                              </div>
                              <div id="response-message">
                                  <div id="csrstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                      <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                          <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                              <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 1 0 0 2Z"></path>
                                          </svg>
                                          <span class="sr-only">Info</span>
                                          <div>
                                              <span class="font-medium">Başarılı! </span>
                                              <span id="csrstatus-message-text"></span>
                                          </div>
                                      </div>
                                  </div>

                                  <div id="csrerror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                      <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                          <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                              <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 1 0 0 2Z"></path>
                                          </svg>
                                          <span class="sr-only">Info</span>
                                          <div>
                                              <span class="font-medium">Hata! </span>
                                              <span id="csrerror-message-text"></span>
                                          </div>
                                      </div>
                                  </div>
                              </div>

                              <div style="padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                <button type="button" id="submitForm" style="width: 100%; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);"
                                class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                Oluştur
                              </button>
                            </div>
                          </form>
                      </div>
                  </div>
              </div>
              <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                  <div class="">
                      <div class="mb-4">
                          <div style="margin-right: 20px; margin-left: 20px; margin-top: 10px;" id="csrSendForm-button" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                              <div class="flex justify-between items-center">
                                  <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">CSR Gönder</h2>
                                  <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                              </div>
                          </div>
                          <form id="csrSendForm" method="post" class="nameserver-form hidden">
                            @csrf
                              <input type="hidden" name="productId" value="<?php echo $servers['id']; ?>">
                              <div
                                  style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(1, minmax(0, 1fr)); --cols-xl: repeat(1, minmax(0, 1fr)); padding-right: 30px; padding-left: 30px;"
                                  class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6"
                              >
                                  <!-- -->
                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                      <div data-field-wrapper="" class="fi-fo-field-wrp">
                                          <div class="grid gap-y-2">
                                              <div class="flex items-center gap-x-3 justify-between">
                                                  <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                          Lütfen CSR Kodunuzu girin, Eğer manuel oluşturduysanız işlem yapmayın!
                                                      </span>
                                                  </label>
                                              </div>

                                              <div class="grid auto-cols-fr gap-y-2">
                                                  <div
                                                      class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                  >
                                                      <div class="min-w-0 flex-1">
                                                          <textarea name="csrCode"
                                                                    rows="1"
                                                                    class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500 dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                    style="overflow:hidden; resize:none;"
                                                                    oninput="autoResize(this)"><?php echo $servers['customfields']['customfield'][0]['value']?? null; ?>
                                                          </textarea>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                              <div id="response-message">
                                  <div id="csrsendstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                      <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                          <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                              <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 1 0 0 2Z"></path>
                                          </svg>
                                          <span class="sr-only">Info</span>
                                          <div>
                                              <span class="font-medium">Başarılı! </span>
                                              <span id="csrsendstatus-message-text"></span>
                                          </div>
                                      </div>
                                  </div>

                                  <div id="csrsenderror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                      <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                          <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                              <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 1 0 0 2Z"></path>
                                          </svg>
                                          <span class="sr-only">Info</span>
                                          <div>
                                              <span class="font-medium">Hata! </span>
                                              <span id="csrsenderror-message-text"></span>
                                          </div>
                                      </div>
                                  </div>
                              </div>

                              <div style="padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                <button type="button" id="csrsubmitForm" style="width: 100%; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);"
                                class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                Gönder
                              </button>
                            </div>
                          </form>
                      </div>
                  </div>
              </div>
          </div>
          </div>
          </div>
        <?php endif; ?>
        <?php if ($servers['groupname'] == "lisanspaketleri"): ?>
          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
          <div class="fi-ta">
          <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
              <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                  <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                      <div class="grid gap-y-1">
                          <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                            Lisans Ayrıntıları
                          </h3>
                      </div>
                  </div>
              </div>
              <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                  <div class="">
                    <?php //print_r($servers); ?>
                        <div class="border-t dark:border-gray-700">
                        <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                            <div class="py-2 px-6 flex justify-between">
                                <dt class="text-gray-600 dark:text-gray-400">Lisans iP Adresi</dt>
                                <dd class="font-medium text-gray-900 dark:text-gray-200"><?php echo $servers['customfields']['customfield'][1]['value']; ?></dd>
                            </div>
                            <div class="py-2 px-6 flex justify-between">
                                <dt class="text-gray-600 dark:text-gray-400">Lisans Numarası</dt>
                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                    <?php echo $servers['customfields']['customfield'][2]['value']; ?>
                                </dd>
                            </div>

                        </dl>
                    </div>

                  </div>
              </div>
          </div>
          </div>
          </div>
        <?php endif; ?>

        <?php if ($servers['groupname'] == "SmarterMail"): ?>
          <style media="screen">

          dialog {
            min-width: 30%;

          background: white;
          max-width: 400px;
          padding-top: 2rem;
          border-radius: 20px;
          border: 0;
          box-shadow: 0 5px 30px 0 rgb(0 0 0 / 10%);
          animation: fadeIn 1s ease both;
          &::backdrop {
            animation: fadeIn 1s ease both;
            background: rgb(255 255 255 / 40%);
            z-index: 2;
            backdrop-filter: blur(20px);
          }
          .x {
            filter: grayscale(1);
            border: none;
            background: none;
            position: absolute;
            top: 15px;
            right: 10px;
            transition: ease filter, transform 0.3s;
            cursor: pointer;
            transform-origin: center;
            &:hover {
              filter: grayscale(0);
              transform: scale(1.1);
            }
          }
          h2 {
            font-weight: 600;
            font-size: 2rem;
            padding-bottom: 1rem;
          }
          p {
            font-size: 1rem;
            line-height: 1.3rem;
            padding: 0.5rem 0;
            a {
              &:visited {
                color: rgb(var(--vs-primary));
              }
            }
          }
          }

          @keyframes fadeIn {
          from {
            opacity: 0;
          }
          to {
            opacity: 1;
          }
          }

          </style>
          <dialog id="mail-kutusu-olusturma" class="fi-simple-main  w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
              <div class="fi-simple-page">
                  <section class="grid auto-cols-fr gap-y-6">
                      <header class="fi-simple-header flex flex-col items-center">
                          <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" style="width: 250px;" class="d-none  fi-logo flex mb-4" />
                          <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" style="width: 250px;" class="l-none  fi-logo flex mb-4" />
                          <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                              Mail Kutusu Oluşturma
                          </h1>
                      </header>

                      <form id="createsmartermailuser-form" action="{{ route('resave.save') }}" method="post">
                        @csrf
                        <input type="hidden" name="action" value="createsmartermailuser" />
                        <input style="color:black;" type="hidden" name="serviceId" value="<?php echo $othersId; ?>">
                        <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center gap-x-3 justify-between">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Kullanıcı adı
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div
                                                class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                            >
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                        autocomplete="off"
                                                        autofocus="autofocus"
                                                        name="username"
                                                        required="required"
                                                        type="text"
                                                        placeholder="Lütfen kullanıcı adı girin (user)"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center gap-x-3 justify-between">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Görünen isim
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div
                                                class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                            >
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                        autocomplete="on"
                                                        autofocus="autofocus"
                                                        name="displayname"
                                                        required="required"
                                                        type="text"
                                                        placeholder="Görünen isim (Ad Soyad)"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center gap-x-3 justify-between">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Şifre
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div
                                                class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                            >
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                        name="password"
                                                        required="required"
                                                        type="password"
                                                        placeholder="Güçlü bir şifre girin"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center gap-x-3 justify-between">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Mail Kutusu Boyutu
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div
                                                class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                            >
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                        name="mailboxsize"
                                                        required="required"
                                                        type="text"
                                                        placeholder="Posta Kutusu Boyutu (MB) (0 = sınırsız)"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <button style="width: 100%;margin-top:25px; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500   dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                          Kaydet
                        </button>
                      </form>
                      <div id="response-message-action" style=""></div>
                  </section>
              </div>
              <button onclick="this.closest('dialog').close();" aria-label="close" class="x">❌</button>
          </dialog>


          <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $('#createsmartermailuser-form').on('submit', function(e) {
      e.preventDefault();

      var $form = $(this);
      var formData = $form.serialize();
      var $btn = $form.find('button');
      var originalBtnText = $btn.text();

      $btn.prop('disabled', true).text('Lütfen bekleyin...');
      $('#response-message-action').text(''); // Önceki mesajı temizle
      console.log("🔄 Gönderilen veri:", formData);

      $.ajax({
        type: 'POST',
        url: $form.attr('action'),
        data: formData,
        success: function(response) {
          if (response.success) {
            $('#response-message-action').css('color', 'green').text('✅ Başarılı: ' + response.message);
            $btn.text('✅ Tamamlandı');
            setTimeout(() => location.reload(), 1000);
          } else {
            const customMessage = getCustomErrorMessage(response.message);
            $('#response-message-action').css('color', 'red').text('❌ Hata: ' + customMessage);
            $btn.prop('disabled', false).text(originalBtnText);
          }
          console.log("✅ Sunucudan dönen cevap:", response);
        },
        error: function(xhr) {
          let rawMsg = 'Bilinmeyen bir hata oluştu.';
          if (xhr.responseJSON && xhr.responseJSON.message) {
            rawMsg = xhr.responseJSON.message;
          }
          const customMessage = getCustomErrorMessage(rawMsg);
          $('#response-message-action').css('color', 'red').text('❌ Hata: ' + customMessage);
          $btn.prop('disabled', false).text(originalBtnText);
          console.error("❌ AJAX Hatası:", xhr);
        }
      });

      // 🔧 Burada hata mesajlarını özelleştiriyorsun
      function getCustomErrorMessage(code) {
        switch (code) {
          case 'EXCEPTION_DOMAIN_USER_LIMIT_EXCEEDED':
            return 'Bu domaine atanabilecek maksimum kullanıcı sayısına ulaşıldı.';
          case 'EXCEPTION_INVALID_PASSWORD':
            return 'Şifre geçersiz. Lütfen en az 8 karakterli güçlü bir şifre kullanın.';
          case 'EXCEPTION_USERNAME_TAKEN':
            return 'Kullanıcı adı zaten mevcut. Lütfen farklı bir kullanıcı adı girin.';
          default:
            return code; // Bilinmeyen mesajlar orijinal haliyle gösterilir
        }
      }
    });
  </script>
          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
          <div class="fi-ta">
          <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
              <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                  <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                      <div class="grid gap-y-1">
                          <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                            Kurumsal Mail Detayları
                          </h3>
                      </div>
                  </div>
              </div>
              <?php $data = json_decode($getUserDetails['message'], true);?>
              <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                  <div class="">
                    <div class="">
                      <a style="margin:10px;--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" target="_blank" href="<?php echo $mailLoginButton; ?>">Webmail'e giriş yap</a>
                      <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" onclick="document.getElementById('mail-kutusu-olusturma').showModal();">Mail Kutusu Oluştur</button>
                    </div>
                    <div class="border-t dark:border-gray-700">
                        <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                            <div class="py-2 px-6 flex justify-between">
                                <dt class="text-gray-600 dark:text-gray-400">Yönetici Kullanıcı Adı</dt>
                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                  <?php echo $servers['username']; ?>@<?php echo $servers['domain']; ?>
                                </dd>
                            </div>
                            <div class="py-2 px-6 flex justify-between">
                                <dt class="text-gray-600 dark:text-gray-400">Yönetici Şifresi</dt>
                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                  <?php echo $servers['password']; ?>
                                </dd>
                            </div>

                              <?php if (!empty($data) && is_array($data)):
                                foreach ($data as $getdata):
                                  $kullanici = $getdata['userName'];
                                  $gorunenAd = $getdata['displayName'];
                                  $domain = $servers['domain'];
                                  $mail = $kullanici . '@' . $domain;

                                  $lastDateRaw = $getdata['lastLoginStr'] ?? '1970-01-01';
                                  $lastDate = ($lastDateRaw === '1970-01-01' || empty($lastDateRaw))
                                    ? 'Giriş Yapılmamış'
                                    : date('d-m-Y H:i', strtotime($lastDateRaw));
                              ?>
                                <div class="py-2 px-6 flex justify-between items-center border-b border-gray-200 dark:border-gray-700">
                                  <div>
                                    <dt class="text-gray-600 dark:text-gray-400"><?= $mail ?></dt>
                                    <dd class="font-medium text-gray-900 dark:text-gray-200">Son Giriş: <?= $lastDate ?></dd>
                                  </div>
                                  <div>
                                    <button
                                      class="bg-blue-600 dark:text-white px-3 py-1 rounded text-sm hover:bg-blue-500"
                                      onclick="acModal('<?= $kullanici ?>', '<?= addslashes($gorunenAd) ?>', '<?php echo $getdata['bytesAllowed'] / 1024 / 1024; ?>')"
                                    >
                                      Düzenle
                                    </button>
                                  </div>
                                </div>
                              <?php endforeach; ?>
                            <?php else: ?>
                              <div class="py-2 px-6 text-center text-gray-600 dark:text-gray-400">
                                Herhangi bir mail adresiniz mevcut değil.
                              </div>
                            <?php endif; ?>
                        </dl>
                    </div>

                  </div>
              </div>
          </div>
          </div>
          </div>
          <dialog id="mail-kutusu-duzenle" class="fi-simple-main w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
              <section class="grid auto-cols-fr gap-y-6">
                <header class="fi-simple-header flex flex-col items-center">
                  <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" style="width: 250px;" class="d-none fi-logo flex mb-4" />
                  <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" style="width: 250px;" class="l-none fi-logo flex mb-4" />
                  <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                    Mail Kutusu Düzenleme
                  </h1>
                  <p style="text-align:center;">Bir kullanıcıyı silmek tüm verileri silecektir ve geri alınamaz.</p>
                </header>

                <form id="duzenlesmartermailuser-form" action="{{ route('resave.save') }}" method="post">
                  @csrf
                  <input type="hidden" name="action" value="savechangessmartermailuser" />
                  <input style="color:black;" type="hidden" name="serviceId" value="<?php echo $othersId; ?>">
                  <input type="hidden" name="selectuser" id="edit-selectuser" />

                  <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">

                    <!-- Kullanıcı adı (gösterim için) -->
                    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                      <div class="fi-fo-field-wrp">
                        <label class="fi-fo-field-wrp-label text-sm font-medium leading-6 text-gray-950 dark:text-white">Kullanıcı Adı</label>
                        <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 bg-white dark:bg-white/5 ring-gray-950/10 dark:ring-white/20 overflow-hidden">
                          <input name="username" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 dark:text-white bg-white/0 ps-3 pe-3" id="edit-username" disabled />
                        </div>
                      </div>
                    </div>

                    <!-- Görünen isim -->
                    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                      <div class="fi-fo-field-wrp">
                        <label class="fi-fo-field-wrp-label text-sm font-medium leading-6 text-gray-950 dark:text-white">Görünen isim</label>
                        <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 bg-white dark:bg-white/5 ring-gray-950/10 dark:ring-white/20 overflow-hidden">
                          <input class="fi-input block w-full border-none py-1.5 text-base text-gray-950 dark:text-white bg-white/0 ps-3 pe-3" name="displayname" id="edit-displayname" required type="text" placeholder="Ad Soyad" />
                        </div>
                      </div>
                    </div>

                    <!-- Şifre -->
                    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                      <div class="fi-fo-field-wrp">
                        <label class="fi-fo-field-wrp-label text-sm font-medium leading-6 text-gray-950 dark:text-white">Yeni Şifre</label>
                        <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 bg-white dark:bg-white/5 ring-gray-950/10 dark:ring-white/20 overflow-hidden">
                          <input class="fi-input block w-full border-none py-1.5 text-base text-gray-950 dark:text-white bg-white/0 ps-3 pe-3" name="password" id="edit-password" type="password" placeholder="Yeni şifre (boşsa değişmez)" />
                        </div>
                      </div>
                    </div>

                    <!-- Mailbox boyutu -->
                    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                      <div class="fi-fo-field-wrp">
                        <label class="fi-fo-field-wrp-label text-sm font-medium leading-6 text-gray-950 dark:text-white">Mail Kutusu Boyutu</label>
                        <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 bg-white dark:bg-white/5 ring-gray-950/10 dark:ring-white/20 overflow-hidden">
                          <input class="fi-input block w-full border-none py-1.5 text-base text-gray-950 dark:text-white bg-white/0 ps-3 pe-3" name="mailboxsize" id="edit-mailboxsize" required type="number" placeholder="MB cinsinden (örn: 2048)" />
                        </div>
                      </div>
                    </div>
                  </div>

                  <button name="actionbutton" value="update" type="submit" style="width: 49%;margin-top:25px; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                    Kaydet
                  </button>

                  <button name="actionbutton" value="delete" type="submit" style="background-color: #dc3545 !important;width: 49%;margin-top:25px; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                    Sil
                  </button>
                </form>

                <div id="response-message-edit" class="mt-4 text-center text-sm"></div>
              </section>
            </div>

            <button onclick="this.closest('dialog').close();" aria-label="close" class="x absolute top-4 right-4 text-lg">❌</button>
          </dialog>

          <script>
            function acModal(kullanici, displayname, mailboxsize = '') {
              document.getElementById('edit-selectuser').value = kullanici;
              document.getElementById('edit-username').value = kullanici;
              document.getElementById('edit-displayname').value = displayname;
              document.getElementById('edit-password').value = '';
              document.getElementById('edit-mailboxsize').value = mailboxsize;

              document.getElementById('mail-kutusu-duzenle').showModal();
            }
          </script>
          <script>
          let clickedButton = null;

$('#duzenlesmartermailuser-form button[type="submit"]').on('click', function() {
clickedButton = $(this); // tıklanan butonu al
});

$('#duzenlesmartermailuser-form').on('submit', function(e) {
e.preventDefault();

const $form = $(this);

// Eğer tıklanan buton varsa onu da veriye ekle
let formData = $form.serialize();
if (clickedButton) {
  const actionName = clickedButton.attr('name');
  const actionValue = clickedButton.val();
  formData += '&' + encodeURIComponent(actionName) + '=' + encodeURIComponent(actionValue);
}

const $btn = clickedButton || $form.find('button[type="submit"]');
const originalBtnText = $btn.text();

$btn.prop('disabled', true).text('Lütfen bekleyin...');
$('#response-message-edit').text('');

console.log("🔄 Gönderilen veri:", formData);

$.ajax({
  type: 'POST',
  url: $form.attr('action'),
  data: formData,
  success: function(response) {
    if (response.success) {
      $('#response-message-edit').css('color', 'green').text('✅ Başarılı: ' + response.message);
      $btn.text('✅ Tamamlandı');
      setTimeout(() => location.reload(), 1000);
    } else {
      const customMessage = getCustomErrorMessage(response.message);
      $('#response-message-edit').css('color', 'red').text('❌ Hata: ' + customMessage);
      $btn.prop('disabled', false).text(originalBtnText);
    }
    console.log("✅ Sunucudan dönen cevap:", response);
  },
  error: function(xhr) {
    let rawMsg = 'Bilinmeyen bir hata oluştu.';
    if (xhr.responseJSON && xhr.responseJSON.message) {
      rawMsg = xhr.responseJSON.message;
    }
    const customMessage = getCustomErrorMessage(rawMsg);
    $('#response-message-edit').css('color', 'red').text('❌ Hata: ' + customMessage);
    $btn.prop('disabled', false).text(originalBtnText);
    console.error("❌ AJAX Hatası:", xhr);
  }
});

function getCustomErrorMessage(code) {
  switch (code) {
    case 'EXCEPTION_DOMAIN_USER_LIMIT_EXCEEDED':
      return 'Bu domaine atanabilecek maksimum kullanıcı sayısına ulaşıldı.';
    case 'EXCEPTION_INVALID_PASSWORD':
      return 'Şifre geçersiz. Lütfen en az 8 karakterli güçlü bir şifre kullanın.';
    case 'EXCEPTION_USERNAME_TAKEN':
      return 'Kullanıcı adı zaten mevcut. Lütfen farklı bir kullanıcı adı girin.';
    case 'No users deleted.':
       return 'Hiçbir kullanıcı silinemedi!'
    default:
      return code;
  }
}
});
          </script>
        <?php endif; ?>
<script>
document.getElementById('submitForm').addEventListener('click', function() {
    // Buton metnini "Lütfen bekleyiniz..." olarak güncelle
    let submitButton = document.getElementById('submitForm');
    submitButton.innerText = "Lütfen bekleyiniz...";
    submitButton.disabled = true; // Tekrarlı tıklamaları önlemek için butonu devre dışı bırak

    let formData = new FormData(document.getElementById('csrForm'));

    fetch('{{ route('ssl.csrcreate') }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        console.log('Başarılı yanıt:', data);

        // Buton metnini geri eski haline getir
        submitButton.innerText = "Oluştur";
        submitButton.disabled = false;

        if (data.success) {
            document.getElementById('csrstatus-message').style.display = 'block';
            document.getElementById('csrerror-message').style.display = 'none';
            document.getElementById('csrstatus-message-text').innerText = 'CSR başarılı bir şekilde oluşturuldu';
        } else {
            document.getElementById('csrstatus-message').style.display = 'none';
            document.getElementById('csrerror-message').style.display = 'block';
            document.getElementById('csrerror-message-text').innerText = 'CSR oluşturma başarısız';
        }

    })
    .catch(error => {
        console.error('Hata:', error);

        // Buton metnini geri eski haline getir
        submitButton.innerText = "Oluştur";
        submitButton.disabled = false;
    });
});

document.getElementById('csrsubmitForm').addEventListener('click', function() {
    // Buton metnini "Lütfen bekleyiniz..." olarak güncelle
    let submitButton = document.getElementById('csrsubmitForm');
    submitButton.innerText = "Lütfen bekleyiniz...";
    submitButton.disabled = true; // Tekrarlı tıklamaları önlemek için butonu devre dışı bırak

    let formData = new FormData(document.getElementById('csrSendForm'));

    fetch('{{ route('ssl.csrupdate') }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        console.log('Başarılı yanıt:', data);

        // Buton metnini geri eski haline getir
        submitButton.innerText = "Gönder";
        submitButton.disabled = false;

        if (data.success) {
            document.getElementById('csrsendstatus-message').style.display = 'block';
            document.getElementById('csrsenderror-message').style.display = 'none';
            document.getElementById('csrsendstatus-message-text').innerText = 'CSR Başarılı bir şekilde gönderilmiştir.';
        } else {
            document.getElementById('csrsendstatus-message').style.display = 'none';
            document.getElementById('csrsenderror-message').style.display = 'block';
            document.getElementById('csrsenderror-message-text').innerText = 'CSR Gönderim işlemi başarısız!';
        }

    })
    .catch(error => {
        console.error('Hata:', error);

        // Buton metnini geri eski haline getir
        submitButton.innerText = "Gönder";
        submitButton.disabled = false;
    });
});

    document.getElementById("csrForm-button").addEventListener("click", function () {
        var replyForm = document.getElementById("csrForm");
        if (replyForm.classList.contains("hidden")) {
            replyForm.classList.remove("hidden");
        } else {
            replyForm.classList.add("hidden");
        }
    });
    document.getElementById("csrSendForm-button").addEventListener("click", function () {
        var replyForm = document.getElementById("csrSendForm");
        if (replyForm.classList.contains("hidden")) {
            replyForm.classList.remove("hidden");
        } else {
            replyForm.classList.add("hidden");
        }
    });
    function autoResize(textarea) {
        textarea.style.height = 'auto'; // Önce yüksekliği sıfırla
        textarea.style.height = textarea.scrollHeight + 'px'; // İçerik yüksekliğine göre ayarla
    }
</script>

    </div>
    <?php if ($servers['groupname'] == "Backup Hizmeti2"): ?>
      <div style="margin-top:20px;--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
              <div class="fi-ta">
                  <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                      <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                          <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                              <div class="grid gap-y-1">
                                  <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                      FTP Yönetim
                                  </h3>
                              </div>
                          </div>
                      </div>
                      <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                          <div class="">
                              <div class="border-t dark:border-gray-700">
                                  <dl class="divide-y divide-gray-200 dark:divide-gray-700">

                                    <div class="container mx-auto mt-8">
                                        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
                                            <div class="p-6">
                                                <div class="flex justify-end mb-4">
                                                    <button id="goBackButton" class="hidden bg-gray-500 dark:bg-gray-700 text-white px-4 py-2 rounded" style="margin-right: 10px;" onclick="goBack()">Geri</button>
                                                    <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);margin-right:10px;" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" onclick="createFolderAndPrompt()">OLUŞTUR</button>
                                                    <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" onclick="showUploadModal()">YÜKLE</button>
                                                </div>
                                                <div class="overflow-x-auto">
                                                    <table class="min-w-full text-left text-gray-900 dark:text-gray-200" style="width:100%;">
                                                        <thead class="bg-gray-200 dark:bg-gray-700">
                                                            <tr>
                                                                <th class="px-4 py-2">İsim</th>
                                                                <th class="px-4 py-2">Değiştirme tarihi</th>
                                                                <th class="px-4 py-2">Boyutu</th>
                                                                <th class="px-4 py-2">Tipi</th>
                                                                <th class="px-4 py-2">İşlem</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="divide-y divide-gray-200 whitespace-nowrap dark:divide-white/5"  id="directoryContents"></tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="uploadModal" class="fixed z-10 inset-0 overflow-y-auto hidden" style="z-index: 9999;">
                                        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                            <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                                                <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                                            </div>
                                            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                                            <div class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                                                <div class="bg-white dark:bg-gray-800 p-6">
                                                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-200" id="uploadModalLabel">Dosya Yükle</h3>
                                                    <div class="mt-2">
                                                        <form id="uploadForm" enctype="multipart/form-data">
                                                            @csrf
                                                            <input type="file" id="fileInput" name="file" class="form-control" required>
                                                            <input type="hidden" id="uploadDirectory" value="/" />
                                                            <button type="submit" class="mt-2 bg-blue-500 dark:bg-blue-700 text-white px-4 py-2 rounded">Yükle</button>
                                                        </form>
                                                    </div>
                                                </div>
                                                <div class="bg-gray-50 dark:bg-gray-700 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                                                    <button type="button" class="bg-red-500 dark:bg-red-700 text-white px-4 py-2 rounded" onclick="hideUploadModal()">Kapat</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  </dl>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
      <script>
          var ftp_handler = "{{ url('/ftp') }}";
          var username = "{{ $servers['username'] }}";
          var password = "{{ $servers['password'] }}";
          var csrfToken = document.querySelector('input[name="_token"]').value;

          function createFolderAndPrompt() {
              createFolder();
          }

          document.addEventListener('DOMContentLoaded', function() {
              const directoryContents = document.getElementById('directoryContents');
              const directoryInput = document.getElementById('uploadDirectory');
              const goBackButton = document.getElementById('goBackButton');

              let currentDirectory = '/';

              function handleClick(event) {
                  event.preventDefault();
                  const path = event.target.dataset.path;
                  const isFolder = event.target.dataset.isFolder === 'true';
                  if (isFolder) {
                      const fullPath = currentDirectory.endsWith('/') ? currentDirectory + path : currentDirectory + '/' + path;
                      currentDirectory = fullPath;
                      directoryInput.value = currentDirectory;
                      loadDirectoryContents(fullPath);
                  }
              }

              function goBack() {
                  if (currentDirectory !== '/') {
                      const pathSegments = currentDirectory.split('/').filter(segment => segment.length > 0);
                      pathSegments.pop();
                      const newPath = '/' + pathSegments.join('/');
                      currentDirectory = newPath || '/';
                      directoryInput.value = currentDirectory;
                      loadDirectoryContents(currentDirectory);
                  }
              }

              goBackButton.addEventListener('click', goBack);

              window.loadDirectoryContents = function(directory) {
                  const formData = new FormData();
                  formData.append('action', 'list');
                  formData.append('dir', directory);
                  formData.append('username', username);
                  formData.append('password', password);
                  formData.append('_token', csrfToken);

                  fetch(ftp_handler, {
                      method: 'POST',
                      body: formData
                  })
                  .then(response => response.json())
                  .then(data => {
                      directoryContents.innerHTML = '';
                      if (data.length === 0) {
                          directoryContents.innerHTML = '<tr><td colspan="5" class="text-center">Bu dizin boş.</td></tr>';
                      } else {
                          data.forEach(item => {
                              const row = document.createElement('tr');
                              row.innerHTML = `
                                  <td class="px-4 py-2"><a href="#" data-path="${item.name}" data-is-folder="${item.isFolder}">${item.name}</a></td>
                                  <td class="px-4 py-2">${item.isFolder ? 'Klasör tarihi belirlenemedi.' : new Date(item.modTime * 1000).toLocaleString('tr-TR')}</td>
                                  <td class="px-4 py-2">${item.size}</td>
                                  <td class="px-4 py-2">${item.isFolder ? 'Klasör' : 'Dosya'}</td>
                                  <td class="fi-ta-cell p-0 first-of-type:ps-1 last-of-type:pe-1 sm:first-of-type:ps-3 sm:last-of-type:pe-3 fi-ta-actions-cell">
                                  <div class="whitespace-nowrap px-3 py-4">
                                      <div class="fi-ta-actions flex shrink-0 items-center gap-3 justify-end">
                                          <div   x-data="{ toggle: function (event) { $refs.panel.toggle(event) }, open: function (event) { $refs.panel.open(event) }, close: function (event) { $refs.panel.close(event) }, }" class="fi-dropdown">
                                              <div x-on:click="toggle" class="fi-dropdown-trigger flex cursor-pointer" aria-expanded="false">
                                                  <button style="--c-300: var(--primary-300); --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-icon-btn relative flex items-center justify-center rounded-lg outline-none transition duration-75 focus-visible:ring-2 -m-2 h-9 w-9 fi-color-custom text-custom-500 hover:text-custom-600 focus-visible:ring-custom-600 dark:text-custom-400 dark:hover:text-custom-300 dark:focus-visible:ring-custom-500 fi-color-primary fi-ac-icon-btn-group" type="button">
                                                      <svg class="fi-icon-btn-icon h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
                                                          <path d="M10 3a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM10 8.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM11.5 15.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z"></path>
                                                      </svg>
                                                  </button>
                                              </div>

                                              <div x-float.placement.bottom-end.flip.teleport.offset="{ offset: 8,  }" x-ref="panel" x-transition:enter-start="opacity-0" x-transition:leave-end="opacity-0" class="fi-dropdown-panel absolute z-10 w-screen divide-y divide-gray-100 rounded-lg bg-white shadow-lg ring-1 ring-gray-950/5 transition dark:divide-white/5 dark:bg-gray-900 dark:ring-white/10 !max-w-[14rem]" style="position: fixed; display: none; left: 1928px; top: 354px;">
                                                  <div class="fi-dropdown-list p-1">
                                                  ${item.isFolder ? `<a class="fi-dropdown-list-item flex w-full items-center gap-2 whitespace-nowrap rounded-md p-2 text-sm transition-colors duration-75 outline-none disabled:pointer-events-none disabled:opacity-70 hover:bg-gray-50 focus-visible:bg-gray-50 dark:hover:bg-white/5 dark:focus-visible:bg-white/5 fi-dropdown-list-item-color-gray fi-color-gray fi-ac-action fi-ac-grouped-action" href="#" data-path="${directory}/${item.name}" data-is-folder="true">
                                                  <svg class="fi-dropdown-list-item-icon h-5 w-5 text-gray-400 dark:text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
                                                  <path d="M10 12.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"></path>
                                                  <path fill-rule="evenodd" d="M.664 10.59a1.651 1.651 0 0 1 0-1.186A10.004 10.004 0 0 1 10 3c4.257 0 7.893 2.66 9.336 6.41.147.381.146.804 0 1.186A10.004 10.004 0 0 1 10 17c-4.257 0-7.893-2.66-9.336-6.41ZM14 10a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z" clip-rule="evenodd"></path>
                                                  </svg>
                                                  Klasöre Git
                                                  </a>` : `<a class="fi-dropdown-list-item flex w-full items-center gap-2 whitespace-nowrap rounded-md p-2 text-sm transition-colors duration-75 outline-none disabled:pointer-events-none disabled:opacity-70 hover:bg-gray-50 focus-visible:bg-gray-50 dark:hover:bg-white/5 dark:focus-visible:bg-white/5 fi-dropdown-list-item-color-gray fi-color-gray fi-ac-action fi-ac-grouped-action" href="#" data-path="${directory}/${item.name}" onclick="downloadFile('${directory}/${item.name}')">İndir</a>`}
                                                      <a href="#" data-path="${directory}/${item.name}" onclick="renameItem('${directory + '/' + item.name}')" class="fi-dropdown-list-item flex w-full items-center gap-2 whitespace-nowrap rounded-md p-2 text-sm transition-colors duration-75 outline-none disabled:pointer-events-none disabled:opacity-70 hover:bg-gray-50 focus-visible:bg-gray-50 dark:hover:bg-white/5 dark:focus-visible:bg-white/5 fi-dropdown-list-item-color-gray fi-color-gray fi-ac-action fi-ac-grouped-action" >
                                                          <svg class="fi-dropdown-list-item-icon h-5 w-5 text-gray-400 dark:text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
                                                              <path d="m5.433 13.917 1.262-3.155A4 4 0 0 1 7.58 9.42l6.92-6.918a2.121 2.121 0 0 1 3 3l-6.92 6.918c-.383.383-.84.685-1.343.886l-3.154 1.262a.5.5 0 0 1-.65-.65Z"></path>
                                                              <path
                                                                  d="M3.5 5.75c0-.69.56-1.25 1.25-1.25H10A.75.75 0 0 0 10 3H4.75A2.75 2.75 0 0 0 2 5.75v9.5A2.75 2.75 0 0 0 4.75 18h9.5A2.75 2.75 0 0 0 17 15.25V10a.75.75 0 0 0-1.5 0v5.25c0 .69-.56 1.25-1.25 1.25h-9.5c-.69 0-1.25-.56-1.25-1.25v-9.5Z"
                                                              ></path>
                                                          </svg>

                                                          <span class="fi-dropdown-list-item-label flex-1 truncate text-start text-gray-700 dark:text-gray-200" style="">
                                                              Yeniden Adlandır
                                                          </span>
                                                      </a>

                                                      <a href="#" data-path="${directory}/${item.name}" onclick="deleteItem('${directory + '/' + item.name}', ${item.isFolder})" class="fi-dropdown-list-item flex w-full items-center gap-2 whitespace-nowrap rounded-md p-2 text-sm transition-colors duration-75 outline-none disabled:pointer-events-none disabled:opacity-70 hover:bg-gray-50 focus-visible:bg-gray-50 dark:hover:bg-white/5 dark:focus-visible:bg-white/5 fi-dropdown-list-item-color-gray fi-color-gray fi-ac-action fi-ac-grouped-action">
                                                      <svg
                                                          style="--c-400: var(--danger-400); --c-500: var(--danger-500);"
                                                          wire:loading.remove.delay.default="1"
                                                          wire:target="mountTableAction('delete', '6')"
                                                          class="fi-dropdown-list-item-icon h-5 w-5 text-custom-500 dark:text-custom-400"
                                                          xmlns="http://www.w3.org/2000/svg"
                                                          viewBox="0 0 20 20"
                                                          fill="currentColor"
                                                          aria-hidden="true"
                                                          data-slot="icon"
                                                      >
                                                          <path
                                                              fill-rule="evenodd"
                                                              d="M8.75 1A2.75 2.75 0 0 0 6 3.75v.443c-.795.077-1.584.176-2.365.298a.75.75 0 1 0 .23 1.482l.149-.022.841 10.518A2.75 2.75 0 0 0 7.596 19h4.807a2.75 2.75 0 0 0 2.742-2.53l.841-10.52.149.023a.75.75 0 0 0 .23-1.482A41.03 41.03 0 0 0 14 4.193V3.75A2.75 2.75 0 0 0 11.25 1h-2.5ZM10 4c.84 0 1.673.025 2.5.075V3.75c0-.69-.56-1.25-1.25-1.25h-2.5c-.69 0-1.25.56-1.25 1.25v.325C8.327 4.025 9.16 4 10 4ZM8.58 7.72a.75.75 0 0 0-1.5.06l.3 7.5a.75.75 0 1 0 1.5-.06l-.3-7.5Zm4.34.06a.75.75 0 1 0-1.5-.06l-.3 7.5a.75.75 0 1 0 1.5.06l.3-7.5Z"
                                                              clip-rule="evenodd"
                                                          ></path>
                                                      </svg>

                                                      <svg
                                                          fill="none"
                                                          viewBox="0 0 24 24"
                                                          xmlns="http://www.w3.org/2000/svg"
                                                          class="animate-spin fi-dropdown-list-item-icon h-5 w-5 text-custom-500 dark:text-custom-400"
                                                          style="--c-400: var(--danger-400); --c-500: var(--danger-500);"
                                                          wire:loading.delay.default=""
                                                          wire:target="mountTableAction('delete', '6')"
                                                      >
                                                          <path
                                                              clip-rule="evenodd"
                                                              d="M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                                                              fill-rule="evenodd"
                                                              fill="currentColor"
                                                              opacity="0.2"
                                                          ></path>
                                                          <path d="M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z" fill="currentColor"></path>
                                                      </svg>

                                                          <span class="fi-dropdown-list-item-label flex-1 truncate text-start text-gray-700 dark:text-gray-200" style="">
                                                              Kalıcı Olarak Sil
                                                          </span>
                                                      </a>

                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </td> `;
                              directoryContents.appendChild(row);
                          });

                          document.querySelectorAll('#directoryContents a[data-is-folder="true"]').forEach(element => {
                              element.addEventListener('click', handleClick);
                          });

                          if (currentDirectory !== '/') {
                              goBackButton.classList.remove('hidden');
                          } else {
                              goBackButton.classList.add('hidden');
                          }
                      }
                  })
                  .catch(error => {
                      console.error('Error loading directory contents:', error);
                      alert('Error loading directory contents: ' + error.message);
                  });
              };

              window.showUploadModal = function() {
                  document.getElementById('uploadModal').classList.remove('hidden');
              };

              window.hideUploadModal = function() {
                  document.getElementById('uploadModal').classList.add('hidden');
              };

              document.getElementById('uploadForm').addEventListener('submit', function(event) {
                  event.preventDefault();
                  const fileInput = document.getElementById('fileInput');
                  const formData = new FormData();
                  formData.append('file', fileInput.files[0]);
                  formData.append('action', 'upload');
                  formData.append('dir', currentDirectory);
                  formData.append('username', username);
                  formData.append('password', password);
                  formData.append('_token', csrfToken);

                  fetch(ftp_handler, {
                      method: 'POST',
                      body: formData
                  })
                  .then(response => response.json())
                  .then(data => {
                       alert(data.original);
                       loadDirectoryContents(currentDirectory);
                       hideUploadModal();
                   })
                  .catch(error => {
                      console.error('Error uploading file:', error);
                      alert('Error uploading file: ' + error.message);
                  });
              });

              window.renameItem = function(path) {
                  const newName = prompt('Yeni ismi girin:', path.split('/').pop());
                  if (newName) {
                      const formData = new FormData();
                      formData.append('action', 'rename');
                      formData.append('path', path);
                      formData.append('newName', newName);
                      formData.append('username', username);
                      formData.append('password', password);
                      formData.append('_token', csrfToken);

                      fetch(ftp_handler, {
                          method: 'POST',
                          body: formData
                      })
                      .then(response => response.json())
                      .then(data => {
                           alert(data.original);
                           loadDirectoryContents(currentDirectory);
                       })
                      .catch(error => {
                          console.error('Error renaming item:', error);
                          alert('Error renaming item: ' + error.message);
                      });
                  }
              };

              window.downloadFile = function(path) {
                  const formData = new FormData();
                  formData.append('action', 'download');
                  formData.append('file', path);
                  formData.append('username', username);
                  formData.append('password', password);
                  formData.append('_token', csrfToken);

                  fetch(ftp_handler, {
                      method: 'POST',
                      body: formData
                  })
                  .then(response => response.blob())
                  .then(blob => {
                      const url = window.URL.createObjectURL(blob);
                      const a = document.createElement('a');
                      a.style.display = 'none';
                      a.href = url;
                      a.download = path.split('/').pop();
                      document.body.appendChild(a);
                      a.click();
                      window.URL.revokeObjectURL(url);
                  })
                  .catch(error => {
                      console.error('Error downloading file:', error);
                      alert('Error downloading file: ' + error.message);
                  });
              };

              window.deleteItem = function(path, isFolder) {
                  if (confirm('Bu dosyayı silmek istediğinizden emin misiniz?')) {
                      const formData = new FormData();
                      formData.append('action', 'delete');
                      formData.append('path', path);
                      formData.append('isFolder', isFolder ? 'true' : 'false');
                      formData.append('username', username);
                      formData.append('password', password);
                      formData.append('_token', csrfToken);

                      fetch(ftp_handler, {
                          method: 'POST',
                          body: formData
                      })
                      .then(response => response.json())
                      .then(data => {
                           alert(data.original);
                           loadDirectoryContents(currentDirectory);
                       })
                      .catch(error => {
                          console.error('Error deleting item:', error);
                          alert('Error deleting item: ' + error.message);
                      });
                  }
              };

              window.createFolder = function() {
                  const folderName = prompt('Yeni klasör adını girin:');
                  if (folderName && folderName.trim() !== '') {
                      const formData = new FormData();
                      formData.append('action', 'create');
                      formData.append('directory', currentDirectory);
                      formData.append('folderName', folderName);
                      formData.append('username', username);
                      formData.append('password', password);
                      formData.append('_token', csrfToken);

                      fetch(ftp_handler, {
                          method: 'POST',
                          body: formData
                      })
                      .then(response => response.json())
                      .then(data => {
                           alert(data.original);
                           loadDirectoryContents(currentDirectory);
                       })
                      .catch(error => {
                          console.error('Klasör oluşturulurken bir hata oluştu:', error);
                          alert('Klasör oluşturulurken bir hata oluştu: ' + error.message);
                      });
                  } else {
                      alert('Geçerli bir klasör adı girin.');
                  }
              };

              loadDirectoryContents('/');
          });
      </script>
    <?php endif; ?>
</main>


@include("layouts.footer")
