<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;
class EnsureProfileIsComplete
{
    public function handle(Request $request, Closure $next)
    {
        // Eğer login değilse, devam et
        if (!Session::has('client')) {
            return $next($request);
        }

        // Profil sayfasına izin ver
        if (Route::currentRouteName() === 'profile') {
            return $next($request);
        }

        $clientId = Session::get('client');

        // WHMCS'ten veriyi al (burada servis çağrısını yap)
        $whmcs = app()->make('App\Services\WhmcsService');
        $profile = $whmcs->getClientDetails($clientId);

        // Eğer WHMCS bağlantısında sorun varsa geç
        if (!isset($profile['result']) || $profile['result'] !== 'success') {
            return $next($request);
        }

        $fields = [
            $profile['firstname'] ?? '',
            $profile['lastname'] ?? '',
            $profile['address1'] ?? '',
            $profile['city'] ?? '',
            $profile['state'] ?? '',
            $profile['postcode'] ?? '',
        ];

        // customfields'ten TC, doğum yılı, telefon (senin verdiğin sıraya göre)
        $customfields = $profile['customfields'] ?? [];
        $tc       = $customfields[1]['value'] ?? '';
        $dogumyil = $customfields[2]['value'] ?? '';
        $tel      = $profile['phonenumber'] ?? '';

        $fields[] = $tc;
        $fields[] = $dogumyil;
        $fields[] = $tel;

        $isComplete = true;
        foreach ($fields as $f) {
            if (empty(trim($f))) {
                $isComplete = false;
                break;
            }
        }

        if (!$isComplete) {
            return redirect()->route('profile')
                ->with('error', 'Devam edebilmek için lütfen profil bilgilerinizi eksiksiz doldurunuz.');
        }

        return $next($request);
    }
}
