<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CartController extends Controller
{

  public function showCart(Request $request)
  {

      // POST ile gelen veriyi alalım
      $data = $request->input('cart');

      // Eğer veri boş değilse session'a kaydet
      if (!empty($data)) {
          session(['cart_data' => $data]);
          session()->save(); // Session'ı manuel olarak kaydet
      } else {
          Log::warning("POST ile veri gelmedi.");
      }

      // Session'daki veriyi alalım
      $sessionData = session('cart_data');

      // Session verisi yoksa logla
      if (empty($sessionData)) {
          Log::error("Session'da veri bulunamadı.");
      }

      // Ürün silme işlemi
      if ($request->isMethod('post') && $request->has('delete')) {
          // Silinecek productId'yi alıyoruz
          $productId = $request->input('delete');

          // Session'dan cart_data'yı alıyoruz ve JSON'dan array'e çeviriyoruz
          $sessionData = session('cart_data');
          $data = $sessionData ? json_decode($sessionData, true) : [];

          // Eğer items anahtarı mevcutsa işlem yapıyoruz
          if (isset($data['items'])) {
              // Silinecek ürünü items dizisinden çıkarıyoruz
              $data['items'] = array_values(array_filter($data['items'], function ($item) use ($productId) {
                  return $item['productId'] != $productId; // Tür kontrolü olmadan karşılaştırma
              }));

              // Güncellenen veriyi tekrar session'a kaydediyoruz
              session(['cart_data' => json_encode($data)]);
          }

          $deletedId = $productId ?? 'veri yok';
          \Log::info("Silinen Ürün ID: {$deletedId}");
      }

      $clientId = Session::get('client');
      $verify = Session::get('verifystatus');

      if ($verify == true) {
        $veri = "VAR";
      }else {
        $veri = "YOK";
      }

      if (!empty($clientId)) {
        // Burada işlem yapılmamış.
      } else {
        return redirect()->route('login');
      }



      return view('cart.show', [
          'sessionData' => session('cart_data'),
          'verify' => $veri
      ]);
  }



}
