<?php

namespace App\Filament\Resources\CurrencyResource\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Support\Enums\IconPosition;
use Illuminate\Support\Carbon;

use App\Models\Currency;

class ExchangeRatesOverview extends BaseWidget
{
    protected static ?string $pollingInterval = '120s';

    protected function getStats(): array
    {
        $currencies = Currency::where('is_featured', true)
            ->limit(4)
            ->get();

        $stats = [];
        foreach ($currencies as $currency) {
            $stats[] = Stat::make($currency['code'].'/TRY', $currency['buying'].' ₺')
                ->description(Carbon::parse($currency->updated_at)->translatedFormat('j F Y, H:i:s'))
                ->descriptionIcon('heroicon-o-clock', IconPosition::Before)
                ->icon('heroicon-m-banknotes');
        }

        return $stats;
    }
}
