<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum VehicleType: int implements HasLabel, HasIcon, HasColor
{
    case AUTOMOBILE = 1;
    case TRUCK      = 2;
    case TRAILER    = 3;

    public function getLabel(): string
    {
        return match ($this) {
            self::AUTOMOBILE    => 'Binek Araç',
            self::TRUCK         => 'Çekici',
            self::TRAILER       => 'Dorse',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::AUTOMOBILE    => 'warning',
            self::TRUCK         => 'info',
            self::TRAILER       => 'danger',
        };
    }

    public function getIcon(): string
    {
        return match ($this) {
            self::AUTOMOBILE    => 'heroicon-s-truck',
            self::TRUCK         => 'heroicon-s-truck',
            self::TRAILER       => 'heroicon-s-truck',
        };
    }
}
