<!-- Hero Section - Whois Search -->
<section class="whois-search-hero position-relative overflow-hidden">
    <div class="hero-background">
        <div class="hero-overlay"></div>
        <div class="hero-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
        </div>
    </div>

    <div class="container position-relative py-5" style="padding-top: 80px !important; padding-bottom: 80px !important;">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="text-center mb-4" data-sal="fade" data-sal-duration="600">
                    <h1 class="display-4 fw-bold text-white mb-3">Whois Sorgulama</h1>
                    <p class="lead text-white-50 mb-4">Domain bilgilerini sorgulayın ve detaylı Whois kayıtlarını görüntüleyin</p>
                </div>

                <!-- Whois Search Form -->
                <div class="whois-search-wrapper" data-sal="slide-up" data-sal-duration="600" data-sal-delay="200">
                    <form id="queryWhois" action="whois-sorgulama" method="GET" class="whois-search-form">
                        <div class="input-group whois-input-group">
                            <span class="input-group-text bg-white border-0">
                                <i class="fas fa-search text-muted"></i>
                            </span>
                            <input
                                type="text"
                                name="domain"
                                id="domain"
                                class="form-control border-0 px-4"
                                placeholder="Whois bilgisini öğrenmek istediğiniz alan adını yazın..."
                                required
                            />
                            <button class="btn btn-primary btn-search px-5" type="submit">
                                <span class="d-none d-md-inline">Whois </span>Sorgula
                                <i class="fas fa-arrow-right ms-2"></i>
                            </button>
                        </div>
                    </form>

                    <!-- Quick Links -->
                    <div class="quick-links mt-4">
                        <a href="https://serversistemleri.com/domain-sorgulama" class="quick-link" target="_blank">
                            <i class="fas fa-globe me-2"></i>Domain Sorgulama
                        </a>
                        <a href="https://serversistemleri.com/domain-transferi" class="quick-link" target="_blank">
                            <i class="fas fa-exchange-alt me-2"></i>Domain Transfer
                        </a>
                        <a href="https://sspanel.serversistemleri.com/" class="quick-link" target="_blank">
                            <i class="fas fa-sync me-2"></i>Domain Yenile
                        </a>
                        <a href="https://serversistemleri.com/whois-sorgulama" class="quick-link" target="_blank">
                            <i class="fas fa-info-circle me-2"></i>Whois Sorgulama
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Whois Results Section -->
<section class="whois-results-section py-5 whois-container" style="background: #f8f9fa; display: none;">
    <div class="container">
        <div class="row justify-content-center mb-4">
            <div class="col-lg-10">
                <div class="text-center" data-sal="fade" data-sal-duration="600">
                    <h2 class="fw-bold mb-3">Whois Bilgileri</h2>
                    <p class="text-muted">Alan adının detaylı kayıt bilgilerini aşağıda görebilirsiniz</p>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="row g-4">
                    <!-- Domain Information Card -->
                    <div class="col-md-6" data-sal="fade" data-sal-duration="600" data-sal-delay="100">
                        <div class="whois-card h-100">
                            <div class="whois-card-header">
                                <i class="fas fa-globe me-2"></i>
                                Alan Adı Bilgisi
                            </div>
                            <div class="whois-card-body">
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-tag text-primary me-2"></i>Alan Adı
                                    </span>
                                    <span class="whois-value fw-bold" id="domain_name">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-calendar-plus text-success me-2"></i>Kayıt Tarihi
                                    </span>
                                    <span class="whois-value">
                                        <span class="badge bg-success" id="registry_create_date">-</span>
                                    </span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-calendar-times text-danger me-2"></i>Son Kullanma Tarihi
                                    </span>
                                    <span class="whois-value">
                                        <span class="badge bg-danger">
                                            <span id="registry_expiry_date">-</span>
                                            (<span id="registry_remaining_days">-</span>)
                                        </span>
                                    </span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-calendar-check text-warning me-2"></i>Güncelleme Tarihi
                                    </span>
                                    <span class="whois-value">
                                        <span class="badge bg-warning text-dark" id="registry_update_date">-</span>
                                    </span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-info-circle text-info me-2"></i>Durum
                                    </span>
                                    <span class="whois-value text-end" id="status" style="flex-wrap: wrap; display: flex; justify-content: flex-end;">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-server text-primary me-2"></i>Ad Sunucuları
                                    </span>
                                    <span class="whois-value small" id="name_servers">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-building text-secondary me-2"></i>Kayıt Operatorü
                                    </span>
                                    <span class="whois-value fw-bold" id="registered_registrar_name">-</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information Card -->
                    <div class="col-md-6" data-sal="fade" data-sal-duration="600" data-sal-delay="200">
                        <div class="whois-card h-100">
                            <div class="whois-card-header">
                                <i class="fas fa-address-card me-2"></i>
                                Kayıt Sahibi İletişim
                            </div>
                            <div class="whois-card-body">
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-road text-primary me-2"></i>Sokak
                                    </span>
                                    <span class="whois-value" id="sokak">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-city text-primary me-2"></i>Şehir
                                    </span>
                                    <span class="whois-value" id="sehir">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-map text-primary me-2"></i>Eyalet
                                    </span>
                                    <span class="whois-value" id="eyalet">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-mail-bulk text-primary me-2"></i>Posta Kodu
                                    </span>
                                    <span class="whois-value" id="posta">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-flag text-primary me-2"></i>Ülke
                                    </span>
                                    <span class="whois-value" id="ulke">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-phone text-success me-2"></i>Telefon
                                    </span>
                                    <span class="whois-value" id="phone">-</span>
                                </div>
                                <div class="whois-info-item">
                                    <span class="whois-label">
                                        <i class="fas fa-envelope text-danger me-2"></i>E-posta
                                    </span>
                                    <span class="whois-value" id="email">-</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Raw Data Section -->
                <div class="row mt-4">
                    <div class="col-12" data-sal="fade" data-sal-duration="600" data-sal-delay="300">
                        <div class="whois-raw-data">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-code me-2"></i>Raw Data
                                </h5>
                                <button class="btn btn-sm btn-outline-light" onclick="copyRawData()">
                                    <i class="fas fa-copy me-1"></i>Kopyala
                                </button>
                            </div>
                            <pre class="whois-raw-content" id="rawdata">-</pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Domain Benefits Section -->
<section class="benefits-section py-5" style="padding-top: 100px !important; padding-bottom: 100px !important;">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center" data-sal="fade" data-sal-duration="600">
                <span class="badge bg-primary-soft text-primary mb-3 px-3 py-2">Avantajlar</span>
                <h2 class="display-5 fw-bold mb-4">Domain Avantajları</h2>
                <p class="text-muted fs-5">Ücretsiz hizmetler ve güçlü yönetim araçlarıyla domaininizi kolayca yönetin</p>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="100">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Ücretsiz Whois Gizleme</h5>
                    <p class="text-muted mb-0">
                        Alan adınızın kimlik bilgilerini ücretsiz olarak saklayabilirsiniz.
                    </p>
                </div>
            </div>

            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="200">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-network-wired"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Ücretsiz DNS Yönetimi</h5>
                    <p class="text-muted mb-0">
                        A Kaydı, Name Server Kaydı, MX Kaydı gibi işlemleri ücretsiz yapabilirsiniz.
                    </p>
                </div>
            </div>

            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="300">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-directions"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Ücretsiz Yönlendirme</h5>
                    <p class="text-muted mb-0">
                        Domain adresinizi farklı bir domain adresine ücretsiz yönlendirebilirsiniz.
                    </p>
                </div>
            </div>

            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="400">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-lock"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Ücretsiz Domain Kilidi</h5>
                    <p class="text-muted mb-0">
                        Alan adınızı olası izinsiz transferlere karşı ücretsiz kilitleyebilirsiniz.
                    </p>
                </div>
            </div>

            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="500">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-exchange-alt"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Ücretsiz İç Transfer</h5>
                    <p class="text-muted mb-0">
                        Alan adınızı firmamızda bulunan farklı bir hesaba ücretsiz transfer edebilirsiniz.
                    </p>
                </div>
            </div>

            <div class="col-md-6 col-lg-4" data-sal="fade" data-sal-duration="600" data-sal-delay="600">
                <div class="benefit-card h-100">
                    <div class="benefit-icon mb-4">
                        <i class="fas fa-cogs"></i>
                    </div>
                    <h5 class="fw-bold mb-3">Domain Yönetimi</h5>
                    <p class="text-muted mb-0">
                        Tüm alan adlarınızı SS-Panel'den kolayca yönetebilirsiniz.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<?php
$faq = [
    [
        "question" => "Domain Sorgulama Ücretli Midir?",
        "answer" => "Hayır. Domain sorgulama için hiçbir ücret ödemenize gerek yoktur."
    ],
    [
        "question" => "Süresi Biten Alan Adlarımı Nasıl Yenilerim?",
        "answer" => "SS-PANELE giriş yaparak domainlerim sekmesinden yenileme yapmak istediğiniz alan adını seçerek hemen yenileyebilirsiniz."
    ],
    [
        "question" => "Domain Transfer İçin Ne Yapmalıyım?",
        "answer" => 'Domain transferinizi gerçekleştirmek için alan adınızın şu anda bulunduğu firmadan "Transfer Kodu" temin etmeniz gerekir ve ardından domain transfer sayfamıza giderek ilgili kodu girip domain transferini başlatabilirsiniz.'
    ],
    [
        "question" => "Domain Satın Alma İçin Ne Yapmalıyım?",
        "answer" => "Satın almak istediğiniz anahtar kelime ve domain uzantısını domain arama bölümüne girin ve müsait durumdaki alan adını sepete atarak, ödemenizi yapın ve siparişinizi tamamlayın."
    ],
    [
        "question" => "Nasıl Ödeme Yapabilirim?",
        "answer" => "Kredi Kartı veya Banka Havalesi olarak ödeme yapabilirsiniz."
    ],
    [
        "question" => "Domainlerim Ne Zaman Aktif Olur?",
        "answer" => "Kredi kartı ile yapılan ödemeler anlık, banka havalesi ile yapılan işlemlerde ödeme teyidi 24 saat içerisinde yapılarak domainleriniz aktive edilir."
    ],
    [
        "question" => "Domainlerimi Neden ServerSistemleri'den Tescil Ettirmeliyim?",
        "answer" => "ServerSistemleri.com 1500+ den fazla domain uzantısını tescil etmekte olan çok nadir domain firmalarından birisidir. Domainleriniz özel müşteri temsilcisi ve destek ekiplerimizce 24 saat yönetilmektedir."
    ],
    [
        "question" => "Domain (Alan Adı) Nedir?",
        "answer" => "Domain, internet sitenizin webteki açık adresidir. Web adresinizi ziyaret etmek isteyen kişiler, domaini tarayıcıya yazarak internet sitenize ulaşır. Bir web sitesi açmak için domain satın almak zorundasınız."
    ],
    [
        "question" => "Domain Kime Ait, Nasıl Sorgularım?",
        "answer" => "Domain kime ait gibi bilgileri Whois sorgulama araçlarından öğrenebilirsiniz."
    ],
    [
        "question" => "Domain (Alan Adı) Tescili Nedir?",
        "answer" => "Alan adı, internet sitenizin web dünyasındaki adresidir. Alan adları bir IP adresi üzerinden çalışabilir. Eğer bir internet sitesi açmak istiyorsanız öncelikli olarak bir domain tescili yapmanız gereklidir."
    ],
    [
        "question" => "Domain Uzantısı Nedir?",
        "answer" => "Domain yani alan adı uzantısı, internet siteniz için tescil ettiğiniz domainin noktadan sonra başlayan kısmıdır. (Örn: .com.tr, .com, .org vb.)"
    ],
    [
        "question" => "Kayıt İşlemi Tamamlanan Domain Değiştirilebilir Mi?",
        "answer" => "Domain kayıt edildikten sonra, tescil edilen domain değiştirilemez ve ücret iadesi yapılamaz. Domain seçimi yaparken domain satın alma kurallarına dikkat etmenizi tavsiye ederiz."
    ],
    [
        "question" => "Hangi Domain Uzantısını Satın Almalıyım?",
        "answer" => "Dünyada en fazla .COM ve .NET domainleri satılmaktadır. İçerik farkı gözetmeden her web sitesi bu uzantıları kullanabilmektedir. Örneğin Rusya'da .ru domain uzantısı, Almanya'da .de domain uzantısı daha fazla satılmaktadır."
    ],
    [
        "question" => "İyi Bir Domain Nasıl Seçilir?",
        "answer" => "Domain tercih ederken dikkat ediniz. Markanızı veya firmanızı en iyi şekilde temsil edecek alan adınıza karar vermeniz gerekir. Akıcı, anlaşılır, kısa, kolay telaffuz edilen ve tire ile ayrılmayan bir domain seçin."
    ],
    [
        "question" => "Domain Satın Alma Yaparken Dikkat Etmem Gerekenler Nelerdir?",
        "answer" => "İnternet sitenizin konusu ile ilgili anahtar kelimeler içeren domainler daha akılda kalıcı olacaktır ve arama motoru sıralamasında ön sıralarda gelmenizi sağlayacaktır. Tescil edeceğiniz alan adının marka kaydı olup olmadığını kontrol edin."
    ],
    [
        "question" => "Domain Nasıl Transfer Edilir?",
        "answer" => "Tescil etmiş olduğunuz domainlerinizi, tescil tarihinden 60 gün geçtikten sonra transfer edebilirsiniz. Domain transfer sayfası üzerinden domain transferinizi başlatabilirsiniz."
    ],
    [
        "question" => "Domaini Satın Aldım, Web Sitemi Nasıl Aktive Ederim?",
        "answer" => "Domain satın aldıktan sonra yapmanız gereken tek işlem hosting satın almanızdır. Hosting satın aldıktan sonra NameServer adreslerini yönlendirmeniz yeterlidir."
    ],
    [
        "question" => "Domain İç Transfer İçin Ücret Ödemem Gerekli Mi?",
        "answer" => "ServerSistemleri üzerinde domain iç transferi ücretsizdir."
    ],
    [
        "question" => "Domain Süresi Bitince Ne Zaman Açığa Çıkar?",
        "answer" => "Domain süresi bitince hemen açığa çıkmaz. ServerSistemleri domain yenileme kurallarına göre, -20 gün içinde .com .net .org gibi domainleri yenileyebilirsiniz."
    ],
    [
        "question" => "Domain Sorgulama Nedir?",
        "answer" => "Bir alan adı kayıt etmeden önce domainin müsait mi sorgulamak gereklidir. Bu işleme domain sorgulama denir. Kayıtlı bir domainin Whois bilgilerine ulaşmak için Whois sayfamızı kullanabilirsiniz."
    ],
    [
        "question" => "Domain Tescili Neden Ücretlidir?",
        "answer" => "Domain kayıt işlemleri ICANN ve IANA tarafından yürütülmektedir. Sistemin sağlıklı işlemesi ve gerekli giderleri karşılamak için domain ücretsiz olarak tescil edilemez."
    ],
    [
        "question" => "Satın Almak İstediğim Domain Kayıtlı, Ne Yapabilirim?",
        "answer" => "Bazı domain uzantılarında belgeli işlem yapılmaktadır. Jenerik diye tanımlanan .com, .net, .org, vb. domainler ilk gelen alır kuralı ile çalışmaktadır."
    ],
    [
        "question" => "Kredi Kartı ile Domain Alırsam Hemen Aktif Olur mu?",
        "answer" => "Kredi kartı ile yapılan domain satın alma sonrası belge gerektirmeyen domain uzantıları hemen aktif olur. Belge gerektiren domainler için ödeme sonrası destek ekibimiz sizinle irtibata geçecektir."
    ],
    [
        "question" => "Kayıtlı Domain Değiştirilebilir Mi?",
        "answer" => "Tescil edilen bir domain maalesef değiştirilemez."
    ],
    [
        "question" => "Hosting Satın Almak Zorunlu Mu?",
        "answer" => "Domain aldığınız zaman hosting almak mecburi değildir. Ücretsiz DNS Yönetimi ve Domain Yönlendirme hizmetlerinden faydalanabilirsiniz."
    ],
    [
        "question" => "Domainim İçin DNS Oluşturabilir Miyim?",
        "answer" => "Alan adınız için özel DNS yani name server oluşturma işlemini ServerSistemleri müşteri paneliniz üzerinden yapabilirsiniz. Teknik destek ekibimizden destek alabilirsiniz."
    ],
    [
        "question" => "Domain Whois Gizleme Nedir?",
        "answer" => "Domain Whois Gizleme, alan adı satın alırken kullandığınız bilgilerinin başkaları tarafından gözükmesini engelleyen bir servistir. serversistemleri.com üzerinden Whois gizleme ücretsizdir."
    ],
    [
        "question" => "ServerSistemleri Nameserver Adresleri Nedir?",
        "answer" => "ServerSistemleri.com sunucularımızın nameserver adresleri unna1.serversistemleri.com ve unna2.serversistemleri.com'dur."
    ],
    [
        "question" => "Domain Adresimi ServerSistemleri.com'dan Başka Bir Firmaya Transfer Ettirebilir Miyim?",
        "answer" => "Evet. Dilediğiniz zaman domaininizi başka bir firmaya transfer edebilirsiniz."
    ]
];
?>

<section class="faq-section py-5 bg-light" style="padding-top: 100px !important; padding-bottom: 100px !important;">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center" data-sal="fade" data-sal-duration="600">
                <span class="badge bg-primary-soft text-primary mb-3 px-3 py-2">SSS</span>
                <h2 class="display-5 fw-bold mb-4">Sıkça Sorulan Sorular</h2>
                <p class="text-muted fs-5">Domain hakkında merak ettiklerinizi burada bulabilirsiniz</p>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="accordion faq-accordion" id="faqAccordion">
                    <div class="row">
                        <?php $faq_sira = 0; foreach ($faq as $key): $faq_sira++; ?>
                        <div class="col-lg-6 mb-4" data-sal="fade" data-sal-duration="600" data-sal-delay="<?php echo ($faq_sira % 2 == 0) ? '100' : '0'; ?>">
                            <div class="accordion-item border-0 rounded-3 shadow-sm">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-<?php echo $faq_sira; ?>">
                                        <i class="fas fa-question-circle text-primary me-3"></i>
                                        <span class="fw-semibold"><?php echo $key['question']; ?></span>
                                    </button>
                                </h2>
                                <div id="faq-<?php echo $faq_sira; ?>" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <p class="text-muted mb-0"><?php echo $key['answer']; ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Custom Styles -->
<style>
/* Whois Search Hero */
.whois-search-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 400px;
}

.hero-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    overflow: hidden;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.3);
}

.hero-shapes .shape {
    position: absolute;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    animation: float 20s infinite ease-in-out;
}

.hero-shapes .shape-1 {
    width: 300px;
    height: 300px;
    top: -100px;
    left: -100px;
}

.hero-shapes .shape-2 {
    width: 200px;
    height: 200px;
    top: 50%;
    right: -50px;
    animation-delay: 5s;
}

.hero-shapes .shape-3 {
    width: 150px;
    height: 150px;
    bottom: -50px;
    left: 30%;
    animation-delay: 10s;
}

@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-30px) rotate(180deg); }
}

/* Whois Search Form */
.whois-search-wrapper {
    max-width: 900px;
    margin: 0 auto;
}

.whois-search-form {
    background: white;
    border-radius: 60px;
    padding: 8px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.whois-input-group {
    border-radius: 60px;
    overflow: hidden;
}

.whois-input-group .input-group-text {
    padding: 0 1.5rem;
}

.whois-input-group .form-control {
    font-size: 1.1rem;
    padding: 1.5rem 1rem;
    box-shadow: none !important;
}

.whois-input-group .form-control:focus {
    outline: none;
}

.btn-search {
    border-radius: 50px;
    padding: 1rem 2rem;
    font-weight: 600;
    font-size: 1.1rem;
    white-space: nowrap;
}

/* Quick Links */
.quick-links {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 1rem;
}

.quick-link {
    color: white;
    text-decoration: none;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    font-size: 0.9rem;
}

.quick-link:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
    color: white;
}

/* Whois Cards */
.whois-card {
    background: white;
    border-radius: 1rem;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.whois-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(102, 126, 234, 0.15);
}

.whois-card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    font-weight: 700;
    font-size: 1.1rem;
    padding: 1.25rem 1.5rem;
    text-align: center;
}

.whois-card-body {
    padding: 1.5rem;
}

.whois-info-item {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    padding: 1rem 0;
    border-bottom: 1px solid #e9ecef;
    gap: 1rem;
}

.whois-info-item:last-child {
    border-bottom: none;
}

.whois-label {
    font-weight: 600;
    color: #333;
    display: flex;
    align-items: center;
    min-width: 40%;
    font-size: 0.9rem;
}

.whois-value {
    text-align: right;
    color: #6c757d;
    word-break: break-word;
    font-size: 0.9rem;
}

/* Raw Data Section */
.whois-raw-data {
    background: linear-gradient(135deg, #1e1e1e 0%, #2d2d2d 100%);
    border-radius: 1rem;
    padding: 1.5rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.whois-raw-content {
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 0.5rem;
    padding: 1.5rem;
    color: #d1d1d1;
    font-family: 'Courier New', monospace;
    font-size: 0.85rem;
    line-height: 1.6;
    max-height: 400px;
    overflow-y: auto;
    margin: 0;
}

.whois-raw-content::-webkit-scrollbar {
    width: 8px;
}

.whois-raw-content::-webkit-scrollbar-track {
    background: rgba(0, 0, 0, 0.2);
    border-radius: 4px;
}

.whois-raw-content::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.3);
    border-radius: 4px;
}

.whois-raw-content::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.5);
}

.whois-raw-data h5 {
    color: white;
}

/* Benefit Cards */
.benefit-card {
    padding: 2rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 1rem;
    transition: all 0.3s ease;
}

.benefit-card:hover {
    border-color: #667eea;
    transform: translateY(-10px);
    box-shadow: 0 15px 35px rgba(102, 126, 234, 0.15);
}

.benefit-icon {
    width: 80px;
    height: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 1rem;
    color: white;
    font-size: 2rem;
}

/* FAQ Accordion */
.faq-accordion .accordion-item {
    background: white;
    margin-bottom: 0;
    overflow: hidden;
}

.faq-accordion .accordion-button {
    padding: 1.25rem 1.5rem;
    background: white;
    border: none;
    font-size: 0.95rem;
    color: #333;
}

.faq-accordion .accordion-button:not(.collapsed) {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
    color: #667eea;
    box-shadow: none;
}

.faq-accordion .accordion-button:focus {
    box-shadow: none;
    border: none;
}

.faq-accordion .accordion-button::after {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23667eea'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
}

.faq-accordion .accordion-body {
    padding: 1.25rem 1.5rem;
    padding-top: 0;
}

/* Badge Soft */
.bg-primary-soft {
    background-color: rgba(102, 126, 234, 0.1);
}

/* Responsive */
@media (max-width: 768px) {
    .whois-search-hero {
        min-height: 350px;
    }

    .whois-input-group .form-control {
        font-size: 1rem;
        padding: 1rem;
    }

    .btn-search {
        padding: 1rem 1.5rem;
        font-size: 1rem;
    }

    .quick-links {
        display: none;
    }

    .whois-info-item {
        flex-direction: column;
        gap: 0.5rem;
    }

    .whois-label {
        min-width: 100%;
    }

    .whois-value {
        text-align: left;
    }

    .benefit-icon {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
}

@media (min-width: 1400px) {
    .container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container {
        max-width: 1200px;
    }
}
</style>

<!-- jQuery Library -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Custom Scripts -->
<script>
// Copy raw data function
function copyRawData() {
    const rawData = document.getElementById('rawdata').textContent;
    navigator.clipboard.writeText(rawData).then(() => {
        const btn = event.target.closest('button');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check me-1"></i>Kopyalandı!';
        setTimeout(() => {
            btn.innerHTML = originalHTML;
        }, 2000);
    });
}

// Global control variable
window.startWaitedOpt = true;

// Get domain parameter from URL and perform necessary checks
const urlParams = new URLSearchParams(window.location.search);
const domainParam = urlParams.get("domain");

if (domainParam && $("#domain").length) {
    // Write domain parameter from URL to input field
    $("#domain").val(domainParam);

    // Check and submit form at regular intervals
    const intervalId = setInterval(() => {
        if (window.startWaitedOpt) {
            if ($("#queryWhois").length) {
                $("#queryWhois").submit();
                clearInterval(intervalId);
            } else {
                console.error("Form '#queryWhois' not found.");
                clearInterval(intervalId);
            }
        }
    }, 200);
} else {
    console.warn("Required parameters or DOM elements not found.");
}

// Document ready
$(document).ready(function () {
    // Form submit handler
    $('#queryWhois').on('submit', function (e) {
        e.preventDefault();

        var domain = $('#domain').val();

        // Show preloader, hide content
        $(".preloader").show();
        $(".whois-container").hide();

        // AJAX request
        $.ajax({
            url: `https://serversistemleri.com/api/whois.php?query=${domain}`,
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                // Extract and place information from incoming data
                const regrInfo = response.regrinfo || {};
                const domainInfo = regrInfo.domain || {};
                const regyInfo = response.regyinfo || {};
                const rawdata = response.rawdata || [];

                // Helper function to extract value from rawdata
                function extractFromRawdata(key) {
                    const line = rawdata.find(e => e.includes(key + ':'));
                    if (line) {
                        const parts = line.split(':');
                        return parts.slice(1).join(':').trim().replace('\r', '');
                    }
                    return null;
                }

                // Domain information - Status
                if (domainInfo.status && domainInfo.status.length > 0) {
                    // Clean up status values (remove URLs)
                    const statusValues = domainInfo.status.map(s => {
                        return s.split(' ')[0].replace('https://icann.org/epp#', '').replace('https://www.icann.org/epp#', '');
                    });
                    $('#status').html(statusValues.map(s => `<span class="badge bg-info text-dark me-1 mb-1">${s}</span>`).join(''));
                } else {
                    $('#status').text(' - ');
                }

                $('#registry_create_date').text(domainInfo.created || ' - ');
                $('#registry_update_date').text(domainInfo.changed || ' - ');

                // Extract registrant information from rawdata
                const registrantStreet = extractFromRawdata('Registrant Street');
                const registrantCity = extractFromRawdata('Registrant City');
                const registrantState = extractFromRawdata('Registrant State / Province') || extractFromRawdata('Registrant State');
                const registrantPostal = extractFromRawdata('Registrant Postal Code');
                const registrantCountry = extractFromRawdata('Registrant Country');
                const registrantPhone = extractFromRawdata('Registrant Phone');
                const registrantEmail = extractFromRawdata('Registrant Email');

                // Fill contact information
                $('#sokak').text(registrantStreet || ' - ');
                $('#sehir').text(registrantCity || ' - ');
                $('#eyalet').text(registrantState || ' - ');
                $('#posta').text(registrantPostal || ' - ');
                $('#ulke').text(registrantCountry || ' - ');
                $('#phone').text(registrantPhone || ' - ');
                $('#email').text(registrantEmail || ' - ');

                // List name server information
                let nameServersHtml = '';
                if (domainInfo.nserver) {
                    for (const [server, ip] of Object.entries(domainInfo.nserver)) {
                        nameServersHtml += `<div class="mb-1"><small>${server} (${ip})</small></div>`;
                    }
                } else {
                    nameServersHtml = ' - ';
                }
                $('#name_servers').html(nameServersHtml);
                $('#domain_name').html(domain);

                // Registrar information
                $('#registered_registrar_name').text(regyInfo.registrar || ' - ');

                // Function to convert date from various formats to "DD-MM-YYYY"
                function formatDate(dateString) {
                    if (!dateString) return ' - ';

                    // If already in DD-MM-YYYY format, return as is
                    if (/^\d{2}-\d{2}-\d{4}$/.test(dateString)) {
                        return dateString;
                    }

                    // Try different date formats
                    let date;
                    if (dateString.includes('T')) {
                        // ISO format: 2025-02-18T23:32:57Z
                        date = new Date(dateString);
                    } else if (dateString.includes('-')) {
                        const parts = dateString.split("-");
                        if (parts[0].length === 4) {
                            // YYYY-MM-DD format
                            date = new Date(parts[0], parts[1] - 1, parts[2]);
                        } else {
                            // DD-MM-YYYY format
                            return dateString;
                        }
                    } else {
                        return dateString; // Return as is if format unknown
                    }

                    const day = String(date.getDate()).padStart(2, '0');
                    const month = String(date.getMonth() + 1).padStart(2, '0');
                    const year = date.getFullYear();
                    return `${day}-${month}-${year}`;
                }

                // Function to calculate remaining days between two dates
                function calculateRemainingDays(currentDate, targetDate) {
                    const oneDay = 24 * 60 * 60 * 1000;
                    const diffDays = Math.round((targetDate - currentDate) / oneDay);
                    return diffDays;
                }

                // Extract and format expiry date - try API data first, then rawdata
                let expiryDateRaw = null;

                // First try to get from API response (for .tr domains)
                if (domainInfo.expires) {
                    expiryDateRaw = domainInfo.expires;
                } else {
                    // Fallback to rawdata (for .com domains)
                    const expiryLine = rawdata.find(e =>
                        e.includes('Registry Expiry Date:') ||
                        e.includes('Registrar Registration Expiration Date:') ||
                        e.includes('Expiration Date:') ||
                        e.includes('Expires on')
                    );

                    if (expiryLine) {
                        expiryDateRaw = expiryLine.split(':').slice(1).join(':').trim().replace('\r', '');
                    }
                }

                if (expiryDateRaw) {
                    const expiryDateFormatted = formatDate(expiryDateRaw);
                    $("#registry_expiry_date").text(expiryDateFormatted);

                    // Calculate remaining days
                    let expiryDate;
                    if (expiryDateRaw.includes('T')) {
                        // ISO format
                        expiryDate = new Date(expiryDateRaw);
                    } else if (/^\d{2}-\d{2}-\d{4}$/.test(expiryDateRaw)) {
                        // DD-MM-YYYY format (from .tr domains)
                        const [day, month, year] = expiryDateRaw.split("-");
                        expiryDate = new Date(year, month - 1, day);
                    } else if (/^\d{4}-\d{2}-\d{2}$/.test(expiryDateRaw)) {
                        // YYYY-MM-DD format
                        const [year, month, day] = expiryDateRaw.split("-");
                        expiryDate = new Date(year, month - 1, day);
                    }

                    if (expiryDate && !isNaN(expiryDate.getTime())) {
                        const remainingDays = calculateRemainingDays(new Date().getTime(), expiryDate.getTime());
                        $("#registry_remaining_days").text(remainingDays + " Gün Kaldı");
                    } else {
                        $("#registry_remaining_days").text(' - ');
                    }
                } else {
                    $("#registry_expiry_date").text(' - ');
                    $("#registry_remaining_days").text(' - ');
                }

                // Update creation and update dates from domain info
                if (domainInfo.created) {
                    $('#registry_create_date').text(domainInfo.created);
                }
                if (domainInfo.changed) {
                    $('#registry_update_date').text(domainInfo.changed);
                }

                var rd = [];
                for (let el of response.rawdata) {
                    if (el.indexOf("URL of the ICANN") > -1) {
                        break;
                    }
                    rd.push(el);
                }
                $("#rawdata").html(rd.join("<br>"));

                // Hide preloader and show content when AJAX completes
                $(".preloader").fadeOut("slow", function () {
                    $(".whois-container").fadeIn("slow");
                });
            },
            error: function (xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert("Bir hata oluştu. Lütfen tekrar deneyin.");
                $(".preloader").fadeOut("slow");
            }
        });
    });

    <?php if (isset($_GET["domain"])): ?>
        $("#queryWhois").submit();
    <?php endif; ?>
});
</script>
