<style>
/* Hero Section */
.hero-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 570px;
}

.hero-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    overflow: hidden;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.3);
}

.hero-shapes .shape {
    position: absolute;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    animation: float 20s infinite ease-in-out;
}

.hero-shapes .shape-1 {
    width: 300px;
    height: 300px;
    top: -100px;
    left: -100px;
    animation-delay: 0s;
}

.hero-shapes .shape-2 {
    width: 200px;
    height: 200px;
    top: 50%;
    right: -50px;
    animation-delay: 5s;
}

.hero-shapes .shape-3 {
    width: 150px;
    height: 150px;
    bottom: -50px;
    left: 30%;
    animation-delay: 10s;
}

@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-30px) rotate(180deg); }
}

.hero-title {
    font-size: clamp(2rem, 5vw, 3.5rem);
    font-weight: 800;
    line-height: 1.2;
}

.text-gradient {
    background: linear-gradient(135deg, #ffd89b 0%, #19547b 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-subtitle {
    font-size: clamp(1rem, 2vw, 1.25rem);
}

/* Domain Search Form */
.domain-search-wrapper {
    max-width: 900px;
    margin: 0 auto;
}

.domain-search-form {
    background: white;
    border-radius: 60px;
    padding: 8px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.domain-input-group {
    border-radius: 60px;
    overflow: hidden;
}

.domain-input-group .input-group-text {
    padding: 0 1.5rem;
}

.domain-input-group .form-control {
    font-size: 1.1rem;
    padding: 1.5rem 1rem;
    box-shadow: none !important;
}

.domain-input-group .form-control:focus {
    outline: none;
}

.btn-search {
    border-radius: 50px;
    padding: 1rem 2rem;
    font-weight: 600;
    font-size: 1.1rem;
    white-space: nowrap;
}
.btn-search:hover{
  background-color: #ed62e6 !important;
}

/* Quick Links */
.quick-links {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 1rem;
}

.quick-link {
    color: white;
    text-decoration: none;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    font-size: 0.9rem;
}

.quick-link:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
    color: white;
}

/* Trust Badges */
.letter-spacing-1 {
    letter-spacing: 1px;
}

.badge-item {
    display: flex;
    align-items: center;
    padding: 0.75rem 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border-radius: 30px;
}

/* Promotional Slider */
.promotional-slider {
    position: relative;
}

.slider-container {
    background: white;
    position: relative;
    height: 100%;
}

.slider-wrapper {
    position: relative;
    overflow: hidden;
    border-radius: 1rem;
    height: 100%;
}

.slider-item {
    display: none;
    width: 100%;
}

.slider-item:first-child {
    display: block;
}

.slider-item img {
    width: 100%;
    height: auto;
    display: block;
}

.slider-btn {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(255, 255, 255, 0.9);
    border: none;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    cursor: pointer;
    z-index: 10;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #333;
}

.slider-btn:hover {
    background: white;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}

.slider-prev {
    left: 20px;
}

.slider-next {
    right: 20px;
}

.slider-dots {
    position: absolute;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 10px;
    z-index: 10;
}

.slider-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.5);
    cursor: pointer;
    transition: all 0.3s ease;
}

.slider-dot.active {
    background: white;
    width: 30px;
    border-radius: 5px;
}

/* Domain Prices Card */
.domain-prices-card .card {
    transition: transform 0.3s ease;
}

.domain-prices-card .card:hover {
    transform: translateY(-5px);
}

.domain-price-grid {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.domain-price-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 0.5rem;
    transition: all 0.3s ease;
}

.domain-price-item:hover {
    background: #e9ecef;
    transform: translateX(5px);
}

.domain-ext {
    font-weight: 700;
    font-size: 1.2rem;
    color: #333;
}

.domain-price {
    text-align: right;
}

.price-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #667eea;
}

.price-period {
    font-size: 0.9rem;
    color: #6c757d;
}

/* Service Tabs */
.service-tabs-wrapper {
    background: white;
    border-radius: 60px;
    padding: 0.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    overflow-x: auto;
}

.service-tabs {
    flex-wrap: nowrap;
    gap: 0.5rem;
    border: none;
}

.service-tabs .nav-link {
    border: none;
    border-radius: 50px;
    padding: 0.75rem 1.5rem;
    color: #6c757d;
    font-weight: 600;
    white-space: nowrap;
    transition: all 0.3s ease;
}

.service-tabs .nav-link:hover {
    background: #f8f9fa;
    color: #333;
}

.service-tabs .nav-link.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

/* Pricing Cards */
.pricing-card .card {
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.pricing-card .card:hover {
    transform: translateY(-10px);
    border-color: #667eea;
    box-shadow: 0 20px 40px rgba(102, 126, 234, 0.2) !important;
}

.pricing-icon {
    display: flex;
    align-items: center;
    justify-content: center;
}

.pricing-amount {
    padding: 1.5rem 0;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 1rem;
}

.price-wrapper {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
}

.currency-symbol {
    font-size: 1.5rem;
    font-weight: 600;
    color: #667eea;
}

.pricing-amount .price-value {
    font-size: 2.5rem;
    font-weight: 800;
    color: #667eea;
}

.pricing-amount .price-period {
    font-size: 1rem;
    color: #6c757d;
}

.pricing-features ul li {
    display: flex;
    align-items: flex-start;
}

.pricing-features .fa-check-circle {
    flex-shrink: 0;
    margin-top: 3px;
}

.shadow-hover {
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
}

/* Domain Extensions Grid */
.domain-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 1rem;
}

.domain-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 0.75rem;
    text-decoration: none;
    transition: all 0.3s ease;
}

.domain-item:hover {
    border-color: #667eea;
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.15);
}

.domain-item img {
    width: 40px;
    height: 30px;
    object-fit: contain;
}

.domain-info {
    display: flex;
    flex-direction: column;
}

.domain-ext {
    font-weight: 700;
    color: #333;
    font-size: 1.1rem;
}

.domain-country {
    font-size: 0.85rem;
    color: #6c757d;
}

/* Stats Section */
.stats-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stats-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image:
        radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.05) 0%, transparent 50%),
        radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.05) 0%, transparent 50%);
}

.stat-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.2);
    border-radius: 1rem;
    padding: 2rem 1rem;
    transition: all 0.3s ease;
}

.stat-card:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-10px);
}

.stat-icon {
    font-size: 3rem;
    color: white;
}

.stat-number {
    font-size: 3rem;
    font-weight: 800;
    color: white;
    margin-bottom: 0.5rem;
}

.stat-label {
    font-size: 0.95rem;
    color: rgba(255, 255, 255, 0.9);
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* Feature Cards */
.feature-card {
    padding: 2rem;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 1rem;
    transition: all 0.3s ease;
}

.feature-card:hover {
    border-color: #667eea;
    transform: translateY(-10px);
    box-shadow: 0 15px 35px rgba(102, 126, 234, 0.15);
}

.feature-icon {
    width: 80px;
    height: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 1rem;
    color: white;
    font-size: 2rem;
}

/* Badge Soft */
.bg-primary-soft {
    background-color: rgba(102, 126, 234, 0.1);
}

/* Responsive */
@media (max-width: 768px) {
    .hero-title {
        font-size: 2rem;
    }

    .domain-input-group .form-control {
        font-size: 1rem;
        padding: 1rem;
    }

    .btn-search {
        padding: 1rem 1.5rem;
        font-size: 1rem;
    }

    .service-tabs .nav-link {
        padding: 0.5rem 1rem;
        font-size: 0.9rem;
    }

    .slider-btn {
        width: 40px;
        height: 40px;
    }

    .slider-prev {
        left: 10px;
    }

    .slider-next {
        right: 10px;
    }

    .domain-grid {
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
    }

    .stat-number {
        font-size: 2rem;
    }

    .stat-icon {
        font-size: 2rem;
    }
}
</style>
<section class="hero-section position-relative overflow-hidden">
    <div class="hero-background">
        <div class="hero-overlay"></div>
        <div class="hero-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
        </div>
    </div>

    <div class="container position-relative" style="padding-top: 120px; padding-bottom: 120px;">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-8">
                <div class="hero-content text-center" data-sal="fade" data-sal-duration="800">
                    <h1 class="hero-title text-white mb-4">
                        Dijital Dünyanızı <span class="text-gradient">Güçlendirin</span>
                    </h1>
                    <p class="hero-subtitle text-white-50 mb-5 fs-6">
                        Hızlı, güvenli ve ölçeklenebilir hosting çözümleriyle web sitenizi bir üst seviyeye taşıyın
                    </p>

                    <!-- Domain Search Form -->
                    <div class="domain-search-wrapper" data-sal="slide-up" data-sal-duration="600" data-sal-delay="200">
                        <form action="domain-sorgulama" method="GET" class="domain-search-form">
                            <div class="input-group domain-input-group">
                                <span class="input-group-text bg-white border-0">
                                    <i class="fas fa-search text-muted"></i>
                                </span>
                                <input
                                    type="text"
                                    id="domain"
                                    name="domain"
                                    class="form-control border-0 px-4"
                                    placeholder="Hayalinizdeki alan adını yazın... örn: siteniz.com"
                                    required
                                />
                                <button class="btn btn-primary btn-search px-5" type="submit">
                                    <span class="d-none d-md-inline">Alan Adı </span>Sorgula
                                    <i class="fas fa-arrow-right ms-2"></i>
                                </button>
                            </div>
                        </form>

                        <!-- Quick Links -->
                        <div class="quick-links mt-4">
                            <a href="https://serversistemleri.com/domain-sorgulama" class="quick-link" target="_blank">
                                <i class="fas fa-globe me-2"></i>Domain Sorgulama
                            </a>
                            <a href="https://serversistemleri.com/domain-transferi" class="quick-link" target="_blank">
                                <i class="fas fa-exchange-alt me-2"></i>Domain Transfer
                            </a>
                            <a href="https://sspanel.serversistemleri.com/" class="quick-link" target="_blank">
                                <i class="fas fa-sync me-2"></i>Domain Yenile
                            </a>
                            <a href="https://serversistemleri.com/whois-sorgulama" class="quick-link" target="_blank">
                                <i class="fas fa-info-circle me-2"></i>Whois Sorgulama
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container_slider">
  <div class="col-sm">
    <div class="slider-wrapper_slider">
        <div class="slider_slider" id="slider">
            <a href="/domain-sorgulama" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-1.webp" alt="Slider 1" />
            </a>
            <a href="/bireysel-hosting" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-2.webp" alt="Slider 2" />
            </a>
            <a href="/kurumsal-mail" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-3.webp" alt="Slider 3" />
            </a>
            <a href="/backup" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-4.webp" alt="Slider 4" />
            </a>
            <a href="/ssd-bulut-sunucular" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-5.webp" alt="Slider 5" />
            </a>
            <a href="/etugra-ssl-sertifikasi" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-6.webp" alt="Slider 6" />
            </a>
            <a href="/araclar" class="slide_slider">
                <img src="<?php echo $site_url; ?>assets/img/slider-7.webp" alt="Slider 7" />
            </a>
        </div>
        <button class="slibutton_slider prev_slider" id="prev">&#10094;</button>
        <button class="slibutton_slider next_slider" id="next">&#10095;</button>
    </div>
  </div>
  <div class="col-md-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="400" data-sal-easing="ease-in-out-sine">
    <div class="card border-0 shadow-sm rounded-4 h-100">
      <div class="card-body p-md-6 p-xl-8">
        <div class="row row-cols-2 d-flex justify-content-center align-items-center text-center h-100" style="height: 100vh;">
          <div class="col-sm-6 d-flex justify-content-center align-items-center border-end">
            <div class="caption">
              <h4 class="mb-4">.com</h4>
              <p><span class="old-price">$<?php echo number_format($whmcs->GetTLDPricing('com')['register']['1'], 2, ',', ''); ?></span></p>
            </div>
          </div>
          <div class="col-sm-6 d-flex justify-content-center align-items-center">
            <div class="caption">
              <h4 class="mb-4">.com.tr</h4>
              <p><span class="old-price">$<?php echo number_format($whmcs->GetTLDPricing('com.tr')['register']['1'], 2, ',', ''); ?></span></p>
            </div>
          </div>
          <div class="col-sm-6 d-flex justify-content-center align-items-center border-end">
            <div class="caption">
              <h4 class="mb-4">.net</h4>
              <p><span class="old-price">$<?php echo number_format($whmcs->GetTLDPricing('net')['register']['1'], 2, ',', ''); ?></span></p>
            </div>
          </div>
          <div class="col-sm-6 d-flex justify-content-center align-items-center">
            <div class="caption">
              <h4 class="mb-4">.org</h4>
              <p><span class="old-price">$<?php echo number_format($whmcs->GetTLDPricing('org')['register']['1'], 2, ',', ''); ?></span></p>
            </div>
          </div>

          <div class="no-90 col-12">
            <a href="/domain-sorgulama" class="btn btn-dark btn-arrow btn-lg w-100 fs-14 fw-bolder rounded mt-6">
              <span class="btn-arrow__text">Hemen Sorgula<span class="btn-arrow__icon"><i class="las la-arrow-right"></i></span></span>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
    <section class="">
    <div class="pt-80 pb-60">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="text-center">
                        <h2 class="ss-font-size-43 text-dark mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">Web Siteniz ve Kurumsal Gereksinimleriniz İçin Özel Çözümler</h2>
                        <p  class="text-dark text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                          Web siteniz için yüksek performanslı hosting çözümleri, kurumsal ihtiyaçlarınız için profesyonel ve güvenilir hizmetler sunuyoruz. <br> Sizinle büyüyen iş ortaklığımızla, dijital dünyada güçlü bir varlık oluşturun!
                        </p>
                        <div class="d-flex justify-content-center sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                            <div class="pricing-nav-pills d-inline-block mx-auto py-2 px-3 border rounded-pill overflow-x-auto">
                                <ul class="nav nav-pills flex-nowrap" role="tablist">
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14 active" href="#" data-bs-toggle="pill" data-bs-target="#web-sitesi-cozumleri" aria-selected="true" role="tab">
                                            Web Sitesi Çözümleri
                                        </a>
                                    </li>
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14" href="#" data-bs-toggle="pill" data-bs-target="#ssd-bulut-sunucu" aria-selected="false" tabindex="-1" role="tab">
                                            SSD Bulut Sunucu
                                        </a>
                                    </li>
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14" href="#" data-bs-toggle="pill" data-bs-target="#sunucu-barindirma" aria-selected="false" tabindex="-1" role="tab">
                                           Sunucu Barındırma
                                        </a>
                                    </li>
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14" href="#" data-bs-toggle="pill" data-bs-target="#kurumsal-mail" aria-selected="false" tabindex="-1" role="tab">
                                            Kurumsal Mail
                                        </a>
                                    </li>
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14" href="#" data-bs-toggle="pill" data-bs-target="#ssl" aria-selected="false" tabindex="-1" role="tab">
                                            SSL
                                        </a>
                                    </li>
                                    <li class="nav-item flex-shrink-0" role="presentation">
                                        <a class="text-dark nav-link rounded-pill fs-14" href="#" data-bs-toggle="pill" data-bs-target="#yedekleme" aria-selected="false" tabindex="-1" role="tab">
                                            Yedekleme
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12">
                <div class="tab-content sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                    <?php foreach ($plans as $planId => $plan): ?>
                      <div class="tab-pane fade <?php if ($planId == 'web-sitesi-cozumleri'): ?>show active<?php endif; ?>" id="<?php echo $planId ?>" role="tabpanel">
                        <div class="row g-4">
                          <?php foreach ($plan['products'] as $product): ?>
                            <?php
                            $fiyat_usd = number_format($product['price_usd'], 2); // USD formatlama
                            $fiyat_try = number_format($product['price_usd'] * $currency_rate, 2); // TRY formatlama
                            ?>
                            <div class="paket-baslat col-xl-<?php echo count($plan['products']) == 4 ? 3 : (count($plan['products']) == 3 ? 4 : ''); ?> col-md-6">
                              <div class="paket-ust-<?php echo count($plan['products']) == 4 ? 4 : (count($plan['products']) == 3 ? 3 : ''); ?> ">
                                <svg id="katman_1" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 282.9 51.7">
                                  <path id="Path_706" d="M280.2,169.9l-4.4,189.7"/>
                                  <path id="Path_7061" data-name="Path_706" d="M282,92.7l-1.8,77.2"/>
                                  <path id="Path_7062" data-name="Path_706" d="M282.9,51.7l-1,41"/>
                                  <path id="Path_7063" data-name="Path_706" d="M.2,51.7L0,12,233.4,0c27.4,0,49.6,23.1,49.6,51.7"/>
                                  <path id="Path_7064" data-name="Path_706" d="M.5,92.7l-.2-41"/>
                                  <path id="Path_7065" data-name="Path_706" d="M1.1,192.5L.5,92.7"/>
                                  <path id="Path_7066" data-name="Path_706" d="M3.3,573.9L1.1,192.5"/>
                                  <path id="Path_7067" data-name="Path_706" d="M270.6,579.2l-267.3-5.4"/>
                                  <path id="Path_7068" data-name="Path_706" d="M275.8,359.6l-5.1,219.6"/>
                                </svg>
                              </div>
                              <div class="price-card-item-one position-relative overflow-hidden bg-white px-7 py-9 border-end rounded-3" style="border-radius: 0 50px 0 0 !important;">
                                <div class="text-center">
                                  <img style="height:82px;" src="<?php echo $product['img'] ?>" alt="image" class="img-fluid mb-5" />
                                  <h6 class="mb-1"><?php echo $product['title'] ?></h6>
                                  <small><?php echo $product['description'] ?></small>
                                  <div class="mt-5">
                                    <div class="monthly-price">
                                      <h4 class="mb-0"><try>₺<?php echo $fiyat_try; ?></try><usd>$<?php echo $fiyat_usd; ?></usd></h4>
                                    </div>
                                  </div>
                                </div>
                                <a class="btn btn-dark btn-arrow btn-lg w-100 fs-14 fw-bolder rounded mt-6" href="<?php echo $product['link'] ?>">
                                  <span class="btn-arrow__text">
                                    <?php echo $product['button_title']; ?>
                                    <span class="btn-arrow__icon">
                                      <i class="las la-arrow-right"></i>
                                    </span>
                                  </span>
                                </a>
                                <div class="mt-6">
                                  <h6 class="mb-5">Neden <?php echo $product['title'] ?>?</h6>
                                  <ul class="price-service-wrapper list-unstyled d-flex flex-column gap-3 mb-0">
                                    <?php foreach ($product['features'] as $featureTitle => $featureDescription): ?>
                                      <li class="d-flex align-items-center gap-3">
                                        <i class="fa-solid fa-check-to-slot"></i>
                                          <small><span class="fw-bold"><?php echo $featureTitle ?></span> <?php echo $featureDescription ?></small>
                                        </li>
                                      <?php endforeach; ?>
                                    </ul>
                                  </div>
                                </div>

                              </div>
                            <?php endforeach; ?>
                          </div>
                        </div>
                      <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="ss-section registry-section" style="background:white;margin-top: 50px;">
    <div class="container">
        <div class="row no-gutters">
            <div class="col-lg-12">
                <div class="registry-wrap p-4 p-md-5">
                      <div class="container">
                          <div class="row justify-content-center">
                              <div class="col-12">
                                  <div class="text-center">
                                      <h2 class="text-dark mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                                          Dünya geneli domain tescili
                                      </h2>
                                      <p class="text-dark text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                                        Ülkelere özel domain tescil hizmeti sunuyoruz. <b>.tr</b>, <b>.uk</b>, </b>.de</b> gibi ülke uzantılı alan adlarını kolayca kaydedebilir ve web sitenizin yerel pazarda güçlü bir kimlik kazanmasını sağlayabilirsiniz. Tüm dünya geneli yerel uzantılarla, işletmenizi hedef kitlenize daha yakın hale getirin.
                                      </p>
                                  </div>
                              </div>
                          </div>
                      </div>
                    <div class="registry-list-container ss-animate registry-list-collapse fadeInUp ss-animated">
                        <div class="registry-list-content" id="registryList">
                            <div class="registry-list-item">
                                <a href="uzanti/tr">
                                    <img alt=".tr" class="ss-registry-flags registry-tr" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.tr</span><span class="ss-registry-land">Türkiye</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/africa">
                                    <img alt=".africa" class="ss-registry-flags registry-gm" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.africa</span><span class="ss-registry-land">Afrika</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/de">
                                    <img alt=".de" class="ss-registry-flags registry-de" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.de</span><span class="ss-registry-land">Almanya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/us">
                                    <img alt=".us" class="ss-registry-flags registry-us" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.us</span><span class="ss-registry-land">Amerika</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/com-ar">
                                    <img alt=".com.ar" class="ss-registry-flags registry-ar" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.com.ar</span><span class="ss-registry-land">Arjantin</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/al">
                                    <img alt=".al" class="ss-registry-flags registry-al" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.al</span><span class="ss-registry-land">Arnavutluk</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/eu">
                                    <img alt=".az" class="ss-registry-flags registry-eu" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.eu</span><span class="ss-registry-land">Avrupa</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/az">
                                    <img alt=".az" class="ss-registry-flags registry-az" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.az</span><span class="ss-registry-land">Azerbaycan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/com-br">
                                    <img alt=".com.br" class="ss-registry-flags registry-br" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.com.br</span><span class="ss-registry-land">Brezilya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/dj">
                                    <img alt=".dj" class="ss-registry-flags registry-dj" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.dj</span><span class="ss-registry-land">Cibuti</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/cn">
                                    <img alt=".cn" class="ss-registry-flags registry-cn" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.cn</span><span class="ss-registry-land">Çin</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/dm">
                                    <img alt=".dm" class="ss-registry-flags registry-dm" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.dm</span><span class="ss-registry-land">Dominika</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/ma">
                                    <img alt=".ma" class="ss-registry-flags registry-ma" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ma</span><span class="ss-registry-land">Fas</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/fr">
                                    <img alt=".fr" class="ss-registry-flags registry-fr" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.fr</span><span class="ss-registry-land">Fransa</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/co-za">
                                    <img alt=".co.za" class="ss-registry-flags registry-za" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.co.za</span><span class="ss-registry-land">G. Afrika</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/kr">
                                    <img alt=".kr" class="ss-registry-flags registry-kr" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.kr</span><span class="ss-registry-land">Güney Kore</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/it">
                                    <img alt=".ge" class="ss-registry-flags registry-ge" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ge</span><span class="ss-registry-land">Gürcistan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/in">
                                    <img alt=".in" class="ss-registry-flags registry-in" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.in</span><span class="ss-registry-land">Hindistan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/hk">
                                    <img alt=".hk" class="ss-registry-flags registry-hk" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.hk</span><span class="ss-registry-land">Hong Kong</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/co-uk">
                                    <img alt=".co.uk" class="ss-registry-flags registry-uk" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.co.uk</span><span class="ss-registry-land">İngiltere</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/ir">
                                    <img alt=".ir" class="ss-registry-flags registry-ir" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ir</span><span class="ss-registry-land">İran</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/es">
                                    <img alt=".es" class="ss-registry-flags registry-es" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.es</span><span class="ss-registry-land">İspanya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/it">
                                    <img alt=".it" class="ss-registry-flags registry-it" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.it</span><span class="ss-registry-land">İtalya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/jm">
                                    <img alt=".jm" class="ss-registry-flags registry-jm" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.jm</span><span class="ss-registry-land">Jamaika</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/cm">
                                    <img alt=".cm" class="ss-registry-flags registry-cm" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.cm</span><span class="ss-registry-land">Kamerun</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/ca">
                                    <img alt=".ca" class="ss-registry-flags registry-ca" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ca</span><span class="ss-registry-land">Kanada</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/qa">
                                    <img alt=".qa" class="ss-registry-flags registry-qa" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.qa</span><span class="ss-registry-land">Katar</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/kz">
                                    <img alt=".kz" class="ss-registry-flags registry-kz" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.kz</span><span class="ss-registry-land">Kazakistan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/kg">
                                    <img alt=".kg" class="ss-registry-flags registry-kg" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.kg</span><span class="ss-registry-land">Kırgızistan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/co">
                                    <img alt=".co" class="ss-registry-flags registry-co" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.co</span><span class="ss-registry-land">Kolombiya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/mx">
                                    <img alt=".mx" class="ss-registry-flags registry-mx" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.mx</span><span class="ss-registry-land">Mexica</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/mz">
                                    <img alt=".mz" class="ss-registry-flags registry-mz" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.mz</span><span class="ss-registry-land">Mozambik</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/ng">
                                    <img alt=".ng" class="ss-registry-flags registry-ng" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ng</span><span class="ss-registry-land">Nijerya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/ru">
                                    <img alt=".ru" class="ss-registry-flags registry-ru" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.ru</span><span class="ss-registry-land">Rusya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/sd">
                                    <img alt=".sd" class="ss-registry-flags registry-sd" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.sd</span><span class="ss-registry-land">Sudan</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/cl">
                                    <img alt=".cl" class="ss-registry-flags registry-cl" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.cl</span><span class="ss-registry-land">Şili</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/co-tz">
                                    <img alt=".co.tz" class="ss-registry-flags registry-tz" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.co.tz</span><span class="ss-registry-land">Tanzanya</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/tn">
                                    <img alt=".tn" class="ss-registry-flags registry-tn" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.tn</span><span class="ss-registry-land">Tunus</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/uy">
                                    <img alt=".uy" class="ss-registry-flags registry-uy" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.uy</span><span class="ss-registry-land">Uruguay</span>
                                </a>
                            </div>
                            <div class="registry-list-item">
                                <a href="uzanti/gr">
                                    <img alt=".gr" class="ss-registry-flags registry-gr" src="<?php echo $site_url; ?>/design/images/icons/domain/ss-registry-blank.gif">
                                    <span class="ss-registry-ext">.gr</span><span class="ss-registry-land">Yunanistan</span>
                                </a>
                            </div>
                            <button id="loadMore" style="display: none;" class="btn btn-dark btn-arrow btn-lg w-100 fs-14 fw-bolder rounded mt-6">
                              <span class="btn-arrow__text">Devamını gör<span class="btn-arrow__icon"><i class="las la-arrow-right"></i></span></span>
                            </button>
                        </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="ss-menu-class">
  <section class="ss-section ss-counter img ss-animate fadeInUp ss-animated" id="section-counter" style="background-image: url(design/images/Background/counter-bg2.webp);" data-stellar-background-ratio="0.5" data-stellar-vertical-offset="0">
      <div class="container">
          <div class="row justify-content-center mb-3">
              <div class="col-12 col-md-12 text-center heading-section heading-section-white ss-animate fadeInUp ss-animated">
                  <span class="subheading ss-animate fadeInUp ss-animated">GÜLER YÜZLÜ HİZMET GARANTİSİ</span>
              </div>
          </div>
          <div class="row justify-content-center">
              <div class="col-md-10">
                  <div class="row">
                      <div class="col-6 col-md-3 d-flex justify-content-center counter-wrap ss-animate fadeInUp ss-animated">
                          <div class="block-18 text-center">
                              <div class="counter-text">
                                  <strong class="counter-number number" data-number="4300">3,612</strong>
                                  <span>MUTLU MÜŞTERİ</span>
                              </div>
                          </div>
                      </div>
                      <div class="col-6 col-md-3 d-flex justify-content-center counter-wrap ss-animate fadeInUp ss-animated">
                          <div class="block-18 text-center">
                              <div class="counter-text">
                                  <strong class="counter-number number" data-number="3500">2,934</strong>
                                  <span>HOSTING HİZMETİ</span>
                              </div>
                          </div>
                      </div>
                      <div class="col-6 col-md-3 d-flex justify-content-center counter-wrap ss-animate fadeInUp ss-animated">
                          <div class="block-18 text-center">
                              <div class="counter-text">
                                  <strong class="counter-number number" data-number="650">544</strong>
                                  <span>CLOUD SERVER VDS-VDS</span>
                              </div>
                          </div>
                      </div>
                      <div class="col-6 col-md-3 d-flex justify-content-center counter-wrap ss-animate fadeInUp ss-animated">
                          <div class="block-18 text-center">
                              <div class="counter-text">
                                  <strong class="counter-number number" data-number="150">125</strong>
                                  <span>DEDICATED HİZMETİ</span>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </section>
</div>
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', () => {
  const counters = document.querySelectorAll('.counter-number');

  const observerOptions = {
    root: null, // viewport olarak belirlendi
    threshold: 0.5 // div'in %50'si göründüğünde tetiklenecek
  };

  const observer = new IntersectionObserver((entries, observer) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        const counter = entry.target;
        counter.innerText = '0';

        const updateCounter = () => {
          const target = +counter.getAttribute('data-number');
          const current = +counter.innerText;

          const increment = target / 100; // Artış hızını ayarlayın

          if (current < target) {
            counter.innerText = `${Math.ceil(current + increment)}`;
            setTimeout(updateCounter, 20); // Her 20 milisaniyede bir güncelle
          } else {
            counter.innerText = target; // Hedefe ulaştığında sayıyı sabitle
          }
        };

        updateCounter();
        observer.unobserve(counter); // Bir kez sayma tamamlandığında gözlem durduruluyor
      }
    });
  }, observerOptions);

  counters.forEach(counter => {
    observer.observe(counter); // Her bir counter div'i gözlemleniyor
  });
});
</script>

<div class="pt-120 pb-120 bg-secondary">
    <div class="pb-60">
        <div class="container">
            <div class="row g-4 align-items-center justify-content-xl-between">
              <div class="container">
                  <div class="row justify-content-center">
                      <div class="col-12">
                          <div class="text-center">
                              <h2 class="text-dark mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                                Neden serversistemleri.com
                              </h2>
                          </div>
                      </div>
                  </div>
              </div>
            </div>
        </div>
    </div>
    <link rel="stylesheet" href="<?php echo $site_url; ?>/design/css/flaticon.min.css">
    <style media="screen">
    .col-sm-6.col-md-4.feature-list__item.sal-animate:hover {
      background: white;
      border-radius: 25px;
    }
    </style>
    <div class="container">
    <div class="row g-4 g-md-0 feature-list">
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-guarantee"></i>
                </div>
                <h6 class="mb-5">
                    Müşteri Memnuniyeti Garantisi
                </h6>
                <p class="mb-0">
                    Müşteri memnuniyeti, hizmet politikamızın temelini oluşturur. Sürekli yenilikçi çözümlerle müşteri deneyimini iyileştiriyoruz. Memnun kalmadığınız hizmetlerimiz için 15 gün içerisinde koşulsuz para iadesi garantisi sunuyoruz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-support"></i>
                </div>
                <h6 class="mb-5">
                    Kesintisiz Destek
                </h6>
                <p class="mb-0">
                    7/24 hizmetinizdeyiz. İhtiyacınız olduğunda, SS-Panel uygulamamız üzerinden hizmetlerinizi yönetebilir ve destek alabilirsiniz. Her zaman yanınızdayız.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-account"></i>
                </div>
                <h6 class="mb-5">
                    Ekonomik Fiyatlar
                </h6>
                <p class="mb-0">
                    Uygun fiyatlarla profesyonel hizmet sunuyoruz. 0,49$’dan başlayan fiyatlarımızla projelerinizi hayata geçirebilir ve sabit kur avantajlarından faydalanabilirsiniz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-web-page"></i>
                </div>
                <h6 class="mb-5">
                    Modern Teknoloji
                </h6>
                <p class="mb-0">
                    Türkiye, Litvanya ve Almanya’da bulunan sunucularımızla, sınırsız hizmet sunuyoruz. Cloud Server ve Web Hosting hizmetlerimizle kurumsal müşterilerimize destek veriyoruz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-bandwidth"></i>
                </div>
                <h6 class="mb-5">
                    Güçlü Network
                </h6>
                <p class="mb-0">
                    Türkiye’nin en önde gelen veri merkezlerinden birine sahibiz. Fiber altyapımızla ve gelişmiş network sistemlerimizle kesintisiz hizmet sunuyoruz.
                </p>
            </div>
        </div>
        <div class="col-sm-6 col-md-4 feature-list__item" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            <div class="feature-list__card border text-center">
                <div class="mb-8">
                    <i style="font-size:75px;" class="flaticon-cloud-computing"></i>
                </div>
                <h6 class="mb-5">
                    Ücretsiz Servisler
                </h6>
                <p class="mb-0">
                    Ücretsiz SSL ve site taşıma hizmetlerimizden yararlanabilirsiniz. Sürükle-bırak teknolojisi ile kod bilgisi gerekmeden web sitenizi kolayca oluşturabilirsiniz.
                </p>
            </div>
        </div>
    </div>
</div>
</div>
