<?php
$spec = [
    '1' => [
        "icon" => 'ssicon-www',
        "Ram" => 1024,
        "CPU" => 1,
        "Disk" => "20 GB",
        "EMail" => "10 Adet",
        "Mysql" => "2 Adet"
    ],
    '4' => [
        "Ram" => 2048,
        "CPU" => 2,
        "Disk" => "50 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '7' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "Limitsiz",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '10' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "Limitsiz",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '20' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "50 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '22' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "100 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '24' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "200 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '26' => [
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "300 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '12' => [
        "Domain" => "20 Adet",
        "Ram" => 1024,
        "CPU" => 1,
        "Disk" => "20 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '14' => [
        "Domain" => "50 Adet",
        "Ram" => 2048,
        "CPU" => 2,
        "Disk" => "50 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '16' => [
        "Domain" => "100 Adet",
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "100 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ],
    '18' => [
        "Domain" => "Limitsiz",
        "Ram" => 4096,
        "CPU" => 2,
        "Disk" => "200 GB",
        "EMail" => "Limitsiz",
        "Mysql" => "Limitsiz"
    ]
];
$uniqueProducts = [];

foreach ($urunler as $urun) {
    // Ürün ismine göre kontrol
    if (!isset($uniqueProducts[$urun['name']])) {
        // İlk kez karşılaşılan ürünler için başlangıç değerleri
        $uniqueProducts[$urun['name']] = [
            'name' => $urun['name'],
            'pid' => [],
            'specs' => [],
            'min_price_try' => $urun['pricing']['TRY']['monthly'],
            'min_price_usd' => $urun['pricing']['USD']['monthly'],
        ];
    }

    // PID ekle
    $uniqueProducts[$urun['name']]['pid'][] = $urun['pid'];

    // Eğer ürünün pid'si $spec dizisinde varsa, özellikleri ekle
    if (isset($spec[$urun['pid']])) {
        $uniqueProducts[$urun['name']]['specs'][$urun['pid']] = $spec[$urun['pid']];
    }

    // En düşük TRY fiyatını bul
    if ($urun['pricing']['TRY']['monthly'] < $uniqueProducts[$urun['name']]['min_price_try']) {
        $uniqueProducts[$urun['name']]['min_price_try'] = $urun['pricing']['TRY']['monthly'];
    }

    // En düşük USD fiyatını bul
    if ($urun['pricing']['USD']['monthly'] < $uniqueProducts[$urun['name']]['min_price_usd']) {
        $uniqueProducts[$urun['name']]['min_price_usd'] = $urun['pricing']['USD']['monthly'];
    }

}
?>
<style media="screen">
  .urun-ozellikleri {
    font-size: 18px;
    display: flex;
    align-items: center;
    padding-top: 8px;
    padding-bottom: 8px;
    border-bottom: 1px solid rgba(0, 0, 0, 0.1);

  }

  .urun-ozellikleri i {
    font-size: 24px;
    color: #6c757d;
    transition: color 0.3s ease;
    display: flex;
    justify-content: center;
    align-items: center;
    width: 40px; /* Sabit genişlik */
    height: 40px; /* Sabit yükseklik */
    margin-right: 12px;
  }

  .urun-ozellikleri small {
    font-size: 16px;
    color: #333;
  }

  .urun-ozellikleri:hover {
    background-color: #f4f6fc;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  }

  .urun-ozellikleri:hover i {
    color: #495057;
  }

</style>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-12">
            <div class="tab-content sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                  <div class="tab-pane fade show active" role="tabpanel">
                    <div class="row g-4">
                      <?php foreach ($uniqueProducts as $product): ?>
                        <div class="paket-baslat col-xl-<?php echo count($uniqueProducts) == 4 ? 3 : (count($urunler) == 3 ? 4 : ''); ?> col-md-6">
                          <div class="paket-ust-<?php echo count($uniqueProducts) == 4 ? 4 : (count($urunler) == 3 ? 3 : ''); ?> ">
                            <svg id="katman_1" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 282.9 51.7">
                              <path id="Path_706" d="M280.2,169.9l-4.4,189.7"/>
                              <path id="Path_7061" data-name="Path_706" d="M282,92.7l-1.8,77.2"/>
                              <path id="Path_7062" data-name="Path_706" d="M282.9,51.7l-1,41"/>
                              <path id="Path_7063" data-name="Path_706" d="M.2,51.7L0,12,233.4,0c27.4,0,49.6,23.1,49.6,51.7"/>
                              <path id="Path_7064" data-name="Path_706" d="M.5,92.7l-.2-41"/>
                              <path id="Path_7065" data-name="Path_706" d="M1.1,192.5L.5,92.7"/>
                              <path id="Path_7066" data-name="Path_706" d="M3.3,573.9L1.1,192.5"/>
                              <path id="Path_7067" data-name="Path_706" d="M270.6,579.2l-267.3-5.4"/>
                              <path id="Path_7068" data-name="Path_706" d="M275.8,359.6l-5.1,219.6"/>
                            </svg>
                          </div>
                          <div class="price-card-item-one position-relative overflow-hidden bg-white px-7 py-9 border-end rounded-3" style="border-radius: 0 50px 0 0 !important;">
                            <div class="text-center">
                              <img style="height:82px;" src="/assets/img/icons/hosting.svg" alt="image" class="img-fluid mb-5" />
                              <h6 class="mb-1"><?php echo str_replace('-', ' ', $product['name']); ?></h6>
                              <div class="mt-5">
                                <div class="monthly-price">
                                  <h4 class="mb-0"><try>₺<?php echo $product['min_price_try']; ?></try><usd>$<?php echo $product['min_price_usd']; ?></usd></h4>
                                </div>
                              </div>
                            </div>
                            <div class="monthly-price">
                                <button data-bs-toggle="modal" class="btn btn-dark btn-arrow btn-lg w-100 fs-14 fw-bolder rounded mt-6" type="button" data-bs-target="#platformModal" onclick="setProductId(<?php echo implode(', ', $product['pid']); ?>)">
                                  <span class="btn-arrow__text">
                                      Sepete Ekle
                                      <span class="btn-arrow__icon">
                                          <i class="las la-arrow-right"></i>
                                      </span>
                                  </span>
                                </button>
                            </div>
                            <div class="mt-6">
                              <ul class=" list-unstyled d-flex flex-column gap-1 mb-0">
                                <?php foreach ($product['specs'] as $pid => $specDetails): ?>

                                  <?php if (isset($specDetails['Domain'])): ?>
                                    <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                      <i class="ssicon-www"></i>
                                        <small><span class="fw-bold"><?php echo $specDetails['Domain']; ?></span> Domain</small>
                                    </li>
                                  <?php endif; ?>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-xtreme-server"></i>
                                      <small><span class="fw-bold"><?php echo $specDetails['Ram']; ?></span> RAM</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-server"></i>
                                      <small><span class="fw-bold"><?php echo $specDetails['CPU']; ?></span> CPU</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-ssd"></i>
                                      <small><span class="fw-bold"><?php echo $specDetails['Disk']; ?></span> SSD Disk</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-bandwidth"></i>
                                      <small><span class="fw-bold">Limitsiz</span> Trafik</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-mail2"></i>
                                      <small><span class="fw-bold"><?php echo $specDetails['EMail']; ?></span> E-Posta</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-server-eco"></i>
                                      <small><span class="fw-bold"><?php echo $specDetails['Mysql']; ?></span> MySQL</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-ssl"></i>
                                      <small><span class="fw-bold">SSL</span> Ömür Boyu</small>
                                  </li>
                                  <li class="urun-ozellikleri d-flex align-items-center gap-1">
                                    <i class="ssicon-design"></i>
                                      <small><span class="fw-bold">Hazır Site</span>  Eklentisi</small>
                                  </li>
                                  <li style="margin:0 auto;" class="platform-icon d-flex align-items-center gap-1">
                                    <i class="ssicon-linux" style="font-size: 250%; margin-top: 10px;margin-right: 20px;"></i>
                                    <i class="ssicon-windows10" style="font-size: 250%; margin-top: 10px;margin-left: 20px;"></i>
                                  </li>
                                  <?php endforeach; ?>
                                </ul>
                              </div>
                            </div>
                          </div>
                        <?php endforeach; ?>
                      </div>
                    </div>
            </div>
        </div>
    </div>
</div>
