<?php
$liste = $whmcs->GetTLDList();

?>
<style media="screen">
  .banner-bg{
      padding-top: 4rem;
  }
  .fontstyle{
    font-weight: bold;
  }
</style>
<style media="screen">
.banner-bg .col-xl-12{
  padding-top: 50px;
}

.banner-bg {
    background-image: linear-gradient(90deg, #000000f5 30%, rgba(8, 15, 44, 0)),
                      url(<?php echo $site_url; ?>assets/img/domain-fiyat-listesi.webp) !important;
    background-size: cover !important;
    background-position: center !important;
}

.text-custom{
  color: black;
}

/* Mobilde arka plan resmini kaldır ve beyaz yap */
@media (max-width: 768px) {
  .step-container{
    display: none !important;
  }
  .banner-bg {
      background-position: 58% !important;
      background-image: linear-gradient(90deg, #000000f5 10%, rgba(8, 15, 44, 0)),
                        url(<?php echo $site_url; ?>assets/img/domain-fiyat-listesi.webp) !important;
  }
  .banner-bg .col-xl-12{
    padding-top: 0px;
  }

  .text-custom{
      color: white;
  }
}
</style>
<section class="banner-bg bg-dark ssl-banner">
        <div class="container">
            <div class="row align-items-center g-4">
                <div class="col-xl-12">
                    <div class="pb-40">
                        <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">Domain Fiyat Listesi</h1>
                        <p class="text-white mb-8 max-text-60 text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                          Server Sistemleri olarak, müşterilerimize en uygun fiyatlarla kaliteli domain hizmeti sunuyoruz. İşletmenizin dijital dünyada güçlü bir yer edinmesi için ihtiyaçlarınıza uygun domain seçeneklerini sizin için listeledik. Güvenilir altyapımız ve profesyonel destek ekibimizle her zaman yanınızdayız.
                        </p>
                    </div>
                </div>

            </div>
        </div>
</section>
<?php
// Kategoriler için İngilizce-Türkçe çeviri dizisi
$categoryTranslations = [
    "Popular" => "Popüler",
    "Americas" => "Amerikalar",
    "Asia" => "Asya",
    "Business" => "İş",
    "City" => "Şehir",
    "Europe" => "Avrupa",
    "Fun" => "Eğlence",
    "Legal" => "Hukuk",
    "Services" => "Hizmetler",
    "Money and Finance" => "Para ve Finans",
    "Education" => "Eğitim",
    "Other" => "Diğer",
    "Arts and Entertainment" => "Sanat ve Eğlence",
    "Technology" => "Teknoloji",
];

// Kategorileri dinamik olarak alma
$categories = [];
foreach ($liste as $key) {
    if (isset($key['categories'])) {
        foreach ($key['categories'] as $category) {
            $categories[] = $category;
        }
    }
}
// Tekrarlayan kategorileri kaldır
$categories = array_unique($categories);
?>

<?php
// Kategoriler için İngilizce-Türkçe çeviri dizisi
$categoryTranslations = [
    "Popular" => "Popüler",
    "Americas" => "Amerikalar",
    "Asia" => "Asya",
    "Business" => "İş",
    "City" => "Şehir",
    "Europe" => "Avrupa",
    "Fun" => "Eğlence",
    "Legal" => "Hukuk",
    "Services" => "Hizmetler",
    "Money and Finance" => "Para ve Finans",
    "Education" => "Eğitim",
    "Other" => "Diğer",
    "Arts and Entertainment" => "Sanat ve Eğlence",
    "Technology" => "Teknoloji",
    "Leisure and Recreation" => "Eğlence ve Dinlenme",
    "Geographic" => "Coğrafi",
    "Real Estate" => "Gayrimenkul",
    "Shopping" => "Alışveriş",
    "Novelty" => "Yenilik",
    "Sports" => "Spor",
    "Food and Drink" => "Yiyecek ve İçecek",

];

// Kategorileri dinamik olarak alma
$categories = [];
foreach ($liste as $key) {
    if (isset($key['categories'])) {
        foreach ($key['categories'] as $category) {
            $categories[] = $category;
        }
    }
}
// Tekrarlayan kategorileri kaldır
$categories = array_unique($categories);
?>

<div class="pb-60">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-8 col-lg-9">
                <div class="card rounded-3">
                    <div class="card-body p-xl-6">
                        <div class="position-relative">
                            <input type="text" class="form-control bg-transparent py-2 px-8" placeholder="Uzantı arama (Örnek: com)" id="domainSearch" />
                            <span class="text-body position-absolute start-3 lh-1 top-3"><i class="las la-search"></i></span>
                        </div>
                        <div class="table-responsive mt-6">
                            <table class="table table-borderless domain-list-table mb-0">
                                <thead>
                                    <tr>
                                        <th><div class="h6 mb-0 fs-16">Uzantı</div></th>
                                        <th><div class="h6 mb-0 fs-16">Kayıt</div></th>
                                        <th><div class="h6 mb-0 fs-16">Transfer</div></th>
                                        <th><div class="h6 mb-0 fs-16">Yenileme</div></th>
                                        <th><div class="h6 mb-0 fs-16">Kategori</div></th>
                                    </tr>
                                </thead>
                                <tbody id="domainTable">
                                  <?php foreach ($liste as $domain => $key): ?>
                                    <?php echo  $_SESSION['currency']; ?>
                                      <tr style="display: none;"> <!-- Tüm satırları gizli başlatıyoruz -->
                                          <th class="shadow-none">
                                              <p class="text-body fw-semibold mb-0">.<?php echo $domain; ?></p>
                                          </th>
                                          <th class="shadow-none">
                                              <p class="text-body fw-semibold mb-0">
                                                <usd><?php echo isset($key['register'][1]) ? '$' . $key['register'][1] : '-'; ?></usd>
                                                <try><?php echo number_format($key['register'][1] * $whmcs->GetCurrencies('TRY'), 2, '.', ''); ?></try></p>
                                          </th>
                                          <th class="shadow-none">
                                              <p class="text-body fw-semibold mb-0">
                                                <usd><?php echo isset($key['renew'][1]) ? '$' . $key['renew'][1] : '-'; ?></usd>
                                                <try><?php echo number_format($key['renew'][1] * $whmcs->GetCurrencies('TRY'), 2, '.', ''); ?></try></p>
                                          </th>
                                          <th class="shadow-none">
                                              <p class="text-body fw-semibold mb-0">
                                                <usd><?php echo isset($key['transfer']) ? '$' . $key['transfer'] : '-'; ?></usd>
                                                <try><?php echo number_format($key['transfer'][1] * $whmcs->GetCurrencies('TRY'), 2, '.', ''); ?></try></p>
                                          </th>
                                          <th class="shadow-none">
                                              <p class="text-body fw-semibold mb-0">
                                                  <?php
                                                  if (isset($key['categories'])) {
                                                      $translatedCategories = array_map(function ($cat) use ($categoryTranslations) {
                                                          return $categoryTranslations[$cat] ?? $cat;
                                                      }, $key['categories']);
                                                      echo implode(', ', $translatedCategories);
                                                  } else {
                                                      echo '-';
                                                  }
                                                  ?>
                                              </p>
                                          </th>
                                      </tr>
                                  <?php endforeach; ?>

                                </tbody>
                            </table>
                              <div class="text-center mt-4">
                                <button class="col-12 btn btn-primary" id="loadMore">Devamını Gör</button>
                              </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-3">
                <div class="card rounded-3">
                    <div class="card-body p-xl-6">
                        <h6 class="mb-6">Kategoriler</h6>
                        <div class="vstack gap-3" id="categories">
                            <?php foreach ($categories as $index => $category): ?>
                                <div class="form-check">
                                    <input class="form-check-input category-filter" type="checkbox" value="<?php echo $category; ?>" id="cat-<?php echo $index; ?>" />
                                    <label class="form-check-label" for="cat-<?php echo $index; ?>">
                                        <?php echo $categoryTranslations[$category] ?? $category; ?>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    const tableRows = document.querySelectorAll("#domainTable tr"); // Tüm tablo satırlarını seç
    const loadMoreButton = document.getElementById("loadMore"); // "Devamını Gör" butonu
    const rowsPerPage = 10; // Her seferde gösterilecek satır sayısı
    let visibleRowCount = 0; // Şu an görünen satır sayısı

    // Başlangıçta ilk 10 satırı göster
    showNextRows();

    // "Devamını Gör" butonuna tıklama işlemi
    loadMoreButton.addEventListener("click", function () {
        showNextRows();
    });

    /**
     * Her tıklamada sıradaki satırları görünür yap
     */
    function showNextRows() {
        let rowsShown = 0;

        // Gizlenmiş satırları sırayla göster
        for (let i = visibleRowCount; i < tableRows.length; i++) {
            if (rowsShown >= rowsPerPage) break;
            tableRows[i].style.display = ""; // Satırı görünür yap
            rowsShown++;
            visibleRowCount++;
        }

        // Eğer tüm satırlar gösterildiyse, butonu gizle
        if (visibleRowCount >= tableRows.length) {
            loadMoreButton.style.display = "none"; // "Devamını Gör" butonunu gizle
        }
    }
});


document.addEventListener("DOMContentLoaded", function () {
    const searchInput = document.getElementById("domainSearch");
    const categoryCheckboxes = document.querySelectorAll(".category-filter");
    const tableRows = document.querySelectorAll("#domainTable tr");
    const loadMoreButton = document.getElementById("loadMore");

    let visibleRowCount = 0;
    const rowsPerPage = 10;

    // İlk 10 satırı göster
    showNextRows();

    // "Devamını Gör" butonuna tıklama işlemi
    loadMoreButton.addEventListener("click", function () {
        showNextRows();
    });

    // Arama kutusunu ve kategori seçimlerini dinle
    searchInput.addEventListener("input", function () {
        filterTable();
    });

    categoryCheckboxes.forEach(checkbox => {
        checkbox.addEventListener("change", function () {
            filterTable();
        });
    });

    // Tabloyu filtreleme fonksiyonu
    function filterTable() {
        const searchValue = searchInput.value.toLowerCase(); // Arama kutusundaki değer
        const selectedCategories = getSelectedCategories(); // Seçili kategoriler
        visibleRowCount = 0;

        tableRows.forEach(row => {
            const domainCell = row.querySelector("th p").textContent.toLowerCase(); // Domain uzantısı
            const categoryCell = row.querySelectorAll("th p")[4].textContent.toLowerCase(); // Kategori hücresi

            // Filtreleme kriterleri
            const matchesSearch = !searchValue || domainCell.includes(searchValue);
            const matchesCategory = selectedCategories.length === 0 || selectedCategories.some(category => categoryCell.includes(category));

            // Satırı göster veya gizle
            if (matchesSearch && matchesCategory) {
                row.style.display = ""; // Göster
            } else {
                row.style.display = "none"; // Gizle
            }
        });

        // "Devamını Gör" butonu için kontrol
        updateVisibleRows();
    }

    // Seçili kategorileri al
    function getSelectedCategories() {
        const selectedCategories = [];
        categoryCheckboxes.forEach(checkbox => {
            if (checkbox.checked) {
                selectedCategories.push(checkbox.nextElementSibling.textContent.trim().toLowerCase()); // Türkçe kategori
            }
        });
        return selectedCategories;
    }

    // Sıradaki 10 satırı göster
    function showNextRows() {
        let shownRows = 0;

        tableRows.forEach(row => {
            if (row.style.display !== "none" && shownRows < rowsPerPage) {
                row.style.display = ""; // Görünür yap
                shownRows++;
                visibleRowCount++;
            }
        });

        // Eğer tüm satırlar gösterildiyse, butonu gizle
        if (visibleRowCount >= tableRows.length) {
            loadMoreButton.style.display = "none";
        }
    }

    // Filtre sonrası "Devamını Gör" butonunu güncelle
    function updateVisibleRows() {
        let shownRows = 0;
        tableRows.forEach(row => {
            if (row.style.display !== "none") {
                shownRows++;
            }
        });

        if (shownRows > visibleRowCount) {
            loadMoreButton.style.display = ""; // Butonu göster
        } else {
            loadMoreButton.style.display = "none"; // Butonu gizle
        }
    }
});

</script>
