<?php
ini_set('display_errors', 0);
// JSON responses
header("Content-type: application/json; charset=utf-8");

include "dna.php";

// Güvenlik: Dizin Traversal Koruması
// Sabit yol kullanımı
$baseDir = dirname(__DIR__);
$whmcsDataPath = $baseDir . '/whmcs_data.json';
$domainListPath = $baseDir . '/domainlist.json';

// Load WHMCS data
if (file_exists($whmcsDataPath)) {
    $whmcsData = json_decode(file_get_contents($whmcsDataPath), true);
} else {
    $whmcsData = [];
}

$tldPricing = isset($whmcsData['tldPricing']['pricing']) ? $whmcsData['tldPricing']['pricing'] : [];

$api = new DomainNameAPI_PHPLibrary();
// GÜVENLİK NOTU: Kimlik bilgilerini kodda saklamayın. Çevre değişkenleri kullanın.
$apiUser = getenv('DOMAIN_API_USER') ?: 'ugurakkaya';
$apiPass = getenv('DOMAIN_API_PASS') ?: 'Unna2021**1612hello'; // Bu şifre üretimde değiştirilmeli!
$api->setUser($apiUser, $apiPass);

$api->useCaching(true);
$api->useTestMode(false);

$aciklama = ["tr" => "Belgesiz <b>Ön Kayıt</b>"];
$defExts = ["com", "org", "net", "com.tr", "tr", "ist"];

// Güvenlik: Input Validasyonu
// ext parametresi sadece alfanümerik ve nokta içerebilir (örn: com.tr)
$inputExt = $_GET["ext"] ?? null;
if ($inputExt && preg_match('/^[a-z0-9.]+$/', $inputExt) && $inputExt !== "undefined") {
     if (isset($_GET["only"])) {
        $defExts = [$inputExt];
    } elseif (!in_array($inputExt, $defExts)) {
        $defExts[] = $inputExt;
    }
} elseif (isset($_GET["only"]) && (!isset($inputExt) || $inputExt == "undefined")) {
    $defExts = ["com"]; // Default fallback
}

$action = $_GET["action"] ?? '';

switch ($action) {
    case 'queryDomain':
        if (file_exists($domainListPath)) {
            $json_data = file_get_contents($domainListPath);
            $edata = json_decode($json_data, true);
        } else {
             echo json_encode(["error" => "Domain list not found"]);
             exit;
        }

        if (isset($_GET["skip"]) && is_numeric($_GET["skip"]) && $_GET["skip"] > 0) {
            $paged_data = array_slice($edata, (int)$_GET["skip"], 5);

            $defExts = array_map(function ($a) {
                // Güvenlik: Veriden gelen uzantıyı temizle
                return preg_replace('/[^a-z0-9.]/', '', ltrim($a["uzanti"]));
            }, $paged_data);
             // Boş değerleri filtrele
             $defExts = array_filter($defExts);
        }

        // Domain Validasyonu
        $domain = $_GET["domain"] ?? '';
        // Basit domain karakter kontrolü
        if (!preg_match('/^[a-zA-Z0-9.-]+$/', $domain)) {
             echo json_encode(["error" => "Invalid domain format"]);
             exit;
        }

        $tc = (isset($_GET["transfer"])) ? "transfer" : "create";

        if (empty($defExts)) {
             echo json_encode([]); // Sorgulanacak uzantı yok
             exit;
        }

        $query = $api->CheckAvailability([$domain], $defExts, 1, $tc);
        $result = [];

        if (isset($query["data"]) && $query["result"] === "OK") {
            foreach ($query["data"] as $res) {
                $tld = strtolower($res["Tld"] ?? $res["TLD"] ?? '');
                // Gelen TLD'yi güvenli hale getir
                $tld = strip_tags($tld);

                $price = isset($tldPricing[$tld]['register']['1']) ? (float)$tldPricing[$tld]['register']['1'] : 0;

                if (number_format($price * 1.2, 2) == '0.00') {
                  $price_news = isset($tldPricing[$tld]['register']['2']) ? (float)$tldPricing[$tld]['register']['2'] : 0;
                } else {
                  $price_news = $price; // Mantık hatası düzeltildi: Price zaten sayısal
                }

                $result[] = [
                    "DomainName" => htmlspecialchars($res["DomainName"] ?? '', ENT_QUOTES),
                    "TLD" => htmlspecialchars($tld, ENT_QUOTES),
                    "Status" => ($res["ClassKey"] ?? '') === "premium" ? "premium" : htmlspecialchars($res["Status"] ?? '', ENT_QUOTES),
                    "oldPrice" => number_format($price * 1.2, 2),
                    "Aciklama" => $aciklama[$tld] ?? '',
                    "Price" => number_format($price_news, 2),
                    "Currency" => "USD"
                ];
            }
        } else {
            // API hatasını doğrudan basmak yerine genel mesaj verilebilir, duruma göre
            $result = $query["error"] ?? ["message" => "An error occurred during query"];
        }
        echo json_encode($result);
        break;

    case 'checkDomain':
        $domain = $_GET["domain"] ?? '';
        if (!preg_match('/^[a-zA-Z0-9.-]+$/', $domain)) {
             echo json_encode(["error" => "Invalid domain format"]);
             exit;
        }

        $query = $api->CheckAvailability([$domain], $defExts, 1, "create");
        echo json_encode($query);
        break;

    default:
        echo json_encode(["error" => "Invalid action"]);
        break;
}
?>
