<?php $pageTitle = 'Kayıt ol'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
    <head>
        <meta charset="utf-8" />
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="robots" content="noindex, nofollow" />
        <link rel="icon" href="https://sspanel.serversistemleri.com/favicon.ico" />

        <title>
            {{ $pageTitle }} - Server Sistemleri
        </title>

        <style>
            [x-cloak=""],
            [x-cloak="x-cloak"],
            [x-cloak="1"] {
                display: none !important;
            }

            @media (max-width: 1023px) {
                [x-cloak="-lg"] {
                    display: none !important;
                }
            }

            @media (min-width: 1024px) {
                [x-cloak="lg"] {
                    display: none !important;
                }
            }
        </style>

        <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
        <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
        <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
        <style>
            :root {
                --danger-50: 254, 242, 242;
                --danger-100: 254, 226, 226;
                --danger-200: 254, 202, 202;
                --danger-300: 252, 165, 165;
                --danger-400: 248, 113, 113;
                --danger-500: 239, 68, 68;
                --danger-600: 220, 38, 38;
                --danger-700: 185, 28, 28;
                --danger-800: 153, 27, 27;
                --danger-900: 127, 29, 29;
                --danger-950: 69, 10, 10;
                --gray-50: 250, 250, 250;
                --gray-100: 244, 244, 245;
                --gray-200: 228, 228, 231;
                --gray-300: 212, 212, 216;
                --gray-400: 161, 161, 170;
                --gray-500: 113, 113, 122;
                --gray-600: 82, 82, 91;
                --gray-700: 63, 63, 70;
                --gray-800: 39, 39, 42;
                --gray-900: 24, 24, 27;
                --gray-950: 9, 9, 11;
                --info-50: 239, 246, 255;
                --info-100: 219, 234, 254;
                --info-200: 191, 219, 254;
                --info-300: 147, 197, 253;
                --info-400: 96, 165, 250;
                --info-500: 59, 130, 246;
                --info-600: 37, 99, 235;
                --info-700: 29, 78, 216;
                --info-800: 30, 64, 175;
                --info-900: 30, 58, 138;
                --info-950: 23, 37, 84;
                --primary-50: 244, 250, 252;
                --primary-100: 232, 244, 249;
                --primary-200: 198, 228, 241;
                --primary-300: 164, 211, 232;
                --primary-400: 96, 179, 215;
                --primary-500: 28, 146, 198;
                --primary-600: 25, 131, 178;
                --primary-700: 21, 110, 149;
                --primary-800: 17, 88, 119;
                --primary-900: 14, 72, 97;
                --primary-950: 8, 44, 59;
                --success-50: 240, 253, 244;
                --success-100: 220, 252, 231;
                --success-200: 187, 247, 208;
                --success-300: 134, 239, 172;
                --success-400: 74, 222, 128;
                --success-500: 34, 197, 94;
                --success-600: 22, 163, 74;
                --success-700: 21, 128, 61;
                --success-800: 22, 101, 52;
                --success-900: 20, 83, 45;
                --success-950: 5, 46, 22;
                --warning-50: 255, 251, 235;
                --warning-100: 254, 243, 199;
                --warning-200: 253, 230, 138;
                --warning-300: 252, 211, 77;
                --warning-400: 251, 191, 36;
                --warning-500: 245, 158, 11;
                --warning-600: 217, 119, 6;
                --warning-700: 180, 83, 9;
                --warning-800: 146, 64, 14;
                --warning-900: 120, 53, 15;
                --warning-950: 69, 26, 3;
            }
        </style>

        <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

        <link rel="preconnect" href="https://fonts.bunny.net" />
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

        <style>
            :root {
                --font-family: "Inter";
                --sidebar-width: 20rem;
                --collapsed-sidebar-width: 4.5rem;
                --default-theme-mode: light;
            }
        </style>

        <style>
            [wire\:loading][wire\:loading],
            [wire\:loading\.delay][wire\:loading\.delay],
            [wire\:loading\.inline-block][wire\:loading\.inline-block],
            [wire\:loading\.inline][wire\:loading\.inline],
            [wire\:loading\.block][wire\:loading\.block],
            [wire\:loading\.flex][wire\:loading\.flex],
            [wire\:loading\.table][wire\:loading\.table],
            [wire\:loading\.grid][wire\:loading\.grid],
            [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
                display: none;
            }
            [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
            [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
            [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
            [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
            [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
            [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
            [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
            [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
                display: none;
            }
            [wire\:offline][wire\:offline] {
                display: none;
            }
            [wire\:dirty]:not(textarea):not(input):not(select) {
                display: none;
            }
            :root {
                --livewire-progress-bar-color: #2299dd;
            }
            [x-cloak] {
                display: none !important;
            }
        </style>

        <style>
            @keyframes checkmark {
                0% {
                    stroke-dashoffset: 100;
                }
                100% {
                    stroke-dashoffset: 0;
                }
            }
            @keyframes scaleIn {
                0% {
                    transform: scale(0);
                    opacity: 0;
                }
                50% {
                    transform: scale(1.1);
                }
                100% {
                    transform: scale(1);
                    opacity: 1;
                }
            }
            .success-checkmark {
                animation: scaleIn 0.5s ease-in-out;
            }
            .success-checkmark__check {
                transform-origin: 50% 50%;
                stroke-dasharray: 100;
                stroke-dashoffset: 100;
                animation: checkmark 0.6s 0.2s ease-in-out forwards;
            }

            /* Responsive improvements */
            @media (max-width: 640px) {
                .fi-simple-main {
                    margin-top: 0 !important;
                    margin-bottom: 0 !important;
                    border-radius: 0 !important;
                    min-height: 100vh;
                }
                .fi-simple-header img {
                    width: 180px !important;
                }
                .grid.grid-cols-\[--cols-default\] {
                    grid-template-columns: 1fr !important;
                }
            }
        </style>
    </head>
    <body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
  <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
      <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
          <div class="fi-simple-page">
              <section class="grid auto-cols-fr gap-y-6">
                  <header class="fi-simple-header flex flex-col items-center">
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo mb-4" style="width: 250px;" />
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo mb-4" style="width: 250px;" />
                      <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                          Kayıt Ol
                      </h1>
                  </header>

                  <form action="{{ route('register') }}" method="POST" class="fi-form grid gap-y-6" id="register">
                      @csrf
                      <div style="--cols-default: repeat(2, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="firstname">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  İsim
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="text"
                                                      id="firstname"
                                                      name="firstname"
                                                      placeholder="İsminiz"
                                                      required
                                                      autocomplete="given-name"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="lastname">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Soyisim
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="text"
                                                      id="lastname"
                                                      name="lastname"
                                                      placeholder="Soyisminiz"
                                                      required
                                                      autocomplete="family-name"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          @php
                              $userAgent = request()->userAgent();
                              $browserName = strtok($userAgent, '/');
                              $isSSMobil = $browserName === 'SSMobil';
                          @endphp

                          @if($isSSMobil)
                              <input type="hidden" name="mobilactions" value="SSMobil" />
                          @else
                              <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                  <div data-field-wrapper class="fi-fo-field-wrp">
                                      <div class="grid gap-y-2">
                                          <div class="flex items-center justify-between gap-x-3">
                                              <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="tckimlikno">
                                                  <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                      T.C. Kimlik No
                                                      <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                  </span>
                                              </label>
                                          </div>
                                          <div class="grid auto-cols-fr gap-y-2">
                                              <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                  <div class="flex items-center ps-3 text-gray-400">
                                                      <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-5 8a2 2 0 100-4 2 2 0 000 4zm0 0c1.306 0 2.417.835 2.83 2M9 14a3.001 3.001 0 00-2.83 2M15 11h3m-3 4h2"/>
                                                      </svg>
                                                  </div>
                                                  <div class="min-w-0 flex-1">
                                                      <input
                                                          type="text"
                                                          id="tckimlikno"
                                                          name="tckimlikno"
                                                          placeholder="T.C. Kimlik Numaranız"
                                                          pattern="[0-9]{11}"
                                                          maxlength="11"
                                                          required
                                                          class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                              <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                  <div data-field-wrapper class="fi-fo-field-wrp">
                                      <div class="grid gap-y-2">
                                          <div class="flex items-center justify-between gap-x-3">
                                              <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="dogumyili">
                                                  <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                      Doğum Yılı
                                                      <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                  </span>
                                              </label>
                                          </div>
                                          <div class="grid auto-cols-fr gap-y-2">
                                              <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                  <div class="flex items-center ps-3 text-gray-400">
                                                      <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                                      </svg>
                                                  </div>
                                                  <div class="min-w-0 flex-1">
                                                      <input
                                                          type="number"
                                                          id="dogumyili"
                                                          name="dogumyili"
                                                          placeholder="Doğum yılınız (örn: 1990)"
                                                          min="1900"
                                                          max="{{ date('Y') }}"
                                                          required
                                                          class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          @endif
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="phonenumber">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Telefon Numarası
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="tel"
                                                      id="phonenumber"
                                                      name="phonenumber"
                                                      placeholder="5XX XXX XX XX"
                                                      pattern="[0-9]{10}"
                                                      maxlength="10"
                                                      required
                                                      autocomplete="tel"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="email">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  E-Posta Adresi
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="email"
                                                      id="email"
                                                      name="email"
                                                      placeholder="ornek@email.com"
                                                      required
                                                      autocomplete="email"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="password">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Şifre
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="password"
                                                      id="password"
                                                      name="password"
                                                      placeholder="Şifreniz"
                                                      required
                                                      autocomplete="new-password"
                                                      minlength="8"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                              <button type="button" onclick="togglePassword('password')" class="px-3 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors" aria-label="Şifreyi göster/gizle">
                                                  <svg id="password-eye-open" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                                  </svg>
                                                  <svg id="password-eye-closed" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                                  </svg>
                                              </button>
                                          </div>
                                          <small id="password-error" class="text-danger-600 dark:text-danger-400 text-xs hidden mt-1">Şifreniz en az 8 karakter olmalıdır.</small>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="password2">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Şifre Tekrar
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="password"
                                                      id="password2"
                                                      name="password2"
                                                      placeholder="Şifrenizi tekrar giriniz"
                                                      required
                                                      autocomplete="new-password"
                                                      minlength="8"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                              <button type="button" onclick="togglePassword('password2')" class="px-3 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors" aria-label="Şifreyi göster/gizle">
                                                  <svg id="password2-eye-open" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                                  </svg>
                                                  <svg id="password2-eye-closed" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                                  </svg>
                                              </button>
                                          </div>
                                          <small id="password2-error" class="text-danger-600 dark:text-danger-400 text-xs hidden mt-1">Şifreler eşleşmiyor veya 8 karakterden az.</small>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <div id="alert"></div>
                      <div class="fi-form-actions">
                          <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                              <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" type="submit" id="submit-button">
                                  <span class="fi-btn-label">KAYIT OL</span>
                              </button>
                          </div>
                      </div>

                      <div class="text-center mt-4">
                          <p class="text-sm text-gray-600 dark:text-gray-400">
                              Zaten hesabınız var mı?
                              <a href="{{ route('login') }}" class="text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors duration-200">
                                  Giriş Yapın
                              </a>
                          </p>
                      </div>
                  </form>

              </section>
          </div>
      </main>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    (function() {
        'use strict';

        const ALERT_TEMPLATES = {
            success: (message) => `
                <div class="bg-green-50 dark:bg-gray-800 dark:text-green-400 flex flex-col items-center justify-center p-6 rounded-lg text-green-800 text-sm" role="alert">
                    <svg class="success-checkmark h-16 w-16 mb-4" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="26" cy="26" r="25" fill="currentColor" fill-opacity="0.2" stroke="currentColor" stroke-width="2"/>
                        <path class="success-checkmark__check" d="M14 27l7.5 7.5L38 18" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span class="sr-only">Başarılı</span>
                    <div class="text-center">
                        <p class="font-semibold text-lg mb-1">Kayıt Başarılı!</p>
                        <p class="text-sm">${message}</p>
                        <p class="text-xs mt-2 opacity-75">Giriş sayfasına yönlendiriliyorsunuz...</p>
                    </div>
                </div>
            `,
            error: (message) => `
                <div class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert">
                    <svg style="margin-right: 5px;" aria-hidden="true" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                    </svg>
                    <span class="sr-only">Hata</span>
                    <div><span class="font-medium">Hata!</span> ${message}</div>
                </div>
            `
        };

        // Password toggle function
        window.togglePassword = function(inputId) {
            const input = document.getElementById(inputId);
            const eyeOpen = document.getElementById(inputId + '-eye-open');
            const eyeClosed = document.getElementById(inputId + '-eye-closed');

            if (input.type === 'password') {
                input.type = 'text';
                eyeOpen.classList.add('hidden');
                eyeClosed.classList.remove('hidden');
            } else {
                input.type = 'password';
                eyeOpen.classList.remove('hidden');
                eyeClosed.classList.add('hidden');
            }
        };

        // Password validation function
        function validatePasswords() {
            const password = $('#password').val();
            const password2 = $('#password2').val();
            const submitButton = $('#submit-button');
            const passwordError = $('#password-error');
            const password2Error = $('#password2-error');

            // Validate first password
            if (password.length > 0 && password.length < 8) {
                passwordError.removeClass('hidden');
            } else {
                passwordError.addClass('hidden');
            }

            // Validate second password
            if (password2.length > 0 && (password2.length < 8 || password !== password2)) {
                password2Error.removeClass('hidden');
            } else {
                password2Error.addClass('hidden');
            }

            // Check if both passwords are at least 8 characters and match
            const isValid = password.length >= 8 && password2.length >= 8 && password === password2;

            // Enable/disable submit button
            submitButton.prop('disabled', !isValid);

            // Add visual feedback
            if (!isValid) {
                submitButton.addClass('opacity-50 cursor-not-allowed');
            } else {
                submitButton.removeClass('opacity-50 cursor-not-allowed');
            }
        }

        $(document).ready(function() {
            // Validate passwords on input
            $('#password, #password2').on('input', validatePasswords);

            // Initial validation
            validatePasswords();

            $('#register').on('submit', function(e) {
                e.preventDefault();

                const $form = $(this);
                const $button = $('#submit-button');
                const $alert = $('#alert');
                const originalButtonText = $button.text();

                $button.text('Lütfen bekleyiniz...').prop('disabled', true);

                $.ajax({
                    url: $form.attr('action'),
                    method: $form.attr('method'),
                    data: $form.serialize(),
                    success: function(response) {
                        if (response.status === 'success') {
                            $alert.html(ALERT_TEMPLATES.success(response.message));
                            setTimeout(() => {
                                window.location.href = '/login';
                            }, 2000);
                        } else {
                            $alert.html(ALERT_TEMPLATES.error(response.message));
                            $button.text(originalButtonText).prop('disabled', false);
                        }
                    },
                    error: function(xhr) {
                        const errorMessage = `Form gönderilirken bir hata oluştu. ${xhr.status}: ${xhr.statusText}`;
                        $alert.html(ALERT_TEMPLATES.error(errorMessage));
                        $button.text(originalButtonText).prop('disabled', false);
                    }
                });
            });
        });
    })();
</script>

<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>

</body>
</html>
