<?php $pageTitle = 'Şifremi Unuttum'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="icon" href="https://sspanel.serversistemleri.com/favicon.ico" />

    <title>{{ $pageTitle }} - Server Sistemleri</title>

    <style>
           [x-cloak=""],
           [x-cloak="x-cloak"],
           [x-cloak="1"] {
               display: none !important;
           }

           @media (max-width: 1023px) {
               [x-cloak="-lg"] {
                   display: none !important;
               }
           }

           @media (min-width: 1024px) {
               [x-cloak="lg"] {
                   display: none !important;
               }
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
       <style>
           :root {
               --danger-50: 254, 242, 242;
               --danger-100: 254, 226, 226;
               --danger-200: 254, 202, 202;
               --danger-300: 252, 165, 165;
               --danger-400: 248, 113, 113;
               --danger-500: 239, 68, 68;
               --danger-600: 220, 38, 38;
               --danger-700: 185, 28, 28;
               --danger-800: 153, 27, 27;
               --danger-900: 127, 29, 29;
               --danger-950: 69, 10, 10;
               --gray-50: 250, 250, 250;
               --gray-100: 244, 244, 245;
               --gray-200: 228, 228, 231;
               --gray-300: 212, 212, 216;
               --gray-400: 161, 161, 170;
               --gray-500: 113, 113, 122;
               --gray-600: 82, 82, 91;
               --gray-700: 63, 63, 70;
               --gray-800: 39, 39, 42;
               --gray-900: 24, 24, 27;
               --gray-950: 9, 9, 11;
               --info-50: 239, 246, 255;
               --info-100: 219, 234, 254;
               --info-200: 191, 219, 254;
               --info-300: 147, 197, 253;
               --info-400: 96, 165, 250;
               --info-500: 59, 130, 246;
               --info-600: 37, 99, 235;
               --info-700: 29, 78, 216;
               --info-800: 30, 64, 175;
               --info-900: 30, 58, 138;
               --info-950: 23, 37, 84;
               --primary-50: 244, 250, 252;
               --primary-100: 232, 244, 249;
               --primary-200: 198, 228, 241;
               --primary-300: 164, 211, 232;
               --primary-400: 96, 179, 215;
               --primary-500: 28, 146, 198;
               --primary-600: 25, 131, 178;
               --primary-700: 21, 110, 149;
               --primary-800: 17, 88, 119;
               --primary-900: 14, 72, 97;
               --primary-950: 8, 44, 59;
               --success-50: 240, 253, 244;
               --success-100: 220, 252, 231;
               --success-200: 187, 247, 208;
               --success-300: 134, 239, 172;
               --success-400: 74, 222, 128;
               --success-500: 34, 197, 94;
               --success-600: 22, 163, 74;
               --success-700: 21, 128, 61;
               --success-800: 22, 101, 52;
               --success-900: 20, 83, 45;
               --success-950: 5, 46, 22;
               --warning-50: 255, 251, 235;
               --warning-100: 254, 243, 199;
               --warning-200: 253, 230, 138;
               --warning-300: 252, 211, 77;
               --warning-400: 251, 191, 36;
               --warning-500: 245, 158, 11;
               --warning-600: 217, 119, 6;
               --warning-700: 180, 83, 9;
               --warning-800: 146, 64, 14;
               --warning-900: 120, 53, 15;
               --warning-950: 69, 26, 3;
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

       <link rel="preconnect" href="https://fonts.bunny.net" />
       <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

       <style>
           :root {
               --font-family: "Inter";
               --sidebar-width: 20rem;
               --collapsed-sidebar-width: 4.5rem;
               --default-theme-mode: light;
           }
       </style>

       <script>

           if (theme === "dark" || (theme === "system" && window.matchMedia("(prefers-color-scheme: dark)").matches)) {
               document.documentElement.classList.add("dark");
           }
       </script>

       <!-- Livewire Styles -->
       <style>
           [wire\:loading][wire\:loading],
           [wire\:loading\.delay][wire\:loading\.delay],
           [wire\:loading\.inline-block][wire\:loading\.inline-block],
           [wire\:loading\.inline][wire\:loading\.inline],
           [wire\:loading\.block][wire\:loading\.block],
           [wire\:loading\.flex][wire\:loading\.flex],
           [wire\:loading\.table][wire\:loading\.table],
           [wire\:loading\.grid][wire\:loading\.grid],
           [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
               display: none;
           }
           [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
           [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
           [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
           [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
           [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
           [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
           [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
           [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
               display: none;
           }
           [wire\:offline][wire\:offline] {
               display: none;
           }
           [wire\:dirty]:not(textarea):not(input):not(select) {
               display: none;
           }
           :root {
               --livewire-progress-bar-color: #2299dd;
           }
           [x-cloak] {
               display: none !important;
           }
       </style>

       <style>
           @keyframes checkmark {
               0% {
                   stroke-dashoffset: 100;
               }
               100% {
                   stroke-dashoffset: 0;
               }
           }
           @keyframes scaleIn {
               0% {
                   transform: scale(0);
                   opacity: 0;
               }
               50% {
                   transform: scale(1.1);
               }
               100% {
                   transform: scale(1);
                   opacity: 1;
               }
           }
           .success-checkmark {
               animation: scaleIn 0.5s ease-in-out;
           }
           .success-checkmark__check {
               transform-origin: 50% 50%;
               stroke-dasharray: 100;
               stroke-dashoffset: 100;
               animation: checkmark 0.6s 0.2s ease-in-out forwards;
           }

           /* Responsive improvements */
           @media (max-width: 640px) {
               .fi-simple-main {
                   margin-top: 0 !important;
                   margin-bottom: 0 !important;
                   border-radius: 0 !important;
                   min-height: 100vh;
               }
               .fi-simple-header img {
                   width: 180px !important;
               }
               .grid.grid-cols-\[--cols-default\] {
                   grid-template-columns: 1fr !important;
               }
           }
       </style>
   </head>
<body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
    <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
        <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
                <section class="grid auto-cols-fr gap-y-6">
                    <header class="fi-simple-header flex flex-col items-center">
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" style="width: 250px;" class="l-none fi-logo flex mb-4" />
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" style="width: 250px;" class="d-none fi-logo flex mb-4" />
                        <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                        Şifrenizi mi unuttunuz ?
                        </h1>
                        <p>Şifrenizi sıfırlamak için E-Posta adresinizi girin</p>
                    </header>

                    <form id="form" class="fi-form grid gap-y-6">
                        @csrf
                        <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center justify-between gap-x-3">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="email">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    E-Posta Adresi
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                <div class="flex items-center ps-3 text-gray-400 dark:text-gray-500">
                                                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8m-18 0a2 2 0 012-2h14a2 2 0 012 2m-18 0v8a2 2 0 002 2h14a2 2 0 002-2V8" />
                                                    </svg>
                                                </div>
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3"
                                                        id="email"
                                                        name="code"
                                                        type="email"
                                                        placeholder="E-Posta adresinizi girin"
                                                        autocomplete="email"
                                                        autofocus="autofocus"
                                                        required="required"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="fi-form-actions">
                            <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                                <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" type="submit" id="submit-button">
                                    <span class="fi-btn-label">Şifreyi Sıfırla</span>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div id="success-message" style="display:none; color: green;"></div>
                    <div id="error-message" style="display:none; color: red;"></div>
                </section>
            </div>
        </main>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('#form').on('submit', function(e) {
            e.preventDefault();

            var submitButton = $('#submit-button');
            submitButton.prop('disabled', true).text('Lütfen bekleyin...');

            var formData = $(this).serialize();

            $.ajax({
                url: '{{ route('passwordreset') }}',
                type: 'POST',
                data: formData,
                success: function(response) {
                    // Başarı durumu kontrolü
                    if (response.message) {
                        // Başarı mesajını göster
                        $('#success-message').text(response.message).show();
                        $('#error-message').hide();
                        submitButton.text('Tamamlandı');
                    } else {
                        // Hata mesajını göster
                        $('#error-message').text('Bir hata oluştu, lütfen tekrar deneyin.').show();
                        $('#success-message').hide();
                        submitButton.prop('disabled', false).text('Kodu Doğrula');
                    }
                },
                error: function(xhr) {
                    // Doğrulama hatalarını ekrana yazdır
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessages = '';
                        for (var key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages += errors[key] + '<br>';
                            }
                        }
                        $('#error-message').html(errorMessages).show();
                    } else {
                        $('#error-message').text('Bir hata oluştu, lütfen tekrar deneyin.').show();
                    }
                    $('#success-message').hide();
                    submitButton.prop('disabled', false).text('Kodu Doğrula');
                }
            });
        });
    });
</script>



<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>
</body>
</html>
