<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

class RememberMeSession
{
    public function handle($request, Closure $next)
    {
        if (Session::has('remember_me') && Session::has('session_expiry')) {
            $expiry = Session::get('session_expiry');
            if (Carbon::now()->gt($expiry)) {
                // Süre dolmuşsa çıkış yap
                Session::flush();
                return redirect('/login')->withErrors(['session' => 'Oturum süreniz doldu, lütfen tekrar giriş yapın.']);
            }
        }
        return $next($request);
    }
}
