<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;
use App\Libraries\DomainNameAPI_PHPLibrary;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Session;
class DomainController extends Controller
{
    protected $whmcs;
    protected $authController;

    public function __construct(WhmcsService $whmcs, AuthController $authController)
    {
        $this->whmcs = $whmcs;
        $this->authController = $authController;
    }

    public function save(Request $request)
    {
        $action = $request->input('action');
        $domainId = $request->input('domainid');
        $domainname = $request->input('domainname');
        $nameserver = $request->input('nameserver');
        $nameserverip = $request->input('nameserverip');
        $verify_code = $request->input('code');

        switch ($action) {
            case 'toggleLock':
                return $this->toggleLock($domainId);
            case 'updateNameservers':
                return $this->updateNameservers($request);
            case 'createepp':
                return $this->DomainRequestEPP($domainId);
            case 'autorenew':
                return $this->updateAutoRenew($request);
            case 'addnameserver' :
                 return $this->addnameserver($domainname, $nameserver, $nameserverip);
            case 'updateaddnameserver' :
                  return $this->updateaddnameserver($domainname, $nameserver, $nameserverip, $exnameserverip);
            case 'deleteaddnameserver' :
                  return $this->deleteaddnameserver($domainname, $nameserver);
           case 'domainrenew' :
                 return $this->sendrenewapi($request);
            case 'hostingrenew' :
                 return $this->hostingrenew($request);
            case 'verify' :
                  return $this->verify($verify_code, $domainId);
            default:
                return response()->json(['status' => 'error', 'message' => 'Geçersiz işlem.']);
        }
    }

    protected function toggleLock($domainId)
    {
        $clientId = Session::get('client');
        $currentStatus = $this->whmcs->getDomainLockingStatus($domainId);

        $lockStatus = $currentStatus['lockstatus'] == 'locked' ? 'unlock' : 'lock';
        $response = $this->whmcs->updateDomainLockingStatus($domainId, $lockStatus);

        $subject = "Transfer Kilit durumu değiştirildi!";
        $message = $lockStatus == 'unlock' ? 'Domain adresinizin transfer kilidi başarıyla kapatıldı.' : 'Domain adresinizin transfer kilidi başarıyla açıldı.';

        if ($response['result'] == 'success') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => $message]);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Bir hata oluştu. Lütfen tekrar deneyin.']);
        }
    }


    protected function updateNameservers(Request $request)
    {
        $clientId = Session::get('client');
        $domainId = $request->input('domainid');
        $nameserver1 = $request->input('nameserver1');
        $nameserver2 = $request->input('nameserver2');
        $nameserver3 = $request->input('nameserver3', null);
        $nameserver4 = $request->input('nameserver4', null);

        $response = $this->whmcs->DomainUpdateNameservers($domainId, $nameserver1, $nameserver2, $nameserver3, $nameserver4);

        $subject = "Nameserver adresiniz güncellendi!";
        $message = "$domainId numaralı domain adresinizin nameserver adresleri güncellendi! güncel nameserver bilgileri aşağıdaki gibidir. <br>
        <b>$nameserver1 <br>
        $nameserver2 <br></b>
        ";


        if ($response['result'] == 'success') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => 'Nameserverlar başarıyla güncellendi.']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'NameServer değiştirme sırasında bir hata oluştu! NameServer yok veya sistemsel bir hata var!']);
        }
    }

    protected function updateAutoRenew(Request $request)
    {

        $domainId = $request->input('domainid');
        $autoRenewStatus = $request->input('autorenew');
        $clientId = Session::get('client');
        $response = $this->whmcs->updateClientDomainAutoRenew($domainId, $autoRenewStatus);
        $subject = "Yenileme Durumunuz Değiştirildi!";

        if ($autoRenewStatus = 0) {
          $message_status = "Aktif";
        }else {
          $message_status = "Pasif";
        }
        $message = "$domainId numaralı domain adresinizin yenileme durumu domain yönetim panelinden $message_status olarak güncellendi.";

        if ($response['result'] == 'success') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => 'Otomatik yenileme durumu başarıyla güncellendi.']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Bir hata oluştu: ' . $response['message']]);
        }
    }

    protected function DomainRequestEPP($domainId)
    {
        $clientId = Session::get('client');
        $clientDetails = $this->whmcs->getClientDetails($clientId);

        $ad = $clientDetails['firstname'];
        $soyad = $clientDetails['lastname'];
        $this->authController->sendVerificationSms($clientDetails['phonenumber'], $clientId, $ad, $soyad);
    }

    protected function addnameserver($domainname, $nameserver, $nameserverip) {
        $clientId = Session::get('client');
        $dna = new DomainNameAPI_PHPLibrary('ugurakkaya', 'Unna2021**1612hello');
        $nameserver_data = $nameserver . '.' . $domainname;

        $subject = "Yeni bir nameserver oluşturuldu!";
        $message = "$domainname isimli domain adresinize yeni bir nameserver ($nameserver_data) oluşturuldu.";
        $response = $dna->AddChildNameServer($domainname, $nameserver_data, $nameserverip);
        if ($response['result'] == 'OK') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => 'İsim Sunucusu Başarılı bir şekilde oluşturuldu!']);
        } elseif ($response['result'] == 'ERROR') {
            return response()->json(['status' => 'error', 'message' => 'Bu isim sunucusu zaten var!']);
        } else {
            $errorMessage = isset($response['error']['Message']) ? $response['error']['Message'] : 'Bilinmeyen bir hata oluştu.';
            return response()->json(['status' => 'error', 'message' => $errorMessage . ' Lütfen destek talebi oluşturun!']);
        }
    }

    protected function updateaddnameserver($domainname, $nameserver, $nameserverip) {
        $clientId = Session::get('client');
        $dna = new DomainNameAPI_PHPLibrary('ugurakkaya', 'Unna2021**1612hello');
        $nameserver_data = $nameserver . '.' . $domainname;
        $response = $dna->ModifyChildNameServer($domainname, $nameserver_data, $nameserverip);

        $subject = "Oluşturulan NameServer Güncellendi!";
        $message = "$domainname isimli domain adresinize ait oluşturulan nameserver ($nameserver_data) adresi güncellendi.";


        if ($response['result'] == 'OK') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => 'İsim Sunucusu Başarılı bir şekilde güncellendi!']);
        } elseif ($response['result'] == 'ERROR') {
            return response()->json(['status' => 'error', 'message' => 'Güncelleme sırasında bir hata oluştu.']);
        } else {
            $errorMessage = isset($response['error']['Message']) ? $response['error']['Message'] : 'Bilinmeyen bir hata oluştu.';
            return response()->json(['status' => 'error', 'message' => $errorMessage . ' Lütfen destek talebi oluşturun!']);
        }
    }

    protected function deleteaddnameserver($domainname, $nameserver) {
        $clientId = Session::get('client');
        $dna = new DomainNameAPI_PHPLibrary('ugurakkaya', 'Unna2021**1612hello');
        $nameserver_data = $nameserver . '.' . $domainname;
        $response = $dna->DeleteChildNameServer($domainname, $nameserver_data);

        $subject = "Oluşturulan NameServer silindi!";
        $message = "$domainname isimli domain adresinize ait nameserver ($nameserver_data) adresi silindi.";


        if ($response['result'] == 'OK') {
            $send_message = $this->whmcs->SendMailCustom($clientId, $subject, $message);
            return response()->json(['status' => 'success', 'message' => 'İsim Sunucusu Başarılı bir şekilde silindi!']);

        } elseif ($response['result'] == 'ERROR') {
            return response()->json(['status' => 'error', 'message' => 'Alt alan adı bulunamadı veya beklenmedik bir sorun oluştu!']);
        } else {
            $errorMessage = isset($response['error']['Message']) ? $response['error']['Message'] : 'Bilinmeyen bir hata oluştu.';
            return response()->json(['status' => 'error', 'message' => $errorMessage . ' Lütfen destek talebi oluşturun!']);
        }
    }

    protected function verify($verify_code, $domainId)
    {
        $clientId = Session::get('client');

        if (!$clientId) {
            return response()->json(['status' => 'error', 'message' => 'Oturum bilgisi bulunamadı.']);
        }

        $storedCode = Session::get("verification_code_{$clientId}");

        if ($storedCode && $storedCode == $verify_code) {
            try {
                $response = $this->whmcs->DomainRequestEPP($domainId);
            } catch (\Exception $e) {
                return response()->json(['status' => 'error', 'message' => 'Domain EPP kodu istenirken bir hata oluştu.']);
            }

            if ($response['result'] == 'success') {
                $eppCode = $response['eppcode'];
                Session::forget("verification_code_{$clientId}");
                Session::forget('verification_sent');
                $customvars = array("transfer_code" => $eppCode, "domainid" => $domainId);
                $messagename = 'Transfer Kodu';

                try {
                    $mailsend = $this->whmcs->SendMail($clientId, $customvars, $messagename);
                    if ($mailsend['result'] == 'success') {
                        return response()->json(['status' => 'success', 'message' => 'Doğrulama kodunuz başarılı bir şekilde uygulanmıştır. Transfer kodunuz mail adresinize iletilmiştir.']);
                    } else {
                        \Log::error('Mail gönderilemedi: ', $mailsend);
                        return response()->json(['status' => 'error', 'message' => 'Mail gönderilemedi: ' . $mailsend['message']]);
                    }
                } catch (\Exception $e) {
                    \Log::error('Mail gönderilirken bir hata oluştu: ' . $e->getMessage());
                    return response()->json(['status' => 'error', 'message' => 'Mail gönderilirken bir hata oluştu.']);
                }
            } else {
                return response()->json(['status' => 'error', 'message' => 'EPP kodu alınamadı.']);
            }
        } else {
            return response()->json(['status' => 'error', 'message' => 'Doğrulama kodu hatalı, lütfen tekrar deneyin!']);
        }
    }

    protected function sendrenewapi(Request $request)
    {
        // Form verilerini al
        $clientId = session('client');
        $domain_id = $request->input('domainid');
        $domain = $request->input('domainname');
        $period = $request->input('period');

        // WHMCS API'ye istek gönder
        $response = $this->whmcs->sendrenewapi($clientId, $domain_id, $domain, $period);

        if (!empty($response['invoiceid'])) {
            return response()->json([
                'success' => true,
                'invoiceid' => $response['invoiceid'] // WHMCS'den gelen invoiceid
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Fatura oluşturulamadı. Lütfen tekrar deneyin.'
            ]);
        }
    }

    protected function hostingrenew(Request $request)
    {
        // Form verilerini al
        $clientId = session('client');
        $serviceid = $request->input('serviceid');
        $period = $request->input('period');

        // WHMCS API'ye istek gönder
        $response = $this->whmcs->sendrenew($clientId, $serviceid, $period);

        if (!empty($response['invoiceid'])) {
            return response()->json([
                'success' => true,
                'invoiceid' => $response['invoiceid'] // WHMCS'den gelen invoiceid
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Fatura oluşturulamadı. Lütfen tekrar deneyin.'
            ]);
        }
    }

}
