<?php

namespace App\Filament\Resources\VehicleResource\Pages;

use App\Filament\Resources\VehicleResource;
use App\Models\Vehicle;

use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;

class ListVehicles extends ListRecords
{
    protected static string $resource = VehicleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'all' => Tab::make('Tümü')
                ->icon('heroicon-o-list-bullet')
                ->badge(Vehicle::all()->count())
                ->modifyQueryUsing(fn ($query) => $query->withoutTrashed()),

            'tasit' => Tab::make('Binek Araç')
                ->icon('heroicon-o-truck')
                ->badge(Vehicle::where('vehicle_type_id', 1)->count())
                ->modifyQueryUsing(fn ($query) => $query->where('vehicle_type_id', 1)),

            'cekici' => Tab::make('Çekici')
                ->icon('heroicon-o-truck')
                ->badge(Vehicle::where('vehicle_type_id', 2)->count())
                ->modifyQueryUsing(fn ($query) => $query->where('vehicle_type_id', 2)),

            'dorse' => Tab::make('Dorse')
                ->icon('heroicon-o-truck')
                ->badge(Vehicle::where('vehicle_type_id', 3)->count())
                ->modifyQueryUsing(fn ($query) => $query->where('vehicle_type_id', 3)),

            'archived' => Tab::make('Arşiv')
                ->icon('heroicon-o-archive-box')
                ->badge(Vehicle::onlyTrashed()->count())
                ->badgeColor('warning')
                ->modifyQueryUsing(fn ($query) => $query->onlyTrashed()),
        ];
    }
}
