<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum BloodGroup: int implements HasLabel
{
    case A_POSITIVE     = 1;
    case A_NEGATIVE     = 2;
    case B_POSITIVE     = 3;
    case B_NEGATIVE     = 4;
    case AB_POSITIVE    = 5;
    case AB_NEGATIVE    = 6;
    case O_POSITIVE     = 7;
    case O_NEGATIVE     = 8;

    public function getLabel(): string
    {
        return match ($this) {
            self::A_POSITIVE    => 'A rh(+)',
            self::A_NEGATIVE    => 'A rh(-)',
            self::B_POSITIVE    => 'B rh(+)',
            self::B_NEGATIVE    => 'B rh(-)',
            self::AB_POSITIVE   => 'AB rh(+)',
            self::AB_NEGATIVE   => 'AB rh(-)',
            self::O_POSITIVE    => 'O rh(+)',
            self::O_NEGATIVE    => 'O rh(-)',
        };
    }
}
