const MenuState = {
  isOpen: false,
  activeMenuId: null,
  closeTimeout: null, // Kapanma kontrolü için timeout

  init() {
    this.cacheDOM();
    this.attachEventListeners();
    this.handleResize();
  },

  cacheDOM() {
    this.dom = {
      mobileIcon: document.querySelector('.top-menu-mobile-icon'),
      menuItems: document.querySelectorAll('.top-menu-link ul li'),
      menuBg: document.querySelector('.top-menu-bg'),
      menuList: document.querySelector('.top-menu-area .top-menu-link ul'),
      menuArea: document.querySelector('.top-menu-area'),
      menuDetailArea: document.querySelector('.top-menu-detail-area'),
      navbarOverlay: document.querySelector('.navbar-overlay'), // Fare sınırını takip etmek için
    };
  },

  attachEventListeners() {
    // Mobil menü ikonuna tıklama
    this.dom.mobileIcon?.addEventListener('click', this.toggleMobileMenu.bind(this));

    // Menü öğelerine tıklama ve hover olayları
    this.dom.menuItems.forEach(item => {
      item.addEventListener('click', () => this.handleMenuItemClick(item));
      const menuLink = item.querySelector('a');
      menuLink?.addEventListener('mouseenter', (e) => this.handleMenuHover(e));
    });

    // Fare menü detay alanından dışarı çıkarsa menüyü kapat
    this.dom.navbarOverlay?.addEventListener('mouseleave', this.handleMouseLeave.bind(this));
    this.dom.navbarOverlay?.addEventListener('mouseenter', this.clearCloseTimeout.bind(this));

    // Menü detay alanında fare giriş ve çıkış olaylarını dinle
    document.querySelectorAll('.top-menu-detail-item').forEach(detailItem => {
      detailItem.addEventListener('mouseenter', this.clearCloseTimeout.bind(this));
      detailItem.addEventListener('mouseleave', this.handleMouseLeave.bind(this));
    });

    // Pencere yeniden boyutlandırma
    window.addEventListener('resize', this.handleResize.bind(this));
  },

  toggleMobileMenu() {
    const { menuList, menuArea, mobileIcon } = this.dom;
    const icon = mobileIcon?.querySelector('i');

    if (!menuList) return;

    const isMenuOpen = menuList.style.display === 'block';

    // Mobil menüyü aç/kapat
    menuList.style.display = isMenuOpen ? 'none' : 'block';
    menuList.classList.toggle('top-menu-box-shadow', !isMenuOpen);
    menuArea?.classList.toggle('top-menu-mobile-open', !isMenuOpen);

    // Buton ikonunu değiştir
    icon?.classList.toggle('icon-fs-menu', isMenuOpen);
    icon?.classList.toggle('icon-fs-close', !isMenuOpen);
  },

  handleMenuItemClick(item) {
    const { menuItems } = this.dom;
    const isOpen = item.classList.contains('menu-link-open');

    // Diğer menüleri kapat
    menuItems.forEach(mi => mi.classList.remove('menu-link-open', 'menu-link-hover'));

    if (!isOpen) {
      item.classList.add('menu-link-open', 'menu-link-hover');
      this.loadMenuContent(item);
    }
  },

  loadMenuContent(item) {
    const menuLink = item.querySelector('a');
    const menuId = menuLink?.dataset.id;

    if (!menuId || menuId === 'ss-menu-kurumsal') return;

    const content = document.querySelector(`#${menuId} .top-menu-content`)?.cloneNode(true);
    const detail = item.querySelector('.top-menu-link-detail');

    if (detail && content) {
      detail.innerHTML = '';
      detail.appendChild(content);
    }
  },

  handleMenuHover(event) {
    if (window.innerWidth < 1100) return;

    const menuId = event.target.dataset.id;
    if (!menuId) return;

    const menuDetail = document.querySelector(`#${menuId}`);
    const { menuBg, menuDetailArea } = this.dom;

    if (menuDetail?.style.display === 'flex') {
      this.closeMenu();
    } else {
      this.openMenu(menuDetail, menuBg, menuDetailArea);
    }
  },

  openMenu(menuDetail, menuBg, menuDetailArea) {
    // Diğer menüleri kapat
    document.querySelectorAll('.top-menu-detail-item').forEach(item => {
      item.style.display = 'none';
    });

    // Aktif menüyü aç
    menuDetailArea?.style.setProperty('display', 'table');
    menuBg?.style.setProperty('display', 'block');
    menuDetail?.style.setProperty('display', 'flex');
    this.isOpen = true;
  },

  handleMouseLeave() {
    // Fare `navbar-overlay` veya detay alanından çıkınca kapanmayı tetikle
    this.closeTimeout = setTimeout(() => {
      this.closeAllMenus();
    }, 300); // 300ms gecikme
  },

  clearCloseTimeout() {
    // Kapanmayı engelle
    if (this.closeTimeout) {
      clearTimeout(this.closeTimeout);
      this.closeTimeout = null;
    }
  },

  closeAllMenus() {
    const { menuBg, menuDetailArea } = this.dom;

    // Tüm menüleri kapat
    document.querySelectorAll('.top-menu-detail-item').forEach(item => {
      item.style.display = 'none';
    });

    menuBg?.style.setProperty('display', 'none');
    menuDetailArea?.style.setProperty('display', 'none');
    this.activeMenuId = null;
    this.isOpen = false;
  },

  handleResize() {
    if (window.innerWidth >= 1100) {
      // Geniş ekranda mobil menüyü kapat
      this.dom.menuList?.style.removeProperty('display');
    }
  },
};

// Menü durumu başlat
document.addEventListener('DOMContentLoaded', () => MenuState.init());


window.onscroll = function() {
    var header = document.getElementById("fato");
    var scrollThreshold = 100; // Kaç piksel kaydırıldığında devreye gireceğini belirler

    // Eğer menü açıksa header'ı gizli tut
    if (document.body.classList.contains('menu-open')) {
        header.style.setProperty("display", "none", "important");
        return; // Menü açıkken scroll kodu çalışmasın
    }

    if (window.pageYOffset > scrollThreshold) {
        header.style.setProperty("display", "none", "important"); // Div'i gizler
    } else {
        header.style.setProperty("display", "block", "important"); // Div'i tekrar gösterir
    }
};

// Menü açıldığında .top-header-area'yı gizle
document.addEventListener('DOMContentLoaded', function() {
    const menuButton = document.getElementById('mobile_menu_icon'); // Menü butonu

    if (menuButton) {
        menuButton.addEventListener('click', function() {
            document.body.classList.toggle('menu-open'); // Menü aç/kapat

            var header = document.getElementById("fato");

            if (document.body.classList.contains('menu-open')) {
                header.style.setProperty("display", "none", "important");
            } else {
                header.style.setProperty("display", "block", "important");
            }
        });
    }
});


  $(document).on("click", 'a[href="sepet"]', function (e) {
      e.preventDefault(); // Varsayılan sepet yönlendirmesini durdur

      var co = $(this).find("span.badge").text(); // Sepet sayısını al
      if (co == "0" || !co) { // Eğer sepet boşsa

          // Modal HTML yapısını dinamik olarak oluştur
          var modalHtml = `
          <div class="modal fade show" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true" style="display: block; background-color: rgba(0,0,0,0.5);">
              <div class="modal-dialog modal-dialog-centered">
                  <div class="modal-content">
                      <div class="modal-header" style="background-color:#1c1c1c;border-bottom: 0 solid #1c1c1c !important;">
                          <button style="opacity: 1;" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                          <div class="delete-icon">
                              <i class="fa-solid fa-basket-shopping"></i>
                          </div>
                          <h5 class="mt-3" style="color: white;">Sepetiniz Boş</h5>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="col-12 btn btn-delete">Onayla</button>
                      </div>
                  </div>
              </div>
          </div>`;

          // Modal HTML'ini body'ye ekle
          $('body').append(modalHtml);

          // Modalı göster, arka planı kapat
          $('#deleteModal').modal({
              backdrop: false, // Arka planı karartmayı devre dışı bırak
              show: true
          });

          // "X" veya "Onayla" butonuna basıldığında modalı kapat
          $('body').on('click', '.btn-close, .btn-delete', function () {
              $('#deleteModal').modal('hide');
              $('#deleteModal').remove(); // Modalı kaldır
          });

      } else {
          // Eğer sepet doluysa, sepet sayfasına yönlendir
          window.location.href = 'sepet';
      }
  });


function updateCartCount() {
    $.ajax({
        url: '', // Aynı sayfaya istek gönder
        method: 'POST',
        data: { action: 'get_cart_count' }, // Sepet sayısını iste
        success: function(response) {
            // Dönen sayıyı badge içerisine günceller
            $('#cart-count').text(response);
        }
    });
}

// Örnek olarak her 5 saniyede bir sepet sayısını güncelle
setInterval(updateCartCount, 1000);

// Sepete bir ürün ekledikten hemen sonra güncellemek için bu fonksiyonu da çağırabilirsiniz
// updateCartCount();
document.addEventListener("DOMContentLoaded", function() {
    const listItems = document.querySelectorAll('.registry-list-item');
    const loadMoreButton = document.getElementById('loadMore');
    const initialCount = 14;

    // Eğer mobilse sadece ilk 14 öğeyi göster
    if (window.innerWidth <= 768) { // Mobil genişlik kontrolü
        listItems.forEach((item, index) => {
            if (index >= initialCount) {
                item.style.display = 'none';
            }
        });

        // Eğer 14'ten fazla öğe varsa butonu göster
        if (listItems.length > initialCount) {
            loadMoreButton.style.display = 'block';
        }

        // Butona tıklanınca display: none'yi kaldır
        loadMoreButton.addEventListener('click', function() {
            listItems.forEach(item => {
                item.style.removeProperty('display');
            });
            loadMoreButton.style.display = 'none'; // Butonu gizle
        });
    }
});


let cpanelId, pleskId, selectedProductName;

function setProductId(cpanel, plesk, productName) {
    cpanelId = cpanel;
    pleskId = plesk;
    selectedProductName = productName;
}

function selectPlatform(platformId) {
    // Seçilen platform ve ürün adını localStorage'a kaydedelim
    localStorage.setItem('selectedPlatformId', platformId);
    localStorage.setItem('selectedProductName', selectedProductName);

    // Domain seçim sayfasına yönlendirelim
    window.location.href = 'hosting-kurulum';
}

let index = 0;

jQuery(document).ready(function() {

								document.querySelector('#BoxSurpriseBtn').addEventListener('click', function() {
									document.getElementById('BoxSurpriseInput').select()
									document.execCommand('copy');
									$('.BoxSurpriseClipboard #BoxSurpriseInput').addClass('CodeBoxFlashBG')
										.delay('1000').queue(function() {
											$('.BoxSurpriseClipboard #BoxSurpriseInput').removeClass('CodeBoxFlashBG').dequeue();
										});
								});

							});
