<?php $pageTitle = 'Şifre Güncelleme'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="icon" href="https://sspanel.serversistemleri.com/favicon.ico" />

    <title><?php echo e($pageTitle); ?> - Server Sistemleri</title>

    <style>
           [x-cloak=""],
           [x-cloak="x-cloak"],
           [x-cloak="1"] {
               display: none !important;
           }

           @media (max-width: 1023px) {
               [x-cloak="-lg"] {
                   display: none !important;
               }
           }

           @media (min-width: 1024px) {
               [x-cloak="lg"] {
                   display: none !important;
               }
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
       <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
       <style>
           :root {
               --danger-50: 254, 242, 242;
               --danger-100: 254, 226, 226;
               --danger-200: 254, 202, 202;
               --danger-300: 252, 165, 165;
               --danger-400: 248, 113, 113;
               --danger-500: 239, 68, 68;
               --danger-600: 220, 38, 38;
               --danger-700: 185, 28, 28;
               --danger-800: 153, 27, 27;
               --danger-900: 127, 29, 29;
               --danger-950: 69, 10, 10;
               --gray-50: 250, 250, 250;
               --gray-100: 244, 244, 245;
               --gray-200: 228, 228, 231;
               --gray-300: 212, 212, 216;
               --gray-400: 161, 161, 170;
               --gray-500: 113, 113, 122;
               --gray-600: 82, 82, 91;
               --gray-700: 63, 63, 70;
               --gray-800: 39, 39, 42;
               --gray-900: 24, 24, 27;
               --gray-950: 9, 9, 11;
               --info-50: 239, 246, 255;
               --info-100: 219, 234, 254;
               --info-200: 191, 219, 254;
               --info-300: 147, 197, 253;
               --info-400: 96, 165, 250;
               --info-500: 59, 130, 246;
               --info-600: 37, 99, 235;
               --info-700: 29, 78, 216;
               --info-800: 30, 64, 175;
               --info-900: 30, 58, 138;
               --info-950: 23, 37, 84;
               --primary-50: 244, 250, 252;
               --primary-100: 232, 244, 249;
               --primary-200: 198, 228, 241;
               --primary-300: 164, 211, 232;
               --primary-400: 96, 179, 215;
               --primary-500: 28, 146, 198;
               --primary-600: 25, 131, 178;
               --primary-700: 21, 110, 149;
               --primary-800: 17, 88, 119;
               --primary-900: 14, 72, 97;
               --primary-950: 8, 44, 59;
               --success-50: 240, 253, 244;
               --success-100: 220, 252, 231;
               --success-200: 187, 247, 208;
               --success-300: 134, 239, 172;
               --success-400: 74, 222, 128;
               --success-500: 34, 197, 94;
               --success-600: 22, 163, 74;
               --success-700: 21, 128, 61;
               --success-800: 22, 101, 52;
               --success-900: 20, 83, 45;
               --success-950: 5, 46, 22;
               --warning-50: 255, 251, 235;
               --warning-100: 254, 243, 199;
               --warning-200: 253, 230, 138;
               --warning-300: 252, 211, 77;
               --warning-400: 251, 191, 36;
               --warning-500: 245, 158, 11;
               --warning-600: 217, 119, 6;
               --warning-700: 180, 83, 9;
               --warning-800: 146, 64, 14;
               --warning-900: 120, 53, 15;
               --warning-950: 69, 26, 3;
           }
       </style>

       <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

       <link rel="preconnect" href="https://fonts.bunny.net" />
       <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

       <style>
           :root {
               --font-family: "Inter";
               --sidebar-width: 20rem;
               --collapsed-sidebar-width: 4.5rem;
               --default-theme-mode: light;
           }
       </style>

       <script>

           if (theme === "dark" || (theme === "system" && window.matchMedia("(prefers-color-scheme: dark)").matches)) {
               document.documentElement.classList.add("dark");
           }
       </script>

       <!-- Livewire Styles -->
       <style>
           [wire\:loading][wire\:loading],
           [wire\:loading\.delay][wire\:loading\.delay],
           [wire\:loading\.inline-block][wire\:loading\.inline-block],
           [wire\:loading\.inline][wire\:loading\.inline],
           [wire\:loading\.block][wire\:loading\.block],
           [wire\:loading\.flex][wire\:loading\.flex],
           [wire\:loading\.table][wire\:loading\.table],
           [wire\:loading\.grid][wire\:loading\.grid],
           [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
               display: none;
           }
           [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
           [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
           [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
           [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
           [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
           [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
           [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
           [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
               display: none;
           }
           [wire\:offline][wire\:offline] {
               display: none;
           }
           [wire\:dirty]:not(textarea):not(input):not(select) {
               display: none;
           }
           :root {
               --livewire-progress-bar-color: #2299dd;
           }
           [x-cloak] {
               display: none !important;
           }
       </style>

       <style>
           @keyframes checkmark {
               0% {
                   stroke-dashoffset: 100;
               }
               100% {
                   stroke-dashoffset: 0;
               }
           }
           @keyframes scaleIn {
               0% {
                   transform: scale(0);
                   opacity: 0;
               }
               50% {
                   transform: scale(1.1);
               }
               100% {
                   transform: scale(1);
                   opacity: 1;
               }
           }
           .success-checkmark {
               animation: scaleIn 0.5s ease-in-out;
           }
           .success-checkmark__check {
               transform-origin: 50% 50%;
               stroke-dasharray: 100;
               stroke-dashoffset: 100;
               animation: checkmark 0.6s 0.2s ease-in-out forwards;
           }

           /* Responsive improvements */
           @media (max-width: 640px) {
               .fi-simple-main {
                   margin-top: 0 !important;
                   margin-bottom: 0 !important;
                   border-radius: 0 !important;
                   min-height: 100vh;
               }
               .fi-simple-header img {
                   width: 180px !important;
               }
               .grid.grid-cols-\[--cols-default\] {
                   grid-template-columns: 1fr !important;
               }
           }
       </style>
   </head>
<body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
    <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
        <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
            <div class="fi-simple-page">
              <?php if ($status == 'true'): ?>
                <section class="grid auto-cols-fr gap-y-6">
                    <header class="fi-simple-header flex flex-col items-center">
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo mb-4" style="width: 250px;" />
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo mb-4" style="width: 250px;" />
                        <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                        Şifre Sıfırlama
                        </h1>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-2">Lütfen yeni şifrenizi belirleyin</p>
                    </header>

                    <form id="form" class="fi-form grid gap-y-6">
                        <?php echo csrf_field(); ?>
                        <input id="token" type="hidden" name="token" value="<?php echo $token; ?>">
                        <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center justify-between gap-x-3">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="password">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Yeni Şifre
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                <div class="flex items-center ps-3 text-gray-400">
                                                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                                    </svg>
                                                </div>
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        type="password"
                                                        id="password"
                                                        name="password"
                                                        placeholder="Yeni şifrenizi girin"
                                                        required
                                                        minlength="8"
                                                        autocomplete="new-password"
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                                </div>
                                                <button type="button" onclick="togglePassword('password')" class="px-3 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors" aria-label="Şifreyi göster/gizle">
                                                    <svg id="password-eye-open" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                                    </svg>
                                                    <svg id="password-eye-closed" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                                    </svg>
                                                </button>
                                            </div>
                                            <small id="password-error" class="text-danger-600 dark:text-danger-400 text-xs hidden">Şifreniz en az 8 karakter olmalı.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                <div data-field-wrapper class="fi-fo-field-wrp">
                                    <div class="grid gap-y-2">
                                        <div class="flex items-center justify-between gap-x-3">
                                            <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="password2">
                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                    Yeni Şifre (Tekrar)
                                                    <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="grid auto-cols-fr gap-y-2">
                                            <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                <div class="flex items-center ps-3 text-gray-400">
                                                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                                    </svg>
                                                </div>
                                                <div class="min-w-0 flex-1">
                                                    <input
                                                        type="password"
                                                        id="password2"
                                                        name="password2"
                                                        placeholder="Yeni şifrenizi tekrar girin"
                                                        required
                                                        minlength="8"
                                                        autocomplete="new-password"
                                                        class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                                </div>
                                                <button type="button" onclick="togglePassword('password2')" class="px-3 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors" aria-label="Şifreyi göster/gizle">
                                                    <svg id="password2-eye-open" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                                    </svg>
                                                    <svg id="password2-eye-closed" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                                    </svg>
                                                </button>
                                            </div>
                                            <small id="password2-error" class="text-danger-600 dark:text-danger-400 text-xs hidden">Şifreniz en az 8 karakter olmalı.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-start gap-2 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                            <svg class="h-5 w-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                            </svg>
                            <p class="text-xs text-blue-800 dark:text-blue-300">
                                Şifreniz en az 8 karakter uzunluğunda olmalı, küçük ve büyük harf içermeli, en az bir sembol (#, $, vb.) barındırmalı ve sözlük kelimelerinden kaçınılmalıdır.
                            </p>
                        </div>

                        <div id="alert"></div>
                        <div class="fi-form-actions">
                            <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                                <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" type="submit" id="submit-button">
                                    <span class="fi-btn-label">ŞİFREYİ GÜNCELLE</span>
                                </button>
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <p class="text-sm text-gray-600 dark:text-gray-400">
                                Şifrenizi hatırladınız mı?
                                <a href="<?php echo e(route('login')); ?>" class="text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors duration-200">
                                    Giriş Yapın
                                </a>
                            </p>
                        </div>
                    </form>
                </section>
                <?php else: ?>
                  <section class="grid auto-cols-fr gap-y-6">
                      <header class="fi-simple-header flex flex-col items-center">
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo mb-4" style="width: 250px;" />
                        <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo mb-4" style="width: 250px;" />
                          <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white mt-6">
                          <?php echo $status; ?>
                          </h1>
                      </header>
                      <div class="text-center mt-4">
                          <a href="<?php echo e(route('login')); ?>" class="text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors duration-200">
                              Giriş Sayfasına Dön
                          </a>
                      </div>
                  </section>
              <?php endif; ?>

            </div>
        </main>
    </div>
</div>

<script>
(function() {
    'use strict';

    const ALERT_TEMPLATES = {
        success: (message) => `
            <div class="bg-green-50 dark:bg-gray-800 dark:text-green-400 flex flex-col items-center justify-center p-6 rounded-lg text-green-800 text-sm" role="alert">
                <svg class="success-checkmark h-16 w-16 mb-4" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="26" cy="26" r="25" fill="currentColor" fill-opacity="0.2" stroke="currentColor" stroke-width="2"/>
                    <path class="success-checkmark__check" d="M14 27l7.5 7.5L38 18" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <span class="sr-only">Başarılı</span>
                <div class="text-center">
                    <p class="font-semibold text-lg mb-1">Şifreniz Güncellendi!</p>
                    <p class="text-sm">${message}</p>
                    <p class="text-xs mt-2 opacity-75">Giriş sayfasına yönlendiriliyorsunuz...</p>
                </div>
            </div>
        `,
        error: (message) => `
            <div class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert">
                <svg style="margin-right: 5px;" aria-hidden="true" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                </svg>
                <span class="sr-only">Hata</span>
                <div><span class="font-medium">Hata!</span> ${message}</div>
            </div>
        `
    };

    // Password toggle function
    window.togglePassword = function(inputId) {
        const input = document.getElementById(inputId);
        const eyeOpen = document.getElementById(inputId + '-eye-open');
        const eyeClosed = document.getElementById(inputId + '-eye-closed');

        if (input.type === 'password') {
            input.type = 'text';
            eyeOpen.classList.add('hidden');
            eyeClosed.classList.remove('hidden');
        } else {
            input.type = 'password';
            eyeOpen.classList.remove('hidden');
            eyeClosed.classList.add('hidden');
        }
    };

    // Input validation
    const passwordInput = document.getElementById("password");
    const password2Input = document.getElementById("password2");
    const passwordError = document.getElementById("password-error");
    const password2Error = document.getElementById("password2-error");

    function validateInput(input, errorElement) {
        if (input.value.length > 0 && input.value.length < 8) {
            errorElement.classList.remove("hidden");
        } else {
            errorElement.classList.add("hidden");
        }
    }

    passwordInput.addEventListener("blur", () => {
        validateInput(passwordInput, passwordError);
    });

    password2Input.addEventListener("blur", () => {
        validateInput(password2Input, password2Error);
    });

    // Form submit handler
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('form');
        const submitButton = document.getElementById('submit-button');
        const alertDiv = document.getElementById('alert');
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        form.addEventListener('submit', function (e) {
            e.preventDefault();

            const password = document.getElementById('password').value;
            const password2 = document.getElementById('password2').value;
            const token = document.getElementById('token').value;

            if (password !== password2) {
                alertDiv.innerHTML = ALERT_TEMPLATES.error('Şifreler uyuşmuyor!');
                return;
            }

            if (password.length < 8) {
                alertDiv.innerHTML = ALERT_TEMPLATES.error('Şifreniz en az 8 karakter olmalıdır!');
                return;
            }

            // Submit butonunu devre dışı bırak
            submitButton.disabled = true;
            submitButton.querySelector('.fi-btn-label').textContent = 'Lütfen bekleyiniz...';

            const formData = {
                password: password,
                password2: password2,
                token: token
            };

            fetch('<?php echo e(route('passwordresetform')); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify(formData)
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Bilinmeyen bir hata oluştu.');
                    });
                }
                return response.json();
            })
            .then(data => {
                alertDiv.innerHTML = ALERT_TEMPLATES.success(data.message || 'Şifreniz başarıyla güncellendi!');
                // 2 saniye sonra login sayfasına yönlendir
                setTimeout(() => {
                    window.location.href = '<?php echo e(route('login')); ?>';
                }, 2000);
            })
            .catch(error => {
                alertDiv.innerHTML = ALERT_TEMPLATES.error(error.message);
                submitButton.disabled = false;
                submitButton.querySelector('.fi-btn-label').textContent = 'ŞİFREYİ GÜNCELLE';
            });
        });
    });
})();
</script>



<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>
</body>
</html>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/auth/passpage.blade.php ENDPATH**/ ?>