<?php $pageTitle = 'Ürün Detayları'; ?> @include("layouts.header")

<?php
$whmcsFilePath = storage_path('app/public/whmcs_data.json');
if (file_exists($whmcsFilePath)) {
    $whmcs_data = json_decode(file_get_contents($whmcsFilePath), true);
} else {
    $whmcs_data = []; // Dosya bulunamazsa boş array döndür
}

 ?>
 <?php

 function getDomainExtension($domain) {
     $parts = explode('.', $domain);
     $totalParts = count($parts);

     // En az 2 parçalı değilse geçersiz
     if ($totalParts < 2) {
         return false;
     }

     // Eğer son parça 2 harften uzunsa (örnek: 'com', 'org') tek parça uzantıdır
     $tld = $parts[$totalParts - 1];

     // Eğer son parça 2 harfli ise (örnek: 'tr', 'de', 'uk'), iki parçalı uzantı olabilir
     if (strlen($tld) == 2 && $totalParts >= 3) {
         return $parts[$totalParts - 2] . '.' . $tld;
     }

     // Normal tek uzantı
     return $tld;
 }

 ?>
<style media="screen">
    .mbtn {
        width: 24%;
    }

    .label-mobile {
        display: none;
    }

    .label-desktop {
        display: block;
    }

    .label {
        padding: 5px 10px;
        border-radius: 3px;
        font-size: 14px;
        color: white;
        text-align: center;
    }

    .label-default {
        background-color: #777;
    }

    .label-default[href]:hover,
    .label-default[href]:focus {
        background-color: #5e5e5e;
    }

    .label-primary {
        background-color: #337ab7;
    }

    .label-primary[href]:hover,
    .label-primary[href]:focus {
        background-color: #286090;
    }

    .label-success {
        background-color: #5cb85c;
    }

    .label-success[href]:hover,
    .label-success[href]:focus {
        background-color: #449d44;
    }

    .label-info {
        background-color: #5bc0de;
    }

    .label-info[href]:hover,
    .label-info[href]:focus {
        background-color: #31b0d5;
    }

    .label-warning {
        background-color: #f0ad4e;
    }

    .label-warning[href]:hover,
    .label-warning[href]:focus {
        background-color: #ec971f;
    }

    .label-danger {
        background-color: #d9534f;
    }

    .label-danger[href]:hover,
    .label-danger[href]:focus {
        background-color: #c9302c;
    }

    @media only screen and (max-width: 600px) {
        .mr-15 {
            margin-left: 15px;
        }
        .mbtn {
            width: 100%;
            margin-bottom: 5px;
        }
        .label-mobile {
            display: block;
        }
        .label-desktop {
            display: none;
        }
    }
</style>
<?php
  $domain = $product['domains']['domain'][0];
$statusClasses = [
   "Active" => "label-success",
   "Suspended" => "label-warning",
   "Terminated" => "label-danger",
   "Cancelled" => "label-default"
];
$status = $domain['status'];
$cssClass = isset($statusClasses[$status]) ? $statusClasses[$status] : "label-default";
 ?>
    <main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
        <div class="fi-page fi-dashboard-page">
            <section class="flex flex-col gap-y-8 py-8">
                <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                    <div>
                        <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                            Domain Detayları
                        </h1>
                    </div>
                </header>
            </section>
        </div>
            <?php $domain['status'] == 'Expired'; ?>
            <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(<?php if ($domain['status'] == 'Expired'): ?>1<?php else: ?>2<?php endif; ?>, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Domain Genel Bakış
                                        </h3>
                                    </div>
                                </div>
                            </div>

                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                <div class="">
                                    <div class="px-6 py-4">
                                        <div class="flex items-center">
                                            <div class="bg-gray-200 dark:bg-gray-700 p-4 rounded-full label-desktop">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-800 dark:text-white" viewBox="0 0 20 20" fill="currentColor">
                                          <path fill-rule="evenodd" d="M4 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm2-1a1 1 0 00-1 1v10a1 1 0 001 1h8a1 1 0 001-1V5a1 1 0 00-1-1H6zm4 8a2 2 0 100 4 2 2 0 000-4zm0 1a1 1 0 110 2 1 1 0 010-2z" clip-rule="evenodd" />
                                      </svg>
                                            </div>
                                            <div style="margin-left: 10px;" class="ml-4">
                                                <h1 class="text-xl font-semibold text-gray-900 dark:text-white">{{$domain['domainname']}}</h1>
                                                <p class="text-gray-600 dark:text-gray-400">
                                                    <?php
                                        $currentDate = new DateTime();
                                        $nextDueDate = new DateTime($domain['nextduedate']);
                                        $daysRemaining = $currentDate->diff($nextDueDate)->days;
                                        $isPast = $currentDate > $nextDueDate;
                                        if ($isPast) {
                                          echo "Bu alan adının süresi $daysRemaining gün önce doldu...</p>";
                                        } else {
                                          echo "Bu alan adının süresi $daysRemaining gün sonra bitiyor...</p>";
                                        }
                                         ?>
                                                </p>
                                            </div>
                                            <form action="{{ route('domain.save') }}" method="POST" class="hostingrenew-form" style="display: contents;">
                                              @csrf
                                              <input type="hidden" name="action" value="domainrenew">
                                              <input type="hidden" name="domainid" value="<?php echo $product['domainid']; ?>">
                                              <input type="hidden" name="domainname" value="<?php echo $domain['domainname']; ?>">
                                              <select name="period" style="text-align: center; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="mbtn fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                <option selected disabled>Süre Uzat</option>
                                                  <?php
                                                  $tldPricing = $whmcs_data['tldPricing']['pricing']; // TLD verilerini al

                                                  $turkish_cycles = [
                                                    1 => '1 Yıllık',
                                                    2 => '2 Yıllık',
                                                    3 => '3 Yıllık',
                                                    4 => '4 Yıllık',
                                                    5 => '5 Yıllık',
                                                    6 => '6 Yıllık',
                                                    7 => '7 Yıllık',
                                                    8 => '8 Yıllık',
                                                    9 => '9 Yıllık',
                                                    10 => '10 Yıllık'
                                                  ];

                                                  // Örneğin "ARMY" uzantısı için:
                                                  $tld = getDomainExtension($domain['domainname']); // bu kısmı dinamikleştirebilirsin

                                                  if (isset($tldPricing[$tld]['renew'])) {
                                                    foreach ($tldPricing[$tld]['renew'] as $year => $price) {
                                                      if ($price > 0) {
                                                        $label = isset($turkish_cycles[$year]) ? $turkish_cycles[$year] : $year . ' Yıllık';
                                                        echo "<option value=\"{$year}\">{$label} (\${$price})</option>";
                                                      }
                                                    }
                                                  }
                                                  ?>
                                              </select>
                                            </form>
                                            <span class="label-desktop label <?php echo $cssClass; ?> ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">

                                    <?php
                                    if ($domain['status'] == "Active") {
                                      echo "Aktif";
                                    }
                                    if ($domain['status'] == "Expired") {
                                      echo "Süresi Doldu";
                                    }
                                    if ($domain['status'] == "Terminated") {
                                      echo "Kapatıldı";
                                    }
                                    if ($domain['status'] == "Cancelled") {
                                      echo "İptal Edildi";
                                    }
                                     ?>
                                  </span>
                                        </div>
                                        <div style="margin-top:10px;" class="mt-4">
                                            <span style="margin-bottom:5px;border-radius: .5rem;" class="label-mobile label <?php echo $cssClass; ?> ml-auto bg-green-200 text-green-800 px-3 py-1 rounded-full text-sm">
                                  <?php

                                  if ($domain['status'] == "Active") {
                                    echo "Aktif";
                                  }
                                  if ($domain['status'] == "Expired") {
                                    echo "Süresi Doldu";
                                  }
                                  if ($domain['status'] == "Terminated") {
                                    echo "Kapatıldı";
                                  }
                                  if ($domain['status'] == "Cancelled") {
                                    echo "İptal Edildi";
                                  }
                                   ?>
                                </span>
                                        </div>
                                    </div>
                                    <div class="border-t dark:border-gray-700">
                                        <dl class="divide-y divide-gray-200 dark:divide-gray-700">
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Yenileme Tutarı</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">${{$domain['recurringamount']}}</dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Sonraki Yenileme Tarihi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo date_format(date_create($domain['nextduedate']), "d/m/Y"); ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Ödeme şekli</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php
                                                    if ($domain['paymentmethod'] == "banktransfer") {
                                                      echo "Banka Transferi";
                                                    }
                                                    if ($domain['paymentmethod'] == "paytr") {
                                                      echo "Kredi Kartı";
                                                    }
                                                    ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Kayıt Tarihi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo date_format(date_create($domain['regdate']), "d/m/Y"); ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Bitiş Tarihi</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo date_format(date_create($domain['expirydate']), "d/m/Y"); ?>
                                                </dd>
                                            </div>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($domain['status'] == 'Active'): ?>

                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Domain Yönetim Kısayolları
                                        </h3>
                                    </div>
                                </div>
                            </div>

                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                <div class="">
                                    <div class="mb-4">
                                      <div style="margin-right: 20px; margin-left: 20px; margin-top: 10px;" id="nameserver-save-button" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                                        <div class="flex justify-between items-center">
                                          <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">NameServer Güncelle</h2>
                                          <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                                        </div>
                                      </div>
                                        <form id="nameserver-save-form" action="{{ route('domain.save') }}" method="post" class="nameserver-form hidden">
                                            @csrf
                                            <input type="hidden" name="action" value="updateNameservers">
                                            <input type="hidden" name="domainid" value="{{$product['domainid']}}">
                                          <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr)); --cols-xl: repeat(2, minmax(0, 1fr));padding-right:30px;padding-left:30px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6">

                                              <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                  <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                      <div class="grid gap-y-2">
                                                          <div class="flex items-center gap-x-3 justify-between">
                                                              <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                                <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                  NameServer 1
                                                                </span>
                                                              </label>
                                                            </div>

                                                            <div class="grid auto-cols-fr gap-y-2">
                                                              <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                  <div class="min-w-0 flex-1">
                                                                      <input name="nameserver1" value="<?php if (isset($dna['data']['NameServers'][0])): echo $dna['data']['NameServers'][0]; endif; ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                          type="text" />
                                                                        </div>
                                                                      </div>
                                                                    </div>
                                                                  </div>
                                                                </div>
                                                              </div>
                                                              <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                                <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                                  <div class="grid gap-y-2">
                                                                    <div class="flex items-center gap-x-3 justify-between">
                                                                      <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                                        <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                          NameServer 2
                                                                        </span>
                                                                      </label>
                                                                    </div>

                                                                    <div class="grid auto-cols-fr gap-y-2">
                                                                      <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                        <div class="min-w-0 flex-1">
                                                                          <input name="nameserver2" value="<?php if (isset($dna['data']['NameServers'][1])): echo $dna['data']['NameServers'][1]; endif; ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                            type="text" />
                                                                          </div>
                                                                        </div>
                                                                      </div>
                                                                    </div>
                                                                  </div>
                                                                </div>
                                                                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                                  <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                                    <div class="grid gap-y-2">
                                                                      <div class="flex items-center gap-x-3 justify-between">
                                                                        <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                                          <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                            NameServer 3
                                                                          </span>
                                                                        </label>
                                                                      </div>

                                                                      <div class="grid auto-cols-fr gap-y-2">
                                                                        <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                          <div class="min-w-0 flex-1">
                                                                            <input name="nameserver3" value="<?php if (isset($dna['data']['NameServers'][2])): echo $dna['data']['NameServers'][2]; endif; ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                              type="text" />
                                                                            </div>
                                                                          </div>
                                                                        </div>
                                                                      </div>
                                                                    </div>
                                                                  </div>

                                                                  <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                                    <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                                      <div class="grid gap-y-2">
                                                                        <div class="flex items-center gap-x-3 justify-between">
                                                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                                            <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                              NameServer 4
                                                                            </span>
                                                                          </label>
                                                                        </div>

                                                                        <div class="grid auto-cols-fr gap-y-2">
                                                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                                            <div class="min-w-0 flex-1">
                                                                              <input name="nameserver4" value="<?php if (isset($dna['data']['NameServers'][3])): echo $dna['data']['NameServers'][3]; endif; ?>" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                                type="text" />
                                                                              </div>
                                                                            </div>
                                                                          </div>
                                                                        </div>
                                                                      </div>
                                                                    </div>
                                                                  </div>
                                            <div id="response-message">
                                              <div id="lockedstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                                <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                                  <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                                  </svg>
                                                  <span class="sr-only">Info</span>
                                                  <div>
                                                    <span class="font-medium">Başarılı! </span> <span id="lockedstatus-message-text"></span>
                                                  </div>
                                                </div>
                                              </div>
                                              <div id="lockederror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                                <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                                  <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                                  </svg>
                                                  <span class="sr-only">Info</span>
                                                  <div>
                                                    <span class="font-medium">Hata! </span> <span id="lockederror-message-text"></span>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div style="padding-left:30px;padding-right: 30px;margin-top: 10px;">
                                                <button style="width: 100%;--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Kaydet</button>
                                            </div>
                                        </form>
                                    </div>
                                      <div class="mb-4">
                                        <div id="addnameserver-button" style="margin-right: 20px; margin-left: 20px;" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                                          <div class="flex justify-between items-center">
                                            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">Alt NameServer Kaydet</h2>
                                            <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                                          </div>
                                        </div>
                                        <form id="addnameserver-form" action="{{ route('domain.save') }}" method="post" class="addnameserver-form hidden">
                                          @csrf
                                          <input type="hidden" name="action" value="addnameserver" />
                                          <input type="hidden" name="domainname" value="{{$domain['domainname']}}" />
                                          <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr)); --cols-xl: repeat(2, minmax(0, 1fr)); padding-right: 30px; padding-left: 30px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6">
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                <div class="grid gap-y-2">
                                                  <div class="flex items-center gap-x-3 justify-between">
                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        NameServer (Örnek: ns1)
                                                      </span>
                                                    </label>
                                                  </div>
                                                  <div class="grid auto-cols-fr gap-y-2">
                                                    <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                      <div class="min-w-0 flex-1">
                                                        <input name="nameserver" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[- webkit- text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" />
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                <div class="grid gap-y-2">
                                                  <div class="flex items-center gap-x-3 justify-between">
                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        IP Adresi (Örnek: 1.2.3.4)
                                                      </span>
                                                    </label>
                                                  </div>
                                                  <div class="grid auto-cols-fr gap-y-2">
                                                    <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                      <div class="min-w-0 flex-1">
                                                        <input name="nameserverip" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[- webkit- text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" />
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                          <div id="response-message">
                                            <div id="addnameserverstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Başarılı! </span> <span id="addnameserverstatus-message-text"></span></div>
                                              </div>
                                            </div>
                                            <div id="addnameservererror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Hata! </span> <span id="addnameservererror-message-text"></span></div>
                                              </div>
                                            </div>
                                          </div>
                                          <div style="padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                            <button style="width: 100%; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500   dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                              Kaydet
                                            </button>
                                          </div>
                                        </form>
                                      </div>
                                      <div class="mb-4">
                                        <div id="updateaddnameserver-button" style="margin-right: 20px; margin-left: 20px;" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                                          <div class="flex justify-between items-center">
                                            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">Alt NameServer Güncelle</h2>
                                            <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                                          </div>
                                        </div>
                                        <form id="updateaddnameserver-form" action="{{ route('domain.save') }}" method="post" class="updateaddnameserver-form hidden">
                                          @csrf
                                          <input type="hidden" name="action" value="updateaddnameserver" />
                                          <input type="hidden" name="domainname" value="{{$domain['domainname']}}" />
                                          <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr)); --cols-xl: repeat(2, minmax(0, 1fr)); padding-right: 30px; padding-left: 30px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6">
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                <div class="grid gap-y-2">
                                                  <div class="flex items-center gap-x-3 justify-between">
                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        NameServer (Örnek: ns1)
                                                      </span>
                                                    </label>
                                                  </div>
                                                  <div class="grid auto-cols-fr gap-y-2">
                                                    <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                      <div class="min-w-0 flex-1">
                                                        <input name="nameserver" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[- webkit- text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" />
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                <div class="grid gap-y-2">
                                                  <div class="flex items-center gap-x-3 justify-between">
                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        IP Adresi (Örnek: 1.2.3.4)
                                                      </span>
                                                    </label>
                                                  </div>
                                                  <div class="grid auto-cols-fr gap-y-2">
                                                    <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                      <div class="min-w-0 flex-1">
                                                        <input name="nameserverip" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[- webkit- text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" />
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                          <div id="response-message">
                                            <div id="updateaddnameserverstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Başarılı! </span> <span id="updateaddnameserverstatus-message-text"></span></div>
                                              </div>
                                            </div>
                                            <div id="updateaddnameservererror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Hata! </span> <span id="updateaddnameservererror-message-text"></span></div>
                                              </div>
                                            </div>
                                          </div>
                                          <div style="padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                            <button style="width: 100%; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500   dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                              Kaydet
                                            </button>
                                          </div>
                                        </form>
                                      </div>
                                      <div class="mb-4">
                                        <div id="deleteaddnameserver-button" style="margin-right: 20px; margin-left: 20px;" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                                          <div class="flex justify-between items-center">
                                            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">Alt NameServer Silme</h2>
                                            <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                                          </div>
                                        </div>
                                        <form id="deleteaddnameserver-form" action="{{ route('domain.save') }}" method="post" class="deleteaddnameserver-form hidden">
                                          @csrf
                                          <input type="hidden" name="action" value="deleteaddnameserver" />
                                          <input type="hidden" name="domainname" value="{{$domain['domainname']}}" />
                                          <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(1, minmax(0, 1fr)); --cols-xl: repeat(1, minmax(0, 1fr)); padding-right: 30px; padding-left: 30px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] xl:grid-cols-[--cols-xl] fi-fo-component-ctn gap-6">
                                            <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                <div class="grid gap-y-2">
                                                  <div class="flex items-center gap-x-3 justify-between">
                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3">
                                                      <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                        NameServer (Örnek: ns1)
                                                      </span>
                                                    </label>
                                                  </div>
                                                  <div class="grid auto-cols-fr gap-y-2">
                                                    <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 [&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-600 dark:[&amp;:not(:has(.fi-ac-action:focus))]:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                                      <div class="min-w-0 flex-1">
                                                        <input name="nameserver" class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 disabled:[-webkit-text-fill-color:theme(colors.gray.500)] disabled:placeholder:[-webkit-text-fill-color:theme(colors.gray.400)] dark:text-white dark:placeholder:text-gray-500dark:disabled:text-gray-400 dark:disabled:[-webkit-text-fill-color:theme(colors.gray.400)] dark:disabled:placeholder:[- webkit- text-fill-color:theme(colors.gray.500)] sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" type="text" />
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                          <div id="response-message">
                                            <div id="deleteaddnameserverstatus-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Başarılı! </span> <span id="deleteaddnameserverstatus-message-text"></span></div>
                                              </div>
                                            </div>
                                            <div id="deleteaddnameservererror-message" style="display: none; padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                              <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                                <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                  <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                                </svg>
                                                <span class="sr-only">Info</span>
                                                <div><span class="font-medium">Hata! </span> <span id="deleteaddnameservererror-message-text"></span></div>
                                              </div>
                                            </div>
                                          </div>
                                          <div style="padding-left: 30px; padding-right: 30px; margin-top: 10px;">
                                            <button style="width: 100%; --c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500   dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                              Kaydet
                                            </button>
                                          </div>
                                        </form>
                                      </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php if ($domain['status'] == "Active"): ?>
            <div style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr));margin-top:25px;" class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-wi gap-6">
                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Whois Bilgisi
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                <div class="">
                                    <div class="border-t dark:border-gray-700">
                                        <dl class="divide-y divide-gray-200 dark:divide-gray-700 mr-15">
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">İsim</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo $whois['RegistrantContact']['First_Name'] . ' ' . $whois['RegistrantContact']['Last_Name']; ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Şirket</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php if ($whois['RegistrantContact']['Company_Name'] == 'n/a'): ?>Mevcut Değil
                                                    <?php else: ?>
                                                    <?php echo $whois['RegistrantContact']['Company_Name']; ?>
                                                    <?php endif; ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Email</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo $whois['RegistrantContact']['Email']; ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Telefon</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo '+' . $whois['RegistrantContact']['Phone_Country_Code'] . ' ' . $whois['RegistrantContact']['Phone']; ?>
                                                </dd>
                                            </div>
                                            <div class="py-2 px-6 flex justify-between">
                                                <dt class="text-gray-600 dark:text-gray-400">Adres</dt>
                                                <dd class="font-medium text-gray-900 dark:text-gray-200">
                                                    <?php echo $whois['RegistrantContact']['Address_1'] . ', ' . $whois['RegistrantContact']['State'] . ', ' . $whois['RegistrantContact']['City'] . ', ' . $whois['RegistrantContact']['Country'] . ' ' . $whois['RegistrantContact']['ZIP_Code']; ?>
                                                </dd>
                                            </div>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default] fi-wi-widget fi-wi-table">
                    <div class="fi-ta">
                        <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                            <div class="fi-ta-header-ctn divide-y divide-gray-200 dark:divide-white/10">
                                <div class="fi-ta-header flex flex-col gap-3 p-4 sm:px-6 sm:flex-row sm:items-center">
                                    <div class="grid gap-y-1">
                                        <h3 class="fi-ta-header-heading text-base font-semibold leading-6 text-gray-950 dark:text-white">
                                            Diğer Yönetim Kısayolları
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                            <div class="">
                                <div class="border-t dark:border-gray-700">
                                  <div class="mb-4">
                                      <div class="bg-white dark:bg-gray-900 dark:text-white p-4 rounded-b shadow">
                                          <div class="flex justify-between items-center">
                                              <div class="flex items-center">
                                                <span id="lock-status-label" style="margin-right:10px;" class="label {{ $dna['data']['LockStatus'] == 'true' ? 'label-success' : 'label-danger' }} bg-green-500 text-white p-2 rounded mr-2">{{ $dna['data']['LockStatus'] == 'locked' ? 'Aktif' : 'Pasif' }}</span>
                                                  <span class="font-bold text-xl">Transfer Kilidi</span>
                                              </div>
                                              <form action="{{ route('domain.save') }}" method="POST" class="inline locked-form">
                                                  @csrf
                                                  <input type="hidden" name="action" value="toggleLock">
                                                  <input type="hidden" name="domainid" value="{{$product['domainid']}}">
                                                  <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">{{ $dna['data']['LockStatus'] == 'true' ? 'Devre Dışı Bırak' : 'Aktif Edin' }}</button>

                                              </form>
                                          </div>
                                          <p class="mt-2 font-medium text-gray-900 dark:text-gray-200">Transfer Kilidi Aktif Et (Önerilir). Kilidin etkin olması durumunda izinsiz transferler engellenmiş olacaktır.</p>
                                      </div>
                                  </div>
                                    <div class="mb-4 epp-form-mb">
                                        <div class="bg-white dark:bg-gray-900 dark:text-white p-4 rounded-b shadow">
                                            <div class="flex justify-between items-center">
                                                <div class="flex items-center">
                                                    <span class="font-bold text-xl">Transfer Kodu Al</span>
                                                  </div>
                                                  <form action="{{ route('domain.save') }}" method="POST" class="inline epp-form">
                                                    @csrf
                                                    <input type="hidden" name="action" value="createepp">
                                                    <input type="hidden" name="domainid" value="{{ $product['domainid'] }}">
                                                    <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);display:none;" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                                        {{ $dna['data']['LockStatus'] == 'true' ? 'disabled' : '' }}>
                                                        Transfer Kodu Al
                                                      </button>
                                                      <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ringcustom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" onclick="window.dialog.showModal();">Transfer Kodu Al</button>
                                                    </form>
                                                  </div>
                                                  <p class="mt-2 font-medium text-gray-900 dark:text-gray-200">Transfer etmek istediğiniz domain adresinizin önce transfer kilidini açmanız gerekmektedir.</p>
                                                </div>
                                              </div>
                                              <div class="mb-4">
                                                  <div class="bg-white dark:bg-gray-900 dark:text-white p-4 rounded-b shadow">
                                                      <div class="flex justify-between items-center">
                                                          <div class="flex items-center">
                                                            <span id="renew-status-label" style="margin-right:10px;" class="label {{ $domain['donotrenew'] == '0' ? 'label-success' : 'label-danger' }} bg-green-500 text-white p-2 rounded mr-2">{{ $domain['donotrenew'] == '0' ? 'Aktif' : 'Pasif' }}</span>
                                                              <span class="font-bold text-xl">Otomatik Yenileme</span>
                                                          </div>
                                                          <form action="{{ route('domain.save') }}" method="POST" class="inline renew-form">
                                                              @csrf
                                                              <input type="hidden" name="action" value="autorenew">
                                                              <input type="hidden" name="autorenew" value="{{ $domain['donotrenew'] == '0' ? '1' : '0' }}">
                                                              <input type="hidden" name="domainid" value="{{$product['domainid']}}">
                                                              <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">
                                                                  {{ $domain['donotrenew'] == '0' ? 'Devre Dışı Bırak' : 'Aktif Edin' }}
                                                              </button>
                                                          </form>

                                                      </div>
                                                      <p class="mt-2 font-medium text-gray-900 dark:text-gray-200">Otomatik yenilemeyi açarak, alan adınızın süresi bitmeden tarafınıza e-posta ile yenileme faturası gönderilmesini sağlayabilirsiniz.</p>
                                                  </div>
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <style media="screen">

                                dialog {
                                  min-width: 30%;

                                background: white;
                                max-width: 400px;
                                padding-top: 2rem;
                                border-radius: 20px;
                                border: 0;
                                box-shadow: 0 5px 30px 0 rgb(0 0 0 / 10%);
                                animation: fadeIn 1s ease both;
                                &::backdrop {
                                  animation: fadeIn 1s ease both;
                                  background: rgb(255 255 255 / 40%);
                                  z-index: 2;
                                  backdrop-filter: blur(20px);
                                }
                                .x {
                                  filter: grayscale(1);
                                  border: none;
                                  background: none;
                                  position: absolute;
                                  top: 15px;
                                  right: 10px;
                                  transition: ease filter, transform 0.3s;
                                  cursor: pointer;
                                  transform-origin: center;
                                  &:hover {
                                    filter: grayscale(0);
                                    transform: scale(1.1);
                                  }
                                }
                                h2 {
                                  font-weight: 600;
                                  font-size: 2rem;
                                  padding-bottom: 1rem;
                                }
                                p {
                                  font-size: 1rem;
                                  line-height: 1.3rem;
                                  padding: 0.5rem 0;
                                  a {
                                    &:visited {
                                      color: rgb(var(--vs-primary));
                                    }
                                  }
                                }
                                }

                                @keyframes fadeIn {
                                from {
                                  opacity: 0;
                                }
                                to {
                                  opacity: 1;
                                }
                                }

                                </style>

                                <dialog id="dialog" class="fi-simple-main  w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
                                    <div class="fi-simple-page">
                                        <section class="grid auto-cols-fr gap-y-6">
                                            <header class="fi-simple-header flex flex-col items-center">
                                                <img alt="filament-panels::layout.logo.alt" src="https://sspanel.serversistemleri.com/templates/sspanel/design/images/media/logos/logo-big-white.png" class="fi-logo flex mb-4" />
                                                <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                                                    Doğrulama Kodu
                                                </h1>
                                                <p style="text-align: center;">Transfer kodunuzun güvenli bir şekilde gönderilebilmesi için lütfen SMS doğrulama kodunuzu giriniz!</p>
                                            </header>

                                            <form action="{{ route('domain.save') }}" method="post" class="verify-form fi-form grid gap-y-6">
                                                @csrf
                                                <input type="hidden" name="action" value="verify">
                                                <input type="hidden" name="domainid" value="{{$product['domainid']}}">
                                                <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                                                    <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                        <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                            <div class="grid gap-y-2">
                                                                <div class="flex items-center gap-x-3 justify-between">
                                                                    <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                                                        <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                                            Doğrulama Kodu
                                                                            <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                                                        </span>
                                                                    </label>
                                                                </div>
                                                                <div class="grid auto-cols-fr gap-y-2">
                                                                    <div
                                                                        class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden"
                                                                    >
                                                                        <div class="min-w-0 flex-1">
                                                                            <input
                                                                                class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                                autocomplete="on"
                                                                                autofocus="autofocus"
                                                                                name="code"
                                                                                required="required"
                                                                                type="text"
                                                                            />
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="fi-form-actions">
                                                    <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                                                        <button
                                                            style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);"
                                                            class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                                            type="submit"
                                                            id="submit-button"
                                                        >
                                                            <span class="fi-btn-label">Kodu Doğrula</span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div id="response-message">
                                                  <div id="verifystatus-message" style="display: none;">
                                                    <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                                                      <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                                      </svg>
                                                      <span class="sr-only">Info</span>
                                                      <div>
                                                        <span class="font-medium">Başarılı! </span> <span id="verifystatus-message-text"></span>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <div id="verifyerror-message" style="display: none;">
                                                    <div class="flex items-center p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-300" role="alert">
                                                      <svg style="margin-right: 10px;" class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                                      </svg>
                                                      <span class="sr-only">Info</span>
                                                      <div>
                                                        <span class="font-medium">Hata! </span> <span id="verifyerror-message-text"></span>
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                            </form>

                                        </section>
                                    </div>

                                    <button onclick="window.dialog.close();" aria-label="close" class="x">❌</button>
                                </dialog>

            <?php endif; ?>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
            document.getElementById("nameserver-save-button").addEventListener("click", function () {
    var replyForm = document.getElementById("nameserver-save-form");
    if (replyForm.classList.contains("hidden")) {
        replyForm.classList.remove("hidden");
    } else {
        replyForm.classList.add("hidden");
      }
    });

    document.getElementById("addnameserver-button").addEventListener("click", function () {
      var replyForm = document.getElementById("addnameserver-form");
      if (replyForm.classList.contains("hidden")) {
          replyForm.classList.remove("hidden");
        } else {
          replyForm.classList.add("hidden");
        }
      });

      document.getElementById("updateaddnameserver-button").addEventListener("click", function () {
        var replyForm = document.getElementById("updateaddnameserver-form");
        if (replyForm.classList.contains("hidden")) {
          replyForm.classList.remove("hidden");
        } else {
          replyForm.classList.add("hidden");
        }
      });

      document.getElementById("deleteaddnameserver-button").addEventListener("click", function () {
        var replyForm = document.getElementById("deleteaddnameserver-form");
        if (replyForm.classList.contains("hidden")) {
          replyForm.classList.remove("hidden");
        } else {
          replyForm.classList.add("hidden");
        }
      });

      $(document).ready(function () {
        $(document).on("submit", "form.epp-form", function (e) {
          e.preventDefault();
          var form = $(this);
          var url = form.attr("action");
          var method = form.attr("method");
          var data = form.serialize();
          var button = form.find("button");
          var originalButtonText = button.text();

          $.ajax({
              url: url,
              method: method,
              data: data,
              success: function (response) {

                  },
                  error: function (xhr, status, error) {
                    $("#eppstatus-message").hide();
                    $("#epperror-message").hide();
                    $("#epperror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                    $("#epperror-message").show();
                  },
                });
              });
            });
            $(document).ready(function () {
              $(document).on("submit", "form.verify-form", function (e) {
                e.preventDefault();
                var form = $(this);
                var url = form.attr("action");
                var method = form.attr("method");
                var data = form.serialize();
                var button = form.find("button");
                var originalButtonText = button.text();

                // Buton ismini "Lütfen bekleyiniz.." olarak değiştir
                button.text("Lütfen bekleyiniz..");
                button.prop("disabled", true);
                $.ajax({
                  url: url,
                  method: method,
                  data: data,
                  success: function (response) {
                    $("#verifystatus-message").hide();
                    $("#verifyerror-message").hide();

                    if (response.status === "success") {
                      $("#verifystatus-message-text").html(response.message);
                      $("#verifystatus-message").show();
                      setTimeout(function () {
                          window.dialog.close();
                        }, 3000);
                      } else {
                        $("#verifyerror-message-text").html(response.message);
                        $("#verifyerror-message").show();
                      }

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#verifystatus-message").hide();
                      $("#verifyerror-message").hide();
                      $("#verifyerror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#verifyerror-message").show();

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });

              $(document).ready(function () {
                $(document).on("submit", "form.renew-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();
                  var statusLabel = $("#renew-status-label");
                  // Buton ismini "Lütfen bekleyiniz.." olarak değiştir
                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);
                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#eppstatus-message").hide();
                      $("#epperror-message").hide();

                      if (response.status === "success") {
                        $("#eppstatus-message-text").html(response.message);
                        $("#eppstatus-message").show();

                        // Orijinal buton metnine göre yeni metni ayarla
                        if (originalButtonText === "Aktif Et") {
                          button.text("Devre Dışı Bırak");
                          statusLabel.text("Aktif");
                          statusLabel.removeClass("label-danger bg-red-500").addClass("label-success bg-green-500");
                        }
                        if (originalButtonText === "Devre Dışı Bırak") {
                          button.text("Aktif Et");
                          statusLabel.text("Pasif");
                          statusLabel.removeClass("label-success bg-green-500").addClass("label-danger bg-red-500");
                        }
                      } else {
                        $("#lockederror-message-text").html(response.message);
                        $("#lockederror-message").show();
                        // Hata durumunda buton metnini geri yükle
                        button.text(originalButtonText);
                      }

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#eppstatus-message").hide();
                      $("#epperror-message").hide();
                      $("#epperror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#epperror-message").show();

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });
              $(document).ready(function () {
                var button = $("form.locked-form").find("button");
                var originalButtonText = button.text();
                var eppFormMb = $(".epp-form-mb");

                // Sayfa yüklendiğinde orijinal button text "Devre Dışı Bırak" ise .epp-form-mb öğesini gizle
                if (originalButtonText === "Devre Dışı Bırak") {
                  eppFormMb.hide();
                }

                $(document).on("submit", "form.locked-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();
                  var statusLabel = $("#lock-status-label");
                  var eppButton = $("form.epp-form").find("button");
                  var eppFormMb = $(".epp-form-mb");
                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);

                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#lockedstatus-message").hide();
                      $("#lockederror-message").hide();

                      if (response.status === "success") {
                        $("#lockedstatus-message-text").html(response.message);
                        $("#lockedstatus-message").show();

                        if (originalButtonText === "Aktif Edin") {
                          eppButton.prop("disabled", true);
                          button.text("Devre Dışı Bırak");
                          statusLabel.text("Aktif");
                          statusLabel.removeClass("label-danger bg-red-500").addClass("label-success bg-green-500");
                          eppFormMb.hide();
                        }
                        if (originalButtonText === "Devre Dışı Bırak") {
                          eppButton.prop("disabled", false);
                          button.text("Aktif Edin");
                          statusLabel.text("Pasif");
                          statusLabel.removeClass("label-success bg-green-500").addClass("label-danger bg-red-500");
                          eppFormMb.show();
                        }
                      } else {
                        $("#lockederror-message-text").html(response.message);
                        $("#lockederror-message").show();
                        button.text(originalButtonText);
                      }
                    },
                    error: function (xhr, status, error) {
                      $("#lockedstatus-message").hide();
                      $("#lockederror-message").hide();
                      $("#lockederror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#lockederror-message").show();

                      button.text(originalButtonText);
                    },
                    complete: function () {
                      button.prop("disabled", false);
                    },
                  });
                });
              });



              $(document).ready(function () {
                $(document).on("submit", "form.nameserver-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();

                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);

                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#lockedstatus-message").hide();
                      $("#lockederror-message").hide();

                      if (response.status === "success") {
                        $("#lockedstatus-message-text").html(response.message);
                        $("#lockedstatus-message").show();
                      } else {
                        $("#lockederror-message-text").html(response.message);
                        $("#lockederror-message").show();
                      }

                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#lockedstatus-message").hide();
                      $("#lockederror-message").hide();
                      $("#lockederror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#lockederror-message").show();

                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });

              $(document).ready(function () {
                $(document).on("submit", "form.addnameserver-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();

                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);

                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#addnameserverstatus-message").hide();
                      $("#addnameservererror-message").hide();

                      if (response.status === "success") {
                        $("#addnameserverstatus-message-text").html(response.message);
                        $("#addnameserverstatus-message").show();
                      } else {
                        $("#addnameservererror-message-text").html(response.message);
                        $("#addnameservererror-message").show();
                      }

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#addnameserverstatus-message").hide();
                      $("#addnameservererror-message").hide();
                      $("#addnameservererror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#addnameservererror-message").show();

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });

              $(document).ready(function () {
                $(document).on("submit", "form.updateaddnameserver-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();

                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);

                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#updateaddnameserverstatus-message").hide();
                      $("#updateaddnameservererror-message").hide();

                      if (response.status === "success") {
                        $("#updateaddnameserverstatus-message-text").html(response.message);
                        $("#updateaddnameserverstatus-message").show();
                      } else {
                        $("#updateaddnameservererror-message-text").html(response.message);
                        $("#updateaddnameservererror-message").show();
                      }

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#updateaddnameserverstatus-message").hide();
                      $("#updateaddnameservererror-message").hide();
                      $("#updateaddnameservererror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#updateaddnameservererror-message").show();

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });

              $(document).ready(function () {
                $(document).on("submit", "form.deleteaddnameserver-form", function (e) {
                  e.preventDefault();
                  var form = $(this);
                  var url = form.attr("action");
                  var method = form.attr("method");
                  var data = form.serialize();
                  var button = form.find("button");
                  var originalButtonText = button.text();

                  button.text("Lütfen bekleyiniz..");
                  button.prop("disabled", true);

                  $.ajax({
                    url: url,
                    method: method,
                    data: data,
                    success: function (response) {
                      $("#deleteaddnameserverstatus-message").hide();
                      $("#deleteaddnameservererror-message").hide();

                      if (response.status === "success") {
                        $("#deleteaddnameserverstatus-message-text").html(response.message);
                        $("#deleteaddnameserverstatus-message").show();
                      } else {
                        $("#deleteaddnameservererror-message-text").html(response.message);
                        $("#deleteaddnameservererror-message").show();
                      }

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                    error: function (xhr, status, error) {
                      $("#deleteaddnameserverstatus-message").hide();
                      $("#deleteaddnameservererror-message").hide();
                      $("#deleteaddnameservererror-message-text").html("Bir hata oluştu. Lütfen tekrar deneyin.");
                      $("#deleteaddnameservererror-message").show();

                      // Buton ismini geri değiştir
                      button.text(originalButtonText);
                      button.prop("disabled", false);
                    },
                  });
                });
              });
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const form = document.querySelector(".hostingrenew-form");
        const selectElement = form.querySelector('select[name="period"]');

        selectElement.addEventListener("change", function () {
            if (selectElement.value) {
                // Seçili option'ı geçici olarak sakla
                const selectedOption = selectElement.options[selectElement.selectedIndex];
                const originalText = selectedOption.text;

                // Seçenek metnini "Bekleyiniz..." olarak değiştir
                selectedOption.text = "Bekleyiniz...";

                const formData = new FormData(form);

                fetch("{{ route('domain.save') }}", {
                    method: "POST",
                    body: formData,
                    headers: {
                        "X-CSRF-TOKEN": "{{ csrf_token() }}",
                        Accept: "application/json",
                    },
                })
                .then((response) => {
                    if (!response.ok) {
                        throw new Error("HTTP hatası: " + response.status);
                    }
                    return response.json();
                })
                .then((data) => {
                    if (data.success && data.invoiceid) {
                        // Başarılı yanıt ve invoiceid varsa yönlendir
                        window.location.href = `https://sspanel.serversistemleri.com/invoices/view/${data.invoiceid}`;
                    } else {
                        alert("İşlem başarısız oldu: " + (data.message || "Bilinmeyen bir hata oluştu."));
                        selectedOption.text = originalText; // Eski seçeneği geri yükle
                    }
                })
                .catch((error) => {
                    console.error("Hata:", error);
                    alert("Bir hata oluştu. Lütfen tekrar deneyin.");
                    selectedOption.text = originalText; // Hata durumunda eski metni geri al
                });
            }
        });
    });
</script>
    </main>
    @include("layouts.footer")
